/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.check.ReportEntry;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.AbstractCabinetBasicCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.AutoConfigRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.CluNpuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.DigitalSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.GpbRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.NodeRestartRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.PmServiceRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ProductInfoRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.Rbs3CommonBasicCvRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.Rbs3MediumAccessUnitRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.RedundantControlSystemParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ReliableProgramUniterRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.RestartEscalationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.RfSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.ScbRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.SwitchInternalLinkRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.SwitchPlaneRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.TubRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupportSystemAvailableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.SyncRefInfo;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ConfirmDialogParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.AtfProviderImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsData;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.SwAllocOtherRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchCoreUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimingUnit;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.RfSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class Rbs3CabinetBasicCI
extends AbstractCabinetBasicCI {
    private AtfProviderImpl myAtfProvider;
    private ArrayList allResourceItems;
    private RedundantControlSystemParameter redundantControlSystemCustParam;
    private ConfirmDialogParameter restartCustParam;
    private ConfigurationCheckReport report;
    private boolean isOpen = false;
    private HashMap definedRfBoardPositions;
    private RbsData rbsData;
    private CluNpuRI cluRI;
    private DigitalSubrackRI hubSubrackRI;
    private SwAllocOtherRI swAllocOtherRI;
    private RfSubrackRI rfSubrackRI;
    private NodeRestartRI nodeRestartRI;
    private RestartEscalationRI restartEscalationRI;
    private ReliableProgramUniterRI rpuRI;
    private SwitchPlaneRI spRI;
    private int noOfScbInRf = 0;
    private List redundantRIs = new ArrayList();
    private HashMap boardPositions = new HashMap();
    private RfSubrackMoi rfSubrackMoi;
    private Rbs3CommonBasicCvRI commonBasicCvRI;
    private boolean supportSystemAvailable = false;
    protected SupportSystemAvailableRI supportSystemAvailableRI = null;

    public Rbs3CabinetBasicCI(Rbs rbs) {
        super(rbs);
    }

    public ArrayList getNeededRIs() {
        if (this.isOpen && (this.redundantControlSystemCustParam.isValueEqualTo("NO") || this.redundantControlSystemCustParam.getLoadedValue().equals("YES") && this.redundantControlSystemCustParam.isValueEqualTo("YES"))) {
            for (int i = 0; i < this.redundantRIs.size(); ++i) {
                this.allResourceItems.remove(this.redundantRIs.get(i));
            }
        }
        return this.allResourceItems;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("CabinetBasicCI.open(): Already open");
        }
        this.rbsData = super.getRbsData();
        this.createBasicCommonResourceItems();
        if (this.allResourceItems != null) {
            this.initialiseCustomerParameters();
        }
        this.isOpen = true;
        return this.isOpen;
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        this.report = super.checkConfiguration();
        this.rbsData = super.getRbsData();
        this.definedRfBoardPositions = this.rbsData.getRfBoardPositions();
        if (this.definedRfBoardPositions != null) {
            int n;
            Object[] objectArray = this.definedRfBoardPositions.keySet().toArray();
            String string = (String)objectArray[0];
            this.rfSubrackMoi = new RfSubrackMoi();
            String string2 = this.rfSubrackMoi.getLdn();
            MoHandler moHandler = this.getRbs().getMoHandler();
            BemMo bemMo = moHandler.getMo(string2);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string + " in slot ");
            BemMo[] bemMoArray = null;
            ReportEntry reportEntry = null;
            String string3 = null;
            try {
                bemMoArray = moHandler.getChildren(bemMo, 3, string, "");
                this.noOfScbInRf = bemMoArray.length;
            }
            catch (MoHandlerException moHandlerException) {
                String string4 = moHandlerException.getAction();
                String string5 = moHandlerException.getAdditionalInfo();
                throw new BemException(string4, "checkConfiguration", string2, string5, moHandlerException);
            }
            String[] stringArray = (String[])this.definedRfBoardPositions.get(string);
            List<String> list = Arrays.asList(stringArray);
            for (n = 0; n < stringArray.length - 1; ++n) {
                stringBuffer.append(stringArray[n] + ", ");
            }
            stringBuffer.append(stringArray[stringArray.length - 1]);
            for (n = 0; n < bemMoArray.length; ++n) {
                String string6 = bemMoArray[n].getParent().getParent().getId();
                String string7 = bemMoArray[n].getParent().getParent().getDN();
                if (list.contains(string6)) continue;
                string3 = string + " in slot " + string6;
                reportEntry = new ReportEntry("Error", string7, string3, stringBuffer.toString(), "Not a valid slot for the board type in RF Subrack");
                this.report.addReportEntry(reportEntry);
            }
            if (!(this.noOfGpb <= 1 && this.noOfScbInHub <= 1 && this.noOfTub <= 1 && this.noOfScbInRf <= 1 || this.noOfGpb == 2 && this.noOfScbInHub == 2 && this.noOfTub == 2 && this.noOfScbInRf == 2)) {
                String string8 = "2xGPB, 2xTUB, 2xSCB in Hub Subrack, 2xSCB in RF Subrack";
                string3 = this.noOfGpb + "xGPB, " + this.noOfTub + "xTUB, " + this.noOfScbInHub + "xSCB in Hub Subrack" + this.noOfScbInRf + "xSCB in RF Subrack";
                reportEntry = new ReportEntry("Warning", "", string3, string8, "Redundant Control System configuration not complete");
                this.report.addReportEntry(reportEntry);
            }
        }
        return this.report;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String[] stringArray = new String[]{"redundantControlSystem", "nodeRestart", "ipAddress", "subnetMask", "defaultRouter"};
        super.setCustomerParametersFromSV(stringArray, serviceValue);
    }

    private void createDigitalSubrackRi() {
        if (this.hubSubrackRI != null) {
            return;
        }
        this.rbsData = super.getRbsData();
        int n = this.rbsData.getNoOfSlots();
        String string = this.rbsData.getCabinetPosition();
        String string2 = this.rbsData.getSubrackPosition();
        this.boardPositions = this.rbsData.getBoardPositions();
        Map map = this.rbsData.getRepertoireMap();
        try {
            this.hubSubrackRI = new DigitalSubrackRI(this.getRbs(), n, string, string2, this.boardPositions, super.getHubSubrackMoi(), map);
        }
        catch (BemException bemException) {
            // empty catch block
        }
    }

    private void createSwAllocOtherRI() {
        if (this.swAllocOtherRI != null) {
            return;
        }
        this.swAllocOtherRI = new SwAllocOtherRI(this.rbs);
    }

    private void createRfSubrackRi() {
        if (this.rfSubrackRI != null) {
            return;
        }
        int n = this.rbsData.getRfNoOfSlots();
        String string = this.rbsData.getRfCabinetPosition();
        String string2 = this.rbsData.getRfSubrackPosition();
        HashMap hashMap = this.rbsData.getRfBoardPositions();
        Map map = this.rbsData.getRepertoireMap();
        try {
            this.rfSubrackRI = new RfSubrackRI(this.getRbs(), n, string, string2, hashMap, new RfSubrackMoi(), map);
        }
        catch (BemException bemException) {
            // empty catch block
        }
    }

    private void createBasicCommonResourceItems() throws BemException {
        ResourceItem resourceItem;
        Object object;
        Serializable serializable;
        int n;
        Object object2;
        int n2;
        this.allResourceItems = new ArrayList();
        this.createDigitalSubrackRi();
        this.allResourceItems.add(this.hubSubrackRI);
        this.createSwAllocOtherRI();
        this.allResourceItems.add(this.swAllocOtherRI);
        this.definedRfBoardPositions = this.rbsData.getRfBoardPositions();
        if (this.definedRfBoardPositions != null) {
            this.createRfSubrackRi();
            this.allResourceItems.add(this.rfSubrackRI);
        }
        String[] stringArray = this.rbsData.getProductData();
        this.allResourceItems.add(new ProductInfoRI(super.getRbs(), stringArray[0], stringArray[1], stringArray[2], 0));
        this.allResourceItems.add(new PmServiceRI(super.getRbs(), super.getPmServiceLdn()));
        ArrayList arrayList = this.hubSubrackRI.getSubResourceItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            this.allResourceItems.add(arrayList.get(i));
        }
        String[] stringArray2 = new String[]{MimGeneralProcessorUnit.MOTYPENAME, MimSwitchCoreUnit.MOTYPENAME, MimTimingUnit.MOTYPENAME};
        String[][] stringArrayArray = new String[stringArray2.length][];
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            stringArrayArray[n2] = this.hubSubrackRI.getBoardPosition(stringArray2[n2]);
        }
        n2 = 0;
        if (stringArrayArray[0].length > 0) {
            object2 = Integer.valueOf(stringArrayArray[0][0]);
            n = (Integer)object2;
            this.allResourceItems.add(new Rbs3MediumAccessUnitRI(super.getRbs(), super.getHubSubrackMoi(), n));
        }
        if (stringArrayArray[1].length > 0) {
            int n3 = 0;
            n = 0;
            serializable = this.rbsData.getRfBoardPositions();
            if (serializable != null) {
                object = (String[])this.boardPositions.get(MimSwitchCoreUnit.MOTYPENAME);
                n3 = Integer.valueOf(object[0]);
                String[] stringArray3 = (String[])((HashMap)serializable).get(MimSwitchCoreUnit.MOTYPENAME);
                n = Integer.valueOf(stringArray3[0]);
                resourceItem = this.rfSubrackRI.getRIs(new Integer(n));
                this.allResourceItems.add(resourceItem);
                SwitchInternalLinkRI switchInternalLinkRI = new SwitchInternalLinkRI(super.getRbs(), n3, n, super.getSubrackMoi(), new RfSubrackMoi(), false);
                this.allResourceItems.add(switchInternalLinkRI);
            }
        }
        if (stringArrayArray[0].length > 1 || stringArrayArray[1].length > 1 || stringArrayArray[2].length > 1) {
            object2 = null;
            n = -1;
            serializable = Integer.valueOf(stringArrayArray[0][1]);
            n = (Integer)serializable;
            object2 = this.hubSubrackRI.getSubResourceItem(new Integer(n));
            this.redundantRIs.add(object2);
            if (object2 != null && object2.isInstalled()) {
                n2 = 1;
            }
            object = Integer.valueOf(stringArrayArray[0][0]);
            int n4 = (Integer)object;
            if (stringArrayArray[0].length > 1 && object2 != null) {
                resourceItem = new Rbs3MediumAccessUnitRI(super.getRbs(), super.getHubSubrackMoi(), n);
                this.allResourceItems.add(resourceItem);
                this.redundantRIs.add(resourceItem);
            }
            this.spRI = new SwitchPlaneRI(super.getRbs(), n2);
            this.allResourceItems.add(this.spRI);
            this.redundantRIs.add(this.spRI);
            this.rpuRI = new ReliableProgramUniterRI(super.getRbs(), (HubSubrackMoi)super.getHubSubrackMoi(), n, n4, this.supportSystemAvailable);
            this.allResourceItems.add(this.rpuRI);
            this.redundantRIs.add(this.rpuRI);
            resourceItem = null;
            int n5 = 0;
            int n6 = 0;
            String[] stringArray4 = (String[])this.boardPositions.get(MimSwitchCoreUnit.MOTYPENAME);
            for (int i = 0; i < stringArray4.length; ++i) {
                int n7 = Integer.valueOf(stringArray4[i]);
                if (n7 == 1) continue;
                n5 = n7;
                resourceItem = this.hubSubrackRI.getRIs(new Integer(n7));
                this.redundantRIs.add(resourceItem);
            }
            HashMap hashMap = this.rbsData.getRfBoardPositions();
            String[] stringArray5 = (String[])hashMap.get(MimSwitchCoreUnit.MOTYPENAME);
            for (int i = 0; i < stringArray5.length; ++i) {
                int n8 = Integer.valueOf(stringArray5[i]);
                if (n8 == 1) continue;
                n6 = n8;
                resourceItem = this.rfSubrackRI.getRIs(new Integer(n8));
                this.allResourceItems.add(resourceItem);
                this.redundantRIs.add(resourceItem);
            }
            SwitchInternalLinkRI switchInternalLinkRI = new SwitchInternalLinkRI(super.getRbs(), n5, n6, super.getSubrackMoi(), new RfSubrackMoi(), true);
            this.allResourceItems.add(switchInternalLinkRI);
            this.redundantRIs.add(switchInternalLinkRI);
            ResourceItem resourceItem2 = null;
            Integer n9 = Integer.valueOf(stringArrayArray[2][1]);
            resourceItem2 = this.hubSubrackRI.getSubResourceItem(n9);
            this.redundantRIs.add(resourceItem2);
            this.setRedundantRIs(this.redundantRIs);
        }
        this.cluRI = this.getCluRI();
        if (this.cluRI != null) {
            this.allResourceItems.add(this.cluRI);
        }
        this.commonBasicCvRI = this.getCommonBasicCvRI();
        if (this.commonBasicCvRI != null) {
            this.allResourceItems.add(this.commonBasicCvRI);
        }
        this.allResourceItems.add(new AutoConfigRI(super.getRbs(), true, super.getManagedElementMoi().getLdn()));
        this.nodeRestartRI = new NodeRestartRI(super.getRbs());
        this.allResourceItems.add(this.nodeRestartRI);
        this.restartEscalationRI = new RestartEscalationRI(super.getRbs(), super.getConfigurationVersionLdn());
        this.allResourceItems.add(this.restartEscalationRI);
        this.supportSystemAvailableRI = new SupportSystemAvailableRI(super.getRbs(), this.supportSystemAvailable);
        this.allResourceItems.add(this.supportSystemAvailableRI);
    }

    private void initialiseCustomerParameters() throws BemException {
        Object object;
        this.redundantControlSystemCustParam = new RedundantControlSystemParameter();
        this.restartCustParam = new ConfirmDialogParameter();
        String[] stringArray = new String[]{MimGeneralProcessorUnit.MOTYPENAME, MimSwitchCoreUnit.MOTYPENAME, MimTimingUnit.MOTYPENAME};
        String string = "NO";
        String[][] stringArrayArray = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArrayArray[i] = this.hubSubrackRI.getBoardPosition(stringArray[i]);
        }
        ResourceItem resourceItem = null;
        ResourceItem resourceItem2 = null;
        ResourceItem resourceItem3 = null;
        if (stringArrayArray[0].length > 1 || stringArrayArray[1].length > 1 || stringArrayArray[2].length > 1) {
            object = Integer.valueOf(stringArrayArray[0][1]);
            resourceItem = this.hubSubrackRI.getSubResourceItem((Integer)object);
            this.hubSubrackRI.registerCustomerParameter(this.redundantControlSystemCustParam);
            this.rpuRI.registerCustomerParameter(this.redundantControlSystemCustParam);
            this.spRI.registerCustomerParameter(this.redundantControlSystemCustParam);
            if (resourceItem != null) {
                resourceItem.registerCustomerParameter(this.redundantControlSystemCustParam);
            }
            String[] stringArray2 = (String[])this.boardPositions.get(MimSwitchCoreUnit.MOTYPENAME);
            for (int i = 0; i < stringArray2.length; ++i) {
                int n = Integer.valueOf(stringArray2[i]);
                if (n == 1 || (resourceItem2 = this.hubSubrackRI.getRIs(new Integer(n))) == null) continue;
                resourceItem2.registerCustomerParameter(this.redundantControlSystemCustParam);
            }
            HashMap hashMap = this.rbsData.getRfBoardPositions();
            String[] stringArray3 = (String[])hashMap.get(MimSwitchCoreUnit.MOTYPENAME);
            for (int i = 0; i < stringArray3.length; ++i) {
                int n = Integer.valueOf(stringArray3[i]);
                if (n == 1 || (resourceItem2 = this.rfSubrackRI.getRIs(new Integer(n))) == null) continue;
                resourceItem2.registerCustomerParameter(this.redundantControlSystemCustParam);
            }
            Integer n = Integer.valueOf(stringArrayArray[2][1]);
            resourceItem3 = this.hubSubrackRI.getSubResourceItem(n);
            if (resourceItem3 != null) {
                resourceItem3.registerCustomerParameter(this.redundantControlSystemCustParam);
            }
        } else {
            object = new EnumeratedRange(new String[]{"NO"});
            ParameterRestriction parameterRestriction = new ParameterRestriction("Redundant control system is not supported by this RBS type", (ParameterRange)object, true);
            this.redundantControlSystemCustParam.addRestriction(parameterRestriction);
        }
        if (resourceItem != null && resourceItem.isInstalled() || resourceItem2 != null && resourceItem2.isInstalled() || resourceItem3 != null && resourceItem3.isInstalled()) {
            object = new ParameterRestriction("Redundant control system cannot be deleted", 0);
            this.redundantControlSystemCustParam.addRestriction((ParameterRestriction)object);
            string = "YES";
        }
        this.redundantControlSystemCustParam.setDefaultValue("NO");
        this.redundantControlSystemCustParam.setLoadedValue(string);
        this.restartCustParam.setDefaultValue("NO");
        this.restartCustParam.setLoadedValue("NO");
        super.addParameter(this.redundantControlSystemCustParam);
        super.addParameter(this.restartCustParam);
        this.nodeRestartRI.registerCustomerParameter(this.restartCustParam);
    }

    protected AtfProvider getAtfProvider() {
        return this.getAtfProvider(0);
    }

    protected AtfProvider getAtfProvider(int n) {
        if (this.myAtfProvider == null) {
            String[] stringArray;
            Serializable serializable;
            this.createDigitalSubrackRi();
            this.myAtfProvider = new AtfProviderImpl();
            String[] stringArray2 = (String[])this.boardPositions.get(MimSwitchCoreUnit.MOTYPENAME);
            Integer n2 = Integer.valueOf(stringArray2[0]);
            ScbRI scbRI = (ScbRI)this.hubSubrackRI.getSubResourceItem(n2);
            String string = scbRI.getPiuLdn();
            String string2 = null;
            if (stringArray2.length > 1) {
                serializable = Integer.valueOf(stringArray2[1]);
                stringArray = (String[])this.hubSubrackRI.getSubResourceItem((Integer)serializable);
                string2 = stringArray.getPiuLdn();
            }
            if ((serializable = this.rbsData.getRfBoardPositions()) != null) {
                this.createRfSubrackRi();
                stringArray = (String[])((HashMap)serializable).get(MimSwitchCoreUnit.MOTYPENAME);
                Integer n3 = Integer.valueOf(stringArray[0]);
                ScbRI scbRI2 = (ScbRI)this.rfSubrackRI.getSubResourceItem(n3);
                String string3 = scbRI2.getPiuLdn();
                String string4 = null;
                if (stringArray.length > 1) {
                    Integer n4 = Integer.valueOf(stringArray[1]);
                    ScbRI scbRI3 = (ScbRI)this.rfSubrackRI.getSubResourceItem(n4);
                    string4 = scbRI3.getPiuLdn();
                }
                this.myAtfProvider.putAtfLdns("CONTROLLER_OF_FAN_RF", string3, string4);
            }
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_CU", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_FAN_BB", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_FAN_PS", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_PCU", string, string2);
            this.myAtfProvider.putAtfLdns("CONTROLLER_OF_XALM", string, string2);
        }
        return this.myAtfProvider;
    }

    private void setRedundantRIs(List list) {
        this.redundantRIs = list;
    }

    protected abstract Rbs3CommonBasicCvRI getCommonBasicCvRI() throws BemException;

    protected CluNpuRI getCluRI() {
        return this.cluRI;
    }

    public String[] getSlotsWithTuSynchRef() throws BemException {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = this.hubSubrackRI.getBoardPosition(MimTimingUnit.MOTYPENAME);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                Integer n = Integer.valueOf(stringArray2[i]);
                TubRI tubRI = (TubRI)this.hubSubrackRI.getSubResourceItem(n);
                if (!tubRI.isTuSynchRef()) continue;
                arrayList.add(stringArray2[i]);
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public String[] getTuSynchRefLdns(String string) throws BemException {
        Integer n = Integer.valueOf(string);
        TubRI tubRI = (TubRI)this.hubSubrackRI.getSubResourceItem(n);
        if (tubRI == null) {
            return new String[0];
        }
        return tubRI.getTuSynchRefLdns();
    }

    public SyncRefInfo[] getTuSyncRefs(String string) throws BemException {
        String[] stringArray = this.getTuSynchRefLdns(string);
        int n = 1;
        ArrayList<SyncRefInfo> arrayList = new ArrayList<SyncRefInfo>();
        for (int i = 0; i < stringArray.length; ++i) {
            SyncRefInfo syncRefInfo = new SyncRefInfo(stringArray[i], n, "TUB");
            ++n;
            arrayList.add(syncRefInfo);
        }
        return arrayList.toArray(new SyncRefInfo[0]);
    }

    public String[] getProcessorPiuLdns() throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{};
        String[] stringArray2 = this.hubSubrackRI.getBoardPosition(MimGeneralProcessorUnit.MOTYPENAME);
        if (stringArray2 != null) {
            for (int i = 0; i < stringArray2.length; ++i) {
                Integer n = Integer.valueOf(stringArray2[i]);
                GpbRI gpbRI = (GpbRI)this.hubSubrackRI.getSubResourceItem(n);
                boolean bl = gpbRI.isInstalled();
                if (!bl) continue;
                arrayList.add(gpbRI.getPiuLdn());
            }
        }
        if (arrayList.size() > 0) {
            stringArray = arrayList.toArray(stringArray);
        }
        return stringArray;
    }
}

