/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource;

import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetLink;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpOam;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class EthernetLinkRI
extends AbstractResourceItem
implements ResourceItem {
    private static final String[] myInstallationPhases = new String[]{"EthernetCreationPhase", "IpSettingPhase", "IpResetPhase", "IpValidationPhase"};
    private static final String name = "Ethernet link";
    private final BemMo ethernetMo;
    private String ipAddress;
    private String subnetMask;
    private String broadcast;
    private final String ethernetLinkLdn;
    private boolean wasCreated = false;
    private boolean shouldBeReset = false;
    private Boolean isInstalled;

    public EthernetLinkRI(Rbs rbs) throws BemException {
        super(name, rbs, myInstallationPhases);
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimIpOam.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, MimIp.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi3 = new SingleChildMoi(singleChildMoi2, MimEthernetLink.MOTYPENAME, "1");
        this.ethernetLinkLdn = singleChildMoi3.getLdn();
        this.ethernetMo = this.getMo(this.ethernetLinkLdn);
    }

    public void install(String string) throws BemException {
        if (string.equals("EthernetCreationPhase")) {
            this.createEthernetLink();
        } else if (string.equals("IpSettingPhase")) {
            if (!this.shouldBeReset) {
                this.setEthernetLink(string);
            }
        } else if (string.equals("IpResetPhase")) {
            if (this.shouldBeReset) {
                this.setEthernetLink(string);
            }
        } else if (string.equals("IpValidationPhase") && !this.rbs.getRbsStep().equals("STEP_CABINET")) {
            this.validateIpConfig();
        }
    }

    private Vector getAttributes() {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        vector.add(Nal.getFactory().getNameValue("ipAddress", this.ipAddress));
        vector.add(Nal.getFactory().getNameValue("subnetMask", this.subnetMask));
        vector.add(Nal.getFactory().getNameValue("broadcastAddress", this.broadcast));
        return vector;
    }

    private void createEthernetLink() throws BemException {
        if (!this.isInstalled() && !this.shouldBeReset) {
            Vector vector = this.getAttributes();
            this.wasCreated = true;
            super.createMoIfNotExisting(this.ethernetLinkLdn, vector);
            this.isInstalled = Boolean.TRUE;
        }
    }

    private void setEthernetLink(String string) throws BemException {
        if (!this.wasCreated && this.isInstalled()) {
            Vector vector = this.getAttributes();
            NalNameValue[] nalNameValueArray = vector.toArray(new NalNameValue[0]);
            BemLog.log(6, this.getClass() + " setEthernetLink() attributes=" + vector.toString() + " Phase=" + string);
            this.action(this.ethernetMo, "assignAllIpAddresses", nalNameValueArray);
        }
    }

    private void validateIpConfig() throws BemException {
        this.validateAttribute("ipAddress", this.ipAddress);
        this.validateAttribute("subnetMask", this.subnetMask);
        this.validateAttribute("broadcastAddress", this.broadcast);
    }

    private void validateAttribute(String string, String string2) throws BemException {
        if (string2 == null) {
            return;
        }
        String string3 = (String)this.ethernetMo.getAttribute(string, null);
        if (!string2.equals(string3)) {
            this.rbs.stopInstallation();
            BemException bemException = new BemException();
            bemException.setProperty("Problem", "Failed modifying IP configuration");
            bemException.setProperty("Likely reason", "Unexpected RBS rollback or restart");
            bemException.setProperty("Bad value - Description", "Modified EthernetLink attribute '" + string + "' changed unexpectedly:");
            bemException.setProperty("Bad value - Expected", string2);
            bemException.setProperty("Bad value - Actual", string3);
            bemException.setProperty("ManagedObject", this.ethernetMo.getDN());
            bemException.setProperty("Failing MoOp", "getAttribute");
            bemException.setProperty("ResourceItem  (RI)", this.getName());
            throw bemException;
        }
    }

    public String calculateBroadcastAddress(String string, String string2) throws BemException {
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.convertIPAddressToArray(string);
        int[] nArray2 = this.convertIPAddressToArray(string2);
        for (int i = 0; i < nArray.length; ++i) {
            int n = this.calculateIpAdresses(nArray[i], nArray2[i], "broadcast");
            stringBuffer.append(n);
            if (i >= nArray.length - 1) continue;
            stringBuffer.append(".");
        }
        return stringBuffer.toString();
    }

    private int calculateIpAdresses(int n, int n2, String string) throws BemException {
        int n3 = -1;
        if (string.equals("network")) {
            n3 = n & n2;
        } else if (string.equals("broadcast")) {
            int n4 = n2 ^ 0xFF;
            n3 += (n | n4) + 1;
        } else {
            throw new BemException("calculateIpAdresses(), Address type " + string + " not found");
        }
        return n3;
    }

    private int[] convertIPAddressToArray(String string) throws BemException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = stringTokenizer.countTokens();
        if (n != 4) {
            throw new BemException("convertIPAddressToArray(), Not a valid IP address. IP address: " + string);
        }
        int[] nArray = new int[n];
        for (int i = 0; stringTokenizer.hasMoreTokens() && i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            nArray[i] = Integer.parseInt(string2);
        }
        return nArray;
    }

    public boolean isInstalled() throws BemException {
        if (this.isInstalled == null) {
            String string = this.ethernetLinkLdn;
            boolean bl = super.isExisting(string);
            this.isInstalled = bl;
        }
        return this.isInstalled;
    }

    public String getLoadedValue(String string) throws BemException {
        String string2 = null;
        string2 = (String)this.getAttribute(this.ethernetMo, string);
        return string2;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return this.ethernetLinkLdn;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        CustomerParameter customerParameter = super.getCustomerParameter("ipAddress");
        CustomerParameter customerParameter2 = super.getCustomerParameter("subnetMask");
        this.ipAddress = customerParameter.getValue();
        this.subnetMask = customerParameter2.getValue();
        this.broadcast = this.calculateBroadcastAddress(this.ipAddress, this.subnetMask);
        if (this.isInstalled()) {
            if (customerParameter.hasValueChanged() || customerParameter2.hasValueChanged()) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void setShouldBeReset(boolean bl) {
        this.shouldBeReset = bl;
    }
}

