/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;

public class EcBusRI
extends AbstractResourceItem {
    private static final String NAME = "EcBus";
    private static final String[] myInstallationPhases = new String[]{"CommonPowerSystemCreationPhase", "HwUnitDbControlledDeletionPhase"};
    private String ecBusLdn;
    private String connectionType;
    private String connectionRefLdn;
    private int ecBusNumber;

    public EcBusRI(Rbs rbs, int n, String string) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.ecBusNumber = n;
        MoInstance moInstance = rbs.getMoiRefs().getEquipmentMoi();
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, String.valueOf(n));
        this.ecBusLdn = fixedRdnMoi.getLdn();
        this.connectionType = string;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            Vector vector = this.addNameValueAttr();
            BemMo bemMo = super.getMo(this.ecBusLdn);
            boolean bl = bemMo.isExisting();
            if (bl) {
                super.setAttributes(bemMo, vector);
            } else {
                super.create(bemMo, vector);
            }
        }
    }

    public void updateLoadedValues() throws BemException {
        BemMo bemMo = super.getMo(this.ecBusLdn);
        boolean bl = super.isExisting(bemMo);
        if (!bl) {
            return;
        }
        String string = (String)bemMo.getAttribute("connectionType");
        if (string.equals("EC")) {
            String string2 = MessageFormat.format("EcBus{0}_", new Integer(this.ecBusNumber));
            IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "ecBusNumber");
            integerParameter.setLoadedValue(new Integer(this.ecBusNumber));
            BemMo bemMo2 = (BemMo)bemMo.getAttribute("ecBusConnectorRef");
            if (null == bemMo2) {
                return;
            }
            String string3 = bemMo2.getDN();
            Enumeration enumeration = (Enumeration)this.rbs.getCustomerParameterObject(string2 + "connectorType");
            if (bemMo2.getType().equals(MimAuxPlugInUnit.MOTYPENAME)) {
                enumeration.setLoadedValue("RU");
                this.setSectorNumberForRu(string2, bemMo2);
                int n = Integer.parseInt(this.rbs.getCustomerParameter(string2 + "connectorUnitNumber"));
                RadioEquipmentProvider radioEquipmentProvider = this.rbs.getRadioEquipmentProvider();
                AbstractRuRI[] abstractRuRIArray = radioEquipmentProvider.getSectorRadioUnits(n);
                if (null == abstractRuRIArray || abstractRuRIArray.length == 0) {
                    return;
                }
                for (int i = 0; i < abstractRuRIArray.length; ++i) {
                    if (!string3.equals(abstractRuRIArray[i].getAuxPiuLdn())) continue;
                    ((IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "internalConnectorUnitNumber")).setLoadedValue(new Integer(i + 1));
                    break;
                }
            } else if (bemMo2.getType().equals(MimPlugInUnit.MOTYPENAME)) {
                enumeration.setLoadedValue("DU");
                String string4 = string3.substring(0, string3.lastIndexOf(","));
                String string5 = string4.substring(string4.lastIndexOf("=") + 1, string4.length());
                ((IntegerParameter)this.rbs.getCustomerParameterObject(string2 + "connectorUnitNumber")).setLoadedValue(string5);
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            BemMo[] bemMoArray = this.getEcBusReservedByObjects();
            if (bemMoArray != null) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    super.deleteMoIfExisting(bemMoArray[i].getDN());
                }
            }
            super.deleteMoIfExisting(this.ecBusLdn);
        }
    }

    public BemMo[] getEcBusReservedByObjects() throws BemException {
        BemMo bemMo = super.getMo(this.ecBusLdn);
        if (!bemMo.isExisting()) {
            return null;
        }
        return (BemMo[])super.getAttribute(bemMo, "reservedBy");
    }

    public String getDisplayName() {
        return "EcBus: " + this.getLdn();
    }

    public String getLdn() {
        return this.ecBusLdn;
    }

    public String getConnectionRefLdn() {
        return this.connectionRefLdn;
    }

    public void setConnectionRefLdn(String string) {
        this.connectionRefLdn = string;
    }

    private Vector addNameValueAttr() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo = this.getEcBusConnectorRef();
        if (null != bemMo) {
            vector.add(Nal.getFactory().getNameValue("ecBusConnectorRef", bemMo));
        }
        vector.add(Nal.getFactory().getNameValue("connectionType", this.connectionType));
        return vector;
    }

    private BemMo getEcBusConnectorRef() throws BemException {
        if (this.ecBusNumber == 1 || "AUX".equals(this.connectionType)) {
            return super.getMo(DuwUtil.getPrimaryDuwPiuLdn());
        }
        if (null == this.connectionRefLdn || "".equals(this.connectionRefLdn)) {
            return null;
        }
        return super.getMo(this.connectionRefLdn);
    }

    private void setSectorNumberForRu(String string, BemMo bemMo) throws BemException {
        IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "connectorUnitNumber");
        BemMoImpl[] bemMoImplArray = (BemMoImpl[])bemMo.getAttribute("reservedBy");
        if (null == bemMoImplArray) {
            return;
        }
        for (int i = 0; i < bemMoImplArray.length; ++i) {
            if (!MimAntFeederCable.MOTYPENAME.equals(bemMoImplArray[i].getType())) continue;
            BemMo bemMo2 = (BemMo)bemMoImplArray[i].getAttribute("antennaBranchRef");
            String string2 = bemMo2.getParent().getDN();
            String string3 = string2.substring(string2.lastIndexOf("=") + 1, string2.lastIndexOf("-"));
            integerParameter.setLoadedValue(string3);
            break;
        }
    }
}

