/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.AutoNegotiationParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.ConfiguredSpeedDuplexParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchVlanmembershipEgressConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchVlanmembershipVidConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.LagIdParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.MasterModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.provider.GigabitEthernetSyncRef;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.provider.GigabitEthernetSyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.resource.EthernetSwitchPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.resource.EthernetSwitchRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.resource.GigabitEthernetRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.resource.LagRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AutoIntegrationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.SyncRefInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.MomConverter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsSteps;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVidInformation;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ParentMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class EthernetSwitchCI
extends AbstractConfigurationItem
implements EtmBoardListener,
EthernetSwitchProvider,
EthernetProvider,
CustomerParameterListener,
GigabitEthernetSyncRefProvider {
    public static final String name = "EthernetSwitchCI";
    public static final String ACTION_VALUE_ADD_MODIFY = "ADD_MODIFY";
    public static final String ACTION_VALUE_DELETE = "DELETE";
    public static final int MAX_NUMBER_OF_PORTS = 7;
    public static final int MAX_NO_OF_ETHERNET_SWITCH_VLAN_MEMBERSHIP = 8;
    public static final int MAX_NO_OF_ETHERNET_SWITCH_PORT_VLAN_MEMBERSHIP = 255;
    private static final int MAX_NO_OF_LAG = 4;
    private EtmBoardProvider etmBoardProvider;
    private GigabitEthernetRI gigabitEthernetRI;
    private EthernetSwitchRI ethernetSwitchRI;
    private LagRI lagRI;
    private final EthernetSwitchPortRI[] ethernetSwitchPortRI = new EthernetSwitchPortRI[7];
    private int ethernetSwitchVlanMembershipCounter = 0;
    private int lagCounter = 0;
    private final int[] ethernetSwitchPortVlanMembershipCounter = new int[7];
    private final LagIdParameterRestriction lagIdRestriction = new LagIdParameterRestriction("Link Aggregation Group is optional", 2);
    private boolean isOpen = false;
    ParameterRestriction ignoreRestriction = new ParameterRestriction("Value is not used when Gigabit ethernet is not wanted for ATM", 1);
    ParameterRestriction tncRestriction = new ParameterRestriction("TNC is only supported for DUW v2.");
    private String syncESlot;
    private static final String DUW_BOARD = "DUW";

    public EthernetSwitchCI(Rbs rbs) {
        super(rbs);
    }

    private int getEthernetSwitchVlanMembershipCounter(String string) {
        int n = 0;
        if (string.startsWith("EthernetSwitchVlanMembership")) {
            n = this.ethernetSwitchVlanMembershipCounter;
        } else if (!string.equals("")) {
            int n2 = this.getPortNumberFromEthernetSwitchPortPseudo(string);
            n = this.ethernetSwitchPortVlanMembershipCounter[n2 - 1];
        }
        return n;
    }

    public boolean lagCounterReachedLimit() {
        return this.lagCounter >= 4;
    }

    public boolean vlanMemberShipCounterReachedLimit(String string) {
        int n = string.startsWith("EthernetSwitchVlanMembership") ? 8 : 255;
        return this.getEthernetSwitchVlanMembershipCounter(string) >= n;
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("EthernetSwitchCI.open(): Already open");
        }
        this.setupProviders();
        this.createAllResourceItems();
        this.initialiseSynESlot();
        this.isOpen = true;
        return this.isOpen;
    }

    public void afterOpen() throws BemException {
        if (!this.gigabitEthernetRI.isInstalled() && DuwUtil.hasDuw() || DuwUtil.isPrimaryDuwV2()) {
            Enumeration enumeration = (Enumeration)this.getRbs().getCustomerParameterObject("gigaBitEthernetPort");
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.getRbs().getCustomerParameterObject("gigaBitEthernetPortCreate");
            AutoNegotiationParameter autoNegotiationParameter = (AutoNegotiationParameter)this.getRbs().getCustomerParameterObject("autoNegotiation");
            MasterModeParameter masterModeParameter = (MasterModeParameter)this.getRbs().getCustomerParameterObject("masterMode");
            ConfiguredSpeedDuplexParameter configuredSpeedDuplexParameter = (ConfiguredSpeedDuplexParameter)this.getRbs().getCustomerParameterObject("configuredSpeedDuplex");
            YesNoCustomerParameter yesNoCustomerParameter2 = (YesNoCustomerParameter)this.getRbs().getCustomerParameterObject("emscSupport");
            Enumeration enumeration2 = (Enumeration)this.getRbs().getCustomerParameterObject("useReceivedQl");
            Enumeration enumeration3 = (Enumeration)this.getRbs().getCustomerParameterObject("adminQuality");
            Vector<Enumeration> vector = new Vector<Enumeration>();
            vector.add(autoNegotiationParameter);
            vector.add(masterModeParameter);
            vector.add(configuredSpeedDuplexParameter);
            this.changeGigabitEthernetPortRange(enumeration);
            GigabitPortCreateListener gigabitPortCreateListener = new GigabitPortCreateListener(enumeration, vector, this.ignoreRestriction);
            yesNoCustomerParameter.addCustomerParameterListener(gigabitPortCreateListener);
            GigabitPortListener gigabitPortListener = new GigabitPortListener(vector, this.ignoreRestriction, yesNoCustomerParameter);
            enumeration.addCustomerParameterListener(gigabitPortListener);
            if (this.getRbs().isParameterSupported("IPoverGigabitEthernet_transportOption")) {
                CustomerParameter customerParameter = this.getRbs().getCustomerParameterObject("IPoverGigabitEthernet_transportOption");
                TransportOptionListener transportOptionListener = new TransportOptionListener(yesNoCustomerParameter, yesNoCustomerParameter2, enumeration2, enumeration3, this.ignoreRestriction);
                customerParameter.addCustomerParameterListener(transportOptionListener);
                transportOptionListener.parameterPropertiesChanged(customerParameter, new ParameterEvent(15));
            }
            gigabitPortCreateListener.parameterPropertiesChanged(yesNoCustomerParameter, new ParameterEvent(15));
            gigabitPortListener.parameterPropertiesChanged(enumeration, new ParameterEvent(15));
        }
    }

    private void changeGigabitEthernetPortRange(Enumeration enumeration) throws BemException {
        if (!DuwUtil.isPrimaryDuwV2()) {
            EnumeratedRange enumeratedRange = new EnumeratedRange(new String[]{"TNA", "TNB"});
            this.tncRestriction.setRange(enumeratedRange, true);
            enumeration.addRestriction(this.tncRestriction);
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void createAllResourceItems() throws BemException {
        this.gigabitEthernetRI = new GigabitEthernetRI(this.getRbs());
        List list = this.gigabitEthernetRI.createCustomerParameters();
        this.addCustomerParameters(list);
        if (!DuwUtil.hasDuw()) {
            this.ethernetSwitchRI = new EthernetSwitchRI(this.getRbs());
            List list2 = this.ethernetSwitchRI.createCustomerParameters();
            this.addCustomerParameters(list2);
            this.lagRI = new LagRI(this.getRbs());
            for (int i = 0; i < 7; ++i) {
                this.ethernetSwitchPortRI[i] = new EthernetSwitchPortRI(this.getRbs(), i + 1);
                if (this.getRbs().getRbsStep().equals("STEP_CABINET") && (i == 2 || i == 5 || i == 6)) {
                    this.ethernetSwitchPortRI[i].setConfOamVlan(true);
                }
                list2 = this.ethernetSwitchPortRI[i].createCustomerParameters();
                this.addCustomerParameters(list2);
            }
        }
        this.update();
    }

    public boolean hasEthernetSwitch() throws BemException {
        boolean bl = false;
        if (this.ethernetSwitchRI != null && this.ethernetSwitchRI.isInstalled()) {
            bl = true;
        }
        return bl;
    }

    private void addCustomerParameters(List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CustomerParameter customerParameter = (CustomerParameter)iterator.next();
                this.addParameter(customerParameter);
            }
        }
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        if (!DuwUtil.hasDuw()) {
            this.ethernetSwitchRI.checkConsistency();
            for (int i = 0; i < this.ethernetSwitchPortRI.length; ++i) {
                this.ethernetSwitchPortRI[i].checkConsistency();
            }
        }
    }

    public ArrayList getNeededRIs() throws BemException {
        if (!this.isOpen) {
            throw new BemException("EthernetSwitchCI.getNeededRIs(): EthernetSwitchCI is not open");
        }
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (DuwUtil.hasDuw()) {
            this.setupAutoIntegrationProvider(true);
            String string = this.getRbs().getCustomerParameter("gigaBitEthernetPortCreate");
            if (string.equals("YES")) {
                arrayList.add(this.gigabitEthernetRI);
                return arrayList;
            }
        } else if (this.ethernetSwitchRI != null && this.ethernetSwitchRI.getLdn() != null) {
            this.setupAutoIntegrationProvider(false);
            arrayList.add(this.ethernetSwitchRI);
            if (this.rbs.getCustomerParameterObjectsWithPseudo("linkAggregationGroup").length > 0) {
                arrayList.add(this.lagRI);
            }
            for (int i = 0; i < this.ethernetSwitchPortRI.length; ++i) {
                arrayList.add(this.ethernetSwitchPortRI[i]);
            }
        }
        return arrayList;
    }

    public CustomerParameter createCP(String string, String string2) throws BemException {
        Object object;
        CustomerParameterImpl customerParameterImpl = null;
        boolean bl = false;
        if (string.startsWith("EthernetSwitchVlanMembership")) {
            bl = this.ethernetSwitchRI.pseudoIsExisting(string);
        } else {
            for (int i = 0; i < 7; ++i) {
                if (!string.startsWith(MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership", new Integer(i + 1)))) continue;
                bl = this.ethernetSwitchPortRI[i].pseudoIsExisting(string);
                break;
            }
        }
        try {
            if (this.rbs.getCustomerParameter(string) != null && !this.rbs.getCustomerParameter(string).equals("")) {
                bl = true;
            }
        }
        catch (BemException bemException) {
            bl = false;
        }
        if (string.startsWith("linkAggregationGroup") && string.endsWith("lagId")) {
            StringParameter stringParameter;
            if (bl) {
                stringParameter = (StringParameter)this.getRbs().getCustomerParameterObject(string);
                stringParameter.setValue(string2);
            } else {
                stringParameter = new StringParameter(string, new StringRange(new Integer(0), new Integer(10)));
                object = new EthernetSwitchVlanmembershipVidConversion();
                stringParameter.setMomConverter((MomConverter)object);
                stringParameter.setValue(string2);
                this.addParameter(stringParameter);
            }
            customerParameterImpl = stringParameter;
        } else if (string.startsWith("linkAggregationGroup") && string.endsWith("action")) {
            Enumeration enumeration;
            if (bl) {
                enumeration = (Enumeration)this.getRbs().getCustomerParameterObject(string);
                object = enumeration.getValue();
                enumeration.setValue(string2);
                if (string2.equals(ACTION_VALUE_ADD_MODIFY) && !((String)object).equals(string2)) {
                    ++this.lagCounter;
                } else if (string2.equals(ACTION_VALUE_DELETE) && !((String)object).equals(string2)) {
                    --this.lagCounter;
                }
            } else {
                enumeration = new Enumeration(string, new String[]{ACTION_VALUE_ADD_MODIFY, ACTION_VALUE_DELETE});
                enumeration.setDefaultValue(ACTION_VALUE_ADD_MODIFY);
                enumeration.setValue(string2);
                this.addParameter(enumeration);
                enumeration.addCustomerParameterListener(this);
                this.parameterPropertiesChanged(enumeration, null);
                if (string2.equals(ACTION_VALUE_ADD_MODIFY)) {
                    ++this.lagCounter;
                }
            }
            customerParameterImpl = enumeration;
        } else if (string.endsWith("vid")) {
            IntegerParameter integerParameter;
            if (bl) {
                integerParameter = (IntegerParameter)this.getRbs().getCustomerParameterObject(string);
                integerParameter.setValue(string2);
            } else {
                integerParameter = new IntegerParameter(string, new IntegerRange(0, 4096));
                object = new EthernetSwitchVlanmembershipVidConversion();
                integerParameter.setMomConverter((MomConverter)object);
                integerParameter.setDefaultValue(MimVidInformation.DEFAULT_VID.toString());
                integerParameter.setValue(string2);
                this.addParameter(integerParameter);
            }
            customerParameterImpl = integerParameter;
        } else if (string.endsWith("egressUntag")) {
            TrueFalseCustomerParameter trueFalseCustomerParameter;
            if (bl) {
                trueFalseCustomerParameter = (TrueFalseCustomerParameter)this.getRbs().getCustomerParameterObject(string);
                trueFalseCustomerParameter.setValue(string2);
            } else {
                trueFalseCustomerParameter = new TrueFalseCustomerParameter(string);
                object = new EthernetSwitchVlanmembershipEgressConversion();
                trueFalseCustomerParameter.setMomConverter((MomConverter)object);
                trueFalseCustomerParameter.setDefaultValue(MimVidInformation.DEFAULT_EGRESSUNTAG.toString());
                trueFalseCustomerParameter.setValue(string2);
                this.addParameter(trueFalseCustomerParameter);
            }
            customerParameterImpl = trueFalseCustomerParameter;
        } else if (string.endsWith("action")) {
            Enumeration enumeration;
            if (bl) {
                enumeration = (Enumeration)this.getRbs().getCustomerParameterObject(string);
                object = enumeration.getValue();
                enumeration.setValue(string2);
                if (string2.equals(ACTION_VALUE_ADD_MODIFY) && !((String)object).equals(string2)) {
                    this.increaseVlanMemberShipCounter(string);
                } else if (string2.equals(ACTION_VALUE_DELETE) && !((String)object).equals(string2)) {
                    this.decreaseVlanMemberShipCounter(string);
                }
            } else {
                enumeration = new Enumeration(string, new String[]{ACTION_VALUE_ADD_MODIFY, ACTION_VALUE_DELETE});
                enumeration.setDefaultValue(ACTION_VALUE_ADD_MODIFY);
                enumeration.setValue(string2);
                this.addParameter(enumeration);
                if (string2.equals(ACTION_VALUE_ADD_MODIFY)) {
                    this.increaseVlanMemberShipCounter(string);
                }
            }
            customerParameterImpl = enumeration;
        }
        if (string.startsWith("EthernetSwitchVlanMembership")) {
            if (!bl) {
                this.ethernetSwitchRI.addPseudo(string);
            }
        } else if (string.startsWith("linkAggregationGroup")) {
            if (!bl) {
                this.lagRI.addPseudo(string);
            }
        } else {
            for (int i = 0; i < 7; ++i) {
                if (!string.startsWith(MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership", new Integer(i + 1))) || bl) continue;
                this.ethernetSwitchPortRI[i].addPseudo(string);
            }
        }
        return customerParameterImpl;
    }

    private void setupProviders() throws BemException {
        if (this.etmBoardProvider == null) {
            this.etmBoardProvider = (EtmBoardProvider)this.getRbs().getProvider(EtmBoardProvider.class);
            if (this.etmBoardProvider != null) {
                this.etmBoardProvider.addEtmBoardListener(this);
            } else {
                throw new BemException("EthernetSwitchCI.open(): can not obtain EtmBoardProvider");
            }
        }
    }

    private void setupAutoIntegrationProvider(boolean bl) throws BemException {
        if (RbsSteps.isIntegrateStep(this.getRbs().getRbsStep()) || this.getRbs().getRbsStep().equals("STEP_MIGRATE_RBS")) {
            AutoIntegrationProvider autoIntegrationProvider = (AutoIntegrationProvider)this.getRbs().getProvider(AutoIntegrationProvider.class);
            if (autoIntegrationProvider != null) {
                if (bl) {
                    CustomerParameter customerParameter = autoIntegrationProvider.getGigabitEthernetPortCP();
                    if (customerParameter != null && customerParameter.getAccessLevel() != 1) {
                        CustomerParameter customerParameter2;
                        CustomerParameter customerParameter3 = this.rbs.getCustomerParameterObject("gigaBitEthernetPortCreate");
                        if (customerParameter3 != null) {
                            customerParameter3.setValue("YES");
                        }
                        if ((customerParameter2 = this.rbs.getCustomerParameterObject("gigaBitEthernetPort")) != null) {
                            customerParameter2.setValue(customerParameter.getValue());
                        }
                    }
                } else {
                    CustomerParameter customerParameter;
                    CustomerParameter customerParameter4 = autoIntegrationProvider.getOamVidCP();
                    if (customerParameter4 != null) {
                        this.updateOamVid(customerParameter4);
                    }
                    if ((customerParameter = autoIntegrationProvider.getOamVlanCP()) != null) {
                        this.updateOamVlan(customerParameter);
                    }
                }
            } else {
                throw new BemException("can not obtain AutoIntegrationProvider");
            }
        }
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        Object object;
        int n;
        Vector vector = serviceValue.getAttributesStartingWith("linkAggregationGroup");
        for (int i = 0; i < vector.size(); ++i) {
            NalNameValue nalNameValue = (NalNameValue)vector.get(i);
            this.createCP(nalNameValue.getName(), (String)nalNameValue.getValue());
        }
        Vector vector2 = serviceValue.getAttributesStartingWith("EthernetSwitchVlanMembership");
        for (n = 0; n < vector2.size(); ++n) {
            NalNameValue nalNameValue = (NalNameValue)vector2.get(n);
            this.createCP(nalNameValue.getName(), (String)nalNameValue.getValue());
        }
        for (n = 1; n <= 7; ++n) {
            vector2 = serviceValue.getAttributesStartingWith(MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership", new Integer(n)));
            for (int i = 0; i < vector2.size(); ++i) {
                object = (NalNameValue)vector2.get(i);
                this.createCP(object.getName(), (String)object.getValue());
            }
        }
        if (DuwUtil.hasDuw()) {
            boolean bl;
            String string = serviceValue.getValue("IpIubTestConfiguration_etxSlot");
            String string2 = serviceValue.getValue("IPoverGigabitEthernet_syncIpAddress");
            object = serviceValue.getValue("firstOAMatm_atmIpAddress");
            String string3 = serviceValue.getValue("gigaBitEthernetPort");
            boolean bl2 = string != null || string2 != null;
            boolean bl3 = bl = object != null;
            if (bl2 || bl && string3 != null) {
                CustomerParameter customerParameter = this.getRbs().getCustomerParameterObject("gigaBitEthernetPortCreate");
                customerParameter.setValue("YES");
            }
        }
        String[] stringArray = this.getAllCustomerParameterNames();
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        this.checkConsistency();
    }

    public String getName() {
        return name;
    }

    public void update() {
        try {
            MoInstance moInstance = this.etmBoardProvider.getExchangeTerminalIpMoi();
            if (DuwUtil.hasDuw()) {
                if (moInstance != null) {
                    this.gigabitEthernetRI.setEtmBoard(moInstance);
                    this.gigabitEthernetRI.initiateCPWithNodeValues();
                }
            } else {
                MoInstance moInstance2 = this.ethernetSwitchRI.setEtmBoard(moInstance);
                if (moInstance2 != null) {
                    this.ethernetSwitchRI.initiateCPWithNodeValues();
                    this.lagRI.setEthernetSwitch(moInstance2);
                    this.lagRI.initiateCPWithNodeValues();
                    for (int i = 0; i < 7; ++i) {
                        this.ethernetSwitchPortRI[i].setEthernetSwitch(moInstance2);
                        if (this.isEtmfxPreConfiguredInBasicCV(moInstance, i + 1)) continue;
                        this.ethernetSwitchPortRI[i].initiateCPWithNodeValues();
                    }
                }
            }
        }
        catch (BemException bemException) {
            BemLog.log(2, this.getClass() + ".update()" + bemException.toString());
        }
    }

    public int increaseVlanMemberShipCounter(String string) throws BemException {
        int n = 0;
        if (string.startsWith("EthernetSwitchVlanMembership")) {
            n = this.ethernetSwitchVlanMembershipCounter++;
            if (this.ethernetSwitchVlanMembershipCounter > 8) {
                throw new BemException("Max No Of Vlan MemberShip exceeded");
            }
        } else if (!string.equals("")) {
            int n2 = this.getPortNumberFromEthernetSwitchPortPseudo(string);
            n = this.ethernetSwitchPortVlanMembershipCounter[n2 - 1];
            int n3 = n2 - 1;
            this.ethernetSwitchPortVlanMembershipCounter[n3] = this.ethernetSwitchPortVlanMembershipCounter[n3] + 1;
            if (this.ethernetSwitchPortVlanMembershipCounter[n2 - 1] > 255) {
                throw new BemException("Max No Of Vlan MemberShip exceeded");
            }
        }
        return n;
    }

    private void decreaseVlanMemberShipCounter(String string) {
        if (string.startsWith("EthernetSwitchVlanMembership")) {
            --this.ethernetSwitchVlanMembershipCounter;
        } else if (!string.equals("")) {
            int n = this.getPortNumberFromEthernetSwitchPortPseudo(string);
            int n2 = n - 1;
            this.ethernetSwitchPortVlanMembershipCounter[n2] = this.ethernetSwitchPortVlanMembershipCounter[n2] - 1;
        }
    }

    public int getPortNumberFromEthernetSwitchPortPseudo(String string) {
        int n = "EthernetSwitchPort".length();
        String string2 = string.substring(n + 1, n + 2);
        int n2 = Integer.parseInt(string2);
        return n2;
    }

    public void setEtmBoardProvider(EtmBoardProvider etmBoardProvider) {
        this.etmBoardProvider = etmBoardProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MoInstance getEthernetInterface(String string) throws BemException {
        MoInstance moInstance = null;
        if (!DuwUtil.hasDuw()) return this.ethernetSwitchRI.getInternalEthernetPortMoi();
        if (string.equals("1")) {
            return this.gigabitEthernetRI.getGigabitEthernetMoi();
        }
        if (!string.equals("2")) throw new BemException("Not valid Etx slot. slot=" + string + " should be 1 or 2");
        return this.gigabitEthernetRI.getGigabitEthernetMoi();
    }

    private void updateOamVid(CustomerParameter customerParameter) {
        String string = customerParameter.getValue();
        try {
            if (customerParameter.getAccessLevel() != 1) {
                String string2 = MessageFormat.format("EthernetSwitchVlanMembership_{0}_vid", string);
                String string3 = MessageFormat.format("EthernetSwitchVlanMembership_{0}_egressUntag", string);
                String string4 = MessageFormat.format("EthernetSwitchVlanMembership_{0}_action", string);
                this.createCP(string2, string);
                this.createCP(string3, "FALSE");
                this.createCP(string4, ACTION_VALUE_ADD_MODIFY);
                String string5 = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_vid", new Integer(6), string);
                String string6 = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_egressUntag", new Integer(6), string);
                String string7 = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_action", new Integer(6), string);
                this.createCP(string5, string);
                this.createCP(string6, "FALSE");
                this.createCP(string7, ACTION_VALUE_ADD_MODIFY);
                String string8 = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_vid", new Integer(7), string);
                String string9 = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_egressUntag", new Integer(7), string);
                String string10 = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership_{1}_action", new Integer(7), string);
                this.createCP(string8, string);
                this.createCP(string9, "FALSE");
                this.createCP(string10, ACTION_VALUE_ADD_MODIFY);
            }
        }
        catch (BemException bemException) {
            BemLog.log(2, "EthernetSwitchCI.updateOamVid(), failed");
        }
    }

    private void updateOamVlan(CustomerParameter customerParameter) {
        try {
            if (customerParameter.getAccessLevel() != 1) {
                String string = customerParameter.getValue();
                CustomerParameter customerParameter2 = this.getRbs().getCustomerParameterObject("EthernetSwitchvlan");
                customerParameter2.setValue(string);
            }
        }
        catch (BemException bemException) {
            BemLog.log(2, "EthernetSwitchCI.updateOamVlan(), failed");
        }
    }

    public MoInstance getEthernetSwitchMoi() {
        return this.ethernetSwitchRI.getMoi();
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        String string = customerParameter.getName();
        if (string.startsWith("linkAggregationGroup")) {
            String string2 = this.getLagIdFromPseudo(string);
            if (customerParameter.getValue().equals(ACTION_VALUE_ADD_MODIFY)) {
                this.lagIdRestriction.addModifyLagId(string2);
            } else if (customerParameter.getValue().equals(ACTION_VALUE_DELETE)) {
                this.lagIdRestriction.deleteLagId(string2);
            }
        }
    }

    private String getLagIdFromPseudo(String string) {
        String string2 = "_";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        return string3;
    }

    public ParameterRestriction getLagIdRestriction() {
        return this.lagIdRestriction;
    }

    private boolean isEtmfxPreConfiguredInBasicCV(MoInstance moInstance, int n) throws BemException {
        boolean bl = false;
        if (this.rbs.getRbsStep().equals("STEP_CABINET")) {
            MoHandler moHandler = this.rbs.getMoHandler();
            ParentMoi parentMoi = new ParentMoi(moInstance);
            ParentMoi parentMoi2 = new ParentMoi(parentMoi);
            String string = BemUtil.extractRdnId(parentMoi2.getLdn(), MimSlot.MOTYPENAME);
            BemMo bemMo = moHandler.getMo(this.ethernetSwitchPortRI[0].getLdn());
            BemMo bemMo2 = moHandler.getMo(this.ethernetSwitchPortRI[1].getLdn());
            if (string.equals("2") || string.equals("3")) {
                try {
                    if (moHandler.isExisting(bemMo2) && !moHandler.isExisting(bemMo) && (n == 2 || n == 3)) {
                        bl = true;
                    }
                }
                catch (MoHandlerException moHandlerException) {
                    throw new BemException("Failed in isEtmfxPreConfiguredInBasicCV()", (Throwable)moHandlerException);
                }
            }
        }
        return bl;
    }

    public String[] getAvailableGigabitEthernetSyncRefSlots() throws BemException {
        return new String[]{this.syncESlot};
    }

    public GigabitEthernetSyncRef[] getAvailableGigabitEthernetSyncRefs(String string) throws BemException {
        ArrayList<GigabitEthernetRI> arrayList = new ArrayList<GigabitEthernetRI>();
        String string2 = this.syncESlot;
        if (string2.equals(string)) {
            arrayList.add(this.gigabitEthernetRI);
        }
        GigabitEthernetSyncRef[] gigabitEthernetSyncRefArray = arrayList.toArray(new GigabitEthernetSyncRef[0]);
        return gigabitEthernetSyncRefArray;
    }

    public SyncRefInfo[] getGigabitEthernetSyncRefs(String string) throws BemException {
        GigabitEthernetSyncRef[] gigabitEthernetSyncRefArray = this.getAvailableGigabitEthernetSyncRefs(string);
        String string2 = DUW_BOARD;
        ArrayList<SyncRefInfo> arrayList = new ArrayList<SyncRefInfo>();
        for (int i = 0; i < gigabitEthernetSyncRefArray.length; ++i) {
            arrayList.add(new SyncRefInfo(gigabitEthernetSyncRefArray[i].getGigabitEthernetSyncRefLdn(), Integer.parseInt(ServiceCommon.DUWV2_SYNCE_PORT), string2));
        }
        return arrayList.toArray(new SyncRefInfo[0]);
    }

    public String getSlotForSyncESyncRefLdn(String string) throws BemException {
        String string2 = null;
        String string3 = this.gigabitEthernetRI.getGigabitEthernetSyncRefLdn();
        if (string.equals(string3)) {
            string2 = this.syncESlot;
        }
        return string2;
    }

    private void initialiseSynESlot() throws BemException {
        MoInstance moInstance = null;
        if (this.etmBoardProvider != null) {
            moInstance = this.etmBoardProvider.getExchangeTerminalIpMoi();
        }
        if (moInstance == null) {
            EtmBoardProvider etmBoardProvider = (EtmBoardProvider)((Object)this.rbs.getConfigItem("EtmBoardCI"));
            moInstance = etmBoardProvider.getExchangeTerminalIpMoi();
        }
        this.syncESlot = moInstance == null ? "0" : BemUtil.extractRdnId(moInstance.getLdn(), MimSlot.MOTYPENAME);
    }

    private static class TransportOptionListener
    implements CustomerParameterListener {
        private ParameterRestriction restriction = null;
        private YesNoCustomerParameter portCreate;
        private YesNoCustomerParameter esmcSupport;
        private Enumeration gigaBitEthernetUseReceivedQL;
        private Enumeration gigaBitEthernetAdminQuality;
        private ParameterRestriction ignoreRestriction;

        public TransportOptionListener(YesNoCustomerParameter yesNoCustomerParameter, YesNoCustomerParameter yesNoCustomerParameter2, Enumeration enumeration, Enumeration enumeration2, ParameterRestriction parameterRestriction) {
            this.portCreate = yesNoCustomerParameter;
            this.restriction = new ParameterRestriction("Value must be YES for transport option IPv4");
            this.restriction.setAccessLevel(0);
            this.esmcSupport = yesNoCustomerParameter2;
            this.gigaBitEthernetUseReceivedQL = enumeration;
            this.gigaBitEthernetAdminQuality = enumeration2;
            this.ignoreRestriction = parameterRestriction;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (customerParameter.getValue().equals("atm")) {
                if (this.portCreate.getRestrictions().contains(this.restriction)) {
                    this.portCreate.removeRestriction(this.restriction);
                    this.portCreate.setValue("NO");
                }
                if (DuwUtil.hasDuw()) {
                    if (!this.esmcSupport.getRestrictions().contains(this.ignoreRestriction)) {
                        this.esmcSupport.addRestriction(this.ignoreRestriction);
                    }
                    if (!this.gigaBitEthernetAdminQuality.getRestrictions().contains(this.ignoreRestriction)) {
                        this.gigaBitEthernetAdminQuality.addRestriction(this.ignoreRestriction);
                    }
                    if (!this.gigaBitEthernetUseReceivedQL.getRestrictions().contains(this.ignoreRestriction)) {
                        this.gigaBitEthernetUseReceivedQL.addRestriction(this.ignoreRestriction);
                    }
                }
            } else if (customerParameter.getValue().equals("ipV4")) {
                if (!this.portCreate.getRestrictions().contains(this.restriction)) {
                    this.portCreate.setValue("YES");
                    this.portCreate.setLoadedValue("YES");
                    this.portCreate.addRestriction(this.restriction);
                }
                if (DuwUtil.hasDuw()) {
                    if (this.esmcSupport.getRestrictions().contains(this.ignoreRestriction)) {
                        this.esmcSupport.removeRestriction(this.ignoreRestriction);
                    }
                    if (this.gigaBitEthernetAdminQuality.getRestrictions().contains(this.ignoreRestriction)) {
                        this.gigaBitEthernetAdminQuality.removeRestriction(this.ignoreRestriction);
                    }
                    if (this.gigaBitEthernetUseReceivedQL.getRestrictions().contains(this.ignoreRestriction)) {
                        this.gigaBitEthernetUseReceivedQL.removeRestriction(this.ignoreRestriction);
                    }
                }
            }
        }
    }

    private static class GigabitPortListener
    implements CustomerParameterListener {
        private ParameterRestriction ignoreRestriction;
        private Vector impactedCustomerParameter;
        private YesNoCustomerParameter gigabitPortCreate;

        public GigabitPortListener(Vector vector, ParameterRestriction parameterRestriction, YesNoCustomerParameter yesNoCustomerParameter) {
            this.impactedCustomerParameter = vector;
            this.ignoreRestriction = parameterRestriction;
            this.gigabitPortCreate = yesNoCustomerParameter;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            String string = customerParameter.getValue();
            Iterator iterator = this.impactedCustomerParameter.iterator();
            while (iterator.hasNext()) {
                Enumeration enumeration = (Enumeration)iterator.next();
                if (string.equals("TNA")) {
                    if (enumeration.getRestrictions().contains(this.ignoreRestriction)) continue;
                    enumeration.addRestriction(this.ignoreRestriction);
                    continue;
                }
                if (!this.gigabitPortCreate.getValue().equals("YES") || !enumeration.getRestrictions().contains(this.ignoreRestriction)) continue;
                enumeration.removeRestriction(this.ignoreRestriction);
            }
        }
    }

    private static class GigabitPortCreateListener
    implements CustomerParameterListener {
        private ParameterRestriction ignoreRestriction;
        private Enumeration port;
        private Vector impactedCustomerParameter;

        public GigabitPortCreateListener(Enumeration enumeration, Vector vector, ParameterRestriction parameterRestriction) {
            this.port = enumeration;
            this.impactedCustomerParameter = vector;
            this.ignoreRestriction = parameterRestriction;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            block5: {
                block4: {
                    if (!customerParameter.getValue().equals("YES")) break block4;
                    if (this.port.getRestrictions().contains(this.ignoreRestriction)) {
                        this.port.removeRestriction(this.ignoreRestriction);
                    }
                    if (!this.port.getValue().equals("TNB") && !this.port.getValue().equals("TNC")) break block5;
                    Iterator iterator = this.impactedCustomerParameter.iterator();
                    while (iterator.hasNext()) {
                        Enumeration enumeration = (Enumeration)iterator.next();
                        if (!enumeration.getRestrictions().contains(this.ignoreRestriction)) continue;
                        enumeration.removeRestriction(this.ignoreRestriction);
                    }
                    break block5;
                }
                if (!this.port.getRestrictions().contains(this.ignoreRestriction)) {
                    this.port.addRestriction(this.ignoreRestriction);
                }
                Iterator iterator = this.impactedCustomerParameter.iterator();
                while (iterator.hasNext()) {
                    Enumeration enumeration = (Enumeration)iterator.next();
                    if (enumeration.getRestrictions().contains(this.ignoreRestriction)) continue;
                    enumeration.addRestriction(this.ignoreRestriction);
                }
            }
        }
    }
}

