/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.LocationParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.ipoveratm.IpOverAtmListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.ipoveratm.IpOverAtmRegistrator;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.ipoveratm.RegistrationEvent;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.IpOverAtmProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.LocationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.RIAndCPSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.AtmIpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.AtmSubnetMaskParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.IpOverAtmParameterSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.ServiceCategoryConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.ServiceCategoryParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VciParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpMcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpPcrParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam.VpiParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.provider.IpOverAtmInfoProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.provider.IpOverAtmInfoTextProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.provider.RedundancyChangeProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource.Aal5TpVccTpRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource.AtmStackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.resource.IpAtmLinkRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.ControlSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class IpOverAtmCI
extends AbstractConfigurationItem
implements IpOverAtmListener,
IpOverAtmInfoTextProvider,
RedundancyChangeProvider,
IpOverAtmInfoProvider {
    public static final String name = "IpOverAtmCI";
    static final String[] MSG_LINK_TYPE = new String[]{"default", "redundant"};
    public static final int DEFAULT = 0;
    public static final int REDUNDANT = 1;
    public static final int NO_OF_LINKS = 2;
    private static final String[] IP_ATM_PSEUDO_PREFIX = new String[]{"firstOAMatm_", "secondOAMatm_"};
    private static final String PARAMETER_SET_PSEUDO = "IpOverAtmLinkParamSet_{0}";
    private int linkIdCounter = 0;
    private final boolean[] ipAtmLinkCreated = new boolean[]{false, false};
    AtmPortProvider atmPortProvider = null;
    LocationProvider locationProvider = null;
    private LocationParameter location = null;
    IpOverAtmProvider ipOverAtmProvider = null;
    IpOverAtmRegistrator ipOverAtmRegistrator = null;
    ControlSystemProvider controlSProvider = null;
    private boolean isOpen = false;
    private ArrayList listOfRIAndCPSet = null;
    private boolean isChangeOfRedundantLinkPossible = false;
    private boolean checkIfChangeOfRedundantLinkIsPossible = false;
    private boolean changeOfRedundantLinkAnsweredToYes = false;
    private String redundantMpType = null;

    public static String getIpAtmPseudoPrefixByIndex(int n) {
        return IP_ATM_PSEUDO_PREFIX[n];
    }

    public static String getMsgLinkTypeStringByIndex(int n) {
        return MSG_LINK_TYPE[n];
    }

    public IpOverAtmCI(Rbs rbs) {
        super(rbs);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("IpOverAtmCI.open(): Already open");
        }
        this.listOfRIAndCPSet = new ArrayList();
        this.setProviders();
        for (int i = 0; i < 2; ++i) {
            this.ipOverAtmRegistrator.addIpOverAtmListener(i, this);
        }
        this.isOpen = true;
        return this.isOpen;
    }

    private void setProviders() throws BemException {
        if (this.atmPortProvider == null) {
            this.atmPortProvider = (AtmPortProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        }
        if (this.locationProvider == null) {
            this.locationProvider = (LocationProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        }
        this.location = this.locationProvider.getLocationParameter();
        if (this.ipOverAtmProvider == null) {
            this.ipOverAtmProvider = (IpOverAtmProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        }
        if (this.ipOverAtmRegistrator == null) {
            this.ipOverAtmRegistrator = this.ipOverAtmProvider.getIpOverAtmRegistrator();
        }
        if (this.controlSProvider == null) {
            this.controlSProvider = (ControlSystemProvider)this.rbs.getProvider(ControlSystemProvider.class);
        }
    }

    public String getName() {
        return name;
    }

    protected void loadConfigurationUsedForIpAtmLinks() throws BemException {
        Iterator iterator = this.listOfRIAndCPSet.iterator();
        while (iterator.hasNext()) {
            RIAndCPSet rIAndCPSet = (RIAndCPSet)iterator.next();
            Aal5TpVccTpRI aal5TpVccTpRI = rIAndCPSet.getAal5TpVccTpRI();
            AtmStackRI atmStackRI = rIAndCPSet.getAtmStackRI();
            atmStackRI.setLoadedVclTpMO(aal5TpVccTpRI.getLoadedVclTpId());
        }
    }

    public ArrayList getNeededRIs() throws BemException {
        BemLog.log(3, this.getClass() + ": getNeededRIs(), entered!");
        if (!this.isOpen) {
            throw new BemException("IpOverAtmCI is not open");
        }
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        this.copyVclTrafficDescriptor();
        Iterator iterator = this.listOfRIAndCPSet.iterator();
        while (iterator.hasNext()) {
            RIAndCPSet rIAndCPSet = (RIAndCPSet)iterator.next();
            boolean bl = this.updateRIsBeforeInstall(rIAndCPSet);
            if (!bl) continue;
            arrayList.add(rIAndCPSet.getIpAtmLinkRI());
            arrayList.add(rIAndCPSet.getAal5TpVccTpRI());
            arrayList.add(rIAndCPSet.getAtmStackRI());
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        if (!this.isOpen) {
            throw new BemException("IpOverAtmCI is not open");
        }
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (this.isATMDeletedNeeded()) {
            BemLog.log(3, this.getClass() + ": getRIsToUninstall(), ATM is needed to delete!");
            Iterator iterator = this.listOfRIAndCPSet.iterator();
            while (iterator.hasNext()) {
                RIAndCPSet rIAndCPSet = (RIAndCPSet)iterator.next();
                if (!this.updateRIsBeforeUninstall(rIAndCPSet)) continue;
                arrayList.add(rIAndCPSet.getIpAtmLinkRI());
                arrayList.add(rIAndCPSet.getAal5TpVccTpRI());
                arrayList.add(rIAndCPSet.getAtmStackRI());
            }
        } else {
            RIAndCPSet rIAndCPSet = this.getRIAndCPSet(1);
            this.isChangeOfRedundantLinkPossible();
            if (this.isChangeOfRedundantLinkPossible && this.location.isOnSite() || this.isChangeOfRedundantLinkPossible && this.location.isRemote() && this.changeOfRedundantLinkAnsweredToYes) {
                arrayList.add(rIAndCPSet.getIpAtmLinkRI());
                arrayList.add(rIAndCPSet.getAal5TpVccTpRI());
            }
        }
        return arrayList;
    }

    public boolean isATMDeletedNeeded() throws BemException {
        return DuwUtil.isPrimaryDuwV2() && this.isLmSwapNeeded();
    }

    public boolean isLmSwapNeeded() throws BemException {
        BemLog.log(3, this.getClass() + ": isLmSwapNeeded(), to check whether LM swap is needed!");
        boolean bl = false;
        if (DuwUtil.hasDuw()) {
            String string = "IPoverGigabitEthernet_transportOption";
            String string2 = "firstOAMatm_terminationType";
            BemLog.log(3, this.getClass() + ": isLmSwapNeeded(),  before check " + string + " is supported");
            if (this.rbs.isParameterSupported(string)) {
                BemLog.log(3, this.getClass() + ": isLmSwapNeeded(), " + string + " is supported");
                String string3 = this.rbs.getCustomerParameterObject(string).getValue();
                String string4 = this.rbs.getCustomerParameterServerObject(string).getLoadedValue();
                boolean bl2 = string4.equals("ipV4");
                boolean bl3 = string3.equals("ipV4");
                BemLog.log(3, this.getClass() + ": isLmSwapNeeded(), newTransportOption is " + string3 + ", loadedTransportOption is " + string4);
                if (this.rbs.isParameterSupported(string2)) {
                    boolean bl4;
                    String string5 = this.rbs.getCustomerParameterServerObject(string2).getLoadedValue();
                    String string6 = this.rbs.getCustomerParameterObject(string2).getValue();
                    boolean bl5 = !bl2 && (string5.indexOf("STM") != -1 || string5.indexOf("OC3") != -1);
                    boolean bl6 = bl4 = !bl3 && (string6.indexOf("STM") != -1 || string6.indexOf("OC3") != -1);
                    if (!(!bl5 && !bl4 || bl5 && bl4)) {
                        BemLog.log(3, this.getClass() + ": isLmSwapNeeded(), isLmSwapNeeded is going to be set to true");
                        bl = true;
                    }
                }
            }
            BemLog.log(3, this.getClass() + ": isLmSwapNeeded(),  after check " + string + " is supported");
        }
        return bl;
    }

    protected void copyVclTrafficDescriptor() {
        RIAndCPSet rIAndCPSet = this.getRIAndCPSet(0);
        if (rIAndCPSet != null) {
            AtmStackRI atmStackRI = rIAndCPSet.getAtmStackRI();
            RIAndCPSet rIAndCPSet2 = this.getRIAndCPSet(1);
            if (rIAndCPSet2 != null) {
                AtmStackRI atmStackRI2 = rIAndCPSet2.getAtmStackRI();
                atmStackRI2.setVclAtmTrafficDescr(atmStackRI.getVclAtmTrafficDescr());
            }
        }
    }

    protected RIAndCPSet getRIAndCPSet(int n) {
        Iterator iterator = this.listOfRIAndCPSet.iterator();
        while (iterator.hasNext()) {
            RIAndCPSet rIAndCPSet = (RIAndCPSet)iterator.next();
            int n2 = rIAndCPSet.getLinkId();
            if (n != n2) continue;
            return rIAndCPSet;
        }
        return null;
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        this.checkConsistencyForVCI();
    }

    protected boolean checkConsistencyForVCI() throws BemException {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            RIAndCPSet rIAndCPSet = this.getRIAndCPSet(i);
            if (rIAndCPSet == null) continue;
            String string = rIAndCPSet.getParamSet().getVciParameter().getValue();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!string2.equals(string)) continue;
                String string3 = "Incorrect input. VCI for the redundant link must\n NOT be the same as VCI for the default link.\nPlease fill in a valid value\n";
                throw new BemException(string3);
            }
            arrayList.add(string);
        }
        return bl;
    }

    protected void checkIfChangeOfRedundantLinkIsPossible() throws BemException {
        RIAndCPSet rIAndCPSet = this.getRIAndCPSet(1);
        if (rIAndCPSet != null) {
            Aal5TpVccTpRI aal5TpVccTpRI = rIAndCPSet.getAal5TpVccTpRI();
            this.isChangeOfRedundantLinkPossible = aal5TpVccTpRI.isProcessorIdChanged();
            this.redundantMpType = aal5TpVccTpRI.getMPType();
            this.checkIfChangeOfRedundantLinkIsPossible = true;
        }
    }

    public boolean isChangeOfRedundantLinkPossible() throws BemException {
        if (!this.checkIfChangeOfRedundantLinkIsPossible) {
            this.checkIfChangeOfRedundantLinkIsPossible();
        }
        return this.isChangeOfRedundantLinkPossible;
    }

    public void setChangeOfRedundantLinkAnswer(boolean bl) {
        this.changeOfRedundantLinkAnsweredToYes = bl;
    }

    public boolean isChangeOfRedundantLinkSetToYes() {
        return this.changeOfRedundantLinkAnsweredToYes;
    }

    public String getQuestionForRedundantLink() {
        return MessageFormat.format("You are not on site.\n{0} redundancy has been added by Cabinet Wizard. It is needed to \nupdate the underlaying ATM layers for the redundant IP over ATM link.\nIf you are not on site the connection to the RBS might be lost and the \nconfiguration might be incomplete.\n\nDo you want to update the redundant IP over ATM link?", this.redundantMpType);
    }

    public String getWarningMessageIfYes() {
        return "The connection to the RBS might be lost.\nIf the connection is lost it is needed to go the site and run this \nwizard again in order to reconfigure the redundant IP over ATM link.";
    }

    public String getWarningMessageIfNo() {
        return MessageFormat.format("{0} redundancy configuration is not completed. In case of {0} failure\nthe connection to the RBS will be lost and it will be needed to go\nto the site to solve the problem.", this.redundantMpType);
    }

    public String getIpAddressOrSubnetMaskChangedMsg() throws BemException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 2; ++i) {
            IpAtmLinkRI ipAtmLinkRI;
            boolean bl;
            RIAndCPSet rIAndCPSet = this.getRIAndCPSet(i);
            if (rIAndCPSet == null || !(bl = (ipAtmLinkRI = rIAndCPSet.getIpAtmLinkRI()).isIpAddressOrSubnetMaskChanged())) continue;
            String string = MessageFormat.format("\n IP over ATM ({0}) \n ------------------------------\n The IP configuration for the {0}  IP over ATM link has been changed\n Please update the IP routing table to reflect the changes\n", MSG_LINK_TYPE[i]);
            stringBuffer.append(string);
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    private boolean updateRIsBeforeInstall(RIAndCPSet rIAndCPSet) throws BemException {
        boolean bl = true;
        Aal5TpVccTpRI aal5TpVccTpRI = rIAndCPSet.getAal5TpVccTpRI();
        AtmStackRI atmStackRI = rIAndCPSet.getAtmStackRI();
        IpAtmLinkRI ipAtmLinkRI = rIAndCPSet.getIpAtmLinkRI();
        TerminationParameterList terminationParameterList = rIAndCPSet.getTerminationParameterList();
        String string = terminationParameterList.getSlotParameter().getValue();
        if (string.equals("None") || string.equals("##UNDEFINED")) {
            return !bl;
        }
        String string2 = terminationParameterList.getSlotParameter().getName();
        String string3 = this.atmPortProvider.getAtmPortLdn(string2);
        atmStackRI.addAtmStack(string3);
        aal5TpVccTpRI.setVclTpId(atmStackRI.getVclTpLdn());
        ipAtmLinkRI.setAal5TpVccTpId(aal5TpVccTpRI.getLdn());
        return bl;
    }

    private boolean updateRIsBeforeUninstall(RIAndCPSet rIAndCPSet) throws BemException {
        boolean bl = true;
        Aal5TpVccTpRI aal5TpVccTpRI = rIAndCPSet.getAal5TpVccTpRI();
        AtmStackRI atmStackRI = rIAndCPSet.getAtmStackRI();
        IpAtmLinkRI ipAtmLinkRI = rIAndCPSet.getIpAtmLinkRI();
        TerminationParameterList terminationParameterList = rIAndCPSet.getTerminationParameterList();
        String string = aal5TpVccTpRI.getLoadedVclTpId();
        if (string == null || !aal5TpVccTpRI.isExisting(string)) {
            return !bl;
        }
        String string2 = terminationParameterList.getSlotParameter().getName();
        String string3 = this.atmPortProvider.getAtmPortLdn(string2, true);
        atmStackRI.addAtmStack(string3, true);
        aal5TpVccTpRI.setVclTpId(atmStackRI.getVclTpLdn());
        ipAtmLinkRI.setAal5TpVccTpId(aal5TpVccTpRI.getLdn());
        return bl;
    }

    public boolean usesSameAtmPort(int n, int n2) {
        boolean bl = false;
        String string = null;
        String string2 = null;
        try {
            string = this.getAtmPortLdn(n);
            string2 = this.getAtmPortLdn(n2);
        }
        catch (BemException bemException) {
            // empty catch block
        }
        if (string != null && string2 != null && string.equals(string2)) {
            bl = true;
        }
        return bl;
    }

    protected String getAtmPortLdn(int n) throws BemException {
        RIAndCPSet rIAndCPSet = this.getRIAndCPSet(n);
        if (rIAndCPSet != null) {
            return rIAndCPSet.getAtmPortLdn();
        }
        return null;
    }

    public void setListenersTo_VPI_PCR() {
        RIAndCPSet rIAndCPSet = this.getRIAndCPSet(0);
        RIAndCPSet rIAndCPSet2 = this.getRIAndCPSet(1);
        if (rIAndCPSet == null || rIAndCPSet2 == null) {
            return;
        }
        VpiParameter vpiParameter = rIAndCPSet.getParamSet().getVpiParameter();
        VpPcrParameter vpPcrParameter = rIAndCPSet.getParamSet().getVpPcrParameter();
        VpiParameter vpiParameter2 = rIAndCPSet2.getParamSet().getVpiParameter();
        VpPcrParameter vpPcrParameter2 = rIAndCPSet2.getParamSet().getVpPcrParameter();
        vpiParameter.removeCustomerParameterListener(vpiParameter2);
        vpPcrParameter.removeCustomerParameterListener(vpPcrParameter2);
        vpiParameter.addCustomerParameterListener(vpiParameter2);
        vpPcrParameter.addCustomerParameterListener(vpPcrParameter2);
    }

    public void removeListenersFrom_VPI_PCR() {
        RIAndCPSet rIAndCPSet = this.getRIAndCPSet(0);
        RIAndCPSet rIAndCPSet2 = this.getRIAndCPSet(1);
        if (rIAndCPSet == null || rIAndCPSet2 == null) {
            return;
        }
        VpiParameter vpiParameter = rIAndCPSet.getParamSet().getVpiParameter();
        VpPcrParameter vpPcrParameter = rIAndCPSet.getParamSet().getVpPcrParameter();
        VpiParameter vpiParameter2 = rIAndCPSet2.getParamSet().getVpiParameter();
        VpPcrParameter vpPcrParameter2 = rIAndCPSet2.getParamSet().getVpPcrParameter();
        vpiParameter.removeCustomerParameterListener(vpiParameter2);
        vpPcrParameter.removeCustomerParameterListener(vpPcrParameter2);
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            String string = IP_ATM_PSEUDO_PREFIX[i];
            ServiceNameValue serviceNameValue = serviceValue.getAttribute(string, "externalVpi");
            if (serviceNameValue == null) continue;
            this.createCP(IP_ATM_PSEUDO_PREFIX[i], null);
            RIAndCPSet rIAndCPSet = this.getRIAndCPSet(i);
            rIAndCPSet.isXMLFileInUse = true;
            IpOverAtmParameterSet ipOverAtmParameterSet = rIAndCPSet.getParamSet();
            List list = ipOverAtmParameterSet.getAllPseudos();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add((String)iterator.next());
            }
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        super.setCustomerParametersFromSV(stringArray, serviceValue);
    }

    protected List createCP(String string, TerminationParameterList terminationParameterList) throws BemException {
        ArrayList<IpOverAtmParameterSet> arrayList = new ArrayList<IpOverAtmParameterSet>();
        for (int i = 0; i < 2; ++i) {
            IpOverAtmParameterSet ipOverAtmParameterSet;
            if (!string.equals(IP_ATM_PSEUDO_PREFIX[i])) continue;
            if (this.ipAtmLinkCreated[i]) {
                ipOverAtmParameterSet = this.getListOfCP(i);
                if (ipOverAtmParameterSet != null) {
                    arrayList.add(ipOverAtmParameterSet);
                }
                return arrayList;
            }
            if (terminationParameterList == null) {
                terminationParameterList = this.atmPortProvider.getIpOverAtmLinkParams(i);
            }
            if (terminationParameterList == null) break;
            ipOverAtmParameterSet = this.createCPForIpAtmLink(i);
            RIAndCPSet rIAndCPSet = this.createRIs(i, ipOverAtmParameterSet, terminationParameterList);
            this.listOfRIAndCPSet.add(rIAndCPSet);
            this.loadConfigurationUsedForIpAtmLinks();
            if (ipOverAtmParameterSet == null) continue;
            arrayList.add(ipOverAtmParameterSet);
            return arrayList;
        }
        return null;
    }

    protected IpOverAtmParameterSet createCPForIpAtmLink(int n) throws BemException {
        if (n < 0 || n > IP_ATM_PSEUDO_PREFIX.length) {
            return null;
        }
        String string = IP_ATM_PSEUDO_PREFIX[n];
        String string2 = string + "externalVpi";
        String string3 = string + "vpPeakCellRate";
        String string4 = string + "vpMinimumCellRate";
        String string5 = string + "vpServiceCategory";
        String string6 = string + "externalVci";
        String string7 = string + "vcServiceCategory";
        String string8 = string + "atmIpAddress";
        String string9 = string + "atmSubnetMask";
        IpOverAtmParameterSet ipOverAtmParameterSet = this.createCP(string2, string3, string4, string5, string6, string7, string8, string9);
        this.ipAtmLinkCreated[n] = true;
        return ipOverAtmParameterSet;
    }

    protected IpOverAtmParameterSet createCP(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws BemException {
        VciParameter vciParameter = new VciParameter(string5);
        ServiceCategoryConversion serviceCategoryConversion = new ServiceCategoryConversion();
        ServiceCategoryParameter serviceCategoryParameter = new ServiceCategoryParameter(string6, this.getServiceCategoryRange(true, "vc"), "UBR_PLUS");
        serviceCategoryParameter.setMomConverter(serviceCategoryConversion);
        ServiceCategoryParameter serviceCategoryParameter2 = new ServiceCategoryParameter(string4, this.getServiceCategoryRange(true, "vp"), "CBR");
        serviceCategoryParameter2.setMomConverter(serviceCategoryConversion);
        VpiParameter vpiParameter = new VpiParameter(string);
        VpPcrParameter vpPcrParameter = new VpPcrParameter(string2);
        VpMcrParameter vpMcrParameter = new VpMcrParameter(string3);
        AtmIpAddressParameter atmIpAddressParameter = new AtmIpAddressParameter(string7);
        AtmSubnetMaskParameter atmSubnetMaskParameter = new AtmSubnetMaskParameter(string8);
        Integer n = new Integer(this.linkIdCounter);
        String string9 = MessageFormat.format(PARAMETER_SET_PSEUDO, n);
        ++this.linkIdCounter;
        IpOverAtmParameterSet ipOverAtmParameterSet = new IpOverAtmParameterSet(string9, atmIpAddressParameter, atmSubnetMaskParameter, vciParameter, serviceCategoryParameter, vpiParameter, vpPcrParameter, vpMcrParameter, serviceCategoryParameter2);
        this.addParameter(vciParameter);
        this.addParameter(serviceCategoryParameter);
        this.addParameter(vpiParameter);
        this.addParameter(vpPcrParameter);
        this.addParameter(vpMcrParameter);
        this.addParameter(serviceCategoryParameter2);
        this.addParameter(atmIpAddressParameter);
        this.addParameter(atmSubnetMaskParameter);
        return ipOverAtmParameterSet;
    }

    private EnumeratedRange getServiceCategoryRange(boolean bl, String string) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("UBR_PLUS");
        if (string.equals("vc")) {
            treeSet.add("UBR");
        } else if (string.equals("vp")) {
            treeSet.add("CBR");
        }
        String[] stringArray = new String[treeSet.size()];
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return new EnumeratedRange(stringArray);
    }

    protected IpOverAtmParameterSet getListOfCP(int n) {
        RIAndCPSet rIAndCPSet = this.getRIAndCPSet(n);
        if (rIAndCPSet != null) {
            return rIAndCPSet.getParamSet();
        }
        return null;
    }

    protected RIAndCPSet createRIs(int n, IpOverAtmParameterSet ipOverAtmParameterSet, TerminationParameterList terminationParameterList) throws BemException {
        VciParameter vciParameter = ipOverAtmParameterSet.getVciParameter();
        ServiceCategoryParameter serviceCategoryParameter = ipOverAtmParameterSet.getVcServiceCategoryParameter();
        VpiParameter vpiParameter = ipOverAtmParameterSet.getVpiParameter();
        VpPcrParameter vpPcrParameter = ipOverAtmParameterSet.getVpPcrParameter();
        VpMcrParameter vpMcrParameter = ipOverAtmParameterSet.getVpMcrParameter();
        ServiceCategoryParameter serviceCategoryParameter2 = ipOverAtmParameterSet.getVpServiceCategoryParameter();
        AtmIpAddressParameter atmIpAddressParameter = ipOverAtmParameterSet.getAtmIpAddressParameter();
        AtmSubnetMaskParameter atmSubnetMaskParameter = ipOverAtmParameterSet.getAtmSubnetMaskParameter();
        IpAtmLinkRI ipAtmLinkRI = null;
        Aal5TpVccTpRI aal5TpVccTpRI = null;
        AtmStackRI atmStackRI = null;
        ipAtmLinkRI = new IpAtmLinkRI(this.rbs, atmIpAddressParameter, atmSubnetMaskParameter, n);
        MoInstance moInstance = ipAtmLinkRI.getIpAtmLinkMoi();
        aal5TpVccTpRI = new Aal5TpVccTpRI(this.rbs, n, moInstance, this.controlSProvider);
        atmStackRI = new AtmStackRI(this.rbs, vciParameter, serviceCategoryParameter, vpiParameter, vpPcrParameter, vpMcrParameter, serviceCategoryParameter2, n);
        RIAndCPSet rIAndCPSet = new RIAndCPSet(n, this, this.atmPortProvider, this.location, aal5TpVccTpRI, atmStackRI, ipAtmLinkRI, ipOverAtmParameterSet, terminationParameterList);
        return rIAndCPSet;
    }

    public void notifyIpOverAtmRegistration(int n, TerminationParameterList terminationParameterList, RegistrationEvent registrationEvent) {
        if (registrationEvent.isRegistered()) {
            if (n < 0 || n > 1) {
                return;
            }
            try {
                this.createCP(IP_ATM_PSEUDO_PREFIX[n], terminationParameterList);
            }
            catch (BemException bemException) {
                // empty catch block
            }
        }
    }

    public String[] getIpOverAtmLdns() throws BemException {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.listOfRIAndCPSet.iterator();
        while (iterator.hasNext()) {
            object2 = (RIAndCPSet)iterator.next();
            object = ((RIAndCPSet)object2).getIpAtmLinkRI();
            Aal5TpVccTpRI aal5TpVccTpRI = ((RIAndCPSet)object2).getAal5TpVccTpRI();
            AtmStackRI atmStackRI = ((RIAndCPSet)object2).getAtmStackRI();
            arrayList.add(((IpAtmLinkRI)object).getLdn());
            arrayList.add(aal5TpVccTpRI.getLdn());
            try {
                arrayList.add(((RIAndCPSet)object2).getAtmPortLdn());
            }
            catch (BemException bemException) {
                // empty catch block
            }
            arrayList.add(atmStackRI.getVplTpLdn());
            arrayList.add(atmStackRI.getVplAtmTrafficDescLdn());
            arrayList.add(atmStackRI.getVpcTpLdn());
            arrayList.add(atmStackRI.getVclTpLdn());
            arrayList.add(atmStackRI.getDefaultVclAtmTrafficDescr());
        }
        object2 = new HashSet(arrayList);
        object = new ArrayList(object2);
        return object.toArray(new String[0]);
    }
}

