/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.IntegerConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.BooleanConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.ClientIdentifierTypeConverter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.ConfigurationModeConverter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.DiffieHellmanGroupConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.EncryptionAlgorithmConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IntegrityAlgorithmConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpAccessHosEtIpAddressConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpInterfaceDefaultRouter0Conversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpInterfaceNetworkPrefixLengthConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpInterfaceVidConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpSecTunnelEncryptionAlgorithmConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpSecTunnelIntergrityAlgorithmConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.NtpServerIpAddressConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.OwnIdTypeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.PeerIdTypeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.ProtocolTypeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.PseudoRandomFunctionConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.PtpDomainConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.PtpServerIpAddressConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.StringConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.IpSyncRef;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.IpSyncRefListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.IpSyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.PacketFrequencySyncRef;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.PacketFrequencySyncRefListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.PacketFrequencySyncRefProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.DnsResolverRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IkePeerRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.InternalEthernetPortRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IpAccessHostEtRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IpInterfaceRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IpSecRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IpSecTunnelRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IpSyncRefRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.PacketFrequencySyncRefRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.VpnInterfaceRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.util.IpSecUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AutoIntegrationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardListener;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.IpOverGigabitEthernetProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.SyncRefInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.DNSParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.DNSRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.FQDNParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.FQDNRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.MomConverter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.PtpDomainParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.URLParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.URLRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsSteps;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDhcpClientIdentifier;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDnsResolver;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIkePeer;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpInterface;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSec;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSecTunnel;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIub;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class IpOverGigabitEthernetCI
extends AbstractConfigurationItem
implements IpOverGigabitEthernetProvider,
IpSyncRefProvider,
EtmBoardListener,
CustomerParameterListener,
PacketFrequencySyncRefProvider {
    public static final String name = "IpOverGigabitEthernetCI";
    private static final int NO_OF_IP_SYNC_REF = 2;
    private static final int FIRST = 0;
    private static final int SECOND = 1;
    private static final String ET_BOARD = "ETB";
    private static final String DUW_BOARD = "DUW";
    private static final String CONFIGURATION_MODE_MANUAL = "MANUAL";
    private static final String CONFIGURATION_MODE_DHCP = "DHCP";
    private static final String CLIENT_IDENTIFIER_TYPE_AUTOMATIC = "AUTOMATIC";
    private static final String CLIENT_IDENTIFIER_TYPE_AUTOMATIC_MAC = "AUTOMATIC_MAC";
    private static final String CLIENT_IDENTIFIER_TYPE_AUTOMATIC_SERIAL_NUMBER = "AUTOMATIC_SERIAL_NUMBER";
    private static final String CLIENT_IDENTIFIER_TYPE_MANUAL = "MANUAL";
    private static final String CLIENT_IDENTIFIER_TYPE_NO_CLIENT_IDENTIFIER = "NO_CLIENT_IDENTIFIER";
    private final List allResourceItems = new ArrayList();
    private boolean isOpen = false;
    private EthernetProvider ethernetProvider;
    private EtmBoardProvider etmBoardProvider;
    public final ParameterRestriction restrictionOptional = new ParameterRestriction("Optional", 2);
    private InternalEthernetPortRI internalEthernetPortRI = null;
    private IpAccessHostEtRI ipAccessHostEtRI = null;
    private IpInterfaceRI ipAccessHostEtIpInterfaceRI = null;
    private IpInterfaceRI ipHostLinkIpInterfaceRI = null;
    private final IpSyncRefRI[] ipSyncRefRIs = new IpSyncRefRI[2];
    private int[] ipSyncRefRdns = new int[2];
    private final List ipSyncRefListeners = new ArrayList();
    private final PacketFrequencySyncRefRI[] packetFrequencySyncRefRIs = new PacketFrequencySyncRefRI[2];
    private int[] ptpSyncRefRdns = new int[]{7, 8};
    private String ptpEtxslot;
    private final List packetFrequencySyncRefListeners = new ArrayList();
    private IntegerParameter etxslot;
    private VpnInterfaceRI ipAccessHostEtVpnInterfaceRI;
    private IpAccessHostEtRI ipAccessHostEtInnerIubRI;
    private IpAccessHostEtRI ipAccessHostEtOuterIubRI;
    private IpAccessHostEtRI ipAccessHostEtOuterOamRI;
    public static final String NOIPSEC = "NON_IPSEC";
    public static final String IPSECB = "IPSEC_SINGLE_LINK";
    public static final String IPSECC = "IPSEC_DUAL_LINK";
    private IpSecRI ipSecRI;
    private IkePeerRI ikePeerRI;
    private IpSecTunnelRI ipSecTunnelRI;
    private DnsResolverRI oamDnsResolverRI = null;
    private DnsResolverRI iubDnsResolverRI = null;
    boolean isIpSecCp = false;

    public IpOverGigabitEthernetCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("IpOverGigabitEthernetCI.open(): Already open");
        }
        String string = this.rbs.getRbsStep();
        if (DuwUtil.hasDuw() && (!this.isDualStackNode() || string.equals("STEP_EXPANSION"))) {
            this.initialisePtpEtxSlot();
            this.createPtpCustomerParameters();
            this.createPacketFrequencySyncRefResourceItems();
        }
        if (!this.isDualStackNode() || string.equals("STEP_EXPANSION")) {
            this.setupProviders();
            this.createCustomerParameters();
            this.createAllResourceItems();
            this.initialiseCustomerParameters();
            this.isOpen = true;
        }
        return this.isOpen;
    }

    private void initialisePtpEtxSlot() throws BemException {
        MoInstance moInstance = null;
        if (this.etmBoardProvider != null) {
            moInstance = this.etmBoardProvider.getExchangeTerminalIpMoi();
        }
        if (moInstance == null) {
            EtmBoardProvider etmBoardProvider = (EtmBoardProvider)((Object)this.rbs.getConfigItem("EtmBoardCI"));
            moInstance = etmBoardProvider.getExchangeTerminalIpMoi();
        }
        this.ptpEtxslot = moInstance == null ? "0" : BemUtil.extractRdnId(moInstance.getLdn(), MimSlot.MOTYPENAME);
    }

    private void createPtpCustomerParameters() throws BemException {
        this.createSyncServerTypeCustomerParameters();
        this.createPacketFrequencySyncRefCustomerParameters();
    }

    private void createPacketFrequencySyncRefCustomerParameters() {
        for (int i = 0; i < 2; ++i) {
            this.createPtpServerIpCustomerParameter("IPoverGigabitEthernet_{0}_serverAddress", i);
            this.createPtpServerDomainCustomerParameter("IPoverGigabitEthernet_{0}_ptpDomain", i);
        }
    }

    private void createPtpServerDomainCustomerParameter(String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(this.ptpSyncRefRdns[n]));
        PtpDomainParameter ptpDomainParameter = new PtpDomainParameter(string2, new IntegerRange(0, 255));
        ptpDomainParameter.setMomConverter(new PtpDomainConversion());
        this.addParameter(ptpDomainParameter);
        ptpDomainParameter.addRestriction(this.restrictionOptional);
        ptpDomainParameter.addCustomerParameterListener(this);
    }

    private void createPtpServerIpCustomerParameter(String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(this.ptpSyncRefRdns[n]));
        DNSParameter dNSParameter = new DNSParameter(string2, new DNSRange());
        PtpServerIpAddressConversion ptpServerIpAddressConversion = new PtpServerIpAddressConversion();
        dNSParameter.setMomConverter(ptpServerIpAddressConversion);
        this.addParameter(dNSParameter);
        dNSParameter.addRestriction(this.restrictionOptional);
        dNSParameter.addCustomerParameterListener(this);
    }

    private void createSyncServerTypeCustomerParameters() {
        String[] stringArray = new String[]{"NTP", "PTP"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = MessageFormat.format("IPoverGigabitEthernet_{0}_syncServerType", new Integer(this.ptpSyncRefRdns[i]));
            Enumeration enumeration = new Enumeration(string, new EnumeratedRange(stringArray));
            enumeration.setDefaultValue("NTP");
            this.addParameter(enumeration);
        }
    }

    private void createPacketFrequencySyncRefResourceItems() throws BemException {
        for (int i = 0; i < this.packetFrequencySyncRefRIs.length; ++i) {
            this.packetFrequencySyncRefRIs[i] = new PacketFrequencySyncRefRI(this.rbs, this.rbs.getMoiRefs().getSynchronizationMoi(), this.ptpSyncRefRdns[i]);
        }
    }

    private void createAllResourceItems() throws BemException {
        MoInstance moInstance = null;
        MoInstance moInstance2 = this.etmBoardProvider.getExchangeTerminalIpMoi();
        if (moInstance2 != null) {
            String string = BemUtil.extractRdnId(moInstance2.getLdn(), MimSlot.MOTYPENAME);
            moInstance = this.ethernetProvider.getEthernetInterface(string);
        }
        boolean bl = true;
        this.ipAccessHostEtIpInterfaceRI = new IpInterfaceRI(this.getRbs(), moInstance, !bl);
        this.allResourceItems.add(this.ipAccessHostEtIpInterfaceRI);
        this.ipAccessHostEtRI = new IpAccessHostEtRI(this.getRbs(), this.ipAccessHostEtIpInterfaceRI.getMoi());
        this.allResourceItems.add(this.ipAccessHostEtRI);
        this.ipAccessHostEtOuterIubRI = new IpAccessHostEtRI(this.getRbs(), this.ipAccessHostEtIpInterfaceRI.getMoi(), null, "2");
        this.allResourceItems.add(this.ipAccessHostEtOuterIubRI);
        this.ipAccessHostEtVpnInterfaceRI = new VpnInterfaceRI(this.getRbs(), this.ipAccessHostEtOuterIubRI.getMoi(), !bl);
        this.allResourceItems.add(this.ipAccessHostEtVpnInterfaceRI);
        this.ipAccessHostEtInnerIubRI = new IpAccessHostEtRI(this.getRbs(), null, this.ipAccessHostEtVpnInterfaceRI.getMoi(), "1");
        this.allResourceItems.add(this.ipAccessHostEtInnerIubRI);
        for (int i = 0; i < this.ipSyncRefRdns.length; ++i) {
            this.ipSyncRefRIs[i] = new IpSyncRefRI(this.getRbs(), this.ipAccessHostEtRI.getMoi(), this.ipSyncRefRdns[i]);
            this.allResourceItems.add(this.ipSyncRefRIs[i]);
        }
        this.ipHostLinkIpInterfaceRI = new IpInterfaceRI(this.getRbs(), moInstance, bl);
        this.allResourceItems.add(this.ipHostLinkIpInterfaceRI);
        this.ipAccessHostEtOuterOamRI = new IpAccessHostEtRI(this.getRbs(), this.ipHostLinkIpInterfaceRI.getMoi(), null, "3");
        this.allResourceItems.add(this.ipAccessHostEtOuterOamRI);
        this.ipSecRI = new IpSecRI(this.getRbs());
        this.ikePeerRI = new IkePeerRI(this.getRbs(), this.ipSecRI.getMoi(), 1);
        this.ipSecTunnelRI = new IpSecTunnelRI(this.getRbs(), this.ikePeerRI.getMoi(), this.ipAccessHostEtVpnInterfaceRI.getMoi(), 1);
        this.oamDnsResolverRI = new DnsResolverRI(this.getRbs(), this.ipAccessHostEtOuterOamRI.getMoi(), "1");
        this.iubDnsResolverRI = new DnsResolverRI(this.getRbs(), this.ipAccessHostEtOuterIubRI.getMoi(), "2");
        this.allResourceItems.add(this.iubDnsResolverRI);
        this.allResourceItems.add(this.oamDnsResolverRI);
    }

    private void initialiseCustomerParameters() throws BemException {
        MoInstance moInstance = this.etmBoardProvider.getExchangeTerminalIpMoi();
        if (moInstance == null) {
            this.etxslot.setValue("0");
        } else {
            String string = BemUtil.extractRdnId(moInstance.getLdn(), MimSlot.MOTYPENAME);
            this.etxslot.setValue(string);
            if (this.internalEthernetPortRI == null) {
                this.internalEthernetPortRI = new InternalEthernetPortRI(this.getRbs());
            }
            this.internalEthernetPortRI.setEtmBoard(moInstance);
            MoInstance moInstance2 = this.ethernetProvider.getEthernetInterface(string);
            this.ipAccessHostEtIpInterfaceRI.setEthernetPortMoi(moInstance2);
            this.ipHostLinkIpInterfaceRI.setEthernetPortMoi(moInstance2);
            this.ipAccessHostEtRI.setIpInterfaceMoi(this.ipAccessHostEtIpInterfaceRI.getMoi());
            for (int i = 0; i < this.ipSyncRefRIs.length; ++i) {
                this.ipSyncRefRIs[i].setIpAccessHostEtMoi(this.ipAccessHostEtRI.getMoi());
            }
        }
    }

    public ArrayList getNeededRIs() throws BemException {
        String string;
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        if (!this.isOpen) {
            throw new BemException("IpOverGigabitEthernetCI is not open");
        }
        this.setupAutoIntegrationProvider();
        String string2 = this.getRbs().getCustomerParameter("IpSec_configType");
        String string3 = this.getRbs().getCustomerParameter("IPoverGigabitEthernet_syncIpAddress");
        String string4 = this.getRbs().getCustomerParameter("Iub_ipAddressHostEt");
        String string5 = this.getRbs().getCustomerParameter("IPoverGigabitEthernet_syncIpAddress");
        String string6 = this.getRbs().getCustomerParameter("OamIpHost_outerOamIpAddressHostEt");
        boolean bl = false;
        boolean bl2 = false;
        if (string2.equals(NOIPSEC) && !string3.equals("##UNDEFINED")) {
            bl = this.ipAccessHostEtIpInterfaceRI.shouldRiBeInstalled();
            if (bl) {
                arrayList.add(this.ipAccessHostEtIpInterfaceRI);
                bl2 = true;
            }
            if (bl = this.ipAccessHostEtRI.shouldRiBeInstalled()) {
                arrayList.add(this.ipAccessHostEtRI);
            }
            for (int i = 0; i < this.ipSyncRefRIs.length; ++i) {
                bl = this.ipSyncRefRIs[i].shouldRiBeInstalled();
                if (!bl) continue;
                arrayList.add(this.ipSyncRefRIs[i]);
            }
            string = this.rbs.getRbsStep();
            if (DuwUtil.hasDuw() && (!this.isDualStackNode() || string.equals("STEP_EXPANSION"))) {
                for (int i = 0; i < this.packetFrequencySyncRefRIs.length; ++i) {
                    if (this.packetFrequencySyncRefRIs[i] == null || !this.packetFrequencySyncRefRIs[i].shouldRiBeInstalled()) continue;
                    arrayList.add(this.packetFrequencySyncRefRIs[i]);
                }
            }
        } else if (!string4.equals("##UNDEFINED")) {
            bl = this.ipSecRI.shouldRiBeInstalled();
            if (bl) {
                arrayList.add(this.ipSecRI);
            }
            if (bl = this.ikePeerRI.shouldRiBeInstalled()) {
                arrayList.add(this.ikePeerRI);
            }
            if (bl = this.ipSecTunnelRI.shouldRiBeInstalled()) {
                arrayList.add(this.ipSecTunnelRI);
            }
            if (string2.equals(IPSECB)) {
                this.ipAccessHostEtVpnInterfaceRI.setIpAccessHostEtMoi(this.ipAccessHostEtOuterOamRI.getMoi());
            }
            if (bl = this.ipAccessHostEtVpnInterfaceRI.shouldRiBeInstalled()) {
                arrayList.add(this.ipAccessHostEtVpnInterfaceRI);
            }
            if (bl = this.ipAccessHostEtInnerIubRI.shouldRiBeInstalled()) {
                arrayList.add(this.ipAccessHostEtInnerIubRI);
            }
            for (int i = 0; i < this.ipSyncRefRIs.length; ++i) {
                this.ipSyncRefRIs[i].setIpAccessHostEtMoi(this.ipAccessHostEtInnerIubRI.getMoi());
                bl = this.ipSyncRefRIs[i].shouldRiBeInstalled();
                if (!bl) continue;
                arrayList.add(this.ipSyncRefRIs[i]);
            }
            string = this.rbs.getRbsStep();
            if (DuwUtil.hasDuw() && (!this.isDualStackNode() || string.equals("STEP_EXPANSION"))) {
                for (int i = 0; i < this.packetFrequencySyncRefRIs.length; ++i) {
                    if (this.packetFrequencySyncRefRIs[i] == null || !this.packetFrequencySyncRefRIs[i].shouldRiBeInstalled()) continue;
                    arrayList.add(this.packetFrequencySyncRefRIs[i]);
                }
            }
            if (!string6.equals("##UNDEFINED")) {
                bl = this.ipHostLinkIpInterfaceRI.shouldRiBeInstalled();
                if (bl) {
                    arrayList.add(this.ipHostLinkIpInterfaceRI);
                    bl2 = true;
                }
                if (!string6.equals("##UNDEFINED") && (bl = this.ipAccessHostEtOuterOamRI.shouldRiBeInstalled())) {
                    arrayList.add(this.ipAccessHostEtOuterOamRI);
                }
                if (bl = this.oamDnsResolverRI.shouldRiBeInstalled()) {
                    arrayList.add(this.oamDnsResolverRI);
                }
            }
            if (string2.equals(IPSECC) && !string5.equals("##UNDEFINED")) {
                bl = this.ipAccessHostEtIpInterfaceRI.shouldRiBeInstalled();
                if (bl) {
                    arrayList.add(this.ipAccessHostEtIpInterfaceRI);
                    bl2 = true;
                }
                if (!string5.equals("##UNDEFINED") && (bl = this.ipAccessHostEtOuterIubRI.shouldRiBeInstalled())) {
                    arrayList.add(this.ipAccessHostEtOuterIubRI);
                }
                if (bl = this.iubDnsResolverRI.shouldRiBeInstalled()) {
                    arrayList.add(this.iubDnsResolverRI);
                }
            }
        }
        if (string2.equals(NOIPSEC) && !this.useSameIpInterface()) {
            string = this.getRbs().getCustomerParameter("OamIpHost_oamDefaultRouter0");
            if (this.isIpHostLinkIpInterfaceConfigByDHCP() || !string.equalsIgnoreCase("##UNDEFINED")) {
                this.ipHostLinkIpInterfaceRI.setConfigByDHCP(this.isIpHostLinkIpInterfaceConfigByDHCP());
                bl = this.ipHostLinkIpInterfaceRI.shouldRiBeInstalled();
                if (bl) {
                    arrayList.add(this.ipHostLinkIpInterfaceRI);
                    bl2 = true;
                }
            }
        }
        if (!DuwUtil.hasDuw() && bl2) {
            arrayList.add(this.internalEthernetPortRI);
        }
        return arrayList;
    }

    public boolean isIpHostLinkIpInterfaceConfigByDHCP() throws BemException {
        String string;
        return this.rbs.isParameterSupported("OamIpHost_configurationMode") && CONFIGURATION_MODE_DHCP.equals(string = this.getRbs().getCustomerParameter("OamIpHost_configurationMode"));
    }

    private boolean useSameIpInterface() throws BemException {
        boolean bl = false;
        if (this.isIpHostLinkIpInterfaceConfigByDHCP()) {
            return bl;
        }
        String string = this.getRbs().getCustomerParameter("OamIpHost_oamSubnetMask");
        String string2 = this.getRbs().getCustomerParameter("OamIpHost_oamDefaultRouter0");
        String string3 = this.getRbs().getCustomerParameter("OamIpHost_oamVid");
        String string4 = this.getRbs().getCustomerParameter("IPoverGigabitEthernet_syncSubnetMask");
        String string5 = this.getRbs().getCustomerParameter("IPoverGigabitEthernet_defaultRouter0");
        String string6 = this.getRbs().getCustomerParameter("IPoverGigabitEthernet_syncVid");
        if (string.equalsIgnoreCase(string4) && string2.equalsIgnoreCase(string5) && string3.equalsIgnoreCase(string6)) {
            bl = true;
        }
        return bl;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String[] stringArray = this.filterEtIpSynchSlotFromPseudos(this.getAllCustomerParameterNames());
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        this.checkConsistency();
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        String string = this.rbs.getCustomerParameter("OamIpHost_IkePeer_DnsResolver_dnsServerAutoConfig");
        String string2 = this.rbs.getCustomerParameter("Iub_IkePeer_DnsResolver_dnsServerAutoConfig");
        if (string.equals("TRUE") || string2.equals("TRUE")) {
            String string3 = "Checked ConfigurationItem=" + this.getName() + ":\n" + "In current version DnsResolver doesn't support AUTO config mode.\n";
            throw new BemException(string3);
        }
        CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.rbs.getCustomerParameterObject("Iub_IkePeer_peerIpAddress");
        String string4 = customerParameterImpl.getValue();
        FQDNRange fQDNRange = (FQDNRange)customerParameterImpl.getEnabledValueRange();
        if (fQDNRange.isValidDomainName(string4) && !this.iubDnsResolverRI.shouldRiBeInstalled()) {
            String string5 = "Checked ConfigurationItem=" + this.getName() + ":\n" + "PeerIpAddress of iubIkePeer is a domain but dnsResolver is not configured.\n";
            throw new BemException(string5);
        }
        IpSecUtil.checkIpsec(this.rbs, "Iub_");
    }

    public String getName() {
        return name;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    private void setupProviders() throws BemException {
        if (this.etmBoardProvider == null) {
            this.etmBoardProvider = (EtmBoardProvider)this.getRbs().getProvider(EtmBoardProvider.class);
            if (this.etmBoardProvider != null) {
                this.etmBoardProvider.addEtmBoardListener(this);
            } else {
                throw new BemException("NetworkSyncCI.open(): can not obtain EtmBoardProvider");
            }
        }
        if (this.ethernetProvider == null) {
            this.ethernetProvider = (EthernetProvider)((Object)this.getRbs().getConfigItem("EthernetSwitchCI"));
            if (this.ethernetProvider == null) {
                throw new BemException("IpOverGigabitEthernetCI.setupProviders(): can not obtain EthernetProvider");
            }
        }
    }

    private void setupAutoIntegrationProvider() throws BemException {
        if (RbsSteps.isIntegrateStep(this.getRbs().getRbsStep())) {
            AutoIntegrationProvider autoIntegrationProvider = (AutoIntegrationProvider)((Object)this.getRbs().getConfigItem("AutoIntegrationCI"));
            if (autoIntegrationProvider != null) {
                CustomerParameter customerParameter = autoIntegrationProvider.getOamVidCP();
                if (customerParameter != null) {
                    this.updateOamVid(customerParameter);
                }
            } else {
                throw new BemException("can not obtain AutoIntegrationProvider");
            }
        }
    }

    public MoInstance getIpAccessHostEtRefOamVpnInterface() throws BemException {
        MoInstance moInstance = this.ipAccessHostEtOuterOamRI.getMoi();
        return moInstance;
    }

    public boolean isIpSecCpCreated() {
        return this.isIpSecCp;
    }

    private void createCustomerParameters() throws BemException {
        this.etxslot = new IntegerParameter("IPoverGigabitEthernet_etIPSynchSlot", new IntegerRange(0, 50));
        this.addParameter(this.etxslot);
        this.createIpInterfaceCustomerParameters();
        this.createIpHostLinkCustomerParameters();
        this.createIpAccessHostEtCustomerParamerters();
        this.createIpSyncRefCustomerParameters();
        this.createIpSecCustomerParameters();
        this.createIpSecTunnelCustomerParameters();
        this.createIkePeerCustomerParameters();
        this.createOamDnsResolverCustomerParameters();
        this.createIubDnsResolverCustomerParameters();
    }

    private void createIpHostLinkCustomerParameters() {
        SubnetParameter subnetParameter = new SubnetParameter("OamIpHost_oamSubnetMask", new SubnetRange(MimIpInterface.MIN_NETWORKPREFIXLENGTH, MimIpInterface.MAX_NETWORKPREFIXLENGTH));
        MomConverter momConverter = new IpInterfaceNetworkPrefixLengthConversion();
        subnetParameter.setMomConverter(momConverter);
        subnetParameter.addCustomerParameterListener(this);
        this.addParameter(subnetParameter);
        IpAddressParameter ipAddressParameter = new IpAddressParameter("OamIpHost_oamDefaultRouter0", new IpAddressRange());
        momConverter = new IpInterfaceDefaultRouter0Conversion();
        ipAddressParameter.setMomConverter(momConverter);
        ipAddressParameter.addCustomerParameterListener(this);
        this.addParameter(ipAddressParameter);
        IntegerParameter integerParameter = new IntegerParameter("OamIpHost_oamVid", new IntegerRange(MimIpInterface.MIN_VID, MimIpInterface.MAX_VID));
        momConverter = new IpInterfaceVidConversion();
        integerParameter.setMomConverter(momConverter);
        integerParameter.setDefaultValue(MimIpInterface.DEFAULT_VID.toString());
        integerParameter.addRestriction(this.restrictionOptional);
        integerParameter.addCustomerParameterListener(this);
        this.addParameter(integerParameter);
        Enumeration enumeration = new Enumeration("OamIpHost_configurationMode", new String[]{"MANUAL", CONFIGURATION_MODE_DHCP});
        enumeration.setMomConverter(new ConfigurationModeConverter());
        enumeration.addRestriction(this.restrictionOptional);
        enumeration.addCustomerParameterListener(this);
        this.addParameter(enumeration);
        Enumeration enumeration2 = new Enumeration("OamIpHost_DhcpClientIdentifier_clientIdentifierType", new String[]{CLIENT_IDENTIFIER_TYPE_AUTOMATIC, CLIENT_IDENTIFIER_TYPE_AUTOMATIC_MAC, CLIENT_IDENTIFIER_TYPE_AUTOMATIC_SERIAL_NUMBER, "MANUAL", CLIENT_IDENTIFIER_TYPE_NO_CLIENT_IDENTIFIER});
        enumeration2.setMomConverter(new ClientIdentifierTypeConverter());
        enumeration2.addCustomerParameterListener(this);
        this.addParameter(enumeration2);
        StringParameter stringParameter = new StringParameter("OamIpHost_DhcpClientIdentifier_clientIdentifier", new StringRange(MimDhcpClientIdentifier.MINLEN_CLIENTIDENTIFIER, MimDhcpClientIdentifier.MAXLEN_CLIENTIDENTIFIER));
        stringParameter.addCustomerParameterListener(this);
        this.addParameter(stringParameter);
    }

    private void createIpInterfaceCustomerParameters() {
        SubnetParameter subnetParameter = new SubnetParameter("IPoverGigabitEthernet_syncSubnetMask", new SubnetRange(MimIpInterface.MIN_NETWORKPREFIXLENGTH, MimIpInterface.MAX_NETWORKPREFIXLENGTH));
        MomConverter momConverter = new IpInterfaceNetworkPrefixLengthConversion();
        subnetParameter.setMomConverter(momConverter);
        subnetParameter.addCustomerParameterListener(this);
        this.addParameter(subnetParameter);
        IpAddressParameter ipAddressParameter = new IpAddressParameter("IPoverGigabitEthernet_defaultRouter0", new IpAddressRange());
        momConverter = new IpInterfaceDefaultRouter0Conversion();
        ipAddressParameter.setMomConverter(momConverter);
        ipAddressParameter.addCustomerParameterListener(this);
        this.addParameter(ipAddressParameter);
        IntegerParameter integerParameter = new IntegerParameter("IPoverGigabitEthernet_syncVid", new IntegerRange(MimIpInterface.MIN_VID, MimIpInterface.MAX_VID));
        momConverter = new IpInterfaceVidConversion();
        integerParameter.setMomConverter(momConverter);
        integerParameter.setDefaultValue(MimIpInterface.DEFAULT_VID.toString());
        integerParameter.addRestriction(this.restrictionOptional);
        integerParameter.addCustomerParameterListener(this);
        this.addParameter(integerParameter);
    }

    private void createIpAccessHostEtCustomerParamerters() {
        IpAddressParameter ipAddressParameter = new IpAddressParameter("IPoverGigabitEthernet_syncIpAddress", new IpAddressRange());
        IpAccessHosEtIpAddressConversion ipAccessHosEtIpAddressConversion = new IpAccessHosEtIpAddressConversion();
        ipAddressParameter.setMomConverter(ipAccessHosEtIpAddressConversion);
        this.addParameter(ipAddressParameter);
        IpAddressParameter ipAddressParameter2 = new IpAddressParameter("Iub_ipAddressHostEt", new IpAddressRange());
        IpAccessHosEtIpAddressConversion ipAccessHosEtIpAddressConversion2 = new IpAccessHosEtIpAddressConversion();
        ipAddressParameter2.setMomConverter(ipAccessHosEtIpAddressConversion2);
        this.addParameter(ipAddressParameter2);
        IpAddressParameter ipAddressParameter3 = new IpAddressParameter("OamIpHost_outerOamIpAddressHostEt", new IpAddressRange());
        IpAccessHosEtIpAddressConversion ipAccessHosEtIpAddressConversion3 = new IpAccessHosEtIpAddressConversion();
        ipAddressParameter3.setMomConverter(ipAccessHosEtIpAddressConversion3);
        this.addParameter(ipAddressParameter3);
    }

    private void createIpSyncRefCustomerParameters() throws BemException {
        this.ipSyncRefRdns = DuwUtil.hasDuw() ? new int[]{7, 8} : new int[]{1, 2};
        String string = MessageFormat.format("IPoverGigabitEthernet_{0}_ntpServerIpAddress", new Integer(this.ipSyncRefRdns[0]));
        DNSParameter dNSParameter = new DNSParameter(string, new DNSRange());
        NtpServerIpAddressConversion ntpServerIpAddressConversion = new NtpServerIpAddressConversion();
        dNSParameter.setMomConverter(ntpServerIpAddressConversion);
        this.addParameter(dNSParameter);
        dNSParameter.addRestriction(this.restrictionOptional);
        dNSParameter.addCustomerParameterListener(this);
        String string2 = MessageFormat.format("IPoverGigabitEthernet_{0}_ntpServerIpAddress", new Integer(this.ipSyncRefRdns[1]));
        DNSParameter dNSParameter2 = new DNSParameter(string2, new DNSRange());
        dNSParameter2.setMomConverter(ntpServerIpAddressConversion);
        this.addParameter(dNSParameter2);
        dNSParameter2.addRestriction(this.restrictionOptional);
        dNSParameter2.addCustomerParameterListener(this);
    }

    private void createIpSecCustomerParameters() {
        URLParameter uRLParameter = new URLParameter("IpSec_autoUpdateCertEnrollmentServer", new URLRange(new String[]{"http://", "https://"}, MimIpSec.MINLEN_AUTOUPDATECERTENROLLMENTSERVER, MimIpSec.MAXLEN_AUTOUPDATECERTENROLLMENTSERVER));
        StringConversion stringConversion = new StringConversion(MimIpSec.MOTYPENAME, "autoUpdateCertEnrollmentServer");
        uRLParameter.setMomConverter(stringConversion);
        uRLParameter.setDefaultValue(MimIpSec.DEFAULT_AUTOUPDATECERTENROLLMENTSERVER);
        uRLParameter.addRestriction(this.restrictionOptional);
        this.addParameter(uRLParameter);
        String[] stringArray = new String[]{NOIPSEC, IPSECB, IPSECC};
        Enumeration enumeration = new Enumeration("IpSec_configType", stringArray);
        enumeration.setDefaultValue(NOIPSEC);
        this.addParameter(enumeration);
        this.isIpSecCp = true;
    }

    private void createIpSecTunnelCustomerParameters() {
        String string = null;
        String string2 = null;
        string2 = "Iub_";
        string = string2 + "IpSecTunnel_protocolType";
        CustomerParameterImpl customerParameterImpl = new Enumeration(string, new EnumeratedRange(new String[]{"ANY", "ICMP", "TCP", "UDP", "SCTP", "RAWIP"}));
        Object object = new ProtocolTypeConversion(MimIpSecTunnel.MOTYPENAME, "tsProtocols");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_tsLocalIpAddress";
        customerParameterImpl = new IpAddressParameter(string, new IpAddressRange());
        object = new StringConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_tsLocalIpAddress");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_tsLocalIpAddressMask";
        customerParameterImpl = new IntegerParameter(string, new IntegerRange(0, 32));
        object = new IntegerConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_tsLocalIpAddressMask");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_tsRemoteIpAddress";
        customerParameterImpl = new IpAddressParameter(string, new IpAddressRange());
        object = new StringConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_tsRemoteIpAddress");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_tsRemoteIpAddressMask";
        customerParameterImpl = new IntegerParameter(string, new IntegerRange(0, 32));
        object = new IntegerConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_tsRemoteIpAddressMask");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_pfs";
        customerParameterImpl = new TrueFalseCustomerParameter(string);
        customerParameterImpl.setMomConverter(new BooleanConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_pfs"));
        this.addParameter(customerParameterImpl);
        for (int i = 0; i < 11; ++i) {
            string = MessageFormat.format(string2 + "IpSecTunnel_ChildSaTf_{0}_encryptionAlgorithm", new Integer(i + 1));
            object = new Enumeration(string, new EnumeratedRange(new String[]{"NULL", "AES_CBC_128", "AES_CBC_256", "ALG_3DES_CBC", "AES_128_GCM_128", "AES_256_GCM_128"}));
            IpSecTunnelEncryptionAlgorithmConversion ipSecTunnelEncryptionAlgorithmConversion = new IpSecTunnelEncryptionAlgorithmConversion(MimIpSecTunnel.MOTYPENAME, "encryptionAlgorithm");
            ((CustomerParameterImpl)object).setMomConverter(ipSecTunnelEncryptionAlgorithmConversion);
            this.addParameter((CustomerParameter)object);
            string = MessageFormat.format(string2 + "IpSecTunnel_ChildSaTf_{0}_integrityAlgorithm", new Integer(i + 1));
            Enumeration enumeration = new Enumeration(string, new EnumeratedRange(new String[]{"AES_XCBC_MAC_96", "HMAC_SHA_1_96", "HMAC_MD5_96", "HMAC_SHA2_256_128", "AES_GCM"}));
            IpSecTunnelIntergrityAlgorithmConversion ipSecTunnelIntergrityAlgorithmConversion = new IpSecTunnelIntergrityAlgorithmConversion(MimIpSecTunnel.MOTYPENAME, "integrityAlgorithm");
            enumeration.setMomConverter(ipSecTunnelIntergrityAlgorithmConversion);
            this.addParameter(enumeration);
        }
    }

    private void createIkePeerCustomerParameters() {
        CustomerParameterImpl customerParameterImpl;
        CustomerParameterImpl customerParameterImpl2;
        Object object;
        Object object2;
        String string = "Iub_";
        EnumeratedRange enumeratedRange = new EnumeratedRange(new String[]{"GROUP_2", "GROUP_14", "GROUP_19", "GROUP_20"});
        EnumeratedRange enumeratedRange2 = new EnumeratedRange(new String[]{"AES_CBC_128", "AES_CBC_256", "ALG_3DES_CBC", "AES_128_GCM_128", "AES_256_GCM_128"});
        EnumeratedRange enumeratedRange3 = new EnumeratedRange(new String[]{"AES_XCBC_MAC_96", "HMAC_MD5_96", "HMAC_SHA_1_96", "HMAC_SHA2_256_128", "AES_GCM"});
        EnumeratedRange enumeratedRange4 = new EnumeratedRange(new String[]{"AES_XCBC_PRF128", "HMAC_SHA1", "HMAC_MD5", "HMAC_SHA2_256"});
        for (int i = 1; i < 7; ++i) {
            object2 = new Enumeration(MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_diffieHellmanGroup", String.valueOf(i)), enumeratedRange);
            ((CustomerParameterImpl)object2).setMomConverter(new DiffieHellmanGroupConversion());
            super.addParameter((CustomerParameter)object2);
            object = new Enumeration(MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_encryptionAlgorithm", String.valueOf(i)), enumeratedRange2);
            ((CustomerParameterImpl)object).setMomConverter(new EncryptionAlgorithmConversion());
            super.addParameter((CustomerParameter)object);
            customerParameterImpl2 = new Enumeration(MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_integrityAlgorithm", String.valueOf(i)), enumeratedRange3);
            customerParameterImpl2.setMomConverter(new IntegrityAlgorithmConversion());
            super.addParameter(customerParameterImpl2);
            customerParameterImpl = new Enumeration(MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_pseudoRandomFunction", String.valueOf(i)), enumeratedRange4);
            customerParameterImpl.setMomConverter(new PseudoRandomFunctionConversion());
            super.addParameter(customerParameterImpl);
        }
        EnumeratedRange enumeratedRange5 = new EnumeratedRange(new String[]{"ANY", "IP_V4_ADDRESS", "FQDN", CLIENT_IDENTIFIER_TYPE_AUTOMATIC});
        object2 = new EnumeratedRange(new String[]{CLIENT_IDENTIFIER_TYPE_AUTOMATIC, "IP_V4_ADDRESS", "FQDN", "AUTOMATIC_DN"});
        object = new StringRange(new Integer(1), new Integer(256));
        customerParameterImpl2 = new FQDNParameter(string + "IkePeer_peerIpAddress", new FQDNRange(new Integer(1), new Integer(254)));
        customerParameterImpl2.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "peerIpAddress"));
        customerParameterImpl2.addRestriction(new ParameterRestriction("Configuration not possible whithout peerIpAddress ", 3));
        this.addParameter(customerParameterImpl2);
        customerParameterImpl = new StringParameter(string + "IkePeer_peerIdFqdn", (StringRange)object);
        customerParameterImpl.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "idFqdn"));
        this.addParameter(customerParameterImpl);
        Enumeration enumeration = new Enumeration(string + "IkePeer_peerIdType", enumeratedRange5);
        enumeration.setMomConverter(new PeerIdTypeConversion());
        this.addParameter(enumeration);
        IpAddressParameter ipAddressParameter = new IpAddressParameter(string + "IkePeer_peerIpv4Address", new IpAddressRange());
        ipAddressParameter.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "ipv4Address"));
        this.addParameter(ipAddressParameter);
        StringParameter stringParameter = new StringParameter(string + "IkePeer_ownIdFqdn", (StringRange)object);
        stringParameter.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "idFqdn"));
        this.addParameter(stringParameter);
        Enumeration enumeration2 = new Enumeration(string + "IkePeer_ownIdType", (EnumeratedRange)object2);
        enumeration2.setMomConverter(new OwnIdTypeConversion());
        this.addParameter(enumeration2);
        IpAddressParameter ipAddressParameter2 = new IpAddressParameter(string + "IkePeer_ownIpv4Address", new IpAddressRange());
        ipAddressParameter2.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "ipv4Address"));
        this.addParameter(ipAddressParameter2);
    }

    private void createOamDnsResolverCustomerParameters() {
        Object object;
        String string = "OamIpHost_";
        for (int i = 1; i < 4; ++i) {
            object = new IpAddressParameter(string + "IkePeer_DnsResolver_dnsServerAddress" + i, new IpAddressRange());
            ((CustomerParameterImpl)object).setMomConverter(new StringConversion(MimDnsResolver.MOTYPENAME, "dnsServerAddress"));
            this.addParameter((CustomerParameter)object);
        }
        TrueFalseCustomerParameter trueFalseCustomerParameter = new TrueFalseCustomerParameter(string + "IkePeer_DnsResolver_dnsServerAutoConfig");
        trueFalseCustomerParameter.setMomConverter(new BooleanConversion(MimDnsResolver.MOTYPENAME, "dnsServerAutoConfig"));
        this.addParameter(trueFalseCustomerParameter);
        object = new StringRange(new Integer(0), new Integer(255));
        StringParameter stringParameter = new StringParameter(string + "IkePeer_DnsResolver_defDomainName", (StringRange)object);
        stringParameter.setMomConverter(new StringConversion(MimDnsResolver.MOTYPENAME, "defDomainName"));
        this.addParameter(stringParameter);
        IntegerParameter integerParameter = new IntegerParameter(string + "IkePeer_DnsResolver_dscp", new IntegerRange(0, 63));
        integerParameter.setMomConverter(new IntegerConversion(MimDnsResolver.MOTYPENAME, "dscp"));
        this.addParameter(integerParameter);
        TrueFalseCustomerParameter trueFalseCustomerParameter2 = new TrueFalseCustomerParameter(string + "IkePeer_DnsResolver_isSubDomainName");
        trueFalseCustomerParameter2.setMomConverter(new BooleanConversion(MimDnsResolver.MOTYPENAME, "isSubDomainName"));
        this.addParameter(trueFalseCustomerParameter2);
    }

    private void createIubDnsResolverCustomerParameters() {
        Object object;
        String string = "Iub_";
        for (int i = 1; i < 4; ++i) {
            object = new IpAddressParameter(string + "IkePeer_DnsResolver_dnsServerAddress" + i, new IpAddressRange());
            ((CustomerParameterImpl)object).setMomConverter(new StringConversion(MimDnsResolver.MOTYPENAME, "dnsServerAddress"));
            this.addParameter((CustomerParameter)object);
        }
        TrueFalseCustomerParameter trueFalseCustomerParameter = new TrueFalseCustomerParameter(string + "IkePeer_DnsResolver_dnsServerAutoConfig");
        trueFalseCustomerParameter.setMomConverter(new BooleanConversion(MimDnsResolver.MOTYPENAME, "dnsServerAutoConfig"));
        this.addParameter(trueFalseCustomerParameter);
        object = new StringRange(new Integer(0), new Integer(255));
        StringParameter stringParameter = new StringParameter(string + "IkePeer_DnsResolver_defDomainName", (StringRange)object);
        stringParameter.setMomConverter(new StringConversion(MimDnsResolver.MOTYPENAME, "defDomainName"));
        this.addParameter(stringParameter);
        IntegerParameter integerParameter = new IntegerParameter(string + "IkePeer_DnsResolver_dscp", new IntegerRange(0, 63));
        integerParameter.setMomConverter(new IntegerConversion(MimDnsResolver.MOTYPENAME, "dscp"));
        this.addParameter(integerParameter);
        TrueFalseCustomerParameter trueFalseCustomerParameter2 = new TrueFalseCustomerParameter(string + "IkePeer_DnsResolver_isSubDomainName");
        trueFalseCustomerParameter2.setMomConverter(new BooleanConversion(MimDnsResolver.MOTYPENAME, "isSubDomainName"));
        this.addParameter(trueFalseCustomerParameter2);
    }

    public String[] getAvailableIpSynRefSlots() throws BemException {
        String[] stringArray = new String[]{};
        String string = MessageFormat.format("IPoverGigabitEthernet_{0}_ntpServerIpAddress", new Integer(this.ipSyncRefRdns[0]));
        String string2 = this.getRbs().getCustomerParameter(string);
        if (string2 != null && !string2.equals("") && !string2.equals("##UNDEFINED")) {
            stringArray = new String[]{this.etxslot.getValue()};
        }
        String string3 = MessageFormat.format("IPoverGigabitEthernet_{0}_ntpServerIpAddress", new Integer(this.ipSyncRefRdns[1]));
        String string4 = this.getRbs().getCustomerParameter(string3);
        if (string4 != null && !string4.equals("") && !string4.equals("##UNDEFINED")) {
            stringArray = new String[]{this.etxslot.getValue()};
        }
        return stringArray;
    }

    public IpSyncRef[] getAvailableIpSyncRefs(String string) throws BemException {
        ArrayList<IpSyncRefRI> arrayList = new ArrayList<IpSyncRefRI>();
        String string2 = this.etxslot.getValue();
        if (string2.equals(string)) {
            if (this.isNtp1CustomerParameterSet()) {
                arrayList.add(this.ipSyncRefRIs[0]);
            }
            if (this.isNtp2CustomerParameterSet()) {
                arrayList.add(this.ipSyncRefRIs[1]);
            }
        }
        IpSyncRef[] ipSyncRefArray = arrayList.toArray(new IpSyncRef[0]);
        return ipSyncRefArray;
    }

    public SyncRefInfo[] getIpSyncRefs(String string) throws BemException {
        IpSyncRef[] ipSyncRefArray = this.getAvailableIpSyncRefs(string);
        String string2 = null;
        string2 = DuwUtil.hasDuw() ? DUW_BOARD : ET_BOARD;
        ArrayList<SyncRefInfo> arrayList = new ArrayList<SyncRefInfo>();
        for (int i = 0; i < ipSyncRefArray.length; ++i) {
            int n = Integer.parseInt(ipSyncRefArray[i].getIpSyncRefId());
            arrayList.add(new SyncRefInfo(ipSyncRefArray[i].getIpSyncRefLdn(), n, string2));
        }
        return arrayList.toArray(new SyncRefInfo[0]);
    }

    public void update() {
        try {
            this.initialiseCustomerParameters();
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised("update()IpOverGigabitEthernetCI", bemException);
        }
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        String string = customerParameter.getName();
        if (string.endsWith("ntpServerIpAddress")) {
            this.notifyAllIpSyncRefListeners(customerParameter, parameterEvent);
        }
        if (string.endsWith("ptpServerIpAddress")) {
            this.notifyAllPacketFrequencySyncRefListeners(customerParameter, parameterEvent);
        }
        if (this.ipAccessHostEtIpInterfaceRI != null && this.ipHostLinkIpInterfaceRI != null) {
            try {
                boolean bl = this.useSameIpInterface();
                this.ipAccessHostEtIpInterfaceRI.setUsedByBothIpHosts(bl);
                this.ipHostLinkIpInterfaceRI.setUsedByBothIpHosts(bl);
                boolean bl2 = this.isIpHostLinkIpInterfaceConfigByDHCP();
                this.ipHostLinkIpInterfaceRI.setConfigByDHCP(bl2);
            }
            catch (BemException bemException) {
                Nal.getLog().nalTrace(1, this.getClass(), "Failed to update IpInterfaces", bemException);
            }
        }
    }

    public void addIpSyncRefListener(IpSyncRefListener ipSyncRefListener) {
        this.ipSyncRefListeners.add(ipSyncRefListener);
    }

    private void notifyAllIpSyncRefListeners(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        Iterator iterator = this.ipSyncRefListeners.iterator();
        while (iterator.hasNext()) {
            IpSyncRefListener ipSyncRefListener = (IpSyncRefListener)iterator.next();
            ipSyncRefListener.updateIpSyncRef();
        }
    }

    protected void setEtmBoardProvider(EtmBoardProvider etmBoardProvider) {
        this.etmBoardProvider = etmBoardProvider;
    }

    public String getSlotForSyncRefLdn(String string) throws BemException {
        String string2 = null;
        for (int i = 0; i < this.ipSyncRefRIs.length; ++i) {
            IpSyncRefRI ipSyncRefRI = this.ipSyncRefRIs[i];
            String string3 = ipSyncRefRI.getIpSyncRefLdn();
            if (!string.equals(string3)) continue;
            string2 = this.etxslot.getValue();
        }
        return string2;
    }

    private boolean isNtp1CustomerParameterSet() throws BemException {
        boolean bl = this.isNtpCustomerParameterSet(0);
        return bl;
    }

    private boolean isNtp2CustomerParameterSet() throws BemException {
        boolean bl = this.isNtpCustomerParameterSet(1);
        return bl;
    }

    private boolean isNtpCustomerParameterSet(int n) throws BemException {
        boolean bl = false;
        Integer n2 = new Integer(this.ipSyncRefRdns[n]);
        String string = MessageFormat.format("IPoverGigabitEthernet_{0}_ntpServerIpAddress", n2);
        String string2 = this.getRbs().getCustomerParameter(string);
        if (string2 != null && !string2.equals("") && !string2.equals("##UNDEFINED")) {
            bl = true;
        }
        return bl;
    }

    public MoInstance getOamIpInterface() throws BemException {
        MoInstance moInstance = this.useSameIpInterface() ? this.ipAccessHostEtIpInterfaceRI.getMoi() : this.ipHostLinkIpInterfaceRI.getMoi();
        return moInstance;
    }

    public CustomerParameter getOamSubnetMask() throws BemException {
        return this.getRbs().getCustomerParameterObject("OamIpHost_oamSubnetMask");
    }

    public CustomerParameter getEtxSlotParameter() {
        return this.etxslot;
    }

    public boolean isIpCapable() {
        boolean bl = false;
        if (this.etxslot != null && !this.etxslot.getValue().equals("0")) {
            bl = true;
        }
        return bl;
    }

    private void updateOamVid(CustomerParameter customerParameter) {
        try {
            CustomerParameter customerParameter2 = this.getRbs().getCustomerParameterObject("OamIpHost_oamVid");
            if (customerParameter.getAccessLevel() != 1) {
                customerParameter2.setValue(customerParameter.getValue());
            }
        }
        catch (BemException bemException) {
            BemLog.log(2, "IpOverGigabitEthernetCI.updateOamVid(), failed");
        }
    }

    public CustomerParameter getIpHostLinkSubnetMask() throws BemException {
        CustomerParameter customerParameter = null;
        if (this.ipHostLinkIpInterfaceRI != null) {
            customerParameter = this.ipHostLinkIpInterfaceRI.getIpHostLinkSubnetMask();
        }
        return customerParameter;
    }

    public CustomerParameter getIpHostLinkDefaultRouter() throws BemException {
        CustomerParameter customerParameter = null;
        if (this.ipHostLinkIpInterfaceRI != null) {
            customerParameter = this.ipHostLinkIpInterfaceRI.getIpHostLinkDefaultRouter();
        }
        return customerParameter;
    }

    private boolean isDualStackNode() throws BemException {
        MoHandler moHandler = this.rbs.getMoHandler();
        MoInstance moInstance = this.rbs.getNodeBFunctionMoi();
        BemMo bemMo = moHandler.getMo(moInstance.getLdn());
        try {
            BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, MimIub.MOTYPENAME, "");
            if (bemMoArray != null && bemMoArray.length > 0) {
                BemMo bemMo2 = bemMoArray[0];
                NalStruct nalStruct = (NalStruct)bemMo2.getAttribute("userPlaneTransportOption");
                Boolean bl = (Boolean)nalStruct.getMemberValue("atm");
                Boolean bl2 = (Boolean)nalStruct.getMemberValue("ipV4");
                if (bl.booleanValue() && bl2.booleanValue()) {
                    return true;
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(this.getClass().getName(), "isDualStackNode()", null, "\tCould not find field inuserPlaneTransportOption", noSuchFieldException);
        }
        return false;
    }

    public static int getNumberOfIpSyncRef() {
        return 2;
    }

    private String[] filterEtIpSynchSlotFromPseudos(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        arrayList.remove("IPoverGigabitEthernet_etIPSynchSlot");
        return arrayList.toArray(new String[0]);
    }

    public void addPacketFrequencySyncRefListener(PacketFrequencySyncRefListener packetFrequencySyncRefListener) {
        this.packetFrequencySyncRefListeners.add(packetFrequencySyncRefListener);
    }

    public String[] getAvailablePacketFrequencySyncRefSlots() throws BemException {
        String[] stringArray = new String[]{};
        String string = MessageFormat.format("IPoverGigabitEthernet_{0}_serverAddress", new Integer(this.ptpSyncRefRdns[0]));
        String string2 = this.getRbs().getCustomerParameter(string);
        String string3 = MessageFormat.format("IPoverGigabitEthernet_{0}_serverAddress", new Integer(this.ptpSyncRefRdns[1]));
        String string4 = this.getRbs().getCustomerParameter(string3);
        if (this.isParamConfigured(string2) || this.isParamConfigured(string4)) {
            stringArray = new String[]{this.ptpEtxslot};
        }
        return stringArray;
    }

    private boolean isParamConfigured(String string) {
        return string != null && !string.equals("") && !string.equals("##UNDEFINED");
    }

    public PacketFrequencySyncRef[] getAvailablePacketFrequencySyncRefs(String string) throws BemException {
        ArrayList<PacketFrequencySyncRefRI> arrayList = new ArrayList<PacketFrequencySyncRefRI>();
        String string2 = this.ptpEtxslot;
        if (string2.equals(string)) {
            if (this.isPtpServerConfigured(0)) {
                arrayList.add(this.packetFrequencySyncRefRIs[0]);
            }
            if (this.isPtpServerConfigured(1)) {
                arrayList.add(this.packetFrequencySyncRefRIs[1]);
            }
        }
        PacketFrequencySyncRef[] packetFrequencySyncRefArray = arrayList.toArray(new PacketFrequencySyncRef[0]);
        return packetFrequencySyncRefArray;
    }

    private boolean isPtpServerConfigured(int n) throws BemException {
        Integer n2 = new Integer(this.ptpSyncRefRdns[n]);
        String string = MessageFormat.format("IPoverGigabitEthernet_{0}_serverAddress", n2);
        String string2 = this.getRbs().getCustomerParameter(string);
        return this.isParamConfigured(string2);
    }

    public SyncRefInfo[] getPacketFrequencySyncRefs(String string) throws BemException {
        PacketFrequencySyncRef[] packetFrequencySyncRefArray = this.getAvailablePacketFrequencySyncRefs(string);
        String string2 = null;
        string2 = DUW_BOARD;
        ArrayList<SyncRefInfo> arrayList = new ArrayList<SyncRefInfo>();
        for (int i = 0; i < packetFrequencySyncRefArray.length; ++i) {
            int n = Integer.parseInt(packetFrequencySyncRefArray[i].getPacketFrequencySyncRefId());
            arrayList.add(new SyncRefInfo(packetFrequencySyncRefArray[i].getPacketFrequencySyncRefLdn(), n, string2));
        }
        return arrayList.toArray(new SyncRefInfo[0]);
    }

    public void notifyAllPacketFrequencySyncRefListeners(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        Iterator iterator = this.packetFrequencySyncRefListeners.iterator();
        while (iterator.hasNext()) {
            PacketFrequencySyncRefListener packetFrequencySyncRefListener = (PacketFrequencySyncRefListener)iterator.next();
            packetFrequencySyncRefListener.updateFrequencySyncRef();
        }
    }

    public String getSlotForPtpSyncRefLdn(String string) throws BemException {
        String string2 = null;
        for (int i = 0; i < this.packetFrequencySyncRefRIs.length; ++i) {
            PacketFrequencySyncRefRI packetFrequencySyncRefRI = this.packetFrequencySyncRefRIs[i];
            String string3 = packetFrequencySyncRefRI.getPacketFrequencySyncRefLdn();
            if (!string.equals(string3)) continue;
            string2 = this.ptpEtxslot;
        }
        return string2;
    }

    public DnsResolverRI getOamDnsResolverRI() {
        return this.oamDnsResolverRI;
    }

    public CustomerParameter getIpHostLinkConfigurationMode() throws BemException {
        CustomerParameter customerParameter = null;
        if (this.rbs.isParameterSupported("OamIpHost_configurationMode")) {
            customerParameter = this.rbs.getCustomerParameterObject("OamIpHost_configurationMode");
        }
        return customerParameter;
    }

    public CustomerParameter getClientIdentifier() throws BemException {
        CustomerParameter customerParameter = null;
        if (this.rbs.isParameterSupported("OamIpHost_DhcpClientIdentifier_clientIdentifier")) {
            customerParameter = this.rbs.getCustomerParameterObject("OamIpHost_DhcpClientIdentifier_clientIdentifier");
        }
        return customerParameter;
    }

    public CustomerParameter getClientIdentifierType() throws BemException {
        CustomerParameter customerParameter = null;
        if (this.rbs.isParameterSupported("OamIpHost_DhcpClientIdentifier_clientIdentifierType")) {
            customerParameter = this.rbs.getCustomerParameterObject("OamIpHost_DhcpClientIdentifier_clientIdentifierType");
        }
        return customerParameter;
    }
}

