/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIkePeer;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSec;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSystem;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalObject;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IkePeerRI
extends AbstractResourceItem {
    public static final String name = "IkePeerRI";
    private static String[] phases = new String[]{"IkePeerCreationPhase"};
    private MoInstance ipSecMoi = null;
    private MoInstance ikePeerMoi = null;
    private int rdnId = -1;
    private final List pseudoList = new ArrayList();
    private String prefix = "";

    public IkePeerRI(Rbs rbs, MoInstance moInstance, int n) throws BemException {
        super(name, rbs, phases);
        this.rdnId = n;
        List list = this.getCustomerParameters();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CustomerParameter customerParameter = (CustomerParameter)iterator.next();
            this.pseudoList.add(customerParameter.getName());
        }
        this.initializeMois(moInstance);
        this.initiateCPWithNodeValues();
    }

    private List getCustomerParameters() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        this.prefix = this.rdnId == 1 ? "Iub_" : "OamIpHost_";
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_peerIpAddress"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_peerIdFqdn"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_peerIdType"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_peerIpv4Address"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_ownIdFqdn"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_ownIdType"));
        arrayList.add(this.rbs.getCustomerParameterObject(this.prefix + "IkePeer_ownIpv4Address"));
        for (int i = 0; i < 6; ++i) {
            arrayList.add(this.rbs.getCustomerParameterObject(MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_diffieHellmanGroup", new Integer(i + 1))));
            arrayList.add(this.rbs.getCustomerParameterObject(MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_encryptionAlgorithm", new Integer(i + 1))));
            arrayList.add(this.rbs.getCustomerParameterObject(MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_integrityAlgorithm", new Integer(i + 1))));
            arrayList.add(this.rbs.getCustomerParameterObject(MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_pseudoRandomFunction", new Integer(i + 1))));
        }
        return arrayList;
    }

    private void initializeMois(MoInstance moInstance) {
        if (moInstance != null) {
            this.ipSecMoi = moInstance;
        } else {
            MoInstance moInstance2 = this.rbs.getRootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance2, MimIpSystem.MOTYPENAME, "1");
            this.ipSecMoi = new SingleChildMoi(singleChildMoi, MimIpSec.MOTYPENAME, "1");
        }
        this.ikePeerMoi = new FixedRdnMoi(this.ipSecMoi, MimIkePeer.MOTYPENAME, String.valueOf(this.rdnId));
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = this.ikePeerMoi.getLdn();
        String string2 = "";
        boolean bl = this.isInstalled();
        if (bl) {
            BemMo bemMo = this.getMo(string);
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_peerIpAddress");
            string2 = customerParameterServer.getAttributeName();
            Object object = this.getAttribute(bemMo, string2);
            customerParameterServer.setLoadedValue(object);
            NalStruct nalStruct = (NalStruct)this.getAttribute(bemMo, "peerIdentity");
            String string3 = (String)nalStruct.getMember("idFqdn").getValue();
            String string4 = (String)nalStruct.getMember("ipv4Address").getValue();
            Integer n = (Integer)nalStruct.getMember("idType").getValue();
            CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_peerIdFqdn");
            customerParameterServer2.setLoadedValue(string3);
            CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_peerIpv4Address");
            customerParameterServer3.setLoadedValue(string4);
            CustomerParameterServer customerParameterServer4 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_peerIdType");
            customerParameterServer4.setLoadedValue(n);
            NalStruct nalStruct2 = (NalStruct)this.getAttribute(bemMo, "ownIdentity");
            String string5 = (String)nalStruct2.getMember("idFqdn").getValue();
            String string6 = (String)nalStruct2.getMember("ipv4Address").getValue();
            Integer n2 = (Integer)nalStruct2.getMember("ownIdType").getValue();
            CustomerParameterServer customerParameterServer5 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_ownIdFqdn");
            customerParameterServer5.setLoadedValue(string5);
            CustomerParameterServer customerParameterServer6 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_ownIpv4Address");
            customerParameterServer6.setLoadedValue(string6);
            CustomerParameterServer customerParameterServer7 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_ownIdType");
            customerParameterServer7.setLoadedValue(n2);
            NalStruct[] nalStructArray = (NalStruct[])this.getAttribute(bemMo, "allowedTransforms");
            for (int i = 0; i < nalStructArray.length; ++i) {
                Integer n3 = (Integer)nalStructArray[i].getMember("diffieHellmanGroup").getValue();
                Integer n4 = (Integer)nalStructArray[i].getMember("encryptionAlgorithm").getValue();
                Integer n5 = (Integer)nalStructArray[i].getMember("integrityAlgorithm").getValue();
                Integer n6 = (Integer)nalStructArray[i].getMember("pseudoRandomFunction").getValue();
                String string7 = MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_diffieHellmanGroup", String.valueOf(i + 1));
                CustomerParameterServer customerParameterServer8 = this.rbs.getCustomerParameterServerObject(string7);
                customerParameterServer8.setLoadedValue(n3);
                String string8 = MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_encryptionAlgorithm", String.valueOf(i + 1));
                CustomerParameterServer customerParameterServer9 = this.rbs.getCustomerParameterServerObject(string8);
                customerParameterServer9.setLoadedValue(n4);
                String string9 = MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_integrityAlgorithm", String.valueOf(i + 1));
                CustomerParameterServer customerParameterServer10 = this.rbs.getCustomerParameterServerObject(string9);
                customerParameterServer10.setLoadedValue(n5);
                String string10 = MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_pseudoRandomFunction", String.valueOf(i + 1));
                CustomerParameterServer customerParameterServer11 = this.rbs.getCustomerParameterServerObject(string10);
                customerParameterServer11.setLoadedValue(n6);
            }
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        if (this.ikePeerMoi != null) {
            String string = this.ikePeerMoi.getLdn();
            BemMo bemMo = this.getMo(string);
            bl = this.isExisting(bemMo);
        }
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            Iterator iterator = this.pseudoList.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                if (!customerParameter.isValidValue()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("IkePeerCreationPhase")) {
            this.installIkePeer();
        }
    }

    private void installIkePeer() throws BemException {
        String string = this.ikePeerMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isInstalled();
        if (!bl) {
            NalObject[] nalObjectArray;
            Object object;
            NalNameValue[] nalNameValueArray;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_peerIpAddress");
            Object object2 = customerParameterServer.getValueMom();
            vector.add(Nal.getFactory().getNameValue("peerIpAddress", object2));
            CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_peerIdFqdn");
            CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_peerIdType");
            CustomerParameterServer customerParameterServer4 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_peerIpv4Address");
            Object object3 = customerParameterServer2.getValueMom();
            Object object4 = customerParameterServer3.getValueMom();
            Object object5 = customerParameterServer4.getValueMom();
            if (!object4.equals("##UNDEFINED") && !object4.equals("")) {
                if (object4.equals(new Integer(0)) && (object3.equals("##UNDEFINED") || object3.equals("") || object5.equals("##UNDEFINED") || object5.equals(""))) {
                    Nal.getFactory().getLog().nalTrace(7, this.getClass(), "Invalid CustomerParam: When idType is set to ANY, all types of peer identities must have values ");
                    throw new CustomerParameterException((CustomerParameter)((Object)customerParameterServer3));
                }
                nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("idType", object4), Nal.getFactory().getNameValue("ipv4Address", object5), Nal.getFactory().getNameValue("idFqdn", object3)};
                object = Nal.getFactory().getStruct(nalNameValueArray);
                vector.add(Nal.getFactory().getNameValue("peerIdentity", object));
            }
            nalNameValueArray = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_ownIdFqdn");
            object = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_ownIdType");
            CustomerParameterServer customerParameterServer5 = this.rbs.getCustomerParameterServerObject(this.prefix + "IkePeer_ownIpv4Address");
            Object object6 = nalNameValueArray.getValueMom();
            Object object7 = object.getValueMom();
            Object object8 = customerParameterServer5.getValueMom();
            if (!object7.equals("##UNDEFINED") && !object7.equals("")) {
                if (object7.equals(new Integer(0)) && (!object6.equals("##UNDEFINED") && !object6.equals("") || !object8.equals("##UNDEFINED") && !object8.equals(""))) {
                    Nal.getFactory().getLog().nalTrace(7, this.getClass(), "Invalid CustomerParam: When ownIdType is set to AUTOMATIC, idFqdn and ipv4Address cannot be set ");
                    throw new CustomerParameterException((CustomerParameter)object);
                }
                nalObjectArray = new NalNameValue[]{Nal.getFactory().getNameValue("ownIdType", object7), Nal.getFactory().getNameValue("idFqdn", object6), Nal.getFactory().getNameValue("ipv4Address", object8)};
                NalStruct nalStruct = Nal.getFactory().getStruct((NalNameValue[])nalObjectArray);
                vector.add(Nal.getFactory().getNameValue("ownIdentity", nalStruct));
            }
            nalObjectArray = new NalStruct[6];
            int n = 0;
            for (int i = 0; i < 6; ++i) {
                String string2 = MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_diffieHellmanGroup", String.valueOf(i + 1));
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
                String string3 = customerParameter.getValue();
                CustomerParameterServer customerParameterServer6 = this.rbs.getCustomerParameterServerObject(string2);
                String string4 = MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_encryptionAlgorithm", String.valueOf(i + 1));
                CustomerParameter customerParameter2 = this.rbs.getCustomerParameterObject(string4);
                String string5 = customerParameter2.getValue();
                CustomerParameterServer customerParameterServer7 = this.rbs.getCustomerParameterServerObject(string4);
                String string6 = MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_integrityAlgorithm", String.valueOf(i + 1));
                CustomerParameter customerParameter3 = this.rbs.getCustomerParameterObject(string6);
                String string7 = customerParameter3.getValue();
                CustomerParameterServer customerParameterServer8 = this.rbs.getCustomerParameterServerObject(string6);
                String string8 = MessageFormat.format(this.prefix + "IkePeer_IkeSaTf_{0}_pseudoRandomFunction", String.valueOf(i + 1));
                CustomerParameter customerParameter4 = this.rbs.getCustomerParameterObject(string8);
                String string9 = customerParameter4.getValue();
                CustomerParameterServer customerParameterServer9 = this.rbs.getCustomerParameterServerObject(string8);
                if (string3.equals("##UNDEFINED") || string3.equals("") || string5.equals("##UNDEFINED") || string5.equals("") || string7.equals("##UNDEFINED") || string7.equals("") || string9.equals("##UNDEFINED") || string9.equals("")) continue;
                Object object9 = customerParameterServer6.getValueMom();
                Object object10 = customerParameterServer7.getValueMom();
                Object object11 = customerParameterServer8.getValueMom();
                Object object12 = customerParameterServer9.getValueMom();
                NalNameValue[] nalNameValueArray2 = new NalNameValue[]{Nal.getFactory().getNameValue("diffieHellmanGroup", object9), Nal.getFactory().getNameValue("encryptionAlgorithm", object10), Nal.getFactory().getNameValue("integrityAlgorithm", object11), Nal.getFactory().getNameValue("pseudoRandomFunction", object12)};
                nalObjectArray[i] = Nal.getFactory().getStruct(nalNameValueArray2);
                ++n;
            }
            NalStruct[] nalStructArray = new NalStruct[n];
            int n2 = 0;
            for (int i = 0; i < 6; ++i) {
                if (nalObjectArray[i] == null) continue;
                nalStructArray[n2] = nalObjectArray[i];
                ++n2;
            }
            vector.add(Nal.getFactory().getNameValue("allowedTransforms", nalStructArray));
            vector.add(Nal.getFactory().getNameValue("authenticationMethod", new Integer(0)));
            this.create(bemMo, vector);
        }
    }

    public String getIkePeerId() {
        return String.valueOf(this.rdnId);
    }

    public String getIkePeerLdn() throws BemException {
        String string = "";
        if (this.ikePeerMoi != null) {
            string = this.ikePeerMoi.getLdn();
        }
        return string;
    }

    public String getDisplayName() {
        return name;
    }

    public MoInstance getMoi() {
        return this.ikePeerMoi;
    }

    public String getLdn() {
        return "";
    }
}

