/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractAuxControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDevice;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAiDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimFuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class FuRI
extends AbstractAuxControlledAuxillaryUnitRI {
    public static final String name = "FU";
    private static final String piuTypeProductName = "FU";
    private static String TYPE = "2";
    private static String IDENTITY = "1";
    private String ldn;
    private String auxPiuLdn;
    private MoInstance auxPiuMoi;
    private MoInstance boardMoi;
    private int slotNumber;
    private boolean lockSecondAiDevice = false;
    private MoHandler moHandler;

    public FuRI(Rbs rbs, MoInstance moInstance, int n, String string) throws BemException {
        super("FU", rbs, 12, "FU", string);
        this.slotNumber = n;
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimRbsSlot.MOTYPENAME, String.valueOf(n));
        this.auxPiuMoi = new SingleChildMoi(fixedRdnMoi, MimAuxPlugInUnit.MOTYPENAME, "1");
        this.boardMoi = new SingleChildMoi(this.auxPiuMoi, MimFuDeviceGroup.MOTYPENAME, "1");
        this.auxPiuLdn = this.auxPiuMoi.getLdn();
        this.ldn = this.boardMoi.getLdn();
        this.moHandler = rbs.getMoHandler();
    }

    public FuRI(Rbs rbs, int n, String string) throws BemException {
        super("FU", rbs, 12, "FU", string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(n));
        stringBuffer.append("_");
        stringBuffer.append(IDENTITY);
        stringBuffer.append("_");
        stringBuffer.append(TYPE);
        MoInstance moInstance = rbs.getEquipmentMoi();
        this.auxPiuMoi = new FixedRdnMoi(moInstance, MimAuxPlugInUnit.MOTYPENAME, stringBuffer.toString());
        this.boardMoi = new SingleChildMoi(this.auxPiuMoi, MimFuDeviceGroup.MOTYPENAME, "1");
        this.auxPiuLdn = this.auxPiuMoi.getLdn();
        this.ldn = this.boardMoi.getLdn();
        this.moHandler = rbs.getMoHandler();
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (string.equals("LockPhase") || string.equals("UnlockPhase")) {
            this.lockOrUnlockSecondAiDevice();
        }
    }

    public void setSecondAiLocked(boolean bl) {
        this.lockSecondAiDevice = bl;
    }

    private void lockOrUnlockSecondAiDevice() throws BemException {
        try {
            String string = this.ldn + "," + MimAiDeviceSet.MOTYPENAME + "=1," + MimAiDevice.MOTYPENAME + "=2";
            BemMo bemMo = this.moHandler.getMo(string);
            Integer n = (Integer)this.moHandler.getAttribute(bemMo, "administrativeState");
            if (this.lockSecondAiDevice) {
                if (n != null && n == 1) {
                    this.moHandler.setAttribute(bemMo, "administrativeState", new Integer(0));
                }
            } else if (n != null && n == 0) {
                this.moHandler.setAttribute(bemMo, "administrativeState", new Integer(1));
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string = moHandlerException.getAction();
            throw new BemException(string, this.ldn, (Throwable)moHandlerException);
        }
    }

    public String[] getInstallationPhases() {
        String[] stringArray = super.getInstallationPhases();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        if (!arrayList.contains("LockPhase")) {
            arrayList.add("LockPhase");
        }
        if (!arrayList.contains("UnlockPhase")) {
            arrayList.add("UnlockPhase");
        }
        return arrayList.toArray(new String[0]);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getAuxPiuLdn() {
        return this.auxPiuLdn;
    }

    public String getDisplayName() {
        return "FU:" + this.ldn;
    }
}

