/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.AbstractDuwRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.hspamgmt.HspaResourcesManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.DuwPortUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.MoiRefs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAntFeederCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSectorAntenna;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class RbsLoader {
    private static final String RADIO_INTERNAL_CASCADE_NUMBER_ENDING_1 = "-1";
    private static final String RBS_SUBRACK_NUMBER_ENDING_1 = "1";
    private static final String RBS_SUBRACK_NUMBER_ENDING_2 = "2";
    private static final String MO_RDN_CONNECTOR_SHORT_LINE = "-";
    private static final ArrayList MACRORADIO_UNDER_RBSSLOT_MO = new ArrayList();
    private static final ArrayList MACRORADIO_UNDER_EQUIPEMENT_MO = new ArrayList();
    private static final ArrayList MAINREMOTERADIO_UNDER_EQUIPEMENT_MO = new ArrayList();
    private static final ArrayList MAINREMOTERADIO_UNDER_SECTORANTENNA_MO = new ArrayList();
    private static final RbsLoader _instance = new RbsLoader();

    public static final RbsLoader getInstance() throws BemException {
        return _instance;
    }

    protected void updateLoadedValues(AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, RbbManager rbbManager, SectorCustomerParameterManager sectorCustomerParameterManager, HspaResourcesManager hspaResourcesManager) throws BemException {
        int n = abstractDuwRadioEquipmentCI.getMaxNoOfSectors();
        int n2 = abstractDuwRadioEquipmentCI.getStartingSectorNumber();
        this.disableAllScpmListeners(sectorCustomerParameterManager);
        this.loadCurrentRadioConfiguration(rbbManager.getRbs().getMoHandler());
        if (this.isAnyRadioExistingOnNode()) {
            this.mappingSlotNum2SectorNum(rbbManager);
            SectorRI[] sectorRIArray = abstractDuwRadioEquipmentCI.getSectorRis();
            for (int i = 0; i < n; ++i) {
                String string;
                int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, n2);
                SectorRI sectorRI = sectorRIArray[i];
                if (!sectorRI.isInstalled() || "".equals(string = sectorRIArray[i].getLoadedRadioBuildingBlockName())) continue;
                Integer n4 = sectorRI.getLoadedLineRate();
                this.updateLoadedScpsValue(rbbManager, sectorCustomerParameterManager, string, n3, n4);
            }
        }
        this.enableAllScpmListeners(sectorCustomerParameterManager);
        boolean bl = rbbManager.checkSlotPosition();
        if (!rbbManager.getRbs().isModifyWiz()) {
            bl = true;
        }
        rbbManager.notifyThatRbbsMightBeChanged(sectorCustomerParameterManager, bl);
        hspaResourcesManager.updateLoadedValues();
    }

    private void enableAllScpmListeners(SectorCustomerParameterManager sectorCustomerParameterManager) {
        sectorCustomerParameterManager.enableListeners();
    }

    private void disableAllScpmListeners(SectorCustomerParameterManager sectorCustomerParameterManager) {
        sectorCustomerParameterManager.disableListeners();
    }

    private void updateLoadedScpsValue(RbbManager rbbManager, SectorCustomerParameterManager sectorCustomerParameterManager, String string, int n, Integer n2) throws BemException {
        MoHandler moHandler = rbbManager.getRbs().getMoHandler();
        BemMo bemMo = this.getLoadedFisrtAuxPiuMoForSector(n);
        String string2 = this.getLoadedAuUnitTypeForSector(n);
        String string3 = this.getLoadedPrimaryPortId(moHandler, bemMo);
        String string4 = this.getLoadedSecondaryPortId(moHandler, string3, bemMo);
        String string5 = this.getLoadedCabinetNumber(n);
        String string6 = null;
        String string7 = null;
        String string8 = null;
        boolean bl = this.hasSlotNumForLoadedSector(n);
        if (bl) {
            string6 = RBS_SUBRACK_NUMBER_ENDING_1;
            string7 = "";
            string8 = "YES";
        } else {
            string6 = this.getLoadedSectorSequence(rbbManager, moHandler, bemMo);
            string7 = this.getLoadedRadioSharedBySector(moHandler, n);
            string8 = "NO";
        }
        sectorCustomerParameterManager.setLoadedValues(n, string, n2, string3, string4, string6, string2, string7, string8, string5);
    }

    private String getLoadedPrimaryPortId(MoHandler moHandler, BemMo bemMo) throws BemException {
        return this.getPortIdFromMo(moHandler, bemMo);
    }

    private String getLoadedRadioSharedBySector(MoHandler moHandler, int n) throws BemException {
        BemMo[] bemMoArray = this.getAuxMoByAutype(moHandler, 20);
        String string = "";
        for (int i = 0; i < bemMoArray.length; ++i) {
            String[] stringArray = this.lookupSectorNumberByAuxMo(moHandler, bemMoArray[i]);
            if (stringArray.length == 2) {
                if (n == Integer.parseInt(stringArray[0])) {
                    string = stringArray[1];
                    continue;
                }
                if (n != Integer.parseInt(stringArray[1])) continue;
                string = stringArray[0];
                continue;
            }
            if (stringArray.length != 1 || !stringArray[0].equals(String.valueOf(n))) continue;
            BemMo[] bemMoArray2 = (BemMo[])bemMoArray[i].getAttribute("reservedBy");
            for (int j = 0; j < bemMoArray2.length; ++j) {
                String string2;
                int n2 = bemMoArray2[j].getDN().indexOf(MimAntFeederCable.MOTYPENAME);
                if (n2 == -1 || !(string2 = bemMoArray2[j].getId()).endsWith(MimAntennaBranchDef.BRANCH_B) || string2.equals(n + MimAntennaBranchDef.BRANCH_B)) continue;
                string = string2.substring(0, 1);
            }
        }
        return string;
    }

    private String getLoadedSecondaryPortId(MoHandler moHandler, String string, BemMo bemMo) throws BemException {
        String string2 = bemMo.getParent().getType();
        if (MimSectorAntenna.MOTYPENAME.equals(string2)) {
            return this.getSecondaryPortIdForSAMo(moHandler, string, bemMo);
        }
        if (MimRbsSlot.MOTYPENAME.equals(string2)) {
            return this.getSecondaryPortIdForRbsSlotMo(moHandler, string, bemMo);
        }
        if (MimEquipment.MOTYPENAME.equals(string2)) {
            return this.getSecondaryPortIdForEquipmentMo(moHandler, string, bemMo);
        }
        return "";
    }

    private String getSecondaryPortIdForRbsSlotMo(MoHandler moHandler, String string, BemMo bemMo) throws BemException {
        String string2;
        String string3 = bemMo.getParent().getId();
        String string4 = bemMo.getLastRDN();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bemMo.getParent().getParent().getDN());
        stringBuffer.append(",");
        stringBuffer.append(MimRbsSlot.MOTYPENAME);
        stringBuffer.append("=");
        stringBuffer.append(Integer.parseInt(string3) + 2);
        stringBuffer.append(",");
        stringBuffer.append(string4.replace('1', '2'));
        BemMo bemMo2 = moHandler.getMo(stringBuffer.toString());
        if (bemMo2.isExisting() && !"".equals(string2 = this.getPortIdFromMo(moHandler, bemMo2)) && !string.equals(string2)) {
            return string2;
        }
        return "";
    }

    private String getSecondaryPortIdForSAMo(MoHandler moHandler, String string, BemMo bemMo) throws BemException {
        int n = 4;
        int n2 = 2;
        int n3 = 3;
        for (int i = n2; i <= n; ++i) {
            for (int j = 1; j <= n3; ++j) {
                String string2;
                String string3 = bemMo.getParent().getDN();
                String string4 = bemMo.getLastRDN();
                String string5 = String.copyValueOf(string3.toCharArray(), 0, string3.length() - 1) + j;
                String string6 = String.copyValueOf(string4.toCharArray(), 0, string4.length() - 1) + i;
                String string7 = string5 + "," + string6;
                BemMo bemMo2 = moHandler.getMo(string7);
                if (!bemMo2.isExisting() || "".equals(string2 = this.getPortIdFromMo(moHandler, bemMo2)) || string2.equals(string)) continue;
                return string2;
            }
        }
        return "";
    }

    private String getSecondaryPortIdForEquipmentMo(MoHandler moHandler, String string, BemMo bemMo) throws BemException {
        if ((Integer)bemMo.getAttribute("auType") == 20) {
            String string2 = this.getFirstSectorNumberFromAuxPiuForBranchA(moHandler, bemMo);
            BemMo[] bemMoArray = this.getAllAuxMoUnderEquipment(moHandler);
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string3;
                String string4;
                if ((Integer)bemMoArray[i].getAttribute("auType") != 20 || !string2.equals(string4 = this.getFirstSectorNumberFromAuxPiuForBranchA(moHandler, bemMoArray[i])) || "".equals(string3 = this.getPortIdFromMo(moHandler, bemMoArray[i])) || string3.equals(string)) continue;
                return string3;
            }
        } else {
            int n = 4;
            int n2 = 2;
            String string5 = bemMo.getDN();
            for (int i = n2; i <= n; ++i) {
                String string6;
                String string7 = string5.substring(0, string5.length() - 1) + i;
                BemMo bemMo2 = moHandler.getMo(string7);
                if (!bemMo2.isExisting() || "".equals(string6 = this.getPortIdFromMo(moHandler, bemMo2)) || string6.equals(string)) continue;
                return string6;
            }
        }
        return "";
    }

    private BemMo[] getAllAuxMoUnderEquipment(MoHandler moHandler) throws BemException {
        MoiRefs moiRefs = new MoiRefs();
        BemMo bemMo = moHandler.getMo(moiRefs.getEquipmentMoi().getLdn());
        ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
        BemMo[] bemMoArray = bemMo.getChildren();
        for (int i = 0; i < bemMoArray.length; ++i) {
            if (!bemMoArray[i].getType().equalsIgnoreCase(MimAuxPlugInUnit.MOTYPENAME)) continue;
            arrayList.add(bemMoArray[i]);
        }
        return arrayList.toArray(new BemMo[0]);
    }

    private String getLoadedSectorSequence(RbbManager rbbManager, MoHandler moHandler, BemMo bemMo) throws BemException {
        return this.findSectorSequenceThroughCableWalkOpticalCpri(rbbManager, bemMo);
    }

    private String findSectorSequenceThroughCableWalkOpticalCpri(RbbManager rbbManager, BemMo bemMo) throws BemException {
        BemMo bemMo2;
        int n = 1;
        Rbs rbs = rbbManager.getRbs();
        MoHandler moHandler = rbs.getMoHandler();
        BemMo bemMo3 = bemMo;
        String string = this.getFirstSectorNumberFromAuxPiuForBranchA(moHandler, bemMo3);
        int n2 = rbbManager.getMaxNumberOfSectors();
        for (int i = 0; i < n2 && !this.isDuwMo(bemMo2 = this.getPreviousObjectAOpticalCpri(moHandler, bemMo3)); ++i) {
            String string2 = this.getFirstSectorNumberFromAuxPiuForBranchA(moHandler, bemMo2);
            if (null == string2) {
                bemMo3 = bemMo2;
                --i;
                continue;
            }
            if (!string2.equals(string)) {
                ++n;
            }
            string = string2;
            int n3 = 0;
            if ("".equals(string)) {
                throw new BemException("findSectorSequenceThroughCableWalkOpticalCpri()  converting sectorNumber failed, sectorNumber=" + string + "");
            }
            n3 = Integer.parseInt(string);
            bemMo3 = this.getLoadedFisrtAuxPiuMoForSector(n3);
        }
        return String.valueOf(n);
    }

    private String getFirstSectorNumberFromAuxPiuForBranchA(MoHandler moHandler, BemMo bemMo) {
        String[] stringArray = this.lookupSectorNumberByAuxMo(moHandler, bemMo);
        String string = stringArray.length == 0 ? null : stringArray[0];
        return string;
    }

    public BemMo getDigitalCableWhereAuxPiuIsObjectB(MoHandler moHandler, BemMo bemMo) throws BemException {
        BemMo[] bemMoArray = this.getAllDigitalCables(moHandler, bemMo);
        BemMo bemMo2 = null;
        for (int i = 0; i < bemMoArray.length; ++i) {
            BemMo bemMo3 = bemMoArray[i];
            try {
                this.verifyMoExistence(moHandler, "getDigitalCableWhereAuxPiuIsObjectB", bemMo3);
                BemMo bemMo4 = (BemMo)moHandler.getAttribute(bemMo3, "connectedToObjectBRef");
                this.verifyMoExistence(moHandler, "getDigitalCableWhereAuxPiuIsObjectB", bemMo4);
                if (!bemMo4.getDN().equals(bemMo.getDN())) continue;
                bemMo2 = bemMo3;
                break;
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException("getDigitalCableWhereAuxPiuIsObjectB() can not find the correct DigitalCable. MoHandlerException:", (Throwable)moHandlerException);
            }
        }
        if (bemMo2 == null) {
            throw new BemException("getDigitalCableWhereAuxPiuIsObjectB() can not find the correct DigitalCable");
        }
        return bemMo2;
    }

    private BemMo getObjectA(MoHandler moHandler, BemMo bemMo) throws BemException {
        BemMo bemMo2 = null;
        try {
            this.verifyMoExistence(moHandler, "getObjectA() for DigitalCable", bemMo);
            bemMo2 = (BemMo)moHandler.getAttribute(bemMo, "connectedToObjectARef");
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("getObjectA() can not find the correct ObjectA. MoHandlerException:", (Throwable)moHandlerException);
        }
        return bemMo2;
    }

    private BemMo getPreviousObjectAOpticalCpri(MoHandler moHandler, BemMo bemMo) throws BemException {
        BemMo bemMo2 = null;
        BemMo bemMo3 = this.getDigitalCableWhereAuxPiuIsObjectB(moHandler, bemMo);
        try {
            this.verifyMoExistence(moHandler, "getPreviousObjectAOpticalCpri", bemMo3);
            bemMo2 = (BemMo)bemMo3.getAttribute("connectedToObjectARef");
        }
        catch (Exception exception) {
            throw new BemException("getPreviousObjectAOpticalCpri() can not interprete auxPiuMo", (Throwable)exception);
        }
        return bemMo2;
    }

    private boolean isDuwMo(BemMo bemMo) throws BemException {
        boolean bl = false;
        String string = DuwUtil.getPrimaryDuwPiuLdn();
        String string2 = DuwUtil.getSecondaryDuwPiuLdn();
        String string3 = bemMo.getDN();
        if (string3.equals(string) || string3.equals(string2)) {
            bl = true;
        }
        return bl;
    }

    private boolean isPrimaryDuwMo(BemMo bemMo) throws BemException {
        boolean bl = false;
        String string = DuwUtil.getPrimaryDuwPiuLdn();
        String string2 = bemMo.getDN();
        if (string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private String getPortIdFromMo(MoHandler moHandler, BemMo bemMo) throws BemException {
        String string;
        String string2 = "";
        if (null == bemMo) {
            throw new BemException(this.getClass().getName() + ", getPortIdFromMo(), the first AuxPiuMo is null.");
        }
        if (!bemMo.isExisting()) {
            throw new BemException("MO is not existing on node, LDN=" + bemMo.getDN());
        }
        int n = 0;
        BemMo bemMo2 = null;
        BemMo bemMo3 = null;
        while (true) {
            bemMo2 = this.getDigitalCableWhereAuxPiuIsObjectB(moHandler, bemMo);
            bemMo3 = this.getObjectA(moHandler, bemMo2);
            if (n++ > 100) {
                throw new BemException("getPortIdFromMoOpticalCpri() can not interprete portId");
            }
            if (this.isDuwMo(bemMo3)) {
                string = RBS_SUBRACK_NUMBER_ENDING_2;
                if (this.isPrimaryDuwMo(bemMo3)) {
                    string = RBS_SUBRACK_NUMBER_ENDING_1;
                }
                break;
            }
            bemMo = bemMo3;
        }
        string2 = this.getPortIdFromDigitalCableMo(bemMo2, string);
        return string2;
    }

    private String getPortIdFromDigitalCableMo(BemMo bemMo, String string) throws BemException {
        String string2 = bemMo.getDN();
        String string3 = BemUtil.extractRdnId(string2, MimDigitalCable.MOTYPENAME);
        int n = string3.indexOf("RI_");
        if (n == -1) {
            throw new BemException("getPortIdFromDigitalCableRdn() can not get portId from rdn");
        }
        String string4 = string3.substring(n);
        return DuwPortUtil.getPortIdFromConnectorName(string4, string);
    }

    private BemMo[] getAllDigitalCables(MoHandler moHandler, BemMo bemMo) throws BemException {
        BemMo[] bemMoArray;
        try {
            BemMo[] bemMoArray2 = (BemMo[])moHandler.getAttribute(bemMo, "reservedBy");
            if (bemMoArray2 == null) {
                throw new BemException("getAllDigitalCables() can not find any reservedBy");
            }
            ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
            for (int i = 0; i < bemMoArray2.length; ++i) {
                String string = bemMoArray2[i].getDN();
                int n = string.indexOf(MimDigitalCable.MOTYPENAME);
                if (n == -1) continue;
                arrayList.add(bemMoArray2[i]);
            }
            if (arrayList.size() <= 0) {
                throw new BemException("getAllDigitalCables() can not find any reservedBy Digital Cables");
            }
            bemMoArray = arrayList.toArray(new BemMo[0]);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("getAllDigitalCables()  " + moHandlerException.toString());
        }
        return bemMoArray;
    }

    private void verifyMoExistence(MoHandler moHandler, String string, BemMo bemMo) throws BemException {
        try {
            String string2 = bemMo.getDN();
            if (!moHandler.isExisting(bemMo)) {
                throw new BemException("Required MO does not exist. Probably a faulty configured RBS. LDN=" + string2 + "\n" + string);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Can not access the RBS. MoHandlerException=" + moHandlerException.toString());
        }
    }

    private void loadCurrentRadioConfiguration(MoHandler moHandler) throws BemException {
        MACRORADIO_UNDER_RBSSLOT_MO.clear();
        MACRORADIO_UNDER_EQUIPEMENT_MO.clear();
        MAINREMOTERADIO_UNDER_EQUIPEMENT_MO.clear();
        MAINREMOTERADIO_UNDER_SECTORANTENNA_MO.clear();
        int[] nArray = AuUnitType.ALL_AUTYPE_MIM_LIST;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            BemMo[] bemMoArray = this.getAuxMoByAutype(moHandler, n);
            if (bemMoArray == null) continue;
            for (int j = 0; j < bemMoArray.length; ++j) {
                int n2;
                String string;
                BemMo bemMo = bemMoArray[j];
                String string2 = AuUnitType.getAuTypeByMim((Integer)bemMo.getAttribute("auType"));
                BemMo bemMo2 = bemMo.getParent();
                if (null == bemMo2) continue;
                String string3 = bemMo2.getType();
                BemMo bemMo3 = (BemMo)bemMo.getAttribute("positionRef");
                String[] stringArray = this.lookupSectorNumberByAuxMo(moHandler, bemMo);
                String string4 = string = stringArray.length == 0 ? null : stringArray[0];
                if (MimRbsSlot.MOTYPENAME.equals(string3)) {
                    if (!bemMo.getId().endsWith(RADIO_INTERNAL_CASCADE_NUMBER_ENDING_1)) continue;
                    BemMo bemMo4 = bemMo2.getParent();
                    if (bemMo4.getId().endsWith(RBS_SUBRACK_NUMBER_ENDING_1)) {
                        MACRORADIO_UNDER_RBSSLOT_MO.add(new SectorRadio(string, bemMo2.getId(), RBS_SUBRACK_NUMBER_ENDING_1, string2, bemMo, bemMo3));
                        continue;
                    }
                    if (bemMo4.getId().endsWith(RBS_SUBRACK_NUMBER_ENDING_2)) {
                        MACRORADIO_UNDER_RBSSLOT_MO.add(new SectorRadio(string, bemMo2.getId(), RBS_SUBRACK_NUMBER_ENDING_2, string2, bemMo, bemMo3));
                        continue;
                    }
                    throw new BemException("can not explain the RbsSubrack =" + bemMo.getDN());
                }
                if (MimSectorAntenna.MOTYPENAME.equals(string3)) {
                    String string5 = null != string ? string : bemMo2.getId().substring(0, bemMo2.getId().indexOf(MO_RDN_CONNECTOR_SHORT_LINE));
                    n2 = Integer.parseInt(string5);
                    if (!this.isSectorNumExistingFromTheList(MAINREMOTERADIO_UNDER_SECTORANTENNA_MO, n2)) {
                        MAINREMOTERADIO_UNDER_SECTORANTENNA_MO.add(new SectorRadio(string5, null, null, string2, bemMo, bemMo3));
                        continue;
                    }
                    BemMo bemMo5 = this.getLoadedFisrtAuxPiuMoForSector(n2);
                    if (bemMo5.getDN().endsWith(RADIO_INTERNAL_CASCADE_NUMBER_ENDING_1) || !bemMo.getDN().endsWith(RADIO_INTERNAL_CASCADE_NUMBER_ENDING_1)) continue;
                    this.getSectorRadioForSector(n2).setAuxMo(bemMo);
                    continue;
                }
                if (MimEquipment.MOTYPENAME.equals(string3)) {
                    if (null == string) {
                        int n3;
                        String string6 = bemMo.getId();
                        n2 = string6.indexOf(MO_RDN_CONNECTOR_SHORT_LINE);
                        if (n2 >= (n3 = string6.lastIndexOf(MO_RDN_CONNECTOR_SHORT_LINE))) {
                            throw new BemException("can not explain the aux RDN, mo=" + bemMo.getDN());
                        }
                        string = string6.substring(n2 + 1, n3);
                    }
                    if (AuUnitType.isMacroAuUnitType(AuUnitType.getAuTypeByMim(n))) {
                        MACRORADIO_UNDER_EQUIPEMENT_MO.add(new SectorRadio(string, null, null, string2, bemMo, bemMo3));
                        continue;
                    }
                    for (int k = 0; k < stringArray.length; ++k) {
                        MAINREMOTERADIO_UNDER_EQUIPEMENT_MO.add(new SectorRadio(stringArray[k], null, null, string2, bemMo, bemMo3));
                    }
                    continue;
                }
                throw new BemException("can not explain the aux mo=" + bemMo.getDN());
            }
        }
    }

    private String[] lookupSectorNumberByAuxMo(MoHandler moHandler, BemMo bemMo) {
        ArrayList arrayList = new ArrayList();
        BemMo[] bemMoArray = (BemMo[])bemMo.getAttribute("reservedBy");
        if (bemMoArray != null) {
            arrayList = !this.getSectorNumberByAntFeederCableMo(bemMoArray, "A").isEmpty() ? (ArrayList)this.getSectorNumberByAntFeederCableMo(bemMoArray, "A") : (ArrayList)this.getSectorNumberByAntFeederCableMo(bemMoArray, "B");
        }
        int n = arrayList.size();
        return arrayList.toArray(new String[n]);
    }

    private List getSectorNumberByAntFeederCableMo(BemMo[] bemMoArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < bemMoArray.length; ++i) {
            BemMo bemMo = bemMoArray[i];
            if (!bemMo.getType().equalsIgnoreCase(MimAntFeederCable.MOTYPENAME) || !bemMo.getId().endsWith(string)) continue;
            int n = bemMo.getId().indexOf(string);
            arrayList.add(bemMo.getId().substring(0, n));
        }
        return arrayList;
    }

    private BemMo[] getAuxMoByAutype(MoHandler moHandler, int n) throws BemException {
        String string = "auType==" + n;
        try {
            return moHandler.getChildren(moHandler.getRoot(), 4, MimAuxPlugInUnit.MOTYPENAME, string);
        }
        catch (MoHandlerException moHandlerException) {
            moHandlerException.printStackTrace();
            throw new BemException(moHandlerException);
        }
    }

    private ArrayList filterNonRuPositionSectorMO(BemMo[] bemMoArray) {
        Object object;
        int n;
        ArrayList[] arrayListArray = new ArrayList[]{MACRORADIO_UNDER_EQUIPEMENT_MO, MAINREMOTERADIO_UNDER_EQUIPEMENT_MO, MAINREMOTERADIO_UNDER_SECTORANTENNA_MO};
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < bemMoArray.length; ++n) {
            object = bemMoArray[n].getId();
            if (Integer.parseInt((String)object) > 6) continue;
            arrayList.add(object);
        }
        for (n = 0; n < arrayListArray.length; ++n) {
            object = arrayListArray[n];
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string = ((SectorRadio)((ArrayList)object).get(i)).getSectorNum();
                if (!arrayList.contains(string)) continue;
                arrayList.remove(string);
            }
        }
        return arrayList;
    }

    private void mappingSlotNum2SectorNum(RbbManager rbbManager) throws BemException {
        int n;
        BemMo[] bemMoArray = rbbManager.getSectorsFromRbsMoHandler();
        ArrayList arrayList = this.filterNonRuPositionSectorMO(bemMoArray);
        boolean bl = false;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (n = 0; n < MACRORADIO_UNDER_RBSSLOT_MO.size(); n += 1) {
            SectorRadio sectorRadio = (SectorRadio)MACRORADIO_UNDER_RBSSLOT_MO.get(n);
            String string = sectorRadio.getRbsSubrack();
            String string2 = sectorRadio.getSlotNum();
            if (RBS_SUBRACK_NUMBER_ENDING_1.equals(string)) {
                arrayList2.add(string2);
            } else if (RBS_SUBRACK_NUMBER_ENDING_2.equals(string)) {
                arrayList3.add(string2);
            } else {
                throw new BemException("can not explain the RbsSubrack =" + string);
            }
            if (sectorRadio.sectorNumHasBeenLoaded()) continue;
            bl = true;
        }
        n = rbbManager.checkSlotPosition() ? 1 : 0;
        if (bl) {
            int n2 = arrayList2.size();
            int n3 = arrayList3.size();
            this.allocateSectorNumBySlotNum(arrayList2, rbbManager.getRuPositionBySectors(n2 + n3, n != 0), arrayList, 0, RBS_SUBRACK_NUMBER_ENDING_1);
            this.allocateSectorNumBySlotNum(arrayList3, rbbManager.getRuPositionBySectors(n2 + n3, n != 0), arrayList, arrayList2.size(), RBS_SUBRACK_NUMBER_ENDING_2);
        }
    }

    private void allocateSectorNumBySlotNum(ArrayList arrayList, int[] nArray, ArrayList arrayList2, int n, String string) {
        block0: for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] != Integer.parseInt(string2)) continue;
                for (int k = 0; k < MACRORADIO_UNDER_RBSSLOT_MO.size(); ++k) {
                    SectorRadio sectorRadio = (SectorRadio)MACRORADIO_UNDER_RBSSLOT_MO.get(k);
                    if (!sectorRadio.getSlotNum().equals(string2) || !string.equals(sectorRadio.getRbsSubrack())) continue;
                    int n2 = j + n;
                    if (n2 >= arrayList2.size()) continue block0;
                    sectorRadio.setSectorNum((String)arrayList2.get(j + n));
                    continue block0;
                }
                continue block0;
            }
        }
    }

    private boolean isSectorNumExistingFromTheList(ArrayList arrayList, int n) {
        for (int i = 0; i < arrayList.size(); ++i) {
            SectorRadio sectorRadio = (SectorRadio)arrayList.get(i);
            String string = sectorRadio.getSectorNum();
            if (null == string || "".equals(string)) {
                return false;
            }
            if (n != Integer.parseInt(string)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnyRadioExistingOnNode() {
        return !MACRORADIO_UNDER_RBSSLOT_MO.isEmpty() || !MACRORADIO_UNDER_EQUIPEMENT_MO.isEmpty() || !MAINREMOTERADIO_UNDER_EQUIPEMENT_MO.isEmpty() || !MAINREMOTERADIO_UNDER_SECTORANTENNA_MO.isEmpty();
    }

    private boolean hasSlotNumForLoadedSector(int n) {
        for (int i = 0; i < MACRORADIO_UNDER_RBSSLOT_MO.size(); ++i) {
            SectorRadio sectorRadio = (SectorRadio)MACRORADIO_UNDER_RBSSLOT_MO.get(i);
            String string = sectorRadio.getSectorNum();
            if (null == string || "".equals(string)) {
                return false;
            }
            if (n != Integer.parseInt(string)) continue;
            return true;
        }
        return false;
    }

    private String getLoadedAuUnitTypeForSector(int n) throws BemException {
        return (String)this.getAttValueByType(n, 1);
    }

    private BemMo getLoadedFisrtAuxPiuMoForSector(int n) throws BemException {
        return (BemMo)this.getAttValueByType(n, 2);
    }

    private SectorRadio getSectorRadioForSector(int n) throws BemException {
        return (SectorRadio)this.getAttValueByType(n, 0);
    }

    private String getLoadedCabinetNumber(int n) throws BemException {
        BemMo bemMo = (BemMo)this.getAttValueByType(n, 3);
        BemMo bemMo2 = this.getLoadedFisrtAuxPiuMoForSector(n);
        if (bemMo != null) {
            if (bemMo.isExisting()) {
                return bemMo.getId();
            }
            if (BemLanguageHelp.getEnvironment() != 1) {
                throw new BemException("AuxPlugInUnit:" + bemMo2.getDN() + ", the positionRef=[" + bemMo.getDN() + "] does not exist on the node");
            }
            if (null != bemMo.getDN() && !"".equals(bemMo.getDN())) {
                throw new BemException("AuxPlugInUnit:" + bemMo2.getDN() + ", the positionRef=[" + bemMo.getDN() + "] does not exist on the node");
            }
        }
        return null;
    }

    private Object getAttValueByType(int n, int n2) throws BemException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(MACRORADIO_UNDER_EQUIPEMENT_MO);
        arrayList.addAll(MACRORADIO_UNDER_RBSSLOT_MO);
        arrayList.addAll(MAINREMOTERADIO_UNDER_SECTORANTENNA_MO);
        arrayList.addAll(MAINREMOTERADIO_UNDER_EQUIPEMENT_MO);
        for (int i = 0; i < arrayList.size(); ++i) {
            SectorRadio sectorRadio = (SectorRadio)arrayList.get(i);
            String string = sectorRadio.getSectorNum();
            if ("".equals(string) || null == string || n != Integer.parseInt(string)) continue;
            switch (n2) {
                case 0: {
                    return sectorRadio;
                }
                case 1: {
                    return sectorRadio.getAuUnitType();
                }
                case 2: {
                    return sectorRadio.getAuxMo();
                }
                case 3: {
                    return sectorRadio.getCabinetNumber();
                }
            }
            throw new BemException("can not explain the method input type =" + n2);
        }
        return null;
    }

    private static class SectorRadio {
        private String sectorNum = "";
        private String auUnitType = "";
        private String slotNum = "";
        private String rbsSubrack = "";
        private BemMo firstAuxPiuMo = null;
        private BemMo cabinetMo = null;

        public SectorRadio(String string, String string2, String string3, String string4, BemMo bemMo, BemMo bemMo2) {
            this.sectorNum = string;
            this.slotNum = string2;
            this.rbsSubrack = string3;
            this.auUnitType = string4;
            this.firstAuxPiuMo = bemMo;
            this.cabinetMo = bemMo2;
        }

        public String getSectorNum() {
            return this.sectorNum;
        }

        public void setSectorNum(String string) {
            this.sectorNum = string;
        }

        public String getAuUnitType() {
            return this.auUnitType;
        }

        public String getRbsSubrack() {
            return this.rbsSubrack;
        }

        public BemMo getAuxMo() {
            return this.firstAuxPiuMo;
        }

        public void setAuxMo(BemMo bemMo) {
            this.firstAuxPiuMo = bemMo;
        }

        public String getSlotNum() {
            return this.slotNum;
        }

        public BemMo getCabinetNumber() {
            return this.cabinetMo;
        }

        public boolean sectorNumHasBeenLoaded() {
            return !"".equals(this.sectorNum) && null != this.sectorNum;
        }

        public String toString() {
            return "sector=" + this.sectorNum + ",slot=" + this.slotNum + ",subrack=RUW" + this.rbsSubrack + ",unittype=" + this.auUnitType + ",auxMO=" + this.firstAuxPiuMo.getDN() + ";";
        }
    }
}

