/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.hspamgmt;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDownlinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class HspaSettingsRI
extends AbstractResourceItem {
    private static String name = "HspaSettingsRI";
    private BemMo txDeviceGroupMoProxy;
    private BemMo downlink1stBBPMo;
    private BemMo downlink2ndBBPMo;
    private CustomerParameter numEulResourcesCP;
    private CustomerParameter numHsCodeResourcesCP;
    private CustomerParameter staticNumEulResourcesCP;
    private CustomerParameter staticNumHsCodeResourcesCP;
    private CustomerParameter numHsCodeResources1stBBPCP;
    private CustomerParameter numHsCodeResources2ndBBPCP;
    private static final String[] myInstallationPhases = new String[]{"GenericSettingsPhase"};

    public HspaSettingsRI(Rbs rbs, String string, String string2, String string3, CustomerParameter customerParameter, CustomerParameter customerParameter2, CustomerParameter customerParameter3, CustomerParameter customerParameter4, CustomerParameter customerParameter5, CustomerParameter customerParameter6) throws BemException {
        super(name, rbs, myInstallationPhases);
        this.txDeviceGroupMoProxy = this.getTxDeviceGroupBemMo(string);
        this.downlink1stBBPMo = this.getDownlinkBasebandPoolBemMo(string2);
        this.downlink2ndBBPMo = this.getDownlinkBasebandPoolBemMo(string3);
        this.numEulResourcesCP = customerParameter;
        this.numHsCodeResourcesCP = customerParameter2;
        this.staticNumEulResourcesCP = customerParameter3;
        this.staticNumHsCodeResourcesCP = customerParameter4;
        this.numHsCodeResources1stBBPCP = customerParameter5;
        this.numHsCodeResources2ndBBPCP = customerParameter6;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            MoHandler moHandler;
            NalNameValue[] nalNameValueArray;
            ArrayList<NalNameValue> arrayList = new ArrayList<NalNameValue>();
            ArrayList<NalNameValue> arrayList2 = new ArrayList<NalNameValue>();
            ArrayList<NalNameValue> arrayList3 = new ArrayList<NalNameValue>();
            if (this.numHsCodeResourcesCP.getAccessLevel() != 1 && this.numHsCodeResourcesCP.hasValueChanged()) {
                nalNameValueArray = new Integer(this.numHsCodeResourcesCP.getValue());
                arrayList.add(Nal.getFactory().getNameValue("numHsCodeResources", nalNameValueArray));
            }
            if (this.numEulResourcesCP.getAccessLevel() != 1 && this.numEulResourcesCP.hasValueChanged()) {
                nalNameValueArray = new Integer(this.numEulResourcesCP.getValue());
                arrayList.add(Nal.getFactory().getNameValue("numEulResources", nalNameValueArray));
            }
            if (this.numHsCodeResources1stBBPCP.getAccessLevel() != 1 && this.numHsCodeResources1stBBPCP.hasValueChanged()) {
                nalNameValueArray = new Integer(this.numHsCodeResources1stBBPCP.getValue());
                arrayList2.add(Nal.getFactory().getNameValue("numHsCodeResources", nalNameValueArray));
            }
            if (this.numHsCodeResources2ndBBPCP.getAccessLevel() != 1 && this.numHsCodeResources2ndBBPCP.hasValueChanged()) {
                nalNameValueArray = new Integer(this.numHsCodeResources2ndBBPCP.getValue());
                arrayList3.add(Nal.getFactory().getNameValue("numHsCodeResources", nalNameValueArray));
            }
            if (arrayList.size() > 0) {
                nalNameValueArray = arrayList.toArray(new NalNameValue[0]);
                moHandler = this.getRbs().getMoHandler();
                try {
                    if (moHandler.isExisting(this.txDeviceGroupMoProxy)) {
                        moHandler.setAttributes(this.txDeviceGroupMoProxy, nalNameValueArray);
                    }
                }
                catch (MoHandlerException moHandlerException) {
                    String string2 = moHandlerException.getAction();
                    String string3 = moHandlerException.getLdn();
                    String string4 = moHandlerException.getAdditionalInfo();
                    throw new BemException(string2, "HspaSettingsRI install()", string3, string4, moHandlerException);
                }
            }
            if (arrayList2.size() > 0) {
                nalNameValueArray = arrayList2.toArray(new NalNameValue[0]);
                moHandler = this.getRbs().getMoHandler();
                try {
                    if (moHandler.isExisting(this.downlink1stBBPMo)) {
                        moHandler.setAttributes(this.downlink1stBBPMo, nalNameValueArray);
                    }
                }
                catch (MoHandlerException moHandlerException) {
                    String string5 = moHandlerException.getAction();
                    String string6 = moHandlerException.getLdn();
                    String string7 = moHandlerException.getAdditionalInfo();
                    throw new BemException(string5, "HspaSettingsRI install()", string6, string7, moHandlerException);
                }
            }
            if (arrayList3.size() > 0) {
                nalNameValueArray = arrayList3.toArray(new NalNameValue[0]);
                moHandler = this.getRbs().getMoHandler();
                try {
                    if (moHandler.isExisting(this.downlink2ndBBPMo)) {
                        moHandler.setAttributes(this.downlink2ndBBPMo, nalNameValueArray);
                    }
                }
                catch (MoHandlerException moHandlerException) {
                    String string8 = moHandlerException.getAction();
                    String string9 = moHandlerException.getLdn();
                    String string10 = moHandlerException.getAdditionalInfo();
                    throw new BemException(string8, "HspaSettingsRI install()", string9, string10, moHandlerException);
                }
            }
        }
    }

    private int getNumEulResourcesFromRbs() throws BemException {
        Integer n;
        Integer n2 = MimTxDeviceGroup.DEFAULT_NUMEULRESOURCES;
        if (super.isExisting(this.txDeviceGroupMoProxy) && (n = (Integer)super.getAttribute(this.txDeviceGroupMoProxy, "numEulResources")) != null) {
            n2 = n;
        }
        return n2;
    }

    private int getNumHsCodeResourcesFromRbs() throws BemException {
        Integer n;
        Integer n2 = MimTxDeviceGroup.DEFAULT_NUMHSCODERESOURCES;
        if (super.isExisting(this.txDeviceGroupMoProxy) && (n = (Integer)super.getAttribute(this.txDeviceGroupMoProxy, "numHsCodeResources")) != null) {
            n2 = n;
        }
        return n2;
    }

    private int getNumHsCodeResources1stBBPFromRbs() throws BemException {
        Integer n;
        Integer n2 = MimDownlinkBaseBandPool.DEFAULT_NUMHSCODERESOURCES;
        if (super.isExisting(this.downlink1stBBPMo) && (n = (Integer)super.getAttribute(this.downlink1stBBPMo, "numHsCodeResources")) != null) {
            n2 = n;
        }
        return n2;
    }

    private int getNumHsCodeResources2ndBBPFromRbs() throws BemException {
        Integer n;
        Integer n2 = MimDownlinkBaseBandPool.DEFAULT_NUMHSCODERESOURCES;
        if (super.isExisting(this.downlink2ndBBPMo) && (n = (Integer)super.getAttribute(this.downlink2ndBBPMo, "numHsCodeResources")) != null) {
            n2 = n;
        }
        return n2;
    }

    private int getStaticNumEulResourcesFromRbs() throws BemException {
        Integer n;
        Integer n2 = MimTxDeviceGroup.MIN_STATICNUMEULRESOURCES;
        if (super.isExisting(this.txDeviceGroupMoProxy) && (n = (Integer)super.getAttribute(this.txDeviceGroupMoProxy, "staticNumEulResources")) != null) {
            n2 = n;
        }
        return n2;
    }

    private int getStaticNumHsCodeResourcesFromRbs() throws BemException {
        Integer n;
        Integer n2 = MimTxDeviceGroup.MIN_STATICNUMHSCODERESOURCES;
        if (super.isExisting(this.txDeviceGroupMoProxy) && (n = (Integer)super.getAttribute(this.txDeviceGroupMoProxy, "staticNumHsCodeResources")) != null) {
            n2 = n;
        }
        return n2;
    }

    void updateLoadedValue() throws BemException {
        int n = this.getNumEulResourcesFromRbs();
        int n2 = this.getNumHsCodeResourcesFromRbs();
        int n3 = this.getNumHsCodeResources1stBBPFromRbs();
        int n4 = this.getNumHsCodeResources2ndBBPFromRbs();
        int n5 = this.getStaticNumEulResourcesFromRbs();
        int n6 = this.getStaticNumHsCodeResourcesFromRbs();
        String string = "" + n;
        CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.numEulResourcesCP;
        customerParameterImpl.setLoadedValue(string);
        string = "" + n2;
        customerParameterImpl = (CustomerParameterImpl)this.numHsCodeResourcesCP;
        customerParameterImpl.setLoadedValue(string);
        string = "" + n3;
        customerParameterImpl = (CustomerParameterImpl)this.numHsCodeResources1stBBPCP;
        customerParameterImpl.setLoadedValue(string);
        string = "" + n4;
        customerParameterImpl = (CustomerParameterImpl)this.numHsCodeResources2ndBBPCP;
        customerParameterImpl.setLoadedValue(string);
        string = "" + n5;
        customerParameterImpl = (CustomerParameterImpl)this.staticNumEulResourcesCP;
        customerParameterImpl.setLoadedValue(string);
        string = "" + n6;
        customerParameterImpl = (CustomerParameterImpl)this.staticNumHsCodeResourcesCP;
        customerParameterImpl.setLoadedValue(string);
    }

    public String getLdn() {
        String string = this.txDeviceGroupMoProxy.getDN();
        return string;
    }

    public String getDisplayName() {
        return name + ": " + this.getLdn();
    }

    public boolean isInstalled() throws BemException {
        return false;
    }

    private BemMo getTxDeviceGroupBemMo(String string) {
        BemMo bemMo = null;
        String string2 = string + ",PiuDevice=2,TxDeviceGroup=1";
        bemMo = super.getRbs().getMoHandler().getMo(string2);
        return bemMo;
    }

    private BemMo getDownlinkBasebandPoolBemMo(String string) {
        BemMo bemMo = null;
        bemMo = super.getRbs().getMoHandler().getMo(string);
        return bemMo;
    }
}

