/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.CsasrClusterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbMetaDataManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbStaticMetaData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class ChangeRbbHandler
extends ModifyHandler {
    private final String[] ALL_MODIFIABLE_SCPM_ATTRIBUTES = new String[]{"radioBuildingBlock", "cpriLineRate", "primaryPortId", "secondaryPortId", "auUnitType", "radioSharedBySector", "mixedModeRadio"};

    public ChangeRbbHandler(ModifyManager modifyManager) {
        super(modifyManager);
    }

    public ChangeRbbHandler(ModifyManager modifyManager, int n) {
        super(modifyManager, n);
    }

    public List getAllCpPseudoNames() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public void updateScpmIfAppropriate(SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            RbbStaticMetaData rbbStaticMetaData;
            if (!this.isSectorModified(i)) continue;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            String string = sectorCustomerParameterManager.getRbbNameForSector(n);
            String string2 = sectorCustomerParameterManager.getAuUnitTypeForSector(n);
            if (string == null || "".equals(string)) continue;
            if (!string.equals("RBB22_2E") && !AbstractRbb.rbbForRadioShare.contains(string)) {
                sectorCustomerParameterManager.clearRadioSharedBySectorValue(n);
            }
            if ((rbbStaticMetaData = RbbMetaDataManager.getRbbMetaDataManager().getStaticMetaData(RbbHandler.getKeyForStaticDataMap(string, string2))).getNumberOfCpriLinks() != 1) continue;
            sectorCustomerParameterManager.clearSecondaryPortIdValue(n);
        }
    }

    public void doModification() throws BemException {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (this.isRadioPositionAffected(i) || this.isSectorModified(i)) {
                this.requestResetSector(i);
            }
            if (this.isRadioPositionAffected(i)) {
                this.getRbs().setPositionFlag(true);
            }
            this.checkIfSectorIsDowngradedAfterModification(i);
        }
    }

    private boolean isSectorModified(int n) throws BemException {
        ServiceValue serviceValue = this.getModifyManager().getServiceValue();
        boolean bl = false;
        if (serviceValue != null) {
            Vector vector = this.getModifyManager().getServiceValue().getValues("ModifySector");
            int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
            String string = MessageFormat.format("S{0}_", new Integer(n2));
            CustomerParameter customerParameter = this.getRbs().getCustomerParameterObject(string + "needRuPositionAllocation");
            AbstractRbb abstractRbb = this.getLoadedRbb(n);
            bl = this.anyScpmAttributeRequestedForModify(n, vector) && this.anyScpmAttributeModified(n2) || null != abstractRbb && null != customerParameter && customerParameter.hasValueChanged();
        }
        return bl;
    }

    public void checkConsistency() throws BemException {
        ServiceValue serviceValue = this.getModifyManager().getServiceValue();
        Vector vector = serviceValue.getValues("ModifySector");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!ModifyUtil.isScpmAttributeInNameValueVector(vector, i, "radioBuildingBlock", this.startingSectorNumber)) continue;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            this.verifyLoadAndDeleteStatus(n);
            if (this.isAnyAttributeThatNeedsToBeLastInCascadeChainModified(n)) {
                this.verifyThatSectorIsLastInCpriLink(n);
            }
            arrayList.add(n + "");
        }
        RbbManager rbbManager = this.getModifyManager().getRbbManager();
        CsasrClusterManager.modifyOneCluster(vector, rbbManager, arrayList);
        this.checkMigrationPath();
    }

    private void checkMigrationPath() throws BemException {
        MigrationPath migrationPath = new MigrationPath();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            AbstractRbb abstractRbb = this.getLoadedRbb(i);
            if (abstractRbb == null) continue;
            String string = abstractRbb.getName();
            String string2 = this.getScpm().getRbbNameForSector(n);
            if (!migrationPath.judgeMigrationToRbb(string2) || migrationPath.isSupportedPath(string, string2)) continue;
            throw new BemException("BEM can not support modify RadioBuildiingBlock from " + string + " to " + string2);
        }
    }

    public HashMap getRIsToUninstall() throws BemException {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!this.isSectorModified(i) && !this.isRadioPositionAffected(i)) continue;
            AbstractRbb abstractRbb = this.getLoadedRbb(i);
            List list = abstractRbb.getLoadedResourceItems();
            hashMap.putAll(ModifyManager.RIListToHashMap(list));
            if (!abstractRbb.getAuUnitType().equals("IRU")) continue;
            AbstractAntennaSystemCI abstractAntennaSystemCI = this.getModifyManager().getAntennaSystemCI();
            if (abstractAntennaSystemCI.isOpen()) {
                hashMap.putAll(ModifyManager.RIListToHashMap(abstractAntennaSystemCI.getRadioDotRI(i)));
                hashMap.putAll(ModifyManager.RIListToHashMap(abstractAntennaSystemCI.getRdiCableRI(i)));
                continue;
            }
            throw new BemException("Raido Dot could not be deleted according to RBB change since AntennaSystemCI is not open.");
        }
        return hashMap;
    }

    private boolean anySectorAffectsPositions() {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            AbstractRbb abstractRbb = this.getRbb(i);
            AbstractRbb abstractRbb2 = this.getLoadedRbb(i);
            if (abstractRbb == null || abstractRbb2 == null || !abstractRbb.needRuPositionAllocation() || abstractRbb2.getNumOfRus() == abstractRbb.getNumOfRus()) continue;
            return true;
        }
        return false;
    }

    private boolean isRadioPositionAffected(int n) throws BemException {
        AbstractRbb abstractRbb = this.getLoadedRbb(n);
        return this.anySectorAffectsPositions() && this.isSectorExisting(n) && abstractRbb != null && abstractRbb.needRuPositionAllocation();
    }

    private void checkIfSectorIsDowngradedAfterModification(int n) {
        int n2;
        int n3;
        AbstractRbb abstractRbb = this.getRbb(n);
        AbstractRbb abstractRbb2 = this.getLoadedRbb(n);
        if (abstractRbb != null && abstractRbb2 != null && (n3 = abstractRbb.getNumberOfRxBranchesPerAntenna().length) < (n2 = abstractRbb2.getNumberOfRxBranchesPerAntenna().length)) {
            this.getModifyManager().setDowngradedSector(n);
        }
    }

    private boolean anyScpmAttributeRequestedForModify(int n, Vector vector) {
        boolean bl = false;
        for (int i = 0; i < this.ALL_MODIFIABLE_SCPM_ATTRIBUTES.length; ++i) {
            if (!ModifyUtil.isScpmAttributeInNameValueVector(vector, n, this.ALL_MODIFIABLE_SCPM_ATTRIBUTES[i], this.startingSectorNumber)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean isAnyAttributeThatNotNeedsToBeLastInCascadeChainModified(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.getLoadedRbb(n2) == null ? "" : this.getLoadedRbb(n2).getLineRate();
        String string2 = this.getScpm().getLineRateForSector(n);
        return !string.equals(string2);
    }

    private boolean isAnyAttributeThatNeedsToBeLastInCascadeChainModified(int n) throws BemException {
        String string;
        String string2;
        boolean bl;
        boolean bl2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        boolean bl3 = false;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        AbstractRbb abstractRbb = this.getLoadedRbb(n2);
        String string8 = abstractRbb.getName();
        if (!string8.equals(string7 = this.getScpm().getRbbNameForSector(n))) {
            bl3 = true;
        }
        if (!(string6 = abstractRbb.getPrimaryPortId()).equals(string5 = this.getScpm().getPrimaryPortIdForSector(n))) {
            bl3 = true;
        }
        String string9 = abstractRbb.getSecondaryPortId();
        String string10 = this.getScpm().getSecondaryPortIdForSector(n);
        if (string9 != null && string10 != null && !string9.equals(string10)) {
            bl3 = true;
        } else if (string9 == null && string10 != null) {
            bl3 = true;
        } else if (string9 != null && string10 == null) {
            bl3 = true;
        }
        String string11 = abstractRbb.getAuUnitType();
        String string12 = this.getScpm().getAuUnitTypeForSector(n);
        if (!string11.equals(string12)) {
            bl3 = true;
        }
        if (!(string4 = abstractRbb.getRadioSharedBySector()).equals(string3 = this.getScpm().getRadioSharedBySectorForSector(n))) {
            bl3 = true;
        }
        if ((bl2 = this.getRadioCI().getLoadedMixedModeRadioForSector(n)) != (bl = this.getRadioCI().getMixedModeRadioForSector(n))) {
            bl3 = true;
        }
        if (!(string2 = abstractRbb.getCabinetNumber()).equals(string = this.getScpm().getCabinetNumberForSector(n))) {
            bl3 = true;
        }
        return bl3;
    }

    private boolean anyScpmAttributeModified(int n) throws BemException {
        return this.isAnyAttributeThatNotNeedsToBeLastInCascadeChainModified(n) || this.isAnyAttributeThatNeedsToBeLastInCascadeChainModified(n);
    }

    private void verifyThatSectorIsLastInCpriLink(int n) throws BemException {
        int[][] nArray = this.getModifyManager().getRbbManager().getEquippedSectorsCpriLinks();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        block0: for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            int n2 = nArray2.length;
            for (int j = 0; j < n2; ++j) {
                int n3 = nArray2[j];
                if (n3 != n) continue;
                if (j >= n2 - 1) continue block0;
                throw new BemException("The sector number=" + n + " can not be modified because it is not last in its sector cascade chain");
            }
        }
    }

    private void verifyLoadAndDeleteStatus(int n) throws BemException {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        if (!this.isSectorExisting(n2)) {
            throw new BemException("Sector number " + n + " does not exist, and can therefore not be changed." + "\nConsider use of add sector.");
        }
        if (this.getModifyManager().getDeleteHandler().isSectorDeleteRequested(n2)) {
            throw new BemException("Sector number " + n + " is delete requested, and can therefore not be changed." + "\nConsider use of add sector.");
        }
    }

    static class MigrationPairedRbb {
        private String fromRbb;
        private String toRbb;

        public MigrationPairedRbb(String string, String string2) {
            this.fromRbb = string;
            this.toRbb = string2;
        }

        public String getFromRbb() {
            return this.fromRbb;
        }

        public String getToRbb() {
            return this.toRbb;
        }
    }

    static class MigrationPath {
        private List migrationPath = new ArrayList();
        private String[] migrationToRbb;

        public MigrationPath() {
            this.initialization();
        }

        private void initialization() {
            this.migrationPath.add(new MigrationPairedRbb("RBB12_1A", "RBB14_2A"));
            this.migrationPath.add(new MigrationPairedRbb("RBB22_1B", "RBB24_2B"));
            this.migrationToRbb = new String[]{"RBB14_2A", "RBB24_2B"};
        }

        public boolean isSupportedPath(String string, String string2) {
            boolean bl = false;
            if (string.equalsIgnoreCase(string2)) {
                return true;
            }
            Iterator iterator = this.migrationPath.iterator();
            while (iterator.hasNext()) {
                MigrationPairedRbb migrationPairedRbb = (MigrationPairedRbb)iterator.next();
                if (!string.equalsIgnoreCase(migrationPairedRbb.getFromRbb()) || !string2.equalsIgnoreCase(migrationPairedRbb.getToRbb())) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public boolean judgeMigrationToRbb(String string) {
            boolean bl = false;
            for (int i = 0; i < this.migrationToRbb.length; ++i) {
                if (!string.equalsIgnoreCase(this.migrationToRbb[i])) continue;
                bl = true;
                break;
            }
            return bl;
        }
    }
}

