/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.EcBusRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.CsasrClusterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.IruRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParametersUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class DeleteSectorHandler
extends ModifyHandler {
    private Enumeration[] deleteSectorCustParams;
    private String[] deleteSectorCustParamNames;

    public DeleteSectorHandler(ModifyManager modifyManager) {
        super(modifyManager);
    }

    public DeleteSectorHandler(ModifyManager modifyManager, int n) {
        super(modifyManager, n);
        this.setupCustomerParameterNames();
        this.createCustomerParameters();
    }

    public List getAllCpPseudoNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            arrayList.add(this.deleteSectorCustParamNames[i]);
        }
        return arrayList;
    }

    private void setupCustomerParameterNames() {
        this.deleteSectorCustParamNames = new String[this.getMaxNoOfSectors()];
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            String string;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            String string2 = MessageFormat.format("S{0}_", new Integer(n));
            this.deleteSectorCustParamNames[i] = string = string2 + "deleteSector";
        }
    }

    private void createCustomerParameters() {
        this.deleteSectorCustParams = new Enumeration[this.getMaxNoOfSectors()];
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            String string = this.deleteSectorCustParamNames[i];
            Enumeration enumeration = new Enumeration(string, SectorCustomerParametersUtil.getFullSectorSequenceRange());
            enumeration.setLoadedValue("");
            this.deleteSectorCustParams[i] = enumeration;
            this.getModifyManager().getRadioCI().addParameter(enumeration);
        }
    }

    public boolean isSectorDeleteRequested(int n) throws BemException {
        String string = this.deleteSectorCustParams[n].getValue();
        return !string.equals("") && this.isSectorExisting(n);
    }

    public void checkConsistency() throws BemException {
        if (this.anyDeleteRequested()) {
            ArrayList arrayList = this.checkAllConsistencyAndGetDeleteSectorList();
            RbbManager rbbManager = this.getModifyManager().getRbbManager();
            CsasrClusterManager.deleteOneCluster(rbbManager, arrayList);
        }
    }

    private ArrayList checkAllConsistencyAndGetDeleteSectorList() throws BemException {
        int n = 0;
        if (this.getRbs().isPantherHybridRbs() && this.startingSectorNumber == 7) {
            n = 1;
        }
        CellAndCarrierProvider cellAndCarrierProvider = this.getRbs().getCellAndCarrierProvider(n);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!this.isSectorDeleteRequested(i)) continue;
            arrayList.add(this.deleteSectorCustParams[i].getValue());
            this.verifyThatCellsAreOffLine(SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber), cellAndCarrierProvider);
        }
        return arrayList;
    }

    private boolean anyDeleteRequested() throws BemException {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!this.isSectorDeleteRequested(i)) continue;
            return true;
        }
        return false;
    }

    public void updateScpmIfAppropriate(SectorCustomerParameterManager sectorCustomerParameterManager) throws BemException {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!this.isSectorDeleteRequested(i)) continue;
            sectorCustomerParameterManager.clearSectorDependentCPs(SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber));
        }
    }

    public void doModification() throws BemException {
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (!this.isRadioPositionAffected(i) && !this.auxPositionAffected(i)) continue;
            this.requestResetSector(i);
            this.getRbs().setPositionFlag(true);
        }
    }

    private boolean isRadioPositionAffected(int n) throws BemException {
        AbstractRbb abstractRbb = this.getLoadedRbb(n);
        return this.anyDeleteRequested() && this.isSectorExisting(n) && abstractRbb != null && abstractRbb.needRuPositionAllocation();
    }

    private void verifyThatCellsAreOffLine(int n, CellAndCarrierProvider cellAndCarrierProvider) throws BemException {
        boolean bl = cellAndCarrierProvider.areCellsOffline(n);
        if (!bl) {
            String string = "Not possible to delete sector " + n + ". " + "All cells in sector must be offline.";
            throw new BemException(string);
        }
    }

    private boolean ruwPositionAffected(int n, int n2) throws BemException {
        if (this.isSectorDeleteRequested(n)) {
            return true;
        }
        boolean bl = false;
        RbbManager rbbManager = this.getModifyManager().getRbbManager();
        AbstractRbb abstractRbb = this.getLoadedRbb(n);
        if (abstractRbb != null && abstractRbb.needRuPositionAllocation()) {
            int n3;
            if (this.auxPositionAffected(n)) {
                return true;
            }
            int[] nArray = rbbManager.getExistingSectorsWithRuw();
            int n4 = rbbManager.getExistingSectorsWithRuw().length;
            int[] nArray2 = rbbManager.getRuPositionBySectors(n2, true);
            int[] nArray3 = rbbManager.getRuPositionBySectors(n4, true);
            int n5 = 0;
            for (n3 = 0; n3 < n; ++n3) {
                if (this.getLoadedRbb(n3) != null && this.getLoadedRbb(n3).needRuPositionAllocation()) continue;
                ++n5;
            }
            Arrays.sort(nArray);
            for (n3 = 0; n3 < nArray.length && nArray[n3] - this.startingSectorNumber != n; ++n3) {
            }
            int n6 = nArray2[n - n5];
            int n7 = nArray3[n3];
            if (n6 != n7) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean auxPositionAffected(int n) throws BemException {
        AbstractRbb abstractRbb = this.getLoadedRbb(n);
        if (abstractRbb != null && abstractRbb.needRuPositionAllocation()) {
            for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
                String string;
                AbstractRbb abstractRbb2 = this.getLoadedRbb(i);
                if (null == abstractRbb2) continue;
                Rbs rbs = abstractRbb.getDynamicMetaData().getRbs();
                CustomerParameter customerParameter = rbs.getCustomerParameterObject((string = MessageFormat.format("S{0}_", new Integer(i + 1))) + "needRuPositionAllocation");
                if (null == customerParameter || !customerParameter.hasValueChanged()) continue;
                return true;
            }
        }
        return false;
    }

    private int getNumOfSectorsBeforeDelete() throws BemException {
        int n = 0;
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            AbstractRbb abstractRbb = this.getLoadedRbb(i);
            if (!this.isSectorDeleteRequested(i) || null == abstractRbb || !abstractRbb.needRuPositionAllocation()) continue;
            ++n;
        }
        return this.getModifyManager().getRbbManager().getExistingSectorsWithRuw().length + n;
    }

    public HashMap getRIsToUninstall() throws BemException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = this.getNumOfSectorsBeforeDelete();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            Object object;
            if (this.ruwPositionAffected(i, n)) {
                object = this.getLoadedRbb(i);
                boolean bl = false;
                if (((AbstractRbb)object).supportsRadioSharedBy()) {
                    bl = this.isRadioRiForDualSectorNeedToBeKeeped(i, (AbstractRbb)object);
                }
                if (!bl) {
                    List list = ((AbstractRbb)object).getLoadedResourceItems();
                    hashMap.putAll(ModifyManager.RIListToHashMap(list));
                    if (((AbstractRbb)object).getAuUnitType().equals("IRU")) {
                        AbstractAntennaSystemCI abstractAntennaSystemCI = this.getModifyManager().getAntennaSystemCI();
                        if (abstractAntennaSystemCI.isOpen()) {
                            hashMap.putAll(ModifyManager.RIListToHashMap(abstractAntennaSystemCI.getRadioDotRI(i)));
                            hashMap.putAll(ModifyManager.RIListToHashMap(abstractAntennaSystemCI.getRdiCableRI(i)));
                        } else {
                            throw new BemException("Raido Dot could not be deleted when sector is deleted since AntennaSystemCI is not open.");
                        }
                    }
                    for (int j = 0; j < list.size(); ++j) {
                        Object e = list.get(j);
                        if (!(e instanceof IruRI)) continue;
                        IruRI iruRI = (IruRI)e;
                        String string = iruRI.getAuxPiuLdn();
                        try {
                            BemMo[] bemMoArray = (BemMo[])this.getRbs().getMoHandler().getAttribute(this.getRbs().getMoHandler().getMo(string), "reservedBy");
                            for (int k = 0; k < bemMoArray.length; ++k) {
                                if (!bemMoArray[k].getType().equals(MimEcBus.MOTYPENAME)) continue;
                                EcBusRI ecBusRI = new EcBusRI(this.getRbs(), Integer.parseInt(bemMoArray[k].getId()), "EC");
                                hashMap.put(ecBusRI.getLdn(), ecBusRI);
                            }
                            continue;
                        }
                        catch (MoHandlerException moHandlerException) {
                            moHandlerException.printStackTrace();
                        }
                    }
                }
            }
            if (!this.isSectorDeleteRequested(i)) continue;
            object = this.getSectorRI(i);
            hashMap.put(((SectorRI)object).getLdn(), object);
        }
        return hashMap;
    }

    private boolean isRadioRiForDualSectorNeedToBeKeeped(int n, AbstractRbb abstractRbb) throws BemException {
        boolean bl = false;
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            if (i == n) continue;
            AbstractRbb abstractRbb2 = this.getLoadedRbb(i);
            AbstractRuRI abstractRuRI = abstractRbb.getRadioUnitResourceItems()[0];
            if (this.isSectorDeleteRequested(i)) {
                if (!((Object)abstractRuRI).equals(abstractRbb2.getRadioUnitResourceItems()[0]) || n >= i) continue;
                bl = true;
                break;
            }
            if (abstractRbb2 == null || !((Object)abstractRuRI).equals(abstractRbb2.getRadioUnitResourceItems()[0])) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

