/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FreeConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class RB8
extends AbstractRadioBuildingBlock {
    public static final String name = "RB8";
    private static final int NOT_USED = -1;
    private static final int NO_OF_CARRIERS = 3;
    private static final int NO_OF_RUS = 2;
    private static final int NO_OF_TX_BRANCHES = 2;
    private Rbs rbs;
    private List ris = new ArrayList();
    private DigitalCableRI digitalCable1 = null;
    private DigitalCableRI digitalCable2 = null;
    private DigitalCableRI digitalCable3 = null;
    private RfCableRI txRfCable1 = null;
    private RfCableRI rxARfCable1 = null;
    private RfCableRI rxBRfCable1 = null;
    private RfCableRI txRfCable2 = null;
    private RfCableRI rxARfCable2 = null;
    private RfCableRI rxBRfCable2 = null;
    private FuRI fu1 = null;
    private RuRI ru1 = null;
    private FuRI fu2 = null;
    private RuRI ru2 = null;
    private RadioInterfaceBoard ruif1 = null;
    private RadioInterfaceBoard ruif2 = null;
    private int[][] carriersInBaseBandPool = new int[][]{{1}, {2, 3}};
    private int dcElectricalDelay;
    private int rfElectricalUlDelay;
    private int rfElectricalDlDelay;
    private int rfUlAttenuation;
    private int rfDlAttenuation;
    List freeConnectors;
    ReservedConnectorRI[][] reservedConnectors;

    public RB8(Rbs rbs, int n, FuRI fuRI, FuRI fuRI2, RuRI ruRI, RuRI ruRI2, RadioInterfaceBoard radioInterfaceBoard, RadioInterfaceBoard radioInterfaceBoard2, int n2, int n3, int n4, int n5, int n6) throws BemException {
        super(name, n, 3, 2, 2, new RadioInterfaceBoard[]{radioInterfaceBoard, radioInterfaceBoard2});
        this.rbs = rbs;
        this.ru1 = ruRI;
        this.ru2 = ruRI2;
        this.fu1 = fuRI;
        this.fu2 = fuRI2;
        this.ruif1 = radioInterfaceBoard;
        this.ruif2 = radioInterfaceBoard2;
        this.dcElectricalDelay = n2;
        this.rfElectricalUlDelay = n3;
        this.rfElectricalDlDelay = n4;
        this.rfUlAttenuation = n5;
        this.rfDlAttenuation = n6;
        this.createResourceItems();
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        ReservedConnectorRI[][] reservedConnectorRIArrayArray = new ReservedConnectorRI[][]{{reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}, {reservedConnectorRI6, reservedConnectorRI5}, {reservedConnectorRI4, reservedConnectorRI3}, {reservedConnectorRI2, reservedConnectorRI}};
        this.reservedConnectors = reservedConnectorRIArrayArray;
    }

    private void createResourceItems() throws BemException {
        this.ris.add(this.ru1);
        this.ris.add(this.ru2);
        this.ris.add(this.fu1);
        this.ris.add(this.fu2);
        this.freeConnectors = new ArrayList();
        String string = this.ru1.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 2, MimDigitalCable.MOTYPENAME, "objectBConnector"));
        String string2 = this.fu1.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string2, 9, MimRfCable.MOTYPENAME, "objectAConnector"));
        String string3 = this.fu2.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string3, 9, MimRfCable.MOTYPENAME, "objectAConnector"));
        this.digitalCable1 = new DigitalCableRI(this.rbs, this.ruif1.getLdn(), this.getDigitalCableConnectorA(1), this.ru1.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable1);
        this.txRfCable1 = new RfCableRI(this.rbs, this.ru1.getLdn(), 11, this.fu1.getLdn(), 17, -1, this.rfElectricalDlDelay, -1, this.rfDlAttenuation);
        this.ris.add(this.txRfCable1);
        this.rxARfCable1 = new RfCableRI(this.rbs, this.fu1.getLdn(), 6, this.ru1.getLdn(), 3, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxARfCable1);
        this.rxBRfCable1 = new RfCableRI(this.rbs, this.fu2.getLdn(), 8, this.ru1.getLdn(), 4, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxBRfCable1);
        this.digitalCable2 = new DigitalCableRI(this.rbs, this.ruif2.getLdn(), this.getDigitalCableConnectorA(1), this.ru2.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable2);
        this.digitalCable3 = new DigitalCableRI(this.rbs, this.ruif2.getLdn(), this.getDigitalCableConnectorA(2), this.ru2.getLdn(), 2, this.dcElectricalDelay);
        this.ris.add(this.digitalCable3);
        this.txRfCable2 = new RfCableRI(this.rbs, this.ru2.getLdn(), 11, this.fu2.getLdn(), 17, -1, this.rfElectricalDlDelay, -1, this.rfDlAttenuation);
        this.ris.add(this.txRfCable2);
        this.rxARfCable2 = new RfCableRI(this.rbs, this.fu2.getLdn(), 6, this.ru2.getLdn(), 3, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxARfCable2);
        this.rxBRfCable2 = new RfCableRI(this.rbs, this.fu1.getLdn(), 8, this.ru2.getLdn(), 4, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxBRfCable2);
    }

    public List getResourceItems() throws BemException {
        this.fu1.setSecondAiLocked(false);
        this.fu2.setSecondAiLocked(false);
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.ru1);
        arrayList.add(this.ru2);
        arrayList.add(this.fu1);
        arrayList.add(this.fu2);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][0]);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1][1]);
        return arrayList;
    }

    private int getDigitalCableConnectorA(int n) throws BemException {
        int n2 = 0;
        int n3 = this.getSectorNo();
        int[][] nArrayArray = new int[][]{{6, 5}, {4, 3}, {2, 1}, {6, 5}, {4, 3}, {2, 1}};
        n2 = nArrayArray[n3 - 1][n - 1];
        return n2;
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (!string.equalsIgnoreCase("A") && !string.equalsIgnoreCase("B")) {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        n = new Integer(1);
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        String string2 = null;
        if (string.equalsIgnoreCase("A")) {
            string2 = this.fu1.getAuxPiuLdn();
        } else if (string.equalsIgnoreCase("B")) {
            string2 = this.fu2.getAuxPiuLdn();
        } else {
            throw new BemException(this.getClass().getName() + " getFuReference(): Antenna branch " + string + " not supported");
        }
        return string2;
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getRxACableAttributes(n);
        this.rxARfCable1.setAttributes(nalNameValueArray);
        this.rxARfCable2.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getRxBCableAttributes(n);
        this.rxBRfCable1.setAttributes(nalNameValueArray);
        this.rxBRfCable2.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getTxCableAttributes(n);
        this.txRfCable1.setAttributes(nalNameValueArray);
        this.txRfCable2.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getData1CableAttributes(n);
        this.digitalCable1.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getData2CableAttributes(n);
        this.digitalCable2.setAttributes(nalNameValueArray);
        this.digitalCable3.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 3;
    }

    public boolean isDualRadioInterfaceBoardNeeded() {
        return true;
    }

    public boolean isEulInTwoBaseBandPoolsSupported() {
        return true;
    }

    public int[] getCarriersInBasebandPool(int n) {
        return this.carriersInBaseBandPool[n];
    }

    public List getAtfRoleMapping() {
        ArrayList<RadioBuildingBlock.SlotToBBPools> arrayList = new ArrayList<RadioBuildingBlock.SlotToBBPools>();
        arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru1.getSlotNumber(), new int[]{0}));
        arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru2.getSlotNumber(), new int[]{1}));
        return arrayList;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1};
    }
}

