/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.custparam;

import java.util.StringTokenizer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.java14.Java14String;

public class FQDNRange
implements ParameterRange {
    private final Integer min;
    private final Integer max;

    public FQDNRange(Integer n, Integer n2) {
        this.min = n;
        this.max = n2;
    }

    public boolean equals(ParameterRange parameterRange) {
        return parameterRange instanceof FQDNRange;
    }

    public String getDescription() {
        return "FQDN Range permits [A to Z], [a to z], [0 to 9], the dot (.) and the hyphen (-). IPv4 Address Range [0.0.0.0 - 255.255.255.255].IPv6 Address Range [0000 - FFFF::0000 - FFFF].";
    }

    public boolean isValueInRange(Object object) {
        int n;
        String string = (String)object;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < string.length() && !bl; ++n) {
            bl = Character.isLetter(string.charAt(n));
        }
        for (n = 0; n < string.length() && !bl2; ++n) {
            bl2 = string.charAt(n) == ':';
        }
        if (!bl && !bl2) {
            return this.isValidIPV4Address(object);
        }
        if (bl2) {
            return this.isValidIPV6Address(object);
        }
        return this.isValidDomainName(object);
    }

    public boolean isValidIPV4Address(Object object) {
        String string = (String)object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        if (stringTokenizer.countTokens() == 7 && this.isValidIpPart(stringTokenizer.nextToken())) {
            stringTokenizer.nextToken();
            if (this.isValidIpPart(stringTokenizer.nextToken())) {
                stringTokenizer.nextToken();
                if (this.isValidIpPart(stringTokenizer.nextToken())) {
                    stringTokenizer.nextToken();
                    if (this.isValidIpPart(stringTokenizer.nextToken())) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isValidIPV6Address(Object object) {
        String string = (String)object;
        String[] stringArray = Java14String.split(string, ":");
        int n = 0;
        if (stringArray.length > 8 || stringArray.length < 1 && !string.equals("::")) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) {
                ++n;
                continue;
            }
            if (this.isValidIpV6Part(stringArray[i])) continue;
            return false;
        }
        if (n > 2) {
            return false;
        }
        if (!(n != 2 || stringArray[0].equals("") && stringArray[1].equals(""))) {
            return false;
        }
        return n != 0 || stringArray.length == 8 || string.endsWith("::");
    }

    private boolean isValidIpPart(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n >= 0 && n <= 255;
    }

    private boolean isValidIpV6Part(String string) {
        if (string.length() <= 0 || string.length() > 4) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public boolean isValidDomainName(Object object) {
        String string = (String)object;
        int n = 0;
        boolean bl = false;
        for (n = 0; n < string.length() && !bl; ++n) {
            bl = Character.isLetter(string.charAt(n));
        }
        if (!bl) {
            return false;
        }
        if (string.length() < this.min || string.length() > this.max) {
            return false;
        }
        if (string.charAt(string.length() - 1) != '.' && string.length() > 253) {
            return false;
        }
        for (n = 0; n < string.length(); ++n) {
            char c = string.charAt(n);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '.' || c == '-' && n != string.length() - 1) continue;
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.length() >= 1 && string2.length() <= 63) continue;
            return false;
        }
        return true;
    }

    public ParameterRange copyAndRetainRange(ParameterRange parameterRange) {
        return new FQDNRange(this.min, this.max);
    }

    public ParameterRange copyAndRemove(ParameterRange parameterRange) {
        return new FQDNRange(this.min, this.max);
    }
}

