/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.custparam;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestricter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.RestrictionChangedListener;

public class ParameterRestriction
implements ParameterRestricter {
    private ParameterRange restrictedRange = null;
    private boolean isRangeRestrictionTheAllowedRange = true;
    private int permittedAccessLevel = 3;
    private boolean isActive = true;
    private final String reason;
    private ArrayList listeners = new ArrayList();

    public ParameterRestriction(String string) {
        this.reason = string;
    }

    public ParameterRestriction(String string, ParameterRange parameterRange, boolean bl) {
        this(string);
        this.setRange(parameterRange, bl);
    }

    public ParameterRestriction(String string, int n) {
        this(string);
        this.permittedAccessLevel = n;
    }

    public void setRange(ParameterRange parameterRange, boolean bl) {
        if (this.restrictedRange != null && this.restrictedRange.equals(parameterRange) && this.isRangeRestrictionTheAllowedRange == bl) {
            return;
        }
        this.restrictedRange = parameterRange;
        this.isRangeRestrictionTheAllowedRange = bl;
        this.fireRestrictionChanged(new ParameterEvent(2));
    }

    public void setAccessLevel(int n) {
        if (this.permittedAccessLevel == n) {
            return;
        }
        this.permittedAccessLevel = n;
        this.fireRestrictionChanged(new ParameterEvent(4));
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        if (this.isActive == bl) {
            return;
        }
        this.isActive = bl;
        this.fireRestrictionChanged(new ParameterEvent(6));
    }

    public ParameterRange getAdjustedRange(ParameterRange parameterRange) {
        if (!this.isActive()) {
            return parameterRange;
        }
        if (this.restrictedRange == null) {
            return parameterRange;
        }
        ParameterRange parameterRange2 = this.isRangeRestrictionTheAllowedRange ? parameterRange.copyAndRetainRange(this.restrictedRange) : parameterRange.copyAndRemove(this.restrictedRange);
        return parameterRange2;
    }

    public boolean isValueRestricted(String string) {
        if (!this.isActive()) {
            return false;
        }
        if (this.restrictedRange != null) {
            boolean bl = this.restrictedRange.isValueInRange(string);
            if (this.isRangeRestrictionTheAllowedRange) {
                return !bl;
            }
            return bl;
        }
        return false;
    }

    public int getAccessLevel() {
        return this.isActive() ? this.permittedAccessLevel : 3;
    }

    public String getReasonText() {
        return this.reason;
    }

    public void addListener(RestrictionChangedListener restrictionChangedListener) {
        this.listeners.add(restrictionChangedListener);
    }

    public void removeListener(RestrictionChangedListener restrictionChangedListener) {
        this.listeners.remove(restrictionChangedListener);
    }

    protected void fireRestrictionChanged(ParameterEvent parameterEvent) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            RestrictionChangedListener restrictionChangedListener = (RestrictionChangedListener)iterator.next();
            restrictionChangedListener.restrictionChanged(this, parameterEvent);
        }
    }
}

