/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCarrier;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SectorInitialisationRI
extends AbstractResourceItem {
    private static final String name = "SectorInitialisation";
    private static final String[] phases = new String[]{"SectorInitiationPhase", "SectorUninitiationPhase"};
    private MoHandler theMoHandler;
    private String sectorLdn;
    private BemMo sectorMo;
    private int sectorNumber;
    private int MASK = 1;
    private String uninstallNotPossibleReason = "";

    public SectorInitialisationRI(Rbs rbs, int n) {
        super(name, rbs, phases);
        this.theMoHandler = rbs.getMoHandler();
        try {
            int n2 = 0;
            if (rbs.isPantherHybridRbs() && n >= 7) {
                n2 = 1;
            }
            this.sectorLdn = rbs.getAntennaSystemProvider(n2).getSectorLdn(n);
        }
        catch (BemException bemException) {
            System.out.println(bemException.toString());
        }
        this.sectorMo = this.theMoHandler.getMo(this.sectorLdn);
        this.sectorNumber = n;
    }

    public void install(String string) throws BemException {
        if (string.equals("SectorInitiationPhase")) {
            try {
                boolean bl = this.theMoHandler.isExisting(this.sectorMo);
                if (bl && !this.isInstalled()) {
                    NalNameValue[] nalNameValueArray = this.getInitSectorParameters(this.sectorNumber);
                    this.theMoHandler.action(this.sectorMo, "initMultiBandSector", nalNameValueArray);
                }
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.getAction(), this.sectorLdn, (Throwable)moHandlerException);
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("SectorUninitiationPhase")) {
            try {
                boolean bl = this.theMoHandler.isExisting(this.sectorMo);
                if (bl && this.isInstalled()) {
                    this.theMoHandler.action(this.sectorMo, "unInitSector", new NalNameValue[0]);
                }
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.getAction(), this.sectorLdn, (Throwable)moHandlerException);
            }
        }
    }

    public NalNameValue[] getInitSectorParameters(int n) throws BemException, MoHandlerException {
        NalNameValue[] nalNameValueArray = new NalNameValue[1];
        int n2 = this.getNoOfTxBranches();
        RadioEquipmentProvider radioEquipmentProvider = null;
        radioEquipmentProvider = this.rbs.isPantherHybridRbs() && n >= 7 ? this.getRbs().getRadioEquipmentProvider(1) : this.getRbs().getRadioEquipmentProvider(0);
        int n3 = radioEquipmentProvider.getNumberOfSupportedTxBranches(n);
        if (n3 < n2) {
            n2 = n3;
        }
        nalNameValueArray[0] = Nal.getFactory().getNameValue("numberOfTxBranches", new Integer(n2));
        return nalNameValueArray;
    }

    private int getNoOfTxBranches() throws BemException {
        int n = 0;
        if (this.rbs.isPantherHybridRbs() && this.sectorNumber >= 7) {
            n = 1;
        }
        return this.rbs.getRadioEquipmentProvider(n).getNumberOfSupportedTxBranches(this.sectorNumber);
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        try {
            int n;
            Integer n2;
            if (this.sectorMo.isExisting() && (n2 = (Integer)this.theMoHandler.getAttribute(this.sectorMo, "proceduralStatus")) != null && (n = n2.intValue()) == 0) {
                bl = true;
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.getAction(), this.sectorLdn, (Throwable)moHandlerException);
        }
        catch (NalCmException nalCmException) {
            throw new BemException("Sector:" + this.sectorLdn + nalCmException);
        }
        return bl;
    }

    public boolean isUninstallPossible() throws BemException {
        BemMo[] bemMoArray = null;
        try {
            bemMoArray = this.theMoHandler.getChildren(this.sectorMo, 1, MimCarrier.MOTYPENAME, "");
            if (bemMoArray == null) {
                return true;
            }
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo[] bemMoArray2 = (BemMo[])this.theMoHandler.getAttribute(bemMoArray[i], "reservedBy");
                for (int j = 0; j < bemMoArray2.length; ++j) {
                    if (this.isCellLocked(bemMoArray2[j])) continue;
                    this.uninstallNotPossibleReason = "All cells in sector " + this.sectorNumber + " must be offline";
                    return false;
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Checking preconditions for uninitiating sector", "Is cell offline", "", "Cell must be offline", moHandlerException);
        }
        this.uninstallNotPossibleReason = "";
        return true;
    }

    public String getUninstallNotPossibleReason() {
        return this.uninstallNotPossibleReason;
    }

    private boolean isCellLocked(BemMo bemMo) throws MoHandlerException {
        Integer n = null;
        n = (Integer)this.theMoHandler.getAttribute(bemMo, "availabilityStatus");
        int n2 = n;
        return ((n2 >>= 3) & this.MASK) == 1;
    }

    public String getLdn() {
        return this.sectorLdn;
    }

    public String getDisplayName() {
        return "SectorInitialisation:" + this.sectorLdn;
    }
}

