/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.ifc;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalBackendFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactoryParameters;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactoryParametersEmpty;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;

public class Nal {
    private static final Class THIS_CLASS = Nal.class;
    private static final String NEAL_FACTORY_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalFactoryNeal";
    private static final String NEX_FACTORY_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NalFactoryNex";
    private static final String LOG_FACTORY_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.nal.impl.log.NalFactoryLog";
    private static final String MIB_FACTORY_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.nal.impl.mib.NalFactoryMib";
    private static final String NEAL_LOG_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalLogNeal";
    private static final String NEX_LOG_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NalLogNex";
    private static final String SIMPLE_LOG_CLASS_NAME = "se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalSimpleLog";
    private static final String NEAL_CLASS_LOG = "se.ericsson.cello.neal.NealLogger";
    private static final String NEX_CLASS_LOG = "java.util.logging.Logger";
    private static final String NEAL_CLASS_NODE_FACTORY = "se.ericsson.cello.neal.NodeFactory";
    private static final String NEAL_CLASS_NODE_ACESS = "se.ericsson.cello.neal.NodeAccess";
    private static final String NEX_CLASS_NODE_SERVICES = "se.ericsson.cello.emt.nodeservices.NodeServices";
    private static final String BEM_CLI_CLASS = "se.ericsson.wcdma.rbs.bem.client.clients.cli.main.CliMain";
    private static final String BSM_LAUNCHER_CLASS = "test.bemapplication.BsmLauncher";
    public static final String[] junitClassNameConstants = new String[]{"se.ericsson.wcdma.rbs.bem.common.nal.impl.log.NalFactoryLog", "se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalFactoryNeal", "se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NalFactoryNex", "se.ericsson.wcdma.rbs.bem.common.nal.impl.mib.NalFactoryMib", "se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalLogNeal", "se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NalLogNex", "se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalSimpleLog", "se.ericsson.cello.neal.NealLogger", "java.util.logging.Logger", "se.ericsson.cello.neal.NodeAccess", "se.ericsson.cello.emt.nodeservices.NodeServices", "se.ericsson.wcdma.rbs.bem.client.clients.cli.main.CliMain", "test.bemapplication.BsmLauncher", "EndOfClasses"};
    public static final String NAL_TYPE_MIB = "mib";
    public static final String NAL_TYPE_NEAL = "neal";
    public static final String NAL_TYPE_NEX = "nex";
    public static final String LOG_TYPE_SIMPLE = "simple";
    public static final String LOG_TYPE_MIB = "mib";
    public static final String LOG_TYPE_NEAL = "neal";
    public static final String LOG_TYPE_NEX = "nex";
    public static final String LOG_TYPE_EXTERNAL = "external";
    public static final String hidden__NAL_TYPE_EMAS = "emas";
    private static NalBackendFactory theNalFactory = null;
    private static NalLog theNalLog = null;

    public static synchronized void setLogAndFactory(NalLog nalLog, NalFactory nalFactory) {
        Nal.setLog(nalLog);
        Nal.setFactory(nalFactory);
    }

    public static synchronized void setFactory(NalFactory nalFactory) {
        if (!(nalFactory instanceof NalBackendFactory)) {
            throw new Error("Sorry, the NalFactory " + (nalFactory == null ? "null" : nalFactory.getClass().getName()) + "\n   must also implement the methods in the interface 'NalBackendFactory'!");
        }
        theNalFactory = (NalBackendFactory)nalFactory;
    }

    private static synchronized void setFactory(String string, String string2, NalFactoryParameters nalFactoryParameters) {
        NalFactory nalFactory = null;
        try {
            if (string2 == null) {
                string2 = Nal.determinNalType(string, nalFactoryParameters);
            }
            if ("mib".equals(string2)) {
                nalFactory = Nal.newFactoryMib();
            } else if ("nex".equals(string2)) {
                nalFactory = Nal.newFactoryNex(nalFactoryParameters);
            } else if ("neal".equals(string2)) {
                nalFactory = Nal.newFactoryNeal();
            } else if (string2 == null && Nal.isClassPresent(NEX_CLASS_NODE_SERVICES)) {
                string2 = "neal";
                nalFactory = Nal.newFactoryNeal();
                if (nalFactory == null) {
                    throw new Error("FATAL ERROR! Cant find Neal implementations of NalFactory!");
                }
            } else if (string2 == null) {
                string2 = "neal";
                nalFactory = Nal.newFactoryNeal();
                if (nalFactory == null) {
                    throw new Error("FATAL ERROR! Cant find Neal implementations of NalFactory!");
                }
            } else {
                String string3 = "Don't know how to create a NalFactory for MIB=" + string + ", NAL=" + string2 + "!";
                System.out.println(string3);
                throw new Error(string3);
            }
            nalFactory = Nal.newFactoryLog(nalFactory);
        }
        catch (Throwable throwable) {
            Error error = new Error("FATAL ERROR! Failed creating factory of type " + string2 + " for MIB=" + string + " with factory parameters=" + nalFactoryParameters + "!", throwable);
            error.printStackTrace();
            throw error;
        }
        String string4 = Nal.getNalType(nalFactory);
        if (!string2.equals(string4)) {
            Error error = new Error("INTERNAL ERROR! Tried to create factory for " + string2 + ", got " + string4 + " for MIB=" + string + "!");
            error.printStackTrace();
            throw error;
        }
        Nal.setFactory(nalFactory);
    }

    public static synchronized NalFactory getFactory() {
        if (theNalLog == null) {
            Nal.getLog();
        }
        if (theNalFactory == null) {
            Nal.setFactory(null, null, null);
        }
        return theNalFactory;
    }

    private static synchronized NalFactory getFactory(String string, String string2, NalFactoryParameters nalFactoryParameters) {
        if (theNalFactory == null) {
            Nal.setFactory(string, string2, nalFactoryParameters);
        }
        return theNalFactory;
    }

    private static String getLogType() {
        return Nal.getLogType(theNalLog);
    }

    private static String getLogType(NalLog nalLog) {
        if (nalLog == null) {
            return null;
        }
        String string = nalLog.getNalType();
        return string;
    }

    public static synchronized NalLog newLog(String string) {
        String string2 = Nal.getLogType();
        return Nal.newLog(string2, string);
    }

    private static synchronized NalLog newLog(String string, String string2) {
        if (string2 == null) {
            string2 = "se.ericsson.wcdma.rbs.bem";
        }
        try {
            NalLog nalLog = null;
            if (string == null && theNalLog != null) {
                string = Nal.getLogType();
            }
            if (LOG_TYPE_SIMPLE.equals(string)) {
                nalLog = Nal.newLogSimple(string2);
            } else if ("mib".equals(string)) {
                nalLog = Nal.newLogNex(string2);
            } else if ("nex".equals(string)) {
                nalLog = Nal.newLogNex(string2);
            } else if ("neal".equals(string)) {
                nalLog = Nal.newLogNeal(string2);
            } else if (string == null) {
                nalLog = Nal.newLogNex(string2);
                if (nalLog == null) {
                    nalLog = Nal.newLogNeal(string2);
                }
                if (nalLog == null) {
                    nalLog = Nal.newLogSimple(string2);
                }
            } else {
                nalLog = theNalLog;
            }
            if (nalLog == null) {
                String string3 = "Don't know how to create a NalLog for logType=" + string + "!";
                RuntimeException runtimeException = new RuntimeException(string3);
                runtimeException.printStackTrace();
                throw runtimeException;
            }
            return nalLog;
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException("FATAL ERROR! Failed creating NalLog for logType=" + string + "!", exception);
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    private static synchronized void setLog(String string, int n) {
        NalLog nalLog = Nal.newLog(string, "se.ericsson.wcdma.rbs.bem");
        Nal.setLog(nalLog);
        if (n != -1 && !"nex".equals(Nal.getLogType(nalLog))) {
            nalLog.setTraceLevel(n);
        }
    }

    public static synchronized void setLog(NalLog nalLog) {
        theNalLog = nalLog;
    }

    public static synchronized NalLog getLog() {
        return Nal.getLog(null, -1);
    }

    private static synchronized NalLog getLog(String string, int n) {
        if (theNalLog == null) {
            Nal.setLog(string, n);
        }
        return theNalLog;
    }

    public static void connectToMib(String string) {
        Nal.connectToMib(string, -1, null, new NalFactoryParametersEmpty());
    }

    public static void connectToMib(String string, NalFactoryParameters nalFactoryParameters) {
        Nal.connectToMib(string, -1, null, nalFactoryParameters);
    }

    public static void connectToMib(String string, int n) {
        Nal.connectToMib(string, n, null, new NalFactoryParametersEmpty());
    }

    public static void connectToMib(String string, int n, String string2) {
        Nal.connectToMib(string, n, string2, new NalFactoryParametersEmpty());
    }

    public static void connectToMib(String string, int n, String string2, NalFactoryParameters nalFactoryParameters) {
        if (string2 == null) {
            string2 = Nal.determinNalType(string, nalFactoryParameters);
        }
        Nal.getLog(string2, n);
        if (Nal.isAlreadyConnected(string)) {
            return;
        }
        NalFactory nalFactory = Nal.getFactory(string, string2, nalFactoryParameters);
        Nal.connectToMib(string, n, nalFactory);
    }

    private static boolean isAlreadyConnected(String string) {
        return theNalFactory != null && theNalFactory.getHost() != null && theNalFactory.getHost().equals(string);
    }

    public static void connectToMib(String string, int n, NalFactory nalFactory) {
        String string2 = Nal.getNalType(nalFactory);
        System.setProperty("NAL", string2);
        NalLog nalLog = Nal.getLog(string2, n);
        if (nalLog != null) {
            n = nalLog.getTraceLevel();
        }
        ExceptionProperties exceptionProperties = ExceptionProperties.getRevisionProperties();
        exceptionProperties.setProperty("Host Name", string);
        String string3 = "Connecting to MIB " + ("mib".equals(string2) ? "in file '" : "on node '") + string + "' via NAL=" + string2 + " on log level LOG=" + n;
        if (nalLog == null) {
            System.out.println(string3);
            System.err.println("nalLog=" + nalLog + "!");
            NullPointerException nullPointerException = new NullPointerException("Failed to instanciate nalLog!");
            nullPointerException.printStackTrace();
        } else if (nalLog.isTraced(3)) {
            nalLog.nalTrace(3, THIS_CLASS, string3);
        } else {
            System.out.println(string3);
        }
        Nal.setFactory(nalFactory);
        Nal.getFactory().connectToMib(string);
    }

    public static void disconnectFromMib() {
        if (theNalFactory != null) {
            theNalFactory.disconnectFromMib();
            theNalFactory = null;
            theNalLog = null;
        }
    }

    public static String determinNalType(String string, NalFactoryParameters nalFactoryParameters) {
        String string2 = null;
        boolean bl = Nal.isFile(string);
        boolean bl2 = Nal.isIpAddress(string);
        boolean bl3 = false;
        if (nalFactoryParameters != null && nalFactoryParameters.getClass().getName().indexOf("Nex") != -1) {
            bl3 = true;
        }
        if (string == null) {
            string2 = "nex";
        } else if (bl) {
            string2 = "mib";
        } else if (bl2) {
            string2 = Nal.isClassPresent(BSM_LAUNCHER_CLASS) && Nal.isClassPresent(BEM_CLI_CLASS) ? (bl3 ? "nex" : "neal") : (Nal.isClassPresent(BEM_CLI_CLASS) ? "neal" : (Nal.isClassPresent(NEX_CLASS_NODE_SERVICES) ? "nex" : "neal"));
        } else if (!bl && !bl2) {
            String string3 = "Don't know how to connectToMib(mib=" + string + ")! Is neither readable file nor IpAddress";
            System.err.println(string3);
            Error error = new Error(string3);
            error.printStackTrace();
            throw error;
        }
        return string2;
    }

    public static boolean executesOnClient() {
        return !"OSE Delta PowerPC".equals(System.getProperty("os.name"));
    }

    public static boolean isFile(String string) {
        if (string == null) {
            return false;
        }
        File file = new File(string);
        boolean bl = file.canRead();
        return bl;
    }

    public static boolean isIpAddress(String string) {
        if (string == null) {
            return false;
        }
        try {
            InetAddress inetAddress;
            int n = string.indexOf(58);
            if (n != -1) {
                string = string.substring(0, n);
            }
            return (inetAddress = InetAddress.getByName(string)) != null;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean isClassPresent(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static String getNalType(NalFactory nalFactory) {
        String string = ((NalBackendFactory)nalFactory).getNalType();
        return string;
    }

    private static Object newInstance(String string) {
        Object var1_1 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var1_1 = clazz.newInstance();
        }
        catch (Throwable throwable) {
            Error error = new Error("FATAL ERROR! Failed instantiating class " + string + "!", throwable);
            error.printStackTrace();
            throw error;
        }
        return var1_1;
    }

    private static Object newInstance(String string, Class clazz, Object object) {
        Object var3_3 = null;
        try {
            Class<?> clazz2 = Class.forName(string);
            Constructor<?> constructor = clazz2.getConstructor(clazz);
            var3_3 = constructor.newInstance(object);
        }
        catch (Exception exception) {
            Error error = new Error("FATAL ERROR! Failed instantiating class " + string + " with parameter " + object + " of type " + clazz.getName() + "!", exception);
            error.printStackTrace();
            throw error;
        }
        return var3_3;
    }

    public static NalFactory newFactoryNeal() {
        if (!Nal.isClassPresent(NEAL_CLASS_NODE_FACTORY) && !Nal.isClassPresent(NEAL_CLASS_NODE_ACESS)) {
            return null;
        }
        Object object = Nal.newInstance(NEAL_FACTORY_CLASS_NAME);
        return (NalBackendFactory)object;
    }

    static NalFactory newFactoryNex(NalFactoryParameters nalFactoryParameters) {
        if (!Nal.isClassPresent(NEX_CLASS_NODE_SERVICES)) {
            return null;
        }
        Object object = Nal.newInstance(NEX_FACTORY_CLASS_NAME, NalFactoryParameters.class, nalFactoryParameters);
        return (NalBackendFactory)object;
    }

    static NalFactory newFactoryMib() {
        Object object = Nal.newInstance(MIB_FACTORY_CLASS_NAME);
        return (NalBackendFactory)object;
    }

    static NalFactory newFactoryLog(NalFactory nalFactory) {
        NalBackendFactory nalBackendFactory = (NalBackendFactory)nalFactory;
        Object object = Nal.newInstance(LOG_FACTORY_CLASS_NAME, NalBackendFactory.class, nalBackendFactory);
        return (NalBackendFactory)object;
    }

    static NalLog newLogSimple(String string) {
        Object object = Nal.newInstance(SIMPLE_LOG_CLASS_NAME, String.class, string);
        return (NalLog)object;
    }

    static NalLog newLogNex(String string) {
        if (!Nal.isClassPresent(NEX_CLASS_LOG)) {
            return null;
        }
        Object object = Nal.newInstance(NEX_LOG_CLASS_NAME, String.class, string);
        return (NalLog)object;
    }

    static NalLog newLogNeal(String string) {
        if (!Nal.isClassPresent(NEAL_CLASS_LOG)) {
            return null;
        }
        Object object = Nal.newInstance(NEAL_LOG_CLASS_NAME, String.class, string);
        return (NalLog)object;
    }

    public static class LoggerNameParam
    implements NalFactoryParameters {
        public static final String DEFAULT_LOGGER_NAME = "se.ericsson.wcdma.rbs.bem";
        public final String name;

        public LoggerNameParam(String string) {
            this.name = string != null ? string : DEFAULT_LOGGER_NAME;
        }

        public String toString() {
            return this.name;
        }
    }
}

