/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.security.corba.interceptor;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import se.ericsson.security.corba.AccessControlEnabler;
import se.ericsson.security.corba.Current;
import se.ericsson.security.corba.interceptor.CurrentImpl;
import se.ericsson.security.corba.interceptor.TraceErrorLogger;

public class AuthorizationInterceptor
extends LocalObject
implements ServerRequestInterceptor {
    private AccessControlEnabler impl = null;
    private Current gCurrent = null;
    private ORB orb = null;
    private byte[] sharedSecret = null;
    public static final int NO_AUTHORIZATION = 10000;
    public static final int SUBJECT_UNIQUE_ID_MISSING = 10001;
    private static TraceErrorLogger logger = new TraceErrorLogger();

    public AuthorizationInterceptor(ORB oRB, byte[] byArray) throws INITIALIZE {
        this.sharedSecret = byArray;
        this.orb = oRB;
        try {
            this.impl = (AccessControlEnabler)oRB.resolve_initial_references("AccessControlEnabler");
        }
        catch (InvalidName invalidName) {
            new TraceErrorLogger().info(((Object)((Object)this)).getClass(), "Could not resolve AccessControlEnabler");
            throw new INITIALIZE("Could not resolve AccessControlEnabler");
        }
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        String string = serverRequestInfo.operation();
        CurrentImpl currentImpl = (CurrentImpl)this.getCurrent(this.orb);
        String string2 = serverRequestInfo.target_most_derived_interface();
        boolean bl2 = false;
        try {
            object3 = null;
            object2 = null;
            object3 = serverRequestInfo.get_request_service_context(1000);
            object2 = serverRequestInfo.get_request_service_context(1001);
            if (object3 != null) {
                bl2 = this.validateSecret(object3.context_data);
            }
            if (bl2 && object2 != null) {
                object = new ByteArrayInputStream(object2.context_data);
                DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                try {
                    int n = dataInputStream.readInt();
                    currentImpl.addServerClientMapping(new Integer(n));
                }
                catch (IOException iOException) {
                    logger.trace(1, ((Object)((Object)this)).getClass(), "Could not read client thread id: " + iOException);
                }
            }
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
        if (bl2 && currentImpl.getDelegatedPrincipal() == null) {
            logger.trace(1, ((Object)((Object)this)).getClass(), "Request is local and no DP set => no access control performed");
            return;
        }
        object3 = null;
        object2 = null;
        object = currentImpl.getActingPrincipal();
        if (object != null) {
            object2 = object.getName();
        }
        if ((object3 = currentImpl.getUniqueID((Principal)object)) == null) {
            logger.trace(1, ((Object)((Object)this)).getClass(), "X.509 v3 ext. subjectUniqueID is missing in Client certificate");
            throw new NO_PERMISSION(10001, CompletionStatus.COMPLETED_NO);
        }
        if (object3 != null) {
            object2 = null;
        }
        if (!(bl = this.impl.isAuthorized((String)object3, (String)object2, string2, string))) {
            logger.trace(1, ((Object)((Object)this)).getClass(), string2 + "." + string + "is not allowed for: " + (String)object3);
            throw new NO_PERMISSION("The operation " + string2 + "." + string + " is not allowed for user " + (String)object3, 10000, CompletionStatus.COMPLETED_NO);
        }
    }

    private boolean validateSecret(byte[] byArray) {
        if (byArray.length != this.sharedSecret.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == this.sharedSecret[i]) continue;
            return false;
        }
        return true;
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        CurrentImpl currentImpl = (CurrentImpl)this.getCurrent(this.orb);
        currentImpl.removeServerClientMapping();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public String name() {
        return "AuthorizationInterceptor";
    }

    public void destroy() {
    }

    private Current getCurrent(ORB oRB) {
        if (this.gCurrent == null) {
            try {
                this.gCurrent = (Current)oRB.resolve_initial_references("OMSecSecurityCurrent");
            }
            catch (InvalidName invalidName) {
                throw new INITIALIZE("Could not resolve OMSecSecurityCurrent");
            }
        }
        return this.gCurrent;
    }
}

