/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe;

import java.awt.BorderLayout;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import se.ericsson.cello.emt.nodeservices.NodeServices;
import se.ericsson.cello.emt.utils.guitestsupport.GuiTestEventTypes;
import se.ericsson.cello.nex.DestroyableEmbeddable;
import se.ericsson.cello.swe.CvLdnMvcContainerImpl;
import se.ericsson.cello.swe.LdnMvcContainer;
import se.ericsson.cello.swe.SweLog;
import se.ericsson.cello.swe.service.Configuration;
import se.ericsson.cello.swe.service.ConfigurationFactory;
import se.ericsson.cello.swe.service.SweToolServiceFactory;
import se.ericsson.cello.swe.service.SweToolServices;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.emnotification.EmEventInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationListenerInterface;
import se.ericsson.security.launcher.emnotification.EmNotificationServiceInterface;

public class CvSweEmbeddable
implements DestroyableEmbeddable {
    private LauncherInterface myLauncher;
    private static String myHost = null;
    private int myNrOfRunCalls = 0;
    private SweToolServices myToolServices = null;
    private NodeServices myNodeServices = null;
    private Configuration myConfigurationHandler = null;
    private Properties myParameters = null;
    private Launchable myNexLaunchable = null;
    private JPanel myComponent = null;
    private LdnMvcContainer myLdnMvcContainer = null;
    private CvAddDeleteListener myCvAddDeleteListener = null;
    private final String cvTypeAdd = "se.ericsson.cello.emas.sm.CV_ADDED";
    private final String cvTypeDelete = "se.ericsson.cello.emas.sm.CV_DELETED";
    private static final String NEX_CV_TABNAME = "CV";

    public JComponent getComponent() {
        if (null == this.myComponent) {
            this.myComponent = new JPanel();
            this.myComponent.setLayout(new BorderLayout());
            this.myComponent.setName(NEX_CV_TABNAME);
        }
        return this.myComponent;
    }

    public String getName() {
        return "   CV   ";
    }

    public void init(Properties nexProps, Launchable nex, LauncherInterface theLauncher) {
        try {
            ++this.myNrOfRunCalls;
            SweLog.logger().log(Level.INFO, "myNrOfRunCalls=" + this.myNrOfRunCalls);
            this.myLauncher = theLauncher;
            myHost = nexProps.getProperty("HOST", "Host is not defined");
            this.myParameters = nexProps;
            this.myNexLaunchable = nex;
            this.myConfigurationHandler = ConfigurationFactory.createConfiguration(myHost, this.myParameters);
            this.myToolServices = SweToolServiceFactory.createToolServices(nex, this.myLauncher, this.myConfigurationHandler, null);
            this.myNodeServices = this.myToolServices.getNodeServices();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.getComponent();
        this.fillComponent();
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            SweLog.logger().log(Level.INFO, "Create a CV listener");
            this.myCvAddDeleteListener = new CvAddDeleteListener();
            EmNotificationServiceInterface ensi = (EmNotificationServiceInterface)this.myLauncher;
            ensi.addEmNotificationListener((EmNotificationListenerInterface)this.myCvAddDeleteListener);
        } else {
            SweLog.logger().log(Level.INFO, "Did not create a CV listener, launcher is not a notification service");
        }
    }

    public void setLDNs(String[] LDNs) {
        this.myToolServices.sendEmNotification("CV table updated", GuiTestEventTypes.CV_PANEL_UPDATED, null, null);
    }

    private void fillComponent() {
        SweLog.logger().log(Level.INFO, "New CvSweEmbeddable is built.");
        String ldn = "ManagedElement=1,SwManagement=1,ConfigurationVersion=1";
        this.myComponent.removeAll();
        SweLog.logger().log(Level.INFO, " myParameters " + this.myParameters);
        if (System.getProperty("se.ericsson.cello.swe.debug", "NotDefined").equalsIgnoreCase("true")) {
            this.myParameters.put("SWE_CV_HYPER_TOOL_KEYS", "CVCREATE;CVMOPROP;CVMOSEARCH;CVPUTTOFTP;CVGETFROMFTP;CVRESTORE");
            this.myParameters.put("CVCREATE_NAME", "Create CV...");
            this.myParameters.put("CVMOPROP_NAME", "MO Properties");
            this.myParameters.put("CVMOSEARCH_NAME", "Search MO");
            this.myParameters.put("CVPUTTOFTP_NAME", "Put to FTP...");
            this.myParameters.put("CVGETFROMFTP_NAME", "Get from FTP...");
            this.myParameters.put("CVRESTORE_NAME", "Restore CV...");
            this.myParameters.put("CVCREATE_CONFIG", "/cello/emas/mopropcfg.xml");
            this.myParameters.put("CVMOPROP_CONFIG", "/cello/emas/mopropcfg.xml");
            this.myParameters.put("CVMOSEARCH_CONFIG", "/cello/emas/mosearchcfg.xml");
            this.myParameters.put("CVPUTTOFTP_CONFIG", "/cello/emas/cvputtoftpcfg.xml");
            this.myParameters.put("CVGETFROMFTP_CONFIG", "/cello/emas/cvgetfromftpcfg.xml");
            this.myParameters.put("CVRESTORE_CONFIG", "/cello/emas/cvrestorecfg.xml");
        }
        this.myLdnMvcContainer = new CvLdnMvcContainerImpl(ldn, this.myNodeServices, this.myConfigurationHandler, this.myNexLaunchable, this.myLauncher);
        this.myComponent.add(this.myLdnMvcContainer.getComponent());
        this.myLdnMvcContainer.doStart();
        this.myComponent.revalidate();
    }

    public void onLdnMvcContainerExit(LdnMvcContainer aContainer) {
    }

    public void destroy() {
        if (this.myLauncher instanceof EmNotificationServiceInterface) {
            if (this.myCvAddDeleteListener != null) {
                EmNotificationServiceInterface ensi = (EmNotificationServiceInterface)this.myLauncher;
                ensi.removeEmNotificationListener((EmNotificationListenerInterface)this.myCvAddDeleteListener);
                this.myCvAddDeleteListener = null;
                SweLog.logger().log(Level.INFO, "Removed the CV listener");
            } else {
                SweLog.logger().log(Level.WARNING, "Expected to find an active CV notification listener, but it is not active");
            }
        } else {
            SweLog.logger().log(Level.INFO, "Did not remove the CV listener, launcher is not a notification service");
        }
        SweToolServiceFactory.destroy();
        this.myLdnMvcContainer.doStop();
    }

    private class CvAddDeleteListener
    implements EmNotificationListenerInterface {
        public void notificationFromEM(EmEventInterface event) {
            String messageType = event.getType();
            Object objectUserData = event.getUserData();
            String userData = null;
            if (objectUserData != null) {
                userData = objectUserData.toString();
            }
            SweLog.logger().log(Level.FINE, "NotificationFromEM in CV, userData=" + userData);
            if (messageType.equals("se.ericsson.cello.emas.sm.CV_ADDED") || messageType.equals("se.ericsson.cello.emas.sm.CV_DELETED")) {
                String cvId = this.findConfigurationVersionId(userData);
                CvSweEmbeddable.this.myLdnMvcContainer.refresh(cvId);
            }
        }

        private String findConfigurationVersionId(Object userData) {
            String result = null;
            if (userData instanceof String) {
                result = (String)userData;
            }
            return result;
        }
    }
}

