/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.swe.model.tablemodel;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import se.ericsson.cello.swe.model.tablemodel.TableMap;

public class TableSorter
extends TableMap {
    private static final long serialVersionUID = 5030952096366539860L;
    int[] index;
    Vector sortColumns = new Vector();
    boolean ascend = true;
    int compare;

    public TableSorter() {
        this.index = new int[0];
    }

    public TableSorter(TableModel modeler) {
        this.setModel(modeler);
    }

    public void setModel(TableModel modeler) {
        super.setModel(modeler);
        int rowCounts = this.tabModel.getRowCount();
        this.index = new int[rowCounts];
        for (int row = 0; row < rowCounts; ++row) {
            this.index[row] = row;
        }
    }

    private int compareNumber(TableModel datacolumn, int rowOne, int rowTwo, int columns) {
        Number num2;
        double doub2;
        Number num1 = (Number)datacolumn.getValueAt(rowOne, columns);
        double doub1 = num1.doubleValue();
        if (doub1 < (doub2 = (num2 = (Number)datacolumn.getValueAt(rowTwo, columns)).doubleValue())) {
            return -1;
        }
        if (doub1 < doub2) {
            return 1;
        }
        return 0;
    }

    private int compareString(TableModel datacolumn, int rowOne, int rowTwo, int columns) {
        String str2;
        String str1 = (String)datacolumn.getValueAt(rowOne, columns);
        int results = str1.compareTo(str2 = (String)datacolumn.getValueAt(rowTwo, columns));
        if (results < 0) {
            return -1;
        }
        if (results > 0) {
            return 1;
        }
        return 0;
    }

    private int compareBoolean(TableModel datacolumn, int rowOne, int rowTwo, int columns) {
        Boolean boolean2;
        boolean boo2;
        Boolean boolean1 = (Boolean)datacolumn.getValueAt(rowOne, columns);
        boolean boo1 = boolean1;
        if (boo1 == (boo2 = (boolean2 = (Boolean)datacolumn.getValueAt(rowTwo, columns)).booleanValue())) {
            return 0;
        }
        if (boo1) {
            return 1;
        }
        return -1;
    }

    private int compareObject(TableModel datacolumn, int rowOne, int rowTwo, int columns) {
        Object value2;
        String str2;
        Object value1 = datacolumn.getValueAt(rowOne, columns);
        String str1 = value1.toString();
        int results = str1.compareTo(str2 = (value2 = datacolumn.getValueAt(rowTwo, columns)).toString());
        if (results < 0) {
            return -1;
        }
        if (results > 0) {
            return 1;
        }
        return 0;
    }

    public int compareRowsByColumn(int rowOne, int rowTwo, int columns) {
        Class<?> typecolumn = this.tabModel.getColumnClass(columns);
        TableModel datacolumn = this.tabModel;
        Object obj1 = datacolumn.getValueAt(rowOne, columns);
        Object obj2 = datacolumn.getValueAt(rowTwo, columns);
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        if (typecolumn.getSuperclass() == Number.class) {
            return this.compareNumber(datacolumn, rowOne, rowTwo, columns);
        }
        if (typecolumn == Date.class) {
            return this.compareNumber(datacolumn, rowOne, rowTwo, columns);
        }
        if (typecolumn == String.class) {
            return this.compareString(datacolumn, rowOne, rowTwo, columns);
        }
        if (typecolumn == Boolean.class) {
            return this.compareBoolean(datacolumn, rowOne, rowTwo, columns);
        }
        return this.compareObject(datacolumn, rowOne, rowTwo, columns);
    }

    public int compare(int rowOne, int rowTwo) {
        ++this.compare;
        for (int lev = 0; lev < this.sortColumns.size(); ++lev) {
            Integer columns = (Integer)this.sortColumns.elementAt(lev);
            int resultis = this.compareRowsByColumn(rowOne, rowTwo, columns);
            if (resultis == 0) continue;
            return this.ascend ? resultis : -resultis;
        }
        return 0;
    }

    public void tableChanged(TableModelEvent event) {
        int rowCounts = this.tabModel.getRowCount();
        this.index = new int[rowCounts];
        for (int row = 0; row < rowCounts; ++row) {
            this.index[row] = row;
        }
        super.tableChanged(event);
    }

    public void sort(Object sender) {
        this.compare = 0;
        if (this.index.length != this.tabModel.getRowCount()) {
            System.err.println("System out print: Sorter not informed of a change in model.");
        }
        this.shuttlesort((int[])this.index.clone(), this.index, 0, this.index.length);
    }

    public void nTwosort() {
        for (int k = 0; k < this.getRowCount(); ++k) {
            for (int j = k + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.index[k], this.index[j]) != -1) continue;
                this.swapIndex(k, j);
            }
        }
    }

    private void swapIndex(int p, int q) {
        int tmpValue = this.index[p];
        this.index[p] = this.index[q];
        this.index[q] = tmpValue;
    }

    private void setValue(int[] fromBegin, int[] toEnd, int lowValue, int highValue, int middle) {
        int pValue = lowValue;
        int qValue = middle;
        if (highValue - lowValue >= 4 && this.compare(fromBegin[middle - 1], fromBegin[middle]) <= 0) {
            for (int i = lowValue; i < highValue; ++i) {
                toEnd[i] = fromBegin[i];
            }
            return;
        }
        for (int i = lowValue; i < highValue; ++i) {
            toEnd[i] = qValue >= highValue || pValue < middle && this.compare(fromBegin[pValue], fromBegin[qValue]) <= 0 ? fromBegin[pValue++] : fromBegin[qValue++];
        }
    }

    public void shuttlesort(int[] fromBegin, int[] toEnd, int lowValue, int highValue) {
        if (highValue - lowValue < 2) {
            return;
        }
        int middle = (lowValue + highValue) / 2;
        this.shuttlesort(toEnd, fromBegin, lowValue, middle);
        this.shuttlesort(toEnd, fromBegin, middle, highValue);
        this.setValue(fromBegin, toEnd, lowValue, highValue, middle);
    }

    public Object getValueAt(int oneRow, int oneColumn) {
        if (this.index.length != this.tabModel.getRowCount()) {
            System.err.println("System out print: Sorter not informed of a change in model.");
        }
        return this.tabModel.getValueAt(this.index[oneRow], oneColumn);
    }

    public void setValueAt(Object aValue, int oneRow, int oneColumn) {
        if (this.index.length != this.tabModel.getRowCount()) {
            System.err.println("System out print: Sorter not informed of a change in model.");
        }
        this.tabModel.setValueAt(aValue, this.index[oneRow], oneColumn);
    }

    public void sortByColumn(int columns) {
        this.sortByColumn(columns, true);
    }

    public void sortByColumn(int columns, boolean ascend) {
        this.ascend = ascend;
        this.sortColumns.removeAllElements();
        this.sortColumns.addElement(new Integer(columns));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable tableListener) {
        final TableSorter sorterTable = this;
        final JTable tableViewer = tableListener;
        tableViewer.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListenerAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                TableColumnModel columnModel = tableViewer.getColumnModel();
                int viewColumns = columnModel.getColumnIndexAtX(event.getX());
                int columns = tableViewer.convertColumnIndexToModel(viewColumns);
                if (event.getClickCount() == 1 && columns != -1) {
                    int shiftPressed = event.getModifiers() & 1;
                    boolean ascen = shiftPressed == 0;
                    sorterTable.sortByColumn(columns, ascen);
                }
            }
        };
        JTableHeader thread = tableViewer.getTableHeader();
        thread.addMouseListener(listMouseListenerAdapter);
    }
}

