/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.crbs.omf.mao.pnp.request;

import java.util.List;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoNotFoundException;
import se.ericsson.cello.support.servloc.ServiceRepository;
import se.ericsson.crbs.logging.AbstractLogger;
import se.ericsson.crbs.logging.LoggingService;
import se.ericsson.crbs.omf.mao.commonif.LdnFinder;
import se.ericsson.crbs.omf.mao.commonmo.AttrListImpl;
import se.ericsson.crbs.omf.mao.genericmo.xml.MoRefParameter;
import se.ericsson.crbs.omf.mao.pnp.proxy.PnpContext;
import se.ericsson.crbs.omf.mao.pnp.request.PnpSubRequest;
import se.ericsson.crbs.omf.mao.wrappers.ServiceLocatorWrapper;

public abstract class AbstractPnpSubRequest
implements PnpSubRequest {
    protected static final AbstractLogger logger = LoggingService.getLogger();
    protected final Class loggingClass;
    protected final PnpContext pnpContext;
    protected String ldn;
    protected Object executeResult = null;
    protected String executeResultName = "";
    protected final AttrListImpl attributeList;

    public AbstractPnpSubRequest(Class inputLoggingClass, PnpContext inputPnpContext) {
        this.loggingClass = inputLoggingClass;
        this.pnpContext = inputPnpContext;
        this.attributeList = new AttrListImpl(this.pnpContext.getMoRepositoryWrapper());
    }

    public Object getExecuteResult() {
        return this.executeResult;
    }

    public String getExecuteResultName() {
        return this.executeResultName;
    }

    public String getLdn() {
        return this.ldn;
    }

    public void setLdn(String newLdn) {
        this.ldn = newLdn;
    }

    public AttrListImpl getAttributeList() {
        return this.attributeList;
    }

    public String toString() {
        return " requestType:" + this.getRequestType() + " ldn:" + this.ldn + "\n";
    }

    protected ManagedObject getMo(String localLdn) throws MoAccessException {
        logger.traceEnter(this.loggingClass, "getMo(ldn=" + localLdn + ")");
        ManagedObject managedObject = this.pnpContext.getMoRepositoryWrapper().lookup(localLdn);
        if (managedObject == null) {
            logger.traceAbnormal(this.loggingClass, "Mo not found: " + localLdn);
            throw new MoNotFoundException("Mo not found");
        }
        logger.traceReturn(this.loggingClass, "getMo()");
        return managedObject;
    }

    public void replaceMoRefAttributes() throws MoNotFoundException {
        List attrValues = this.attributeList.getAttrValues();
        for (int i = 0; i < attrValues.size(); ++i) {
            if (!(attrValues.get(i) instanceof MoRefParameter)) continue;
            attrValues.set(i, this.convertMoRefParameterToMo((MoRefParameter)attrValues.get(i)));
        }
    }

    public ManagedObject convertMoRefParameterToMo(MoRefParameter attrValue) throws MoNotFoundException {
        String ldn;
        ManagedObject result = null;
        String string = ldn = attrValue.getLdn() != null && attrValue.getLdn().trim().equals("") ? null : attrValue.getLdn();
        if (ldn != null || attrValue.getFroType() != -1 || attrValue.getFroId() != -1) {
            if (ldn == null) {
                ServiceRepository serviceRepository = ServiceLocatorWrapper.getServiceRepository();
                LdnFinder ldnFinder = (LdnFinder)serviceRepository.getService(LdnFinder.class);
                ldn = ldnFinder.getManagedObjectLdn((long)attrValue.getFroType(), (long)attrValue.getFroId());
            }
            if (ldn != null) {
                result = this.pnpContext.getMoRepositoryWrapper().lookup(ldn);
            }
            if (result == null) {
                throw new MoNotFoundException("Could not find MO: " + ldn);
            }
        }
        return result;
    }

    protected static class LdnSubStrings {
        private final String moType;
        private final String parentLdn;
        private final String moId;

        public LdnSubStrings(String ldn) {
            this.moType = ldn.substring(ldn.lastIndexOf(44) + 1, ldn.lastIndexOf(61));
            this.parentLdn = ldn.substring(0, ldn.lastIndexOf(44));
            this.moId = ldn.substring(ldn.lastIndexOf(61) + 1);
        }

        public String getMoType() {
            return this.moType;
        }

        public String getParentLdn() {
            return this.parentLdn;
        }

        public String getId() {
            return this.moId;
        }
    }
}

