/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.mimparser.state;

import org.xml.sax.Attributes;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.model.MimModelImpl;
import se.ericsson.cello.mimparser.model.MomCardinalityImpl;
import se.ericsson.cello.mimparser.model.MomHasClassImpl;
import se.ericsson.cello.mimparser.model.MomParentImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipEndInfoImpl;
import se.ericsson.cello.mimparser.model.MomRelationshipImpl;
import se.ericsson.cello.mimparser.state.ApplicationTagState;
import se.ericsson.cello.mimparser.state.DescriptionSettable;
import se.ericsson.cello.mimparser.state.DescriptionState;
import se.ericsson.cello.mimparser.state.HasClassState;
import se.ericsson.cello.mimparser.state.MaxMinSettable;
import se.ericsson.cello.mimparser.state.MaxState;
import se.ericsson.cello.mimparser.state.MinState;
import se.ericsson.cello.mimparser.state.MomBaseState;
import se.ericsson.cello.mimparser.statemachine.StateMachine;

public class ParentState
extends MomBaseState
implements MaxMinSettable,
DescriptionSettable {
    private MomRelationshipImpl momRelationship;
    private MomParentImpl momParent;
    public static final String PARENT_TAG = "parent";
    private MimModelImpl model;

    public ParentState(MomParentImpl momParentImpl, MomRelationshipImpl momRelationshipImpl, String string, Attributes attributes) {
        super(string);
        this.momRelationship = momRelationshipImpl;
        this.momParent = momParentImpl;
    }

    public void startElement(StateMachine stateMachine, String string, Attributes attributes) {
        this.model = stateMachine.getParseInfo().getMimModel();
        if (string.equals("description")) {
            stateMachine.pushState(new DescriptionState(this));
        } else if (string.equals("applicationTag")) {
            stateMachine.pushState(new ApplicationTagState(this));
        } else if (string.equals("hasClass")) {
            this.momRelationship.setFromElementName(attributes.getValue("name"));
            MomClass momClass = stateMachine.getParseInfo().getMimModel().getClass(attributes.getValue("name"));
            MomHasClassImpl momHasClassImpl = new MomHasClassImpl(attributes, momClass);
            this.momParent.setHasClass(momHasClassImpl);
            stateMachine.pushState(new HasClassState(momHasClassImpl));
        } else if (string.equals("min")) {
            stateMachine.pushState(new MinState(this));
        } else if (string.equals("max")) {
            stateMachine.pushState(new MaxState(this));
        }
    }

    public void setDescription(String string) {
        this.momParent.setDescription(string);
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = this.getEndInfo();
        momRelationshipEndInfoImpl.setDescription(string);
    }

    public void setApplicationTag(String string) {
        this.momParent.setApplicationTag(string);
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = this.getEndInfo();
        momRelationshipEndInfoImpl.setApplicationTag(string);
    }

    public void addMinValue(String string) {
        MomCardinalityImpl momCardinalityImpl = this.getCardinality();
        momCardinalityImpl.setMin(string);
    }

    public void addMaxValue(String string) {
        MomCardinalityImpl momCardinalityImpl = this.getCardinality();
        momCardinalityImpl.setMax(string);
    }

    private MomRelationshipEndInfoImpl getEndInfo() {
        MomRelationshipEndInfoImpl momRelationshipEndInfoImpl = (MomRelationshipEndInfoImpl)this.momRelationship.getFromInfo();
        if (momRelationshipEndInfoImpl == null) {
            momRelationshipEndInfoImpl = new MomRelationshipEndInfoImpl();
            this.momRelationship.setFromInfo(momRelationshipEndInfoImpl);
        }
        return momRelationshipEndInfoImpl;
    }

    private MomCardinalityImpl getCardinality() {
        MomCardinalityImpl momCardinalityImpl = (MomCardinalityImpl)this.momRelationship.getFromCardinality();
        if (momCardinalityImpl == null) {
            momCardinalityImpl = new MomCardinalityImpl(this.model);
            this.momRelationship.setFromCardinality(momCardinalityImpl);
        }
        return momCardinalityImpl;
    }
}

