/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.mao;

import java.io.File;
import se.ericsson.cello.mibmgr.mao.MibManagerMo;
import se.ericsson.cello.moframework.AccessControlHelper;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ManagedObjectBase;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.ncli.mao.MibManagerInputFileException;
import se.ericsson.cello.ncli.mao.MibManagerMoException;
import se.ericsson.cello.ncli.mibmgr.DiskCleaner;
import se.ericsson.cello.ncli.mibmgr.InputFileReader;
import se.ericsson.cello.ncli.mibmgr.MibDumpHandler;
import se.ericsson.cello.ncli.mibmgr.MibDumpListener;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionFactory;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class MibManagerMoImpl
extends ManagedObjectBase
implements MibManagerMo,
MibDumpListener {
    private MoData data;
    private static final String MibManagerId = "1";
    private static MibManagerMoImpl instance = null;
    private IntegerAttribute mibDumpState;
    private static final int MO_DATA_REVISION_14 = 14;

    void recover(MoData moData) throws MoNameAlreadyTakenException {
        Log.trace(MibManagerMoImpl.class, "recover(MoData recoveredData) recoveredData: " + moData);
        this.data = moData;
        if (this.data.getRevision() == 14) {
            moData.getAttribute("userLabel");
            moData.getAttribute("dumpFile");
            if (this.isLastDumpFileExist(((StringAttribute)moData.getAttribute("dumpFile")).getValue(null))) {
                DiskCleaner.getInstance().startScheduleClean(DiskCleaner.getInstance().getOldFile());
            } else {
                String string = DiskCleaner.getInstance().getLatestFile();
                if (string != null && !string.equalsIgnoreCase("")) {
                    ((StringAttribute)moData.getAttribute("dumpFile")).setValue(string);
                    DiskCleaner.getInstance().startScheduleClean(string);
                }
            }
        } else {
            Log.info(this.getClass(), "Wrong Mo data revision for MibMgrMo: Revision = " + this.data.getRevision());
        }
        this.mibDumpState = new IntegerAttribute("mibDumpState", false);
    }

    private MibManagerMoImpl() throws MoNameAlreadyTakenException {
        super(MoRepository.instance().lookupType("SystemFunctions").nextMo(), "MibManager", MibManagerId, null);
        Log.trace(MibManagerMoImpl.class, "MibManagerMoImpl()");
    }

    public static synchronized MibManagerMoImpl instance() {
        Log.trace(MibManagerMoImpl.class, "MibManagerMoImpl.instance(), set MibanaMger configuration");
        try {
            if (instance == null) {
                instance = new MibManagerMoImpl();
            }
        }
        catch (MoNameAlreadyTakenException moNameAlreadyTakenException) {
            Log.info(MibManagerMoImpl.class, "Create instance of MibMgr mo failed", (Exception)((Object)moNameAlreadyTakenException));
        }
        return instance;
    }

    public void delete(Coordinator coordinator) throws MoAccessException {
        throw new UndeletableMoException((ManagedObject)this);
    }

    protected synchronized void registerData() {
        Log.trace(MibManagerMoImpl.class, "registerData()");
        if (this.data == null) {
            try {
                TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
                Control control = transactionFactory.create(3600);
                Coordinator coordinator = control.getCoordinator();
                Log.trace(this.getClass(), "Cello_CMA txId = " + coordinator.getTransactionID() + ", timeout = 3600 sec");
                this.data = new MoData(this.getLocalDistinguishedName(), "MibManager", true, coordinator);
                this.data.registerPersistentAttr((Attribute)new StringAttribute("dumpFile", true, ""));
                this.data.registerPersistentAttr((Attribute)new StringAttribute("userLabel", true, ""));
                this.mibDumpState = new IntegerAttribute("mibDumpState", true);
                this.data.setRevision(14);
                this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
                control.getTerminator().commit();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                Log.info(this.getClass(), "Failed to start MibMgrMo", (Exception)((Object)transactionRequiredException));
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Log.info(this.getClass(), "Failed to start MibMgrMo", (Exception)((Object)transactionRolledBackException));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Log.info(this.getClass(), "Failed to start MibMgrMo", (Exception)((Object)inactiveTransactionException));
            }
            catch (MoAccessException moAccessException) {
                Log.info(this.getClass(), "Failed to start MibMgrMo", (Exception)((Object)moAccessException));
            }
        }
    }

    static void checkParent(ManagedObject managedObject) throws MoAccessException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionGenerateMibDump(final String string, final int n, Coordinator coordinator) throws MoAccessException {
        AccessControlHelper.performAccessControl();
        final MibManagerMoImpl mibManagerMoImpl = this;
        if (this.mibDumpState.getValue(null) == 1) {
            throw new MibManagerMoException("MibDump action is already in progress");
        }
        if (n != 0 && n != 1) throw new MibManagerMoException("Illegal MibDump format");
        File file = new File(string);
        final MibDumpHandler mibDumpHandler = new MibDumpHandler();
        if (!file.exists()) throw new MibManagerInputFileException("Input file missing at " + string);
        InputFileReader inputFileReader = new InputFileReader(string);
        try {
            inputFileReader.validateFile();
            this.updateState(1);
            new Thread("mibDumpGenerator"){

                public void run() {
                    mibDumpHandler.generateDump(string, n, mibManagerMoImpl);
                }
            }.start();
            return;
        }
        catch (MibManagerInputFileException mibManagerInputFileException) {
            this.updateState(2);
            throw mibManagerInputFileException;
        }
    }

    public String getUserLabel(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("userLabel")).getValue(coordinator);
    }

    public void setUserLabel(String string, Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
        ((StringAttribute)this.data.getAttribute("userLabel")).setValue(string);
    }

    public String getDumpFile(Coordinator coordinator) throws MoAccessException {
        this.data.handleTransaction(coordinator, MoData.READ_ACCESS);
        return ((StringAttribute)this.data.getAttribute("dumpFile")).getValue(coordinator);
    }

    public int getMibDumpState(Coordinator coordinator) throws MoAccessException {
        return this.mibDumpState.getValue(coordinator);
    }

    public void dumpStatus(String string, boolean bl) {
        try {
            TransactionFactory transactionFactory = TransactionServiceImpl.instance().getTransactionFactory();
            Control control = transactionFactory.create(3600);
            Coordinator coordinator = control.getCoordinator();
            this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            if (bl) {
                Log.info(this.getClass(), "MibDump Successfully created at " + string);
                ((StringAttribute)this.data.getAttribute("dumpFile")).setValue(string);
                this.updateState(0);
                DiskCleaner.getInstance().startScheduleClean(string);
            } else {
                this.updateState(2);
                Log.info(this.getClass(), "No file generated");
            }
            control.getTerminator().commit();
        }
        catch (TransactionRequiredException transactionRequiredException) {
            Log.trace(this.getClass(), "Could not update attributes " + transactionRequiredException.getMessage());
        }
        catch (NoPermissionException noPermissionException) {
            Log.trace(this.getClass(), "Could not update attributes " + noPermissionException.getMessage());
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Log.trace(this.getClass(), "Could not update attributes " + transactionRolledBackException.getMessage());
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            Log.trace(this.getClass(), "Could not update attributes " + inactiveTransactionException.getMessage());
        }
    }

    private void updateState(int n) {
        Log.trace(this.getClass(), "Update state old=" + this.mibDumpState.getValue(null) + " new=" + n);
        if (n != this.mibDumpState.getValue(null)) {
            String[] stringArray = new String[]{this.mibDumpState.getName()};
            Object[] objectArray = new Object[]{new Integer(n)};
            this.getMaoContext().getAVCNotificationSender().pushAVC((ManagedObject)this, stringArray, objectArray);
        }
        this.mibDumpState.setValue(n);
    }

    private boolean isLastDumpFileExist(String string) {
        Log.trace(this.getClass(), "Method isLastDumpFileExist() on Path: " + string);
        if (string == null || string.equalsIgnoreCase("")) {
            return false;
        }
        File file = new File(string);
        return file.exists();
    }
}

