/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.handlers;

import se.ericsson.cello.ncli.server.command.handlers.CommandHandler;
import se.ericsson.cello.ncli.server.command.handlers.CommandHandlingListener;
import se.ericsson.cello.ncli.server.command.handlers.CommandLineHandling;
import se.ericsson.cello.ncli.server.command.result.Printout;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.MemoryNotSufficientException;
import se.ericsson.cello.ncli.server.exceptions.NcliException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.services.NCLIServices;
import se.ericsson.cello.ncli.server.session.SessionData;
import se.ericsson.cello.ncli.server.session.SessionDataManager;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.cm.Mo;

public class CommandLineHandler
extends CommandHandler
implements CommandLineHandling {
    private boolean saveOnExit = true;
    private String user = "";
    private boolean connected = false;
    private static final String NO_SESSION_DATA = "No session data to restore";

    public CommandLineHandler(CommandHandlingListener commandHandlingListener, NodeServices nodeServices) {
        super(commandHandlingListener, nodeServices);
    }

    public boolean confirmCommand(Printout printout) {
        Log.trace(CommandLineHandler.class, "confirmCommand(): Length of printout is " + printout.getPrintoutBuf().length());
        String string = this.handlingListener.getConfirmation(printout.getPrintoutBuf().toString());
        return string != null && (string.trim().equalsIgnoreCase("y") || string.trim().equalsIgnoreCase("yes"));
    }

    public void sendResponse(Printout printout) {
        Log.trace(CommandLineHandler.class, "sendResponse(): Length of printout is " + printout.getPrintoutBuf().length());
        this.handlingListener.sendCommandResponse(printout.getPrintoutBuf().toString());
    }

    public boolean checkCancellation() {
        return this.handlingListener.checkCancellation();
    }

    public void executeCommandFromHistory(int n) {
        Log.trace(CommandLineHandler.class, "executeCommandFromHistory(" + n + ")");
        Printout printout = PrintoutFactory.createPrintout();
        try {
            String string = this.nodeServices.getCommandHistory().getCommand(n);
            Log.trace(CommandLineHandler.class, "Execute command: " + string);
            printout.addResult(string);
            this.sendResponse(printout);
            this.executeCommand(string);
        }
        catch (NcliException ncliException) {
            printout.addErrorText(ncliException);
            this.sendResponse(printout);
        }
    }

    public void closeSession(boolean bl) {
        this.saveOnExit = bl;
        Log.trace(CommandLineHandler.class, "closeSession()");
        this.handlingListener.closeSession();
    }

    public void disconnect() {
        Log.trace(CommandLineHandler.class, "Disconnecting");
        if (this.connected) {
            this.rollBackAnyActiveTransaction();
            this.saveSessionData();
            this.connected = false;
            try {
                Node node = this.nodeServices.getRootMo().getNode();
                if (node != null) {
                    node.free();
                    node = null;
                }
            }
            catch (Exception exception) {
                Log.trace(CommandLineHandler.class, "Unable to free the CelloNode Object" + exception);
            }
        } else {
            Log.trace(CommandLineHandler.class, "Not connected. Ignoring");
        }
    }

    public void executeCommand(String string) {
        Log.trace(CommandLineHandler.class, "executeCommand(" + string + ")");
        try {
            this.nodeServices.getCommandHistory().addCommand(string);
            this.commandParser.executeParsableString(string, this.commandExecutor, this.nodeServices);
        }
        catch (NcliException ncliException) {
            Printout printout = PrintoutFactory.createPrintout();
            printout.addErrorText(ncliException);
            this.handlingListener.sendCommandResponse(printout.getPrintoutBuf().toString());
        }
        this.sendPrompt();
    }

    private void sendPrompt() {
        this.handlingListener.sendPrompt();
    }

    public void executeArrowUp() {
        this.handlingListener.sendHistoryResponse(this.nodeServices.getCommandHistory().getNextCommand());
        this.sendPrompt();
    }

    public void executeArrowDown() {
        this.handlingListener.sendHistoryResponse(this.nodeServices.getCommandHistory().getPreviousCommand());
        this.sendPrompt();
    }

    public void commandCancelled(Printout printout) {
        this.handlingListener.sendCancelAcknowledge(printout.getPrintoutBuf().toString());
    }

    public void connect(String string) {
        this.connect(string, null, false);
    }

    public void connect(String string, String string2, boolean bl) {
        Log.trace(CommandLineHandler.class, "connect(" + string + ", " + string2 + ", " + bl + ")");
        this.user = string;
        String string3 = null;
        try {
            this.nodeServices.init(string, string2);
            if (bl) {
                SessionDataManager sessionDataManager = NCLIServices.getSessionDataManager();
                SessionData sessionData = sessionDataManager.get(string);
                if (sessionData == null) {
                    Log.trace(CommandLineHandler.class, "No session data to restore.");
                    string3 = NO_SESSION_DATA;
                } else {
                    Log.trace(CommandLineHandler.class, "Restoring session data");
                    this.nodeServices.setCommandHistory(sessionData.getHistory());
                    this.nodeServices.getMoGroupHandler().setDefaultGroup(sessionData.getGroup());
                    Mo mo = this.nodeServices.getCm().getMo(sessionData.getWorkingMo());
                    this.nodeServices.setWorkingMo(mo);
                }
            }
            Log.trace(CommandLineHandler.class, "NodeServices initalized. Set save on exit to default true");
            this.connected = true;
            this.handlingListener.acknowledgeConnection(false, string3);
            this.sendPrompt();
        }
        catch (NcliException ncliException) {
            Log.info(CommandLineHandler.class, "Could not init CS. " + ncliException.getMessage());
            this.handlingListener.acknowledgeConnection(true, ncliException.getMessage());
        }
    }

    private void saveSessionData() {
        if (this.saveOnExit && NCLIServices.getConfigurationReader().getSessionDataStorageTime() > 0L) {
            Log.trace(CommandLineHandler.class, "Saving session data");
            try {
                long l = this.nodeServices.getMoGroupHandler().getDefaultGroup().getMemorySize();
                NCLIServices.getMemoryChecker().memoryIsEnough(l);
                SessionData sessionData = new SessionData(this.nodeServices.getWorkingMo().getLdn(), this.nodeServices.getMoGroupHandler().getDefaultGroup(), this.nodeServices.getCommandHistory());
                NCLIServices.getSessionDataManager().save(this.user, sessionData);
            }
            catch (MemoryNotSufficientException memoryNotSufficientException) {
                Log.info(CommandLineHandler.class, "Could not save session data for user " + this.user, memoryNotSufficientException);
            }
        } else {
            Log.trace(CommandLineHandler.class, "Saving of session data inhibited");
        }
    }

    private void rollBackAnyActiveTransaction() {
        Log.trace(CommandLineHandler.class, "Rolling back any active transaction");
        if (this.nodeServices.getHardTransactionHandler() != null && this.nodeServices.getHardTransactionHandler().isTransactionStarted()) {
            Log.info(CommandLineHandler.class, "Session is closed with active transaction. Transaction is rolled back");
            try {
                this.nodeServices.getHardTransactionHandler().hardRollbackTransaction();
            }
            catch (Exception exception) {
                Log.trace(CommandLineHandler.class, "Rollback failed due to " + exception.getMessage());
            }
        }
    }
}

