/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.command.implementors;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnum;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructMember;
import se.ericsson.cello.ncli.server.command.handlers.CommandResultListener;
import se.ericsson.cello.ncli.server.command.implementors.CSCommand;
import se.ericsson.cello.ncli.server.command.implementors.HistoryCommand;
import se.ericsson.cello.ncli.server.command.result.PrintoutFactory;
import se.ericsson.cello.ncli.server.cs.NodeServices;
import se.ericsson.cello.ncli.server.exceptions.ResolveFailureException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.mom.MomEntityResolver;
import se.ericsson.cello.ncli.server.mom.MomInsensitiveSearch;
import se.ericsson.cello.ncli.server.services.NCLIServices;

public class InfoCommand
extends CSCommand {
    private ArrayList memberList = new ArrayList(0);
    private MomEntityResolver myResolver = null;
    private boolean allFlag = false;
    private String mainEntityName = ".";

    public InfoCommand(CommandResultListener commandResultListener, NodeServices nodeServices) {
        super(commandResultListener, nodeServices);
    }

    public void execute() {
        Log.trace(HistoryCommand.class, "InfoCommand::execute()");
        Log.trace(InfoCommand.class, "mainClass is " + this.mainEntityName);
        Log.trace(InfoCommand.class, "# of members are " + this.memberList.size());
        Log.trace(InfoCommand.class, "All flag is " + this.allFlag);
        this.printout = PrintoutFactory.createPrintout();
        if (!NCLIServices.getConfigurationReader().isMomAware()) {
            this.printout.addErrorText("Info command not supported when MOM Awareness is disabled");
            this.sendResponse();
            return;
        }
        try {
            MomEntity momEntity;
            this.myResolver = new MomEntityResolver(this.nodeServices);
            if (this.mainEntityName.equalsIgnoreCase(".")) {
                this.mainEntityName = this.nodeServices.getWorkingMo().getType();
            }
            if ((momEntity = this.myResolver.getMomEntity(this.mainEntityName)) instanceof MomClass) {
                this.composeClassInfo((MomClass)momEntity);
            } else if (momEntity instanceof MomStruct) {
                this.composeStructInfo((MomStruct)momEntity);
            } else if (momEntity instanceof MomEnum) {
                this.composeEnumInfo((MomEnum)momEntity);
            } else {
                this.printout.addErrorText("Unsupported MOM Entity");
            }
        }
        catch (ResolveFailureException resolveFailureException) {
            this.printout.addErrorText(resolveFailureException.getMessage());
        }
        catch (Exception exception) {
            Log.trace(InfoCommand.class, "Could not get a MomEntityResolver:" + exception.getMessage());
            this.printout.addErrorText(exception.getMessage());
        }
        if (!this.printout.isErrorPrintout()) {
            this.printout.addEndText();
        }
        this.sendResponse();
        Log.trace(InfoCommand.class, "execute() done");
    }

    private void composeEnumInfo(MomEnum momEnum) {
        Log.trace(InfoCommand.class, "composeEnumInfo(" + momEnum.getName() + ")");
        this.printout.addEnumDescription(momEnum);
    }

    private void composeStructInfo(MomStruct momStruct) throws Exception {
        Log.trace(InfoCommand.class, "composeStructInfo(" + momStruct.getName() + ")");
        if (this.memberList.size() == 0 && !this.allFlag) {
            this.printout.addStructDescription(momStruct);
        } else {
            this.printout.addDescriptionHeader(momStruct);
            if (this.allFlag) {
                momStruct.getDescription();
                this.printout.addStructMemberDescription(momStruct.getMembers());
                this.nodeServices.getMimModel().cleanUp();
            } else {
                ArrayList<MomStructMember> arrayList = new ArrayList<MomStructMember>(0);
                Iterator iterator = this.memberList.iterator();
                block0: while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Iterator iterator2 = momStruct.getMembers();
                    while (iterator2.hasNext()) {
                        MomStructMember momStructMember = (MomStructMember)iterator2.next();
                        if (!momStructMember.getName().equalsIgnoreCase(string)) continue;
                        arrayList.add(momStructMember);
                        continue block0;
                    }
                }
                this.printout.addStructMemberDescription(arrayList.iterator());
            }
        }
    }

    private void composeClassInfo(MomClass momClass) throws Exception {
        Log.trace(InfoCommand.class, "composeClassInfo(" + momClass.getName() + ")");
        MomInsensitiveSearch momInsensitiveSearch = new MomInsensitiveSearch(this.nodeServices.getMimModel());
        if (this.memberList.size() == 0 && !this.allFlag) {
            this.printout.addClassDescription(momClass);
        } else {
            this.printout.addDescriptionHeader(momClass);
            if (this.allFlag) {
                momClass.getDescription();
                this.printout.addActionsDescription(momClass.getActions());
                this.printout.addAttributesDescription(momClass.getAttributes());
                this.nodeServices.getMimModel().cleanUp();
            } else {
                ArrayList<MomAction> arrayList = new ArrayList<MomAction>(0);
                ArrayList<MomAction> arrayList2 = new ArrayList<MomAction>(0);
                Iterator iterator = this.memberList.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    MomEntity momEntity = momInsensitiveSearch.findAction(string, momClass);
                    if (momEntity != null) {
                        arrayList2.add((MomAction)momEntity);
                        continue;
                    }
                    momEntity = momClass.getAttribute(string);
                    if (momEntity == null) continue;
                    arrayList.add((MomAction)momEntity);
                }
                this.printout.addActionsDescription(arrayList2.iterator());
                this.printout.addAttributesDescription(arrayList.iterator());
            }
        }
    }

    public void setAllFlag(boolean bl) {
        this.allFlag = bl;
    }

    public void setMainEntity(String string) {
        this.mainEntityName = string;
    }

    public void setMemberList(ArrayList arrayList) {
        this.memberList = arrayList;
    }
}

