/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.ncli.server.services;

import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MimParser;
import se.ericsson.cello.ncli.server.configuration.ConfigurationReader;
import se.ericsson.cello.ncli.server.exceptions.MemoryNotSufficientException;
import se.ericsson.cello.ncli.server.exceptions.MomAwarenessNotSupportedException;
import se.ericsson.cello.ncli.server.exceptions.ReadMomErrorException;
import se.ericsson.cello.ncli.server.logging.Log;
import se.ericsson.cello.ncli.server.services.MemoryChecking;

public class MimModelFactory {
    public static MimModel createMimModel(ConfigurationReader configurationReader, MemoryChecking memoryChecking) throws MomAwarenessNotSupportedException, MemoryNotSufficientException, ReadMomErrorException {
        Object object;
        if (!configurationReader.isMomAware()) {
            Log.trace(MimModelFactory.class, "createMimModel(). MomAwarenessNotSupportedException() occurred.");
            throw new MomAwarenessNotSupportedException();
        }
        String string = configurationReader.getMomFilePath();
        long l = configurationReader.getRequiredFreeMemory();
        long l2 = 0L;
        try {
            object = new File(string);
            l2 = ((File)object).length();
        }
        catch (Exception exception) {
            ReadMomErrorException readMomErrorException = new ReadMomErrorException(exception);
            Log.info(MimModelFactory.class, "createMimModel(). ReadMomErrorException occured.", exception);
            throw readMomErrorException;
        }
        memoryChecking.sufficientMemoryToStoreMom(l2, l);
        try {
            object = ParserFactory.makeParser("com.microstar.xml.SAXDriver");
            ParserAdapter parserAdapter = new ParserAdapter((Parser)object);
            parserAdapter.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new StringReader(""));
                }
            });
            Log.trace(MimModelFactory.class, "createMimModel(). Start reading the MOM XML File at path=" + string);
            MimModel mimModel = MimParser.parse(string, 2, parserAdapter);
            if (mimModel.hasWarnings()) {
                Log.info(MimModelFactory.class, "MimModel generated by MimParser contain warnings");
                Iterator iterator = mimModel.getWarningList();
                while (iterator.hasNext()) {
                    Log.trace(class$se$ericsson$cello$ncli$server$services$MimModelFactory == null ? MimModelFactory.class$("se.ericsson.cello.ncli.server.services.MimModelFactory") : class$se$ericsson$cello$ncli$server$services$MimModelFactory, (String)iterator.next());
                }
            }
            Log.trace(MimModelFactory.class, "createMimModel(). Reading the MOM XML File is done.");
            return mimModel;
        }
        catch (Exception exception) {
            ReadMomErrorException readMomErrorException = new ReadMomErrorException(exception);
            Log.info(MimModelFactory.class, "createMimModel(). ReadMomErrorException occured.", exception);
            throw readMomErrorException;
        }
    }
}

