/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1OutputStream;
import com.maverick.crypto.asn1.ASN1Sequence;
import com.maverick.crypto.asn1.ASN1Set;
import com.maverick.crypto.asn1.BERConstructedOctetString;
import com.maverick.crypto.asn1.BERConstructedSequence;
import com.maverick.crypto.asn1.BEROutputStream;
import com.maverick.crypto.asn1.DEREncodable;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERTaggedObject;
import java.io.IOException;
import java.util.Enumeration;

public class BERTaggedObject
extends DERTaggedObject {
    public BERTaggedObject(int n, DEREncodable dEREncodable) {
        super(n, dEREncodable);
    }

    public BERTaggedObject(boolean bl, int n, DEREncodable dEREncodable) {
        super(bl, n, dEREncodable);
    }

    public BERTaggedObject(int n) {
        super(false, n, new BERConstructedSequence());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(0xA0 | this.bc);
            dEROutputStream.write(128);
            if (!this.cc) {
                if (!this.ac) {
                    if (this.dc instanceof ASN1OctetString) {
                        Enumeration enumeration;
                        if (this.dc instanceof BERConstructedOctetString) {
                            enumeration = ((BERConstructedOctetString)this.dc).getObjects();
                        } else {
                            ASN1OctetString aSN1OctetString = (ASN1OctetString)this.dc;
                            BERConstructedOctetString bERConstructedOctetString = new BERConstructedOctetString(aSN1OctetString.getOctets());
                            enumeration = bERConstructedOctetString.getObjects();
                        }
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    } else if (this.dc instanceof ASN1Sequence) {
                        Enumeration enumeration = ((ASN1Sequence)this.dc).getObjects();
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    } else {
                        if (!(this.dc instanceof ASN1Set)) throw new RuntimeException("not implemented: " + this.dc.getClass().getName());
                        Enumeration enumeration = ((ASN1Set)this.dc).getObjects();
                        while (enumeration.hasMoreElements()) {
                            dEROutputStream.writeObject(enumeration.nextElement());
                        }
                    }
                } else {
                    dEROutputStream.writeObject(this.dc);
                }
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
            return;
        } else {
            super.encode(dEROutputStream);
        }
    }
}

