/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.asn1;

import com.maverick.crypto.asn1.ASN1OctetString;
import com.maverick.crypto.asn1.ASN1TaggedObject;
import com.maverick.crypto.asn1.DERObject;
import com.maverick.crypto.asn1.DEROutputStream;
import com.maverick.crypto.asn1.DERString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERUTF8String
extends DERObject
implements DERString {
    String hb;

    public static DERUTF8String getInstance(Object object) {
        if (object == null || object instanceof DERUTF8String) {
            return (DERUTF8String)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERUTF8String(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERUTF8String.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERUTF8String getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERUTF8String.getInstance(aSN1TaggedObject.getObject());
    }

    DERUTF8String(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            ++n2;
            if ((byArray[n] & 0xE0) == 224) {
                n += 3;
                continue;
            }
            if ((byArray[n] & 0xC0) == 192) {
                n += 2;
                continue;
            }
            ++n;
        }
        char[] cArray = new char[n2];
        n = 0;
        n2 = 0;
        while (n < byArray.length) {
            char c2;
            if ((byArray[n] & 0xE0) == 224) {
                c2 = (char)((byArray[n] & 0x1F) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F);
                n += 3;
            } else if ((byArray[n] & 0xC0) == 192) {
                c2 = (char)((byArray[n] & 0x3F) << 6 | byArray[n + 1] & 0x3F);
                n += 2;
            } else {
                c2 = (char)(byArray[n] & 0xFF);
                ++n;
            }
            cArray[n2++] = c2;
        }
        this.hb = new String(cArray);
    }

    public DERUTF8String(String string) {
        this.hb = string;
    }

    public String getString() {
        return this.hb;
    }

    public int hashCode() {
        return this.getString().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DERUTF8String)) {
            return false;
        }
        DERUTF8String dERUTF8String = (DERUTF8String)object;
        return this.getString().equals(dERUTF8String.getString());
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.hb.toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int k = 0; k != cArray.length; ++k) {
            char c2 = cArray[k];
            if (c2 < '\u0080') {
                byteArrayOutputStream.write(c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteArrayOutputStream.write(0xC0 | c2 >> 6);
                byteArrayOutputStream.write(0x80 | c2 & 0x3F);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | c2 >> 12);
            byteArrayOutputStream.write(0x80 | c2 >> 6 & 0x3F);
            byteArrayOutputStream.write(0x80 | c2 & 0x3F);
        }
        dEROutputStream.b(12, byteArrayOutputStream.toByteArray());
    }
}

