/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.security;

import com.maverick.crypto.digests.SHA1Digest;
import java.util.Random;

public class SecureRandom
extends Random {
    private static SecureRandom e = new SecureRandom();
    private long c = 1L;
    private SHA1Digest g = new SHA1Digest();
    private byte[] f = new byte[this.g.getDigestSize()];
    private byte[] b = new byte[4];
    private byte[] d = new byte[8];

    public SecureRandom() {
        super(0L);
        this.setSeed(System.currentTimeMillis());
    }

    public SecureRandom(byte[] byArray) {
        this.setSeed(byArray);
    }

    public static SecureRandom getInstance(String string) {
        return new SecureRandom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureRandom getInstance() {
        SecureRandom secureRandom = e;
        synchronized (secureRandom) {
            e.setSeed(System.currentTimeMillis());
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getSeed(int n) {
        byte[] byArray = new byte[n];
        SecureRandom secureRandom = e;
        synchronized (secureRandom) {
            e.setSeed(System.currentTimeMillis());
            e.nextBytes(byArray);
        }
        return byArray;
    }

    public byte[] generateSeed(int n) {
        byte[] byArray = new byte[n];
        this.nextBytes(byArray);
        return byArray;
    }

    public synchronized void setSeed(byte[] byArray) {
        this.g.update(byArray, 0, byArray.length);
    }

    public synchronized void nextBytes(byte[] byArray) {
        this.nextBytes(byArray, 0, byArray.length);
    }

    public synchronized void nextBytes(byte[] byArray, int n, int n2) {
        int n3 = 0;
        this.g.doFinal(this.f, 0);
        for (int k = 0; k != n2; ++k) {
            if (n3 == this.f.length) {
                byte[] byArray2 = this.b(this.c++);
                this.g.update(byArray2, 0, byArray2.length);
                this.g.update(this.f, 0, this.f.length);
                this.g.doFinal(this.f, 0);
                n3 = 0;
            }
            byArray[k + n] = this.f[n3++];
        }
        byte[] byArray3 = this.b(this.c++);
        this.g.update(byArray3, 0, byArray3.length);
        this.g.update(this.f, 0, this.f.length);
    }

    public synchronized void setSeed(long l) {
        if (l != 0L) {
            this.setSeed(this.b(l));
        }
    }

    public synchronized int nextInt() {
        this.nextBytes(this.b);
        int n = 0;
        for (int k = 0; k < 4; ++k) {
            n = (n << 8) + (this.b[k] & 0xFF);
        }
        return n;
    }

    protected final synchronized int next(int n) {
        int n2 = (n + 7) / 8;
        byte[] byArray = new byte[n2];
        this.nextBytes(byArray);
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            n3 = (n3 << 8) + (byArray[k] & 0xFF);
        }
        return n3 & (1 << n) - 1;
    }

    private synchronized byte[] b(long l) {
        for (int k = 0; k != 8; ++k) {
            this.d[k] = (byte)l;
            l >>>= 8;
        }
        return this.d;
    }
}

