/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshHmac;
import com.maverick.ssh.components.jce.JCEProvider;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public abstract class AbstractHmac
implements SshHmac {
    protected Mac mac;
    protected int macSize;
    protected int macLength;
    protected String jceAlgorithm;

    public AbstractHmac(String string, int n) {
        this(string, n, n);
    }

    public AbstractHmac(String string, int n, int n2) {
        this.jceAlgorithm = string;
        this.macSize = n;
        this.macLength = n2;
    }

    public void generate(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte[] byArray3 = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)(l >> 0)};
        this.mac.update(byArray3);
        this.mac.update(byArray, n, n2);
        byte[] byArray4 = this.mac.doFinal();
        System.arraycopy(byArray4, 0, byArray2, n3, this.macLength);
    }

    public void update(byte[] byArray) {
        this.mac.update(byArray);
    }

    public byte[] doFinal() {
        return this.mac.doFinal();
    }

    public abstract String getAlgorithm();

    public String getProvider() {
        return this.mac.getProvider().getName();
    }

    public int getMacLength() {
        return this.macLength;
    }

    public void init(byte[] byArray) throws SshException {
        try {
            this.mac = JCEProvider.getProviderForAlgorithm(this.jceAlgorithm) == null ? Mac.getInstance(this.jceAlgorithm) : Mac.getInstance(this.jceAlgorithm, JCEProvider.getProviderForAlgorithm(this.jceAlgorithm));
            byte[] byArray2 = new byte[this.macSize];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, this.jceAlgorithm);
            this.mac.init(secretKeySpec);
        }
        catch (Throwable throwable) {
            throw new SshException(throwable);
        }
    }

    public boolean verify(long l, byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = this.getMacLength();
        byte[] byArray3 = new byte[n4];
        this.generate(l, byArray, n, n2, byArray3, 0);
        for (int k = 0; k < byArray3.length; ++k) {
            if (byArray2[k + n3] == byArray3[k]) continue;
            return false;
        }
        return true;
    }
}

