/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.jce;

import com.maverick.ssh.SshException;
import com.maverick.ssh.SshKeyFingerprint;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh.components.SshRsaPublicKey;
import com.maverick.ssh.components.jce.JCEProvider;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;

public class Ssh2RsaPublicKey
implements SshRsaPublicKey {
    RSAPublicKey c;

    public Ssh2RsaPublicKey() {
    }

    public Ssh2RsaPublicKey(RSAPublicKey rSAPublicKey) {
        this.c = rSAPublicKey;
    }

    public Ssh2RsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        this.c = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
    }

    public byte[] getEncoded() throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithm());
            byteArrayWriter.writeBigInteger(this.c.getPublicExponent());
            byteArrayWriter.writeBigInteger(this.c.getModulus());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            throw new SshException("Failed to encoded key data", 5, iOException);
        }
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    public int getBitLength() {
        return this.c.getModulus().bitLength();
    }

    public void init(byte[] byArray, int n, int n2) throws SshException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, n, n2);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithm())) {
                throw new SshException("The encoded key is not RSA", 5);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            try {
                KeyFactory keyFactory = JCEProvider.getProviderForAlgorithm("RSA") == null ? KeyFactory.getInstance("RSA") : KeyFactory.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
                this.c = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new SshException("Failed to obtain RSA key instance from JCE", 5, exception);
            }
        }
        catch (IOException iOException) {
            throw new SshException("Failed to read encoded key data", 5);
        }
    }

    public String getAlgorithm() {
        return "ssh-rsa";
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws SshException {
        try {
            Object object;
            if (byArray.length != 128) {
                object = new ByteArrayReader(byArray);
                byte[] byArray3 = ((ByteArrayReader)object).readBinaryString();
                String string = new String(byArray3);
                byArray = ((ByteArrayReader)object).readBinaryString();
            }
            object = JCEProvider.getProviderForAlgorithm("SHA1WithRSA") == null ? Signature.getInstance("SHA1WithRSA") : Signature.getInstance("SHA1WithRSA", JCEProvider.getProviderForAlgorithm("SHA1WithRSA"));
            ((Signature)object).initVerify(this.c);
            ((Signature)object).update(byArray2);
            return ((Signature)object).verify(byArray);
        }
        catch (Exception exception) {
            throw new SshException(16, (Throwable)exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SshRsaPublicKey) {
            try {
                return ((SshPublicKey)object).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException sshException) {
            return 0;
        }
    }

    public BigInteger doPublic(BigInteger bigInteger) throws SshException {
        try {
            Cipher cipher = JCEProvider.getProviderForAlgorithm("RSA") == null ? Cipher.getInstance("RSA") : Cipher.getInstance("RSA", JCEProvider.getProviderForAlgorithm("RSA"));
            cipher.init(1, (Key)this.c, JCEProvider.getSecureRandom());
            byte[] byArray = bigInteger.toByteArray();
            return new BigInteger(cipher.doFinal(byArray, byArray[0] == 0 ? 1 : 0, byArray[0] == 0 ? byArray.length - 1 : byArray.length));
        }
        catch (Throwable throwable) {
            if (throwable.getMessage().indexOf("RSA") > -1) {
                throw new SshException("JCE provider requires BouncyCastle provider for RSA/NONE/PKCS1Padding component. Add bcprov.jar to your classpath or configure an alternative provider for this algorithm", 5);
            }
            throw new SshException(throwable);
        }
    }

    public BigInteger getModulus() {
        return this.c.getModulus();
    }

    public BigInteger getPublicExponent() {
        return this.c.getPublicExponent();
    }

    public int getVersion() {
        return 2;
    }
}

