/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.ssh.components.standalone;

import com.maverick.crypto.publickey.DsaPublicKey;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshKeyFingerprint;
import com.maverick.ssh.components.SshDsaPublicKey;
import com.maverick.util.ByteArrayReader;
import com.maverick.util.ByteArrayWriter;
import java.io.IOException;
import java.math.BigInteger;

public class Ssh2DsaPublicKey
extends DsaPublicKey
implements SshDsaPublicKey {
    public Ssh2DsaPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(bigInteger, bigInteger2, bigInteger3, bigInteger4);
    }

    public String getAlgorithm() {
        return "ssh-dss";
    }

    public Ssh2DsaPublicKey() {
    }

    public byte[] getEncoded() throws SshException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithm());
            byteArrayWriter.writeBigInteger(this.p);
            byteArrayWriter.writeBigInteger(this.q);
            byteArrayWriter.writeBigInteger(this.g);
            byteArrayWriter.writeBigInteger(this.y);
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public String getFingerprint() throws SshException {
        return SshKeyFingerprint.getFingerprint(this.getEncoded());
    }

    public void init(byte[] byArray, int n, int n2) throws SshException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, n, n2);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithm())) {
                throw new SshException("Invalid public key header", 4);
            }
            this.p = byteArrayReader.readBigInteger();
            this.q = byteArrayReader.readBigInteger();
            this.g = byteArrayReader.readBigInteger();
            this.y = byteArrayReader.readBigInteger();
        }
        catch (IOException iOException) {
            throw new SshException(iOException, 5);
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        try {
            if (byArray.length != 40) {
                ByteArrayReader byteArrayReader = new ByteArrayReader(byArray, 0, byArray.length);
                byte[] byArray3 = byteArrayReader.readBinaryString();
                String string = new String(byArray3);
                if (!string.equals(this.getAlgorithm())) {
                    return false;
                }
                byArray = byteArrayReader.readBinaryString();
            }
            return super.verifySignature(byArray, byArray2);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Ssh2DsaPublicKey) {
            try {
                return ((Ssh2DsaPublicKey)object).getFingerprint().equals(this.getFingerprint());
            }
            catch (SshException sshException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getFingerprint().hashCode();
        }
        catch (SshException sshException) {
            return 0;
        }
    }
}

