/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.ssh.SshException;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.util.Base64;
import com.sshtools.publickey.SshPublicKeyFile;
import com.sshtools.publickey.SshPublicKeyFileFactory;
import java.io.IOException;

public class OpenSSHPublicKeyFile
implements SshPublicKeyFile {
    byte[] t;
    String u;

    OpenSSHPublicKeyFile(byte[] byArray) throws IOException {
        this.t = byArray;
        this.toPublicKey();
    }

    OpenSSHPublicKeyFile(SshPublicKey sshPublicKey, String string) throws IOException {
        try {
            String string2 = sshPublicKey.getAlgorithm() + " " + Base64.encodeBytes(sshPublicKey.getEncoded(), true);
            if (string != null) {
                string2 = string2 + " " + string;
            }
            this.t = string2.getBytes();
        }
        catch (SshException sshException) {
            throw new IOException("Failed to encode public key");
        }
    }

    public String toString() {
        return new String(this.t);
    }

    public byte[] getFormattedKey() {
        return this.t;
    }

    public SshPublicKey toPublicKey() throws IOException {
        String string;
        String string2 = new String(this.t);
        int n = string2.indexOf(" ");
        if (n > 0 && ((string = string2.substring(0, n)).equals("ssh-dss") || string.equals("ssh-rsa"))) {
            int n2 = string2.indexOf(" ", n + 1);
            if (n2 != -1) {
                String string3 = string2.substring(n + 1, n2);
                if (string2.length() > n2) {
                    this.u = string2.substring(n2 + 1).trim();
                }
                return SshPublicKeyFileFactory.decodeSSH2PublicKey(string, Base64.decode(string3));
            }
            String string4 = string2.substring(n + 1);
            return SshPublicKeyFileFactory.decodeSSH2PublicKey(string, Base64.decode(string4));
        }
        throw new IOException("Key format not supported!");
    }

    public String getComment() {
        return this.u;
    }
}

