/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.control;

import se.ericsson.cello.configurationversion.base.IllegalInputDataException;
import se.ericsson.cello.configurationversion.cancelrestore.RestoreCanceller;
import se.ericsson.cello.configurationversion.changerestoreconfirmationtimeout.ChangeRestoreConfirmationTimeout;
import se.ericsson.cello.configurationversion.changerestoreconfirmationtimeout.ChangeRestoreConfirmationTimeoutException;
import se.ericsson.cello.configurationversion.configcountdown.ConfigCountdownActivatedController;
import se.ericsson.cello.configurationversion.control.CV_ControllerClientInterface;
import se.ericsson.cello.configurationversion.control.CV_ControllerNonBlockingClientInterface;
import se.ericsson.cello.configurationversion.create.CV_Creator;
import se.ericsson.cello.configurationversion.delete.Remover;
import se.ericsson.cello.configurationversion.export.control.Exporter;
import se.ericsson.cello.configurationversion.generatedbdump.control.GenerateDbDumper;
import se.ericsson.cello.configurationversion.importer.Importer;
import se.ericsson.cello.configurationversion.main.event.actionresult.CV_ActionResultDataTypeOfInvokedActionValue;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionActivateRobustReconfigurationInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionCancelRestoreInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionChangeRestoreConfirmationTimeoutInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionConfirmRestoreInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionCreateInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionDeactivateRobustReconfigurationInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionDeleteInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionGenerateDbDumpInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionGetFromFTP_ServerInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionPutToFTP_ServerInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionRemoveFromRollbackListInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionRestoreInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionSetFirstRollbackListInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionSetStartableInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedActionVerifyRestoreInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedCountdownActivatedInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.InvokedEmergencyRestoreInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.RobustReconfigurationActiveAfterRecoveryInformation;
import se.ericsson.cello.configurationversion.main.event.actionresult.RobustReconfigurationActiveInformation;
import se.ericsson.cello.configurationversion.main.exception.ActionNotAllowedException;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.exception.FunctionBusyException;
import se.ericsson.cello.configurationversion.restore.ConfirmRestorer;
import se.ericsson.cello.configurationversion.restore.ContinueRestorer;
import se.ericsson.cello.configurationversion.restore.EmergencyRestorer;
import se.ericsson.cello.configurationversion.restore.Restorer;
import se.ericsson.cello.configurationversion.robustreconfiguration.control.RobustReconfigurationActivator;
import se.ericsson.cello.configurationversion.robustreconfiguration.control.RobustReconfigurationDeactivator;
import se.ericsson.cello.configurationversion.rollbacklist.RollbackListContentsController;
import se.ericsson.cello.configurationversion.service.ServiceController;
import se.ericsson.cello.configurationversion.service.ServiceTypeInformation;
import se.ericsson.cello.configurationversion.startable.SetStartableController;
import se.ericsson.cello.configurationversion.verify.control.RestoreVerifier;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceSubType;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceType;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMo;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class CV_Controller {
    private boolean myIsBusy = false;
    private CV_ActionResultDataTypeOfInvokedActionValue myExecutingFunction = null;
    private static CV_Controller myInstance = null;
    private CV_ControllerClientInterface myClient = null;
    private boolean isWaitingForConfirmationOfRestore = false;
    private Exporter myExporter = null;
    private CV_Creator myCV_Creator = null;
    private Importer myImporter = null;
    private RollbackListContentsController myRollbackListContentsController = null;
    private SetStartableController mySetStartableController = null;
    private Remover myRemover = null;
    private RestoreVerifier myRestoreVerifier = null;
    private GenerateDbDumper myGenerateDbdumper = null;
    private ConfirmRestorer myConfirmRestorer = null;
    private ContinueRestorer myContinueRestorer = null;
    private Restorer myRestorer = null;
    private RestoreCanceller myRestoreCanceller = null;
    private ChangeRestoreConfirmationTimeout myChangeRestoreConfirmationTimeoutController = null;
    private EmergencyRestorer myEmergencyRestorer = null;

    private CV_Controller() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_Controller()");
        }
    }

    public Exporter getMyExporter() {
        return this.myExporter;
    }

    public ConfirmRestorer getMyConfirmRestorer() {
        return this.myConfirmRestorer;
    }

    public synchronized void busyMark(CV_ControllerClientInterface cV_ControllerClientInterface, ServiceSubType serviceSubType) throws FunctionBusyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMark(Object aClient, ServiceSubType aServiceSubType)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taServiceSubType: " + serviceSubType);
        }
        if (cV_ControllerClientInterface == null) {
            throw new FunctionBusyException("Invalid input data when attemting to busy mark the CV function.\n\taClient: null");
        }
        if (this.myIsBusy) {
            if (this.myExecutingFunction != null) {
                throw new FunctionBusyException("The Configuration Version service is already busy with function - \n\t" + this.myExecutingFunction.getName() + "\n\tfor client: - \n\t" + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new FunctionBusyException("The Configuration Version service is already busy with an other function.");
        }
        if (!ServiceController.instance().busyMark(ServiceType.ConfigurationVersion, serviceSubType)) {
            ServiceTypeInformation serviceTypeInformation = ServiceController.instance().getExecutingServiceTypeInformation();
            String string = "\n\texecuting service: " + serviceTypeInformation.getServiceType().getValue();
            if (!serviceTypeInformation.getServiceSubType().getValue().equals(ServiceSubType.none.getValue())) {
                string = string + "\n\texecuting function: " + serviceTypeInformation.getServiceSubType().getValue();
            }
            throw new FunctionBusyException("An interacting service is executing and this prevents the requested CV function from being executed," + string);
        }
        this.myIsBusy = true;
        this.myClient = cV_ControllerClientInterface;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void busyMarkClientOnly(CV_ControllerClientInterface cV_ControllerClientInterface) throws FunctionBusyException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "busyMarkClientOnly(CV_ControllerClientInterface aClient)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface));
        }
        if (cV_ControllerClientInterface == null) throw new FunctionBusyException("Invalid input data when attempting to busy mark the client only.\n\taClient: null ");
        if (!this.myIsBusy) throw new FunctionBusyException("The Configuration Version function is not busy when attempting to busy mark the client only.\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface));
        if (this.myExecutingFunction == null) throw new FunctionBusyException("No Configuration Version function is executing when attempting to busy mark the client only.\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface));
        if (this.myClient != null) {
            throw new FunctionBusyException("The Configuration Version function is already connected to a client when attempting to busy mark the client only.\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myClient = cV_ControllerClientInterface;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void cancelRestore(CV_ControllerClientInterface cV_ControllerClientInterface) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelRestore(CV_ControllerClientInterface aClient)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface));
        }
        InvokedActionCancelRestoreInformation invokedActionCancelRestoreInformation = new InvokedActionCancelRestoreInformation();
        if (this.isBusy() && cV_ControllerClientInterface != null && cV_ControllerClientInterface != this.myClient) {
            InvokedActionRestoreInformation invokedActionRestoreInformation = new InvokedActionRestoreInformation();
            if (this.myExecutingFunction == null) throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\tcancelRestore(CV_ControllerClientInterface aClient)" + "\n\tCancel of restore is not allowed (restore is not in progress)." + "\n\tmyExecutingFunction: " + this.myExecutingFunction);
            if (this.myExecutingFunction.getIdentifier() != invokedActionRestoreInformation.getIdentifier()) throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\tcancelRestore(CV_ControllerClientInterface aClient)" + "\n\tCancel of restore is not allowed (restore is not in progress)." + "\n\tmyExecutingFunction: " + this.myExecutingFunction);
            if (this.myRestorer != null) {
                this.myRestoreCanceller = new RestoreCanceller(this.myRestorer);
                this.myExecutingFunction = invokedActionCancelRestoreInformation;
                this.myRestoreCanceller.cancelRestoreRequest();
                return;
            }
            if (this.myContinueRestorer != null) {
                this.myRestoreCanceller = new RestoreCanceller(this.myContinueRestorer);
                this.myExecutingFunction = invokedActionCancelRestoreInformation;
                this.myRestoreCanceller.cancelRestoreRequest();
                return;
            }
            if (this.myConfirmRestorer == null) throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\tcancelRestore(CV_ControllerClientInterface aClient)" + "\n\tCancel of restore is not allowed." + "\n\tmyExecutingFunction: " + this.myExecutingFunction);
            throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\tcancelRestore(CV_ControllerClientInterface aClient)" + "Not allowed to request for cancel of restore after the restore has been confirmed.");
        }
        if (this.isWaitingForConfirmationOfRestore) {
            this.myRestoreCanceller = new RestoreCanceller();
            this.myExecutingFunction = invokedActionCancelRestoreInformation;
            this.myRestoreCanceller.cancelRestoreRequest();
            return;
        }
        if (!Trace.valid(this.getClass(), 20)) throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\tcancelRestore(CV_ControllerClientInterface aClient)" + "\n\tAttempting to execute function - " + invokedActionCancelRestoreInformation.getName() + "\n\t(" + invokedActionCancelRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\tisBusy: " + this.isBusy() + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        Trace.debug(this.getClass(), 20, "cancelRestore(CV_ControllerClientInterface aClient)", "Attempting to execute function - " + invokedActionCancelRestoreInformation.getName() + "\n\t(" + invokedActionCancelRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\tcancelRestore(CV_ControllerClientInterface aClient)" + "\n\tAttempting to execute function - " + invokedActionCancelRestoreInformation.getName() + "\n\t(" + invokedActionCancelRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\tisBusy: " + this.isBusy() + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
    }

    public void changeRestoreConfirmationTimeout(CV_ControllerClientInterface cV_ControllerClientInterface, int n) throws ActionNotAllowedException, IllegalInputDataException, ChangeRestoreConfirmationTimeoutException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setRestoreConfirmationDeadline(CV_ControllerClientInterface aClient, int aTimerValueInMinutes)", "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "aTimerValueInMinutes: " + n);
        }
        InvokedActionChangeRestoreConfirmationTimeoutInformation invokedActionChangeRestoreConfirmationTimeoutInformation = new InvokedActionChangeRestoreConfirmationTimeoutInformation();
        if (!(this.isBusy() && cV_ControllerClientInterface != null && cV_ControllerClientInterface.equals(this.myClient) && this.isWaitingForConfirmationOfRestore)) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setStartable(CV_ControllerClientInterface aClient, String aCV_Name)", "Attempting to execute function - " + invokedActionChangeRestoreConfirmationTimeoutInformation.getName() + "\n\t(" + invokedActionChangeRestoreConfirmationTimeoutInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\tisBusy: " + this.isBusy() + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionChangeRestoreConfirmationTimeoutInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedActionChangeRestoreConfirmationTimeoutInformation.getSlogan() + ") " + "\n\tisBusy: " + this.isBusy() + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myChangeRestoreConfirmationTimeoutController = new ChangeRestoreConfirmationTimeout();
        this.myChangeRestoreConfirmationTimeoutController.changeRestoreConfirmationTimeout(n);
        this.myExecutingFunction = invokedActionChangeRestoreConfirmationTimeoutInformation;
    }

    public void confirmRestore(CV_ControllerClientInterface cV_ControllerClientInterface, UpgradePackageMo upgradePackageMo, String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "confirmRestore(CV_ControllerClientInterface aClient, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string);
        }
        InvokedActionConfirmRestoreInformation invokedActionConfirmRestoreInformation = new InvokedActionConfirmRestoreInformation();
        if (!this.isBusy() || !this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "confirmRestore(CV_ControllerClientInterface aClient, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "Attempting to execute function - " + invokedActionConfirmRestoreInformation.getName() + "\n\t(" + invokedActionConfirmRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\tconfirmRestore(CV_ControllerClientInterface aClient, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)" + "\n\tAttempting to execute function - " + invokedActionConfirmRestoreInformation.getName() + "\n\t(" + invokedActionConfirmRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myConfirmRestorer = new ConfirmRestorer();
        this.myConfirmRestorer.initiateThread();
        this.myConfirmRestorer.confirmRestoreRequest(upgradePackageMo, string);
        this.myExecutingFunction = invokedActionConfirmRestoreInformation;
        this.isWaitingForConfirmationOfRestore = false;
    }

    public void confirmRestoreResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "continueRestoreResponse()");
        }
        if (this.myClient != null) {
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.restore);
        } else {
            Trace.warning(this.getClass(), "continueRestoreResponse()", "A confirm restore response event was received when no client is expecting it.\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    public void continueRestore(CV_ControllerClientInterface cV_ControllerClientInterface) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "continueRestore(CV_ControllerClientInterface aClient", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface));
        }
        InvokedActionRestoreInformation invokedActionRestoreInformation = new InvokedActionRestoreInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "continueRestore(CV_ControllerClientInterface aClient)", "Attempting to execute function - " + invokedActionRestoreInformation.getName() + "\n\t(" + invokedActionRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\tcontinueRestore(CV_ControllerClientInterface aClient)" + "\n\tAttempting to execute function - " + invokedActionRestoreInformation.getName() + "\n\t(" + invokedActionRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myContinueRestorer = new ContinueRestorer();
        this.myContinueRestorer.initiateThread();
        this.myContinueRestorer.continueRestoreRequest();
        this.myExecutingFunction = invokedActionRestoreInformation;
    }

    public void continueRestoreResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "continueRestoreResponse()");
        }
        if (this.myClient != null) {
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.restore, true);
            this.isWaitingForConfirmationOfRestore = true;
        } else {
            Trace.warning(this.getClass(), "continueRestoreResponse()", "A restore response event was received when no client is expecting it.\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    public void create(CV_ControllerClientInterface cV_ControllerClientInterface, UpgradePackageMo upgradePackageMo, String string, String string2, int n, String string3, String string4, String string5, boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "create(CV_ControllerClientInterface aClient, UpgradePackageMo aCurrentUpgradePackageMo, String aConfigurationVersionName, String anIdentity, int aType, String anUpgradePackageDocumentId, String anOperatorName, String aComment)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCurrentUpgradePackageMo: " + upgradePackageMo + "\n\taConfigurationVersionName: " + string + "\n\tanIdentity: " + string2 + "\n\taType: " + n + "\n\tanUpgradePackageDocumentId: " + string3 + "\n\tanOperatorName: " + string4 + "\n\taComment: " + string5 + "\n\tanIsLongCreationTimeoutValueToBeUsed: " + bl);
        }
        InvokedActionCreateInformation invokedActionCreateInformation = new InvokedActionCreateInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "create(UpgradePackageMo aCurrentUpgradePackageMo, String aConfigurationVersionName, String anIdentity, int aType, String anUpgradePackageDocumentId, String anOperatorName, String aComment)", "Attempting to execute function - " + invokedActionCreateInformation.getName() + "\n\t(" + invokedActionCreateInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCurrentUpgradePackageMo: " + upgradePackageMo + "\n\taConfigurationVersionName: " + string + "\n\tanIdentity: " + string2 + "\n\taType: " + n + "\n\tanUpgradePackageDocumentId: " + string3 + "\n\tanOperatorName: " + string4 + "\n\taComment: " + string5 + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionCreateInformation.getName() + "\n\t(" + invokedActionCreateInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCurrentUpgradePackageMo: " + upgradePackageMo + "\n\taConfigurationVersionName: " + string + "\n\tanIdentity: " + string2 + "\n\taType: " + n + "\n\tanUpgradePackageDocumentId: " + string3 + "\n\tanOperatorName: " + string4 + "\n\taComment: " + string5 + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myCV_Creator = new CV_Creator();
        this.myExecutingFunction = invokedActionCreateInformation;
        this.myCV_Creator.create(upgradePackageMo, string, string2, n, string3, string4, string5, bl);
    }

    public void delete(CV_ControllerClientInterface cV_ControllerClientInterface, String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "delete(CV_ControllerClientInterface aClient, String aCV_Name)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCV_Name: " + string);
        }
        InvokedActionDeleteInformation invokedActionDeleteInformation = new InvokedActionDeleteInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "delete(CV_ControllerClientInterface aClient, String aCV_Name)", "Attempting to execute function - " + invokedActionDeleteInformation.getName() + "\n\t(" + invokedActionDeleteInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionDeleteInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedActionDeleteInformation.getSlogan() + ") " + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myRemover = new Remover();
        this.myExecutingFunction = invokedActionDeleteInformation;
        this.myRemover.remove(string);
    }

    public void emergencyRestore(CV_ControllerClientInterface cV_ControllerClientInterface, boolean bl, boolean bl2, UpgradePackageMo upgradePackageMo, String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "emergencyRestore(CV_ControllerClientInterface aClient, boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tanAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string);
        }
        InvokedEmergencyRestoreInformation invokedEmergencyRestoreInformation = new InvokedEmergencyRestoreInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "emergencyRestore(CV_ControllerClientInterface aClient, boolean anAutoConfigFileExists, boolean anIP_NetworkConfigFileExists, UpgradePackageMo aCurrentUpgradePackage, String aMissingCurrentUP_Information)", "Attempting to execute function - " + invokedEmergencyRestoreInformation.getName() + "\n\t(" + invokedEmergencyRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tanAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedEmergencyRestoreInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedEmergencyRestoreInformation.getSlogan() + ") " + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tanAutoConfigFileExists: " + bl + "\n\tanIP_NetworkConfigFileExists: " + bl2 + "\n\taCurrentUpgradePackage: " + upgradePackageMo + "\n\taMissingCurrentUP_Information: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myEmergencyRestorer = new EmergencyRestorer();
        this.myExecutingFunction = invokedEmergencyRestoreInformation;
        this.myEmergencyRestorer.emergencyRestoreRequest(bl, bl2, upgradePackageMo, string);
    }

    public void export(CV_ControllerClientInterface cV_ControllerClientInterface, String string, String string2, String string3, String string4, String string5, String string6) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "export(Object aClient, String aCV_Name, String aPathOnFTP_Server, String aCV_BackupNameOnFTP_Server, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCV_Name: " + string + "\n\taPathOnFTP_Server: " + string2 + "\n\taCV_BackupNameOnFTP_Server: " + string3 + "\n\tanFTP_ServerIP_Address: " + string4 + "\n\tanFTP_ServerUserID: " + string5 + "\n\tanFTP_ServerPassword: " + "****");
        }
        InvokedActionPutToFTP_ServerInformation invokedActionPutToFTP_ServerInformation = new InvokedActionPutToFTP_ServerInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "exportRequest(String aCV_Name, String aPathOnFTP_Server, String aCV_BackupNameOnFTP_Server, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword)", "Attempting to execute function - " + invokedActionPutToFTP_ServerInformation.getName() + "\n\t(" + invokedActionPutToFTP_ServerInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCV_Name: " + string + "\n\taPathOnFTP_Server: " + string2 + "\n\taCV_BackupNameOnFTP_Server: " + string3 + "\n\tanFTP_ServerIP_Address: " + string4 + "\n\tanFTP_ServerUserID: " + string5 + "\n\tanFTP_ServerPassword: " + "****" + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionPutToFTP_ServerInformation.getName() + "\n\t(" + invokedActionPutToFTP_ServerInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCV_Name: " + string + "\n\taPathOnFTP_Server: " + string2 + "\n\taCV_BackupNameOnFTP_Server: " + string3 + "\n\tanFTP_ServerIP_Address: " + string4 + "\n\tanFTP_ServerUserID: " + string5 + "\n\tanFTP_ServerPassword: " + "****" + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myExporter = new Exporter();
        this.myExporter.initiateThread();
        this.myExporter.exportRequest(string, string2, string3, string4, string5, string6);
        this.myExecutingFunction = invokedActionPutToFTP_ServerInformation;
    }

    public void exportResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "exportResponse()");
        }
        if (this.myClient != null) {
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.exportCV);
        } else {
            Trace.warning(this.getClass(), "exportResponse()", "An export response event was received when no client is expecting it.\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    public synchronized void freeMark(CV_ControllerClientInterface cV_ControllerClientInterface, ServiceSubType serviceSubType) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "freeMark(CV_ControllerClientInterface aCV_ControllerClientInterface, ServiceSubType aServiceSubType)", "aCV_ControllerClientInterface: " + ((Object)cV_ControllerClientInterface).toString() + "\n\taServiceSubType: " + serviceSubType);
        }
        if (this.myIsBusy) {
            if (this.myClient != null && this.myClient.equals(cV_ControllerClientInterface)) {
                this.myIsBusy = false;
                this.myClient = null;
                this.myExecutingFunction = null;
                ServiceController.instance().freeMark(ServiceType.ConfigurationVersion, serviceSubType);
            } else {
                Trace.warning(this.getClass(), "freeMark(CV_ControllerClientInterface aCV_ControllerClientInterface, ServiceSubType aServiceSubType)", "An attempt to free mark the CV function when it was busy (from an other client).");
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "freeMark(CV_ControllerClientInterface aCV_ControllerClientInterface, ServiceSubType aServiceSubType)", "An attempt to free mark the CV function when it already was idle.");
        }
    }

    public synchronized void freeMarkClientOnly(CV_ControllerClientInterface cV_ControllerClientInterface) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "freeMarkClientOnly(CV_ControllerClientInterface aCV_ControllerClientInterface)", "aCV_ControllerClientInterface: " + ((Object)cV_ControllerClientInterface).toString());
        }
        if (this.myIsBusy) {
            if (this.myClient != null && this.myClient.equals(cV_ControllerClientInterface)) {
                this.myClient = null;
            } else {
                Trace.warning(this.getClass(), "freeMarkClientOnly(CV_ControllerClientInterface aCV_ControllerClientInterface)", "An attempt to free mark the client only when it was busy marked (by an other client) or 'null'.");
            }
        } else if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "freeMarkClientOnly(CV_ControllerClientInterface aCV_ControllerClientInterface)", "An attempt to free mark the client only when the CV function was idle.");
        }
    }

    public void importCV(CV_ControllerClientInterface cV_ControllerClientInterface, String string, String string2, String string3, String string4) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "importCV(CV_ControllerClientInterface aClient, String aFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****");
        }
        InvokedActionGetFromFTP_ServerInformation invokedActionGetFromFTP_ServerInformation = new InvokedActionGetFromFTP_ServerInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "importCV(CV_ControllerClientInterface aClient, String aFilePathAndCvBackupZipName, String anFTP_ServerIP_Address, String anFTP_ServerUserID, String anFTP_ServerPassword)", "Attempting to execute function - " + invokedActionGetFromFTP_ServerInformation.getName() + "\n\t(" + invokedActionGetFromFTP_ServerInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionGetFromFTP_ServerInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedActionGetFromFTP_ServerInformation.getSlogan() + ") " + "\n\taFilePathAndCvBackupZipName: " + string + "\n\tanFTP_ServerIP_Address: " + string2 + "\n\tanFTP_ServerUserID: " + string3 + "\n\tanFTP_ServerPassword: " + "****" + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myImporter = new Importer();
        this.myImporter.initiateThread();
        this.myImporter.importRequest(string, string2, string3, string4);
        this.myExecutingFunction = invokedActionGetFromFTP_ServerInformation;
    }

    public void importResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "importResponse()");
        }
        if (this.myClient != null) {
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.importCV);
        } else {
            Trace.warning(this.getClass(), "importResponse()", "An import response event was received when no client is expecting it.\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    public static synchronized CV_Controller instance() {
        if (Trace.valid(CV_Controller.class, 20)) {
            Trace.debug(CV_Controller.class, 20, "instance()");
        }
        if (myInstance == null) {
            myInstance = new CV_Controller();
        }
        return myInstance;
    }

    public boolean isBusy() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isBusy()");
        }
        return this.myIsBusy;
    }

    public void removeFromRollbackList(CV_ControllerClientInterface cV_ControllerClientInterface, String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeFromRollbackList(CV_ControllerClientInterface aClient, String aCV_Name)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCV_Name: " + string);
        }
        InvokedActionRemoveFromRollbackListInformation invokedActionRemoveFromRollbackListInformation = new InvokedActionRemoveFromRollbackListInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "removeFromRollbackList(CV_ControllerClientInterface aClient, String aCV_Name)", "Attempting to execute function - " + invokedActionRemoveFromRollbackListInformation.getName() + "\n\t(" + invokedActionRemoveFromRollbackListInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionRemoveFromRollbackListInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedActionRemoveFromRollbackListInformation.getSlogan() + ") " + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myRollbackListContentsController = new RollbackListContentsController();
        this.myExecutingFunction = invokedActionRemoveFromRollbackListInformation;
        this.myRollbackListContentsController.removeFromRollbackList(string);
    }

    public void restore(CV_ControllerClientInterface cV_ControllerClientInterface, String string, int n, boolean bl, UpgradePackageMo upgradePackageMo) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restore(CV_ControllerClientInterface aClient, String aCV_Name, int anAutoConfigurationInformation, boolean anIsForcedRestoreRequested, String aCurrentStartableCV, UpgradePackageMo aCurrentUpgradePackage)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCV_Name: " + string + "\n\tanAutoConfigurationInformation: " + n + "\n\tanIsForcedRestoreRequested: " + bl + "\n\taCurrentUpgradePackage: " + upgradePackageMo);
        }
        InvokedActionRestoreInformation invokedActionRestoreInformation = new InvokedActionRestoreInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "restore(CV_ControllerClientInterface aClient, String aCV_Name, int anAutoConfigurationInformation, boolean anIsForcedRestoreRequested, String aCurrentStartableCV)", "Attempting to execute function - " + invokedActionRestoreInformation.getName() + "\n\t(" + invokedActionRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Class name: " + this.getClass().getName() + "\n\trestore(CV_ControllerClientInterface aClient, String aCV_Name, int anAutoConfigurationInformation, boolean anIsForcedRestoreRequested, String aCurrentStartableCV)" + "\n\tAttempting to execute function - " + invokedActionRestoreInformation.getName() + "\n\t(" + invokedActionRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\tisBusy: " + this.isBusy() + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myRestorer = new Restorer();
        this.myRestorer.initiateThread();
        this.myRestorer.restoreRequest(string, n, bl, upgradePackageMo);
        this.myExecutingFunction = invokedActionRestoreInformation;
    }

    public void restoreResponse(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreResponse(boolean restoreSuccessful)\n\trestoreSuccessful: " + bl);
        }
        if (this.myClient != null) {
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.restore, bl);
        } else {
            Trace.warning(this.getClass(), "restoreResponse(boolean restoreSuccessful)", "A restore response event was received when no client is expecting it.\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    public void setFirstInRollbackList(CV_ControllerClientInterface cV_ControllerClientInterface, String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setFirstInRollbackList(CV_ControllerClientInterface aClient, String aCV_Name)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCV_Name: " + string);
        }
        InvokedActionSetFirstRollbackListInformation invokedActionSetFirstRollbackListInformation = new InvokedActionSetFirstRollbackListInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setFirstInRollbackList(CV_ControllerClientInterface aClient, String aCV_Name)", "Attempting to execute function - " + invokedActionSetFirstRollbackListInformation.getName() + "\n\t(" + invokedActionSetFirstRollbackListInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionSetFirstRollbackListInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedActionSetFirstRollbackListInformation.getSlogan() + ") " + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myRollbackListContentsController = new RollbackListContentsController();
        this.myExecutingFunction = invokedActionSetFirstRollbackListInformation;
        this.myRollbackListContentsController.setFirstInRollbackList(string);
    }

    public void setStartable(CV_ControllerClientInterface cV_ControllerClientInterface, String string, boolean bl) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setStartable(CV_ControllerClientInterface aClient, String aCV_Name, boolean anIsLongSetStartableTimeoutValueToBeUsed)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCV_Name: " + string + "\n\tanIsLongSetStartableTimeoutValueToBeUsed: " + bl);
        }
        InvokedActionSetStartableInformation invokedActionSetStartableInformation = new InvokedActionSetStartableInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setStartable(CV_ControllerClientInterface aClient, String aCV_Name)", "Attempting to execute function - " + invokedActionSetStartableInformation.getName() + "\n\t(" + invokedActionSetStartableInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionSetStartableInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedActionSetStartableInformation.getSlogan() + ") " + "\n\tisBusy: " + this.isBusy() + "\n\taCV_Name: " + string + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.mySetStartableController = new SetStartableController();
        this.myExecutingFunction = invokedActionSetStartableInformation;
        this.mySetStartableController.setStartable(string, bl);
    }

    public void verifyRestore(CV_ControllerClientInterface cV_ControllerClientInterface, String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyRestore(CV_ControllerClientInterface aClient, String aCV_Name)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCV_Name: " + string);
        }
        InvokedActionVerifyRestoreInformation invokedActionVerifyRestoreInformation = new InvokedActionVerifyRestoreInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setStartable(CV_ControllerClientInterface aClient, String aCV_Name)", "Attempting to execute function - " + invokedActionVerifyRestoreInformation.getName() + "\n\t(" + invokedActionVerifyRestoreInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionVerifyRestoreInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedActionVerifyRestoreInformation.getSlogan() + ") " + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myRestoreVerifier = new RestoreVerifier();
        this.myRestoreVerifier.initiateThread();
        this.myRestoreVerifier.verifyRestoreRequest(string);
        this.myExecutingFunction = invokedActionVerifyRestoreInformation;
    }

    public void verifyRestoreResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyRestoreResponse()");
        }
        if (this.myClient != null) {
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.verifyRestore);
        } else {
            Trace.warning(this.getClass(), "verifyRestoreResponse()", "A verifyRestore response event was received when no client is expecting it.\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    public void activateConfigCountdown(CV_ControllerClientInterface cV_ControllerClientInterface) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "activateConfigCountdown(CV_ControllerClientInterface aClient)", "client: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface));
        }
        InvokedCountdownActivatedInformation invokedCountdownActivatedInformation = new InvokedCountdownActivatedInformation("activateConfigCountdown", "Configuration countdown activated");
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            throw new ActionNotAllowedException("Attempting to execute function activateConfigCountdown \n\twhen not allowed (see status information below).\n\t setConfigCountdownActivated \n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myExecutingFunction = invokedCountdownActivatedInformation;
        ConfigCountdownActivatedController.instance().activate();
    }

    public void deactivateConfigCountdown(CV_ControllerClientInterface cV_ControllerClientInterface) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deactivateConfigCountdown(CV_ControllerClientInterface aClient)", "client: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface));
        }
        InvokedCountdownActivatedInformation invokedCountdownActivatedInformation = new InvokedCountdownActivatedInformation("configCountdownActivated", "Configuration countdown deactivated");
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            throw new ActionNotAllowedException("Attempting to execute function deactivateConfigCountdown \n\twhen not allowed (see status information below).\n\t setConfigCountdownActivated \n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myExecutingFunction = invokedCountdownActivatedInformation;
        ConfigCountdownActivatedController.instance().deactivate();
    }

    public void activateRobustReconfiguration(CV_ControllerClientInterface cV_ControllerClientInterface, boolean bl) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "activateRobustReconfiguration(CV_ControllerClientInterface aClient, boolean anAutoCreatedCVIsTurnedOn)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tanAutoCreatedCVIsTurnedOn: " + bl);
        }
        InvokedActionActivateRobustReconfigurationInformation invokedActionActivateRobustReconfigurationInformation = new InvokedActionActivateRobustReconfigurationInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "activateRobustReconfiguration(CV_ControllerClientInterface aClient, boolean anAutoCreatedCVIsTurnedOn)", "Attempting to execute function - " + invokedActionActivateRobustReconfigurationInformation.getName() + "\n\t(" + invokedActionActivateRobustReconfigurationInformation.getSlogan() + ")" + "\n\twhen not allowed (see status information below)." + "\n\tanAutoCreatedCVIsTurnedOn: " + bl + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionActivateRobustReconfigurationInformation.getName() + "\n\t(" + invokedActionActivateRobustReconfigurationInformation.getSlogan() + ")" + "\n\twhen not allowed (see status information below)." + "\n\tanAutoCreatedCVIsTurnedOn: " + bl + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        RobustReconfigurationActivator robustReconfigurationActivator = new RobustReconfigurationActivator();
        robustReconfigurationActivator.initiateThread();
        robustReconfigurationActivator.activateRobustReconfigurationRequest(bl);
        this.myExecutingFunction = invokedActionActivateRobustReconfigurationInformation;
    }

    public void activateRobustReconfigurationResponse(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "activateRobustReconfigurationResponse(boolean anIsActivated)", "anIsActivated: " + bl);
        }
        if (this.myClient != null) {
            boolean bl2 = true;
            if (bl) {
                this.myExecutingFunction = new RobustReconfigurationActiveInformation();
            } else {
                bl2 = false;
            }
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.robustReconfiguration, bl2);
        } else {
            Trace.warning(this.getClass(), "activateRobustReconfigurationResponse(boolean anIsActivated)", "An activate robust reconfiguration response was received when no client is expecting it.\n\tanIsActivated: " + bl + "\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    public void restoreRobustReconfigurationActivated(CV_ControllerClientInterface cV_ControllerClientInterface) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreRobustReconfigurationActivated(CV_ControllerClientInterface aClient)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface));
        }
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "restoreRobustReconfigurationActivated(CV_ControllerClientInterface aClient)", "Attempting to restore data when function robust reconfiguration is active at recovery\n\twhen not allowed (see status information below).\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to restore data when function robust reconfiguration is active at recovery\n\twhen not allowed (see status information below).\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myExecutingFunction = new RobustReconfigurationActiveAfterRecoveryInformation();
    }

    public void deactivateRobustReconfiguration(CV_ControllerClientInterface cV_ControllerClientInterface, boolean bl) throws ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deactivateRobustReconfiguration(CV_ControllerClientInterface aClient, boolean anAutoCreatedCVIsTurnedOnBackup)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tanAutoCreatedCVIsTurnedOnBackup: " + bl);
        }
        InvokedActionDeactivateRobustReconfigurationInformation invokedActionDeactivateRobustReconfigurationInformation = new InvokedActionDeactivateRobustReconfigurationInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "deactivateRobustReconfiguration(CV_ControllerClientInterface aClient, boolean anAutoCreatedCVIsTurnedOnBackup)", "Attempting to execute function - " + invokedActionDeactivateRobustReconfigurationInformation.getName() + "\n\t(" + invokedActionDeactivateRobustReconfigurationInformation.getSlogan() + ")" + "\n\twhen not allowed (see status information below)." + "\n\tanAutoCreatedCVIsTurnedOnBackup: " + bl + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionDeactivateRobustReconfigurationInformation.getName() + "\n\t(" + invokedActionDeactivateRobustReconfigurationInformation.getSlogan() + ")" + "\n\twhen not allowed (see status information below)." + "\n\tanAutoCreatedCVIsTurnedOnBackup: " + bl + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        RobustReconfigurationDeactivator robustReconfigurationDeactivator = new RobustReconfigurationDeactivator();
        robustReconfigurationDeactivator.initiateThread();
        robustReconfigurationDeactivator.deactivateRobustReconfigurationRequest(bl);
        this.myExecutingFunction = invokedActionDeactivateRobustReconfigurationInformation;
    }

    public void deactivateRobustReconfigurationResponse(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deactivateRobustReconfigurationResponse(boolean anIsDeactivated)", "anIsDeactivated: " + bl);
        }
        if (this.myClient != null) {
            boolean bl2 = false;
            if (!bl) {
                bl2 = true;
            }
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.robustReconfiguration, bl2);
        } else {
            Trace.warning(this.getClass(), "deactivateRobustReconfigurationResponse(boolean anIsDeactivated)", "A deactivate robust reconfiguration response was received when no client is expecting it.\n\tanIsDeactivated: " + bl + "\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    public void generateDbDump(CV_ControllerClientInterface cV_ControllerClientInterface, String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "generateDbDump(CV_ControllerClientInterface aClient, String aCV_Name)", "aClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\taCV_Name: " + string);
        }
        InvokedActionGenerateDbDumpInformation invokedActionGenerateDbDumpInformation = new InvokedActionGenerateDbDumpInformation();
        if (!this.isBusy() || cV_ControllerClientInterface == null || !cV_ControllerClientInterface.equals(this.myClient) || this.isWaitingForConfirmationOfRestore) {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "generateDbDump(CV_ControllerClientInterface aClient, String aCV_Name)", "Attempting to execute function - " + invokedActionGenerateDbDumpInformation.getName() + "\n\t(" + invokedActionGenerateDbDumpInformation.getSlogan() + ") " + "\n\twhen not allowed (see status information below)." + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
            }
            throw new ActionNotAllowedException("Attempting to execute function - " + invokedActionGenerateDbDumpInformation.getName() + "\n\twhen not allowed (see status information below)." + "\n\t(" + invokedActionGenerateDbDumpInformation.getSlogan() + ") " + "\n\taCV_Name: " + string + "\n\tisBusy: " + this.isBusy() + "\n\tisWaitingForConfirmationOfRestore: " + this.isWaitingForConfirmationOfRestore + "\n\taClient: " + this.getStringOfCV_ControllerClient(cV_ControllerClientInterface) + "\n\tmyClient: " + this.getStringOfCV_ControllerClient(this.myClient));
        }
        this.myGenerateDbdumper = new GenerateDbDumper();
        this.myGenerateDbdumper.initiateThread();
        this.myGenerateDbdumper.generateDbDumpRequest(string);
        this.myExecutingFunction = invokedActionGenerateDbDumpInformation;
    }

    public void genereateDbDumpResponse() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "genereateDbDumpResponse()");
        }
        if (this.myClient != null) {
            ((CV_ControllerNonBlockingClientInterface)this.myClient).finished(ServiceSubType.generateDbDump);
        } else {
            Trace.warning(this.getClass(), "genereateDbDumpResponse()", "A generate db dump response event was received when no client is expecting it.\n\tmyExecutingFunction: " + this.myExecutingFunction + "\n\tisBusy: " + this.isBusy());
        }
    }

    private String getStringOfCV_ControllerClient(CV_ControllerClientInterface cV_ControllerClientInterface) {
        if (cV_ControllerClientInterface == null) {
            return null;
        }
        return ((Object)cV_ControllerClientInterface).toString();
    }
}

