/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.base;

import java.io.File;
import java.util.HashSet;
import se.ericsson.cello.configurationversion.file.base.FilePathException;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class FilePath {
    public void createDirPath(String string) throws FilePathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createDirPath(String aDirPath)", "aDirPath: " + string);
        }
        try {
            File file = new File(string);
            if (file.exists()) {
                if (file.isFile()) {
                    Trace.warning(this.getClass(), "createValidCV_BackupRootFilePath ( String aCV_FileDisk, String aCV_RootFilePath )", "The default root path to be used for CV files exists and is not a directory (its a file).");
                }
            } else {
                this.createCV_RootPath(string);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createDirPath(String aDirPath)", "Throwable caught.\n\taDirPath: " + string + throwable);
            throw new FilePathException("Class name: " + this.getClass().getName() + "\n\tcreateDirPath(String aDirPath)" + "\n\taDirPath: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String createValidCV_RootFilePath(String string, String string2) throws FilePathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createValidCV_RootFilePath(String aCV_FileDisk, String aCV_RootFilePath)", "aCV_FileDisk: " + string + "\n\taCV_RootFilePath: " + string2);
        }
        try {
            String string3 = string + string2;
            File file = new File(string3);
            if (file.exists()) {
                if (file.isFile()) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "createValidCV_RootFilePath ( String aCV_FileDisk, String aCV_RootFilePath )", "The default root path to be used for CV files exists and is not a directory (its a file).\n\tWill create an other root path to be used for this CV.");
                    }
                    Integer n = TimeHandler.createActionId();
                    return this.attemptToCreateCV_RootPath(string3, n.toString());
                }
                if (this.removeFilesInDirectory(string3)) {
                    return string3;
                }
                Integer n = TimeHandler.createActionId();
                return this.attemptToCreateCV_RootPath(string3, n.toString());
            }
            return this.attemptToCreateCV_RootPath(string3);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createValidCV_RootFilePath(String aCV_FileDisk, String aCV_RootFilePath", "Throwable caught when trying to determine a root file path that temporary shall be used at creation of files.\n\taCV_BackupRootFilePath: " + string2 + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            throw new FilePathException("Failed to create a root path.\n\tAn unexpected Throwable were caught.\n\tThrowable: " + throwable + "\n\ttThrowable data: " + throwable.toString());
        }
    }

    public boolean removeFilesInDirectory(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "removeFilesInDirectory(String aPath)", "aPath: " + string);
        }
        if (string == null) {
            return true;
        }
        Object[] objectArray = null;
        int n = 0;
        try {
            File file = new File(string);
            objectArray = file.listFiles();
            if (objectArray != null) {
                for (n = 0; n < objectArray.length; ++n) {
                    if (((File)objectArray[n]).delete()) continue;
                    Trace.warning(this.getClass(), "deleteCreatedFiles(String aRootFilePath)", "Failed to delete the file '" + SuLib.toString((File)objectArray[n]) + "' in directory '" + string + "'." + "\n\taPath: " + string);
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "removeFilesInDirectory(String aPath)", "Throwable caught at tremoval of files in directory " + string + "\n\tFiles in the directory: " + SuLib.toString(objectArray) + "\n\tDelete of file number " + n + 1 + " failed." + "\n\tThrowable: " + throwable + "\n\ttThrowable data: " + throwable.toString());
            return false;
        }
    }

    private String attemptToCreateCV_RootPath(String string) throws FilePathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "attemptToCreateCV_RootPath(String aRootPath)", "aRootPath: " + string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        String string2 = string;
        for (int i = 0; i < 10; ++i) {
            if (this.createCV_RootPath(string2)) {
                return string2;
            }
            hashSet.add(string2);
            string2 = this.createA_CV_RootPathName(string);
        }
        throw new FilePathException("Failed to create a CV root path to be used at creation of all related files.\n\tAttempted to create a root path on following directories: " + hashSet.toString());
    }

    private String attemptToCreateCV_RootPath(String string, String string2) throws FilePathException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "attemptToCreateCV_RootPath(String aRootPath, String aNewChildPath)", "aRootPath: " + string + "\n\taNewChildPath: " + string2);
        }
        HashSet hashSet = new HashSet();
        String string3 = string + string2;
        for (int i = 0; i < 10; ++i) {
            if (this.createCV_RootPath(string3)) {
                return string3;
            }
            string3 = this.createA_CV_RootPathName(string);
        }
        throw new FilePathException("Failed to create a CV root path to be used at creation of all related files.\n\tAttempted to create a root path on following directories: " + hashSet.toString());
    }

    private String createA_CV_RootPathName(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createA_CV_RootPathName(String aDefaultRootPath)", "aDefaultRootPath: " + string);
        }
        Integer n = TimeHandler.createActionId();
        return string + n.toString();
    }

    private boolean createCV_RootPath(String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createCV_RootPath(String aCV_RootPath)", "aCV_RootPath: " + string);
        }
        try {
            File file = new File(string);
            return file.mkdirs();
        }
        catch (Throwable throwable) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "createCV_RootPath ( String aPath )", "Failed to create the CV file root path.\n\taCV_RootPath: " + string + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
            }
            return false;
        }
    }
}

