/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.softwareinformation.parser;

import java.io.PrintStream;
import java.util.Collection;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.ActiveOtherLMsInformation;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.JvmInformation;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SoftwareInformationAttributeName;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SoftwareInformationRootElementName;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SoftwareInformationSubElementName;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SwAllocations;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.WebServerInformation;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.base.BackupRestoreXML_RootElement;
import se.ericsson.cello.su.xmlparser.base.UnknownXML_AttributeException;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_ElementInterface;
import se.ericsson.cello.su.xmlparser.base.XML_Exception;
import se.ericsson.cello.sudom.parser.dom.util.locator.LocatorProxy;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class SoftwareInformationElement
extends BackupRestoreXML_RootElement {
    private SwAllocations mySwAllocationsElement = null;
    private JvmInformation myJvmInformationElement = null;
    private ActiveOtherLMsInformation myActiveOtherLMsInformationElement = null;
    private WebServerInformation myWebServerInformationElement = null;

    public SoftwareInformationElement(String string) {
        super("<!DOCTYPE SoftwareInformation>", "<!--DOCTYPE SoftwareInformation SYSTEM \"file:///..\\softwareinformation.dtd\"-->");
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SoftwareInformationElement( int aVersionValue )", "aVersionValue: " + string);
        }
        if (BackupRestoreDataHandler.greaterThanVersion("2", string)) {
            Trace.error(this.getClass(), "SoftwareInformationElement(String aVersion)", "Version used when creating SoftwareInformationElement is larger than handled by the system.\n\taVersion: " + string + "\n\tHighest supported version " + "2" + " will be used.");
            string = "2";
        }
        BackupRestoreDataHandler.instance().setCurrentSoftwareInformationInfo(string);
    }

    public SoftwareInformationElement(AttributeList attributeList, Locator locator) throws UnknownXML_AttributeException {
        super("<!DOCTYPE SoftwareInformation>", "<!--DOCTYPE SoftwareInformation SYSTEM \"file:///..\\softwareinformation.dtd\"-->", locator);
        Object object;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SoftwareInformationElement(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        String string = attributeList.getValue(SoftwareInformationAttributeName.Version.getValue());
        boolean bl = false;
        if (BackupRestoreDataHandler.greaterThanVersion("2", string)) {
            object = "XML file " + BackupRestoreDataHandler.instance().getCurrentFileName() + "." + "\n\tThe attribute '" + SoftwareInformationAttributeName.Version.getValue() + "'" + " in element '" + SoftwareInformationRootElementName.SoftwareInformation + "'" + " has a value that is not supported: '" + string + "'." + "\n\tHighest supported version '" + "2" + "' will be used." + "\n\tUnknown XML elements and attributes will be ignored.";
            Trace.warning(this.getClass(), "SoftwareInformationElement(AttributeList anAttributeList, Locator aLocator)", (String)object);
            string = "2";
            bl = true;
        }
        BackupRestoreDataHandler.instance().setCurrentVersion(string, bl);
        object = SoftwareInformationAttributeName.verifyNames(attributeList);
        if (object == null || ((String[])object).length > 0) {
            SoftwareInformationElement.reportUnknownAttribute(this.getClass(), "SoftwareInformationElement(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SoftwareInformationRootElementName.SoftwareInformation.getValue(), object, locator);
        }
    }

    public XML_ElementInterface createChild(String string, AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", "anElementName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (string.equals(SoftwareInformationSubElementName.SwAllocations.getValue())) {
            return this.createSwAllocations(attributeList, locator);
        }
        if (string.equals(SoftwareInformationSubElementName.JvmInformation.getValue())) {
            return this.createJvmInformation(attributeList, locator);
        }
        if (string.equals(SoftwareInformationSubElementName.ActiveOtherLMsInformation.getValue())) {
            return this.createActiveOtherLMsInformation(attributeList, locator);
        }
        if (string.equals(SoftwareInformationSubElementName.WebServerInformation.getValue())) {
            return this.createWebServerInformation(attributeList, locator);
        }
        return SoftwareInformationElement.reportUnknownElement(this.getClass(), "createChild(String anElementName, AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SoftwareInformationRootElementName.SoftwareInformation.getValue(), string, locator);
    }

    public SwAllocations getSwAllocationsElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationsElement()");
        }
        return this.mySwAllocationsElement;
    }

    public JvmInformation getJvmInformationElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJvmInformationElement()");
        }
        return this.myJvmInformationElement;
    }

    public WebServerInformation getWebServerInformationElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getWebServerInformationElement()");
        }
        return this.myWebServerInformationElement;
    }

    public ActiveOtherLMsInformation getActiveOtherLMsInformationElement() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getActiveOtherLMsInformationElement()");
        }
        return this.myActiveOtherLMsInformationElement;
    }

    public void print(PrintStream printStream) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        this.print(printStream, "");
    }

    public void print(PrintStream printStream, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream, String anIndentation)", "aPrintStream: " + printStream + "\n\tanIndentation: " + string);
        }
        super.print(printStream);
        printStream.println(string + "<" + SoftwareInformationRootElementName.SoftwareInformation.getValue());
        printStream.println("  " + string + SoftwareInformationAttributeName.Version.getValue() + " = \"" + BackupRestoreDataHandler.instance().getCurrentVersion() + "\"");
        printStream.println("  " + string + ">");
        if (this.mySwAllocationsElement != null) {
            printStream.println();
            this.mySwAllocationsElement.print(printStream, "  " + string);
        }
        if (this.myJvmInformationElement != null) {
            printStream.println();
            this.myJvmInformationElement.print(printStream, "  " + string);
        }
        if (this.myActiveOtherLMsInformationElement != null) {
            printStream.println();
            this.myActiveOtherLMsInformationElement.print(printStream, "  " + string);
        }
        if (this.myWebServerInformationElement != null) {
            printStream.println();
            this.myWebServerInformationElement.print(printStream, "  " + string);
        }
        printStream.println();
        printStream.println(string + "</" + SoftwareInformationRootElementName.SoftwareInformation.getValue() + ">");
    }

    public void createChildren(Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createChildren(Collection aSwAllocationInformationDataContainers, Collection aJvmSlotDataContainers, Collection aWebServerSlotDataContainers, Collection anActiveOtherLMsSlotDataContainers)", "aSwAllocationInformationDataContainers: " + collection + "\n\taJvmSlotDataContainers: " + collection2 + "\n\taWebServerSlotDataContainers: " + collection3 + "\n\tanActiveOtherLMsSlotDataContainers: " + collection4);
        }
        this.mySwAllocationsElement = new SwAllocations(collection);
        this.myJvmInformationElement = new JvmInformation(collection2);
        this.myWebServerInformationElement = new WebServerInformation(collection3);
        this.myActiveOtherLMsInformationElement = new ActiveOtherLMsInformation(collection4);
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate( )");
        }
        SoftwareInformationAttributeName.Version.validate(BackupRestoreDataHandler.instance().getCurrentVersion(), super.getLocator());
        SoftwareInformationSubElementName.SwAllocations.validate(this.mySwAllocationsElement, super.getLocator());
        if (this.mySwAllocationsElement != null) {
            this.mySwAllocationsElement.validate();
        }
    }

    private XML_ElementInterface createSwAllocations(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSwAllocations(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.mySwAllocationsElement == null) {
            this.mySwAllocationsElement = new SwAllocations(attributeList, locator);
            return this.mySwAllocationsElement;
        }
        return SoftwareInformationElement.errorMoreElementsThanExpected(this.getClass(), "createSwAllocations(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SoftwareInformationRootElementName.SoftwareInformation.getValue(), SoftwareInformationSubElementName.SwAllocations.getValue(), locator);
    }

    private XML_ElementInterface createJvmInformation(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createJvmInformation(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myJvmInformationElement == null) {
            this.myJvmInformationElement = new JvmInformation(attributeList, locator);
            return this.myJvmInformationElement;
        }
        return SoftwareInformationElement.errorMoreElementsThanExpected(this.getClass(), "createJvmInformation(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SoftwareInformationRootElementName.SoftwareInformation.getValue(), SoftwareInformationSubElementName.JvmInformation.getValue(), locator);
    }

    private XML_ElementInterface createActiveOtherLMsInformation(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createActiveOtherLMsInformation(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myActiveOtherLMsInformationElement == null) {
            this.myActiveOtherLMsInformationElement = new ActiveOtherLMsInformation(attributeList, locator);
            return this.myActiveOtherLMsInformationElement;
        }
        return SoftwareInformationElement.errorMoreElementsThanExpected(this.getClass(), "createActiveOtherLMsInformation(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SoftwareInformationRootElementName.SoftwareInformation.getValue(), SoftwareInformationSubElementName.ActiveOtherLMsInformation.getValue(), locator);
    }

    private XML_ElementInterface createWebServerInformation(AttributeList attributeList, Locator locator) throws XML_Exception {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createWebServerInformation(AttributeList anAttributeList, Locator aLocator)", "anAttributeList: " + attributeList + "\n\taLocator: " + LocatorProxy.getLocatorInfo(locator));
        }
        if (this.myWebServerInformationElement == null) {
            this.myWebServerInformationElement = new WebServerInformation(attributeList, locator);
            return this.myWebServerInformationElement;
        }
        return SoftwareInformationElement.errorMoreElementsThanExpected(this.getClass(), "createWebServerInformation(AttributeList anAttributeList, Locator aLocator)", BackupRestoreDataHandler.instance().getCurrentFileName(), SoftwareInformationRootElementName.SoftwareInformation.getValue(), SoftwareInformationSubElementName.WebServerInformation.getValue(), locator);
    }

    public String toString() {
        return "\n\tmySwAllocationsElement: " + this.mySwAllocationsElement;
    }
}

