/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.file.softwareinformation.proxy;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.configurationversion.file.parser.XML_ParserFactory;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.Repertoire;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.Slot;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.Slots;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SoftwareInformationElement;
import se.ericsson.cello.configurationversion.file.softwareinformation.parser.SwAllocation;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.su.xmlparser.backuprestore.BackupRestoreDataHandler;
import se.ericsson.cello.su.xmlparser.base.DomProxy;
import se.ericsson.cello.su.xmlparser.base.ValidateException;
import se.ericsson.cello.su.xmlparser.base.XML_RootElement;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.SlotDataContainer;
import se.ericsson.cello.upgradepackage.util.datacontainer.SwAllocationDataContainer;

public class SoftwareInformationProxy
extends DomProxy {
    public static final String APPLICATION_SLOT = "APPLICATION_SLOT";
    private SoftwareInformationElement mySoftwareInformationElement = null;

    public SoftwareInformationProxy(Integer n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SwAllocationInformationProxy(Integer aVersionValue)", "aVersionValue: " + n);
        }
        this.mySoftwareInformationElement = new SoftwareInformationElement(n.toString());
    }

    public SoftwareInformationProxy(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "SoftwareInformationProxy(String aFilePathToSoftwareInformationDir)", "aFilePathToSoftwareInformationDir: " + string);
        }
        String string2 = string + "/" + "softwareinformation.xml";
        BackupRestoreDataHandler.instance().setCurrentFileName("softwareinformation.xml");
        try {
            XML_RootElement xML_RootElement = XML_ParserFactory.instance().parseFile(string2, true);
            if (!(xML_RootElement instanceof SoftwareInformationElement)) {
                String string3 = "undefined";
                if (xML_RootElement != null) {
                    string3 = xML_RootElement.getClass().getName();
                }
                throw new ConfigurationVersionException("Illegal type of XML file given as input parameter,\n\tSoftwareInformationProxy(String aFilePathToSoftwareInformationDir)\n\tGiven XML file: " + string2 + "\n\tRoot element type in this file: " + string3);
            }
            this.mySoftwareInformationElement = (SoftwareInformationElement)xML_RootElement;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "SoftwareInformationProxy(String aFilePathToSoftwareInformationDir)", "Throwable caught.\n\taFilePathToSoftwareInformationDir: " + string, throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tSoftwareInformationProxy(String aFilePathToSoftwareInformationDir)" + "\n\tThrowable caught." + "\n\taFilePathToSoftwareInformationDir: " + string + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public void createSoftwareInformation(Collection collection, Collection collection2, Collection collection3, Collection collection4) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSoftwareInformation(Collection aSwAllocationInformationDataContainers, Collection aJvmSlotDataContainers, Collection aWebServerSlotDataContainers, Collection anActiveOtherLMsSlotDataContainers)", "aSwAllocationInformationDataContainers: " + collection + "\n\taJvmSlotDataContainers: " + collection2 + "\n\taWebServerSlotDataContainers: " + collection3 + "\n\tanActiveOtherLMsSlotDataContainers: " + collection4);
        }
        this.mySoftwareInformationElement.createChildren(collection, collection2, collection3, collection4);
    }

    public Collection getSwAllocationDataContainers(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationDataContainers(boolean anIgnoreSlotsNotTrusted)", "anIgnoreSlotsNotTrusted: " + bl);
        }
        Vector<SwAllocationDataContainer> vector = new Vector<SwAllocationDataContainer>();
        Collection collection = this.mySoftwareInformationElement.getSwAllocationsElement().getSwAllocations();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            vector.add(this.createSwAllocationDataContainer((SwAllocation)iterator.next(), bl));
        }
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getSwAllocationDataContainers(boolean anIgnoreSlotsNotTrusted)", "Returning - theSwAllocationDataContainers: " + vector);
        }
        return vector;
    }

    public Collection getJvmSlotDataContainers(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getJvmSlotDataContainers(boolean anIgnoreSlotsNotTrusted)anIgnoreSlotsNotTrusted: " + bl);
        }
        Slots slots = this.mySoftwareInformationElement.getJvmInformationElement().getSlotsElement();
        Collection collection = this.createSlotDataContainers(slots, bl);
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getJvmSlotDataContainers(boolean anIgnoreSlotsNotTrusted)", "Returning - theJvmSlotDataContainers: " + collection);
        }
        return collection;
    }

    public Collection getWebServerSlotDataContainers(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getWebServerSlotDataContainers(boolean anIgnoreSlotsNotTrusted)anIgnoreSlotsNotTrusted: " + bl);
        }
        Slots slots = this.mySoftwareInformationElement.getWebServerInformationElement().getSlotsElement();
        Collection collection = this.createSlotDataContainers(slots, bl);
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getWebServerSlotDataContainers(boolean anIgnoreSlotsNotTrusted)", "Returning - theWebServerSlotDataContainers: " + collection);
        }
        return collection;
    }

    public Collection getActiveOtherLMsSlotDataContainers(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getActiveOtherLMsSlotDataContainers(boolean anIgnoreSlotsNotTrusted)anIgnoreSlotsNotTrusted: " + bl);
        }
        Slots slots = this.mySoftwareInformationElement.getActiveOtherLMsInformationElement().getSlotsElement();
        Collection collection = this.createSlotDataContainers(slots, bl);
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getActiveOtherLMsSlotDataContainers(boolean anIgnoreSlotsNotTrusted)", "Returning - theActiveOtherLMsSlotDataContainers: " + collection);
        }
        return collection;
    }

    private SwAllocationDataContainer createSwAllocationDataContainer(SwAllocation swAllocation, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSwAllocationDataContainer(SwAllocation aSwAllocationElement, boolean anIgnoreSlotsNotTrusted)", "aSwAllocationElement: " + swAllocation + "\n\tanIgnoreSlotsNotTrusted: " + bl);
        }
        SwAllocationDataContainer swAllocationDataContainer = new SwAllocationDataContainer(swAllocation.getLdn());
        swAllocationDataContainer.setRepertoireNames(this.getRepertoireNames(swAllocation));
        swAllocationDataContainer.setSlotDataContainers(this.createSlotDataContainers(swAllocation.getSlotsElement(), bl));
        return swAllocationDataContainer;
    }

    private Collection getRepertoireNames(SwAllocation swAllocation) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoireNames(SwAllocation aSwAllocationElement)", "aSwAllocationElement: " + swAllocation);
        }
        Vector<String> vector = new Vector<String>();
        Iterator iterator = swAllocation.getRepertoiresElement().getRepertoireElements().iterator();
        Repertoire repertoire = null;
        while (iterator.hasNext()) {
            repertoire = (Repertoire)iterator.next();
            vector.add(repertoire.getName());
        }
        return vector;
    }

    private Collection createSlotDataContainers(Slots slots, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSlotDataContainers( Slots aSlotsElement, boolean anOnlyContainsTrustedPIU )", "aSlotsElement: " + slots + "\n\tanOnlyContainsTrustedPIU: " + bl);
        }
        Vector<SlotDataContainer> vector = new Vector<SlotDataContainer>();
        SlotDataContainer slotDataContainer = null;
        Slot slot = null;
        Iterator iterator = slots.getSlots().iterator();
        while (iterator.hasNext()) {
            slot = (Slot)iterator.next();
            boolean bl2 = true;
            if (bl && !slot.containsTrustedPIU()) {
                bl2 = false;
            }
            if (!bl2) continue;
            Integer n = null;
            if (slot.getSmn() != null) {
                n = new Integer(slot.getSmn());
            }
            Integer n2 = null;
            if (slot.getApn() != null) {
                n2 = new Integer(slot.getApn());
            }
            slotDataContainer = new SlotDataContainer(slot.getType(), slot.getLdn(), n, n2, slot.getOperationalProductData(), slot.getPiuType(), slot.containsTrustedPIU());
            vector.add(slotDataContainer);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "createSlotDataContainers( Slots aSlotsElement )", "Returning - theSlotDataContainers: " + vector);
        }
        return vector;
    }

    public void print(PrintStream printStream) throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "print(PrintStream aPrintStream)", "aPrintStream: " + printStream);
        }
        this.mySoftwareInformationElement.validate();
        this.mySoftwareInformationElement.print(printStream);
    }

    public void validate() throws ValidateException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "validate()");
        }
        this.mySoftwareInformationElement.validate();
    }

    public String toString() {
        return "\n\tmySoftwareInformationElement: " + this.mySoftwareInformationElement;
    }
}

