/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.main.handler;

import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import se.ericsson.cello.configurationversion.main.event.storedconfigurationversions.CV_AddedEvent;
import se.ericsson.cello.configurationversion.main.event.storedconfigurationversions.CV_RemovedEvent;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.main.handler.CV_FRO_AttributeHandler;
import se.ericsson.cello.configurationversion.preupgrade.CV_PreUpgradeRelationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.froproxy.cv.interfaces.CV_ListResultInformation;
import se.ericsson.cello.su.froproxy.cv.interfaces.CelloCvData;
import se.ericsson.cello.su.froproxy.cv.interfaces.OsaCvMgmntProxyAccess;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.ConfigurationVersionMo;
import se.ericsson.cello.upgradepackage.trace.Trace;

public class CV_AttributeStoredConfigurationVersionsHandler
extends CV_FRO_AttributeHandler
implements PropertyChangeListener {
    public CV_AttributeStoredConfigurationVersionsHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_AttributeStoredConfigurationVersionsHandler( )");
        }
    }

    public CV_AttributeStoredConfigurationVersionsHandler(boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_AttributeStoredConfigurationVersionsHandler(boolean anAddAsPropertyChangeListener)", "anAddAsPropertyChangeListener: " + bl);
        }
        if (bl) {
            try {
                CV_ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingConfigurationVersionPropertyName.StoredConfigurationVersions, this);
            }
            catch (Throwable throwable) {
                Trace.error(this.getClass(), "CV_AttributeStoredConfigurationVersionsHandler(boolean anAddAsPropertyChangeListener)", "Throwable caught when trying to add this instance as a listener on property change for StoredConfigurationVersions.", throwable);
            }
        }
    }

    public Struct[] get() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "get()");
        }
        OsaCvMgmntProxyAccess osaCvMgmntProxyAccess = null;
        CV_ListResultInformation cV_ListResultInformation = null;
        try {
            osaCvMgmntProxyAccess = (OsaCvMgmntProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaCvMgmntProxyAccess.class);
            cV_ListResultInformation = osaCvMgmntProxyAccess.sendOsaCvListCvReq();
            this.checkResult(cV_ListResultInformation.result);
            int n = cV_ListResultInformation.numberOfCvs;
            CelloCvData[] celloCvDataArray = cV_ListResultInformation.storedCVs;
            Struct[] structArray = new Struct[n];
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = new Object[]{celloCvDataArray[i].name, celloCvDataArray[i].id, celloCvDataArray[i].type, celloCvDataArray[i].puId, celloCvDataArray[i].operator, celloCvDataArray[i].comment, celloCvDataArray[i].date, osaCvMgmntProxyAccess.getResultMsg((int)celloCvDataArray[i].status)};
                structArray[i] = new StructImpl(ConfigurationVersionMo.storedCVNames, objectArray);
                hashSet.add(celloCvDataArray[i].name);
            }
            this.synchExistingCVsWithPreUpgradedCVs(hashSet);
            return structArray;
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            throw new ConfigurationVersionException(froNotAccessibleException.toString());
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "get()", "Throwable caught when trying to get value of attribute 'storedConfigurationVersions'.\n\ttheOsaCvMgmntProxyAccess: " + osaCvMgmntProxyAccess + "\n\ttheCV_ListResultInformation: " + cV_ListResultInformation, throwable);
            throw new ConfigurationVersionException("Throwable caught when trying to get value of attribute 'storedConfigurationVersions'.\n\tThrowable: " + throwable.toString());
        }
    }

    private void synchExistingCVsWithPreUpgradedCVs(Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "synchExistingCVsWithPreUpgradedCVs(String aCV_Names)");
        }
        try {
            CV_PreUpgradeRelationHandler.getInstance().synchExistingCVsWithPreUpgradedCVs(collection);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "synchExistingCVsWithPreUpgradedCVs(String aCV_Names)", "Failed to synch existing CVs with pre upgraded CVs\n\tMessage: " + throwable);
        }
    }

    public void getAndNotify() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAndNotify()");
        }
        String[] stringArray = new String[]{"storedConfigurationVersions"};
        Struct[] structArray = this.get();
        Object[] objectArray = new Object[]{structArray};
        super.notify(stringArray, objectArray);
    }

    public Collection getCV_Names() throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCV_Names()");
        }
        try {
            Struct[] structArray = this.get();
            TreeSet<Object> treeSet = new TreeSet<Object>();
            for (int i = 0; i < structArray.length; ++i) {
                treeSet.add(structArray[i].getValue("name"));
            }
            return treeSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getCV_Names()", "Throwable caught." + throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tgetCV_Names()" + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getCV_Type(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getCV_Type(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            Struct[] structArray = this.get();
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < structArray.length; ++i) {
                string3 = (String)structArray[i].getValue("name");
                if (!string3.equals(string)) continue;
                string2 = (String)structArray[i].getValue("type");
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getCV_Type(String aCV_Name)", "Returns CV type: " + string2);
                }
                return string2;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getCV_Type(String aCV_Name)", "Returns CV type: null");
            }
            return null;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            throw configurationVersionException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getCV_Type(String aCV_Name)", "aCV_Name: " + string + "\n\tThrowable caught when trying to get the type of a CV.", throwable);
            throw new ConfigurationVersionException("Throwable caught when trying to get the type of a CV.\n\tThrowable: " + throwable.toString());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent evt)", "evt: " + propertyChangeEvent);
        }
        try {
            if (propertyChangeEvent.getNewValue() instanceof CV_AddedEvent) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "propertyChange(PropertyChangeEvent evt)", "A CV has been added,\n\tname of added CV: " + ((CV_AddedEvent)propertyChangeEvent.getNewValue()).cvName);
                }
                this.getAndNotify();
            } else if (propertyChangeEvent.getNewValue() instanceof CV_RemovedEvent) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "propertyChange(PropertyChangeEvent evt)", "A CV has been removed,\n\tname of removed CV: " + ((CV_RemovedEvent)propertyChangeEvent.getNewValue()).cvName);
                }
                this.getAndNotify();
            } else {
                Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent evt)", "Unknown type of property change value received (ignored).evt: " + propertyChangeEvent);
            }
        }
        catch (ConfigurationVersionException configurationVersionException) {
            // empty catch block
        }
    }
}

