/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.restore;

import java.io.File;
import java.util.EventObject;
import se.ericsson.cello.configurationversion.base.CV_SubFunctionController;
import se.ericsson.cello.configurationversion.cancelrestore.RestoreCancelInterface;
import se.ericsson.cello.configurationversion.cancelrestore.RestoreCanceller;
import se.ericsson.cello.configurationversion.control.CV_Controller;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.AwaitingRestoreConfirmationEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.ExecutionFailedEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.IdleEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.InitiatingConfirmRestoreTimeSupervisionEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.NodeRestartRequestEvent;
import se.ericsson.cello.configurationversion.main.event.detailedactivity.RestoreCancelledEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.MainIdleEvent;
import se.ericsson.cello.configurationversion.main.event.mainactivity.RestoringDownloadedBackupCV_Event;
import se.ericsson.cello.configurationversion.main.event.restoreconfirmationdeadline.RestoreConfirmationDeadlineEvent;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.restore.ContinueRestoreRequestEvent;
import se.ericsson.cello.configurationversion.restore.IP_handling;
import se.ericsson.cello.configurationversion.restore.RestoreCancelledException;
import se.ericsson.cello.configurationversion.restore.RestoreException;
import se.ericsson.cello.configurationversion.restore.RestoreParticipatorException;
import se.ericsson.cello.configurationversion.restore.RestoreParticipatorHandler;
import se.ericsson.cello.configurationversion.restore.RestoreProperties;
import se.ericsson.cello.configurationversion.util.progresshandler.CV_ProgressInformationHandler;
import se.ericsson.cello.configurationversion.util.progresshandler.NotifyingConfigurationVersionPropertyName;
import se.ericsson.cello.mao.RestartReasonEnum;
import se.ericsson.cello.support.thread.BlockingQueue;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelementdata.ManagedElementDataMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class ContinueRestorer
extends CV_SubFunctionController
implements RestoreCancelInterface,
Runnable {
    private BlockingQueue myQueue = new BlockingQueue();
    private RestoreCanceller myRestoreCanceller = null;
    private boolean myIsRestoreToBeCancelled = false;

    public ContinueRestorer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "ContinueRestorer()");
        }
    }

    public void initiateThread() {
        new Thread((Runnable)this, "ContinueRestorer").start();
    }

    public void cancelExecutionOfRestore(RestoreCanceller restoreCanceller) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "cancelExecutionOfRestore(RestoreCanceller aRestoreCanceller)", "aRestoreCanceller: " + restoreCanceller);
        }
        this.myRestoreCanceller = restoreCanceller;
        this.myIsRestoreToBeCancelled = true;
    }

    public void continueRestoreRequest() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "continueRestoreRequest()");
        }
        ContinueRestoreRequestEvent continueRestoreRequestEvent = new ContinueRestoreRequestEvent(this);
        this.myQueue.enqueue((Object)continueRestoreRequestEvent);
    }

    public void run() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "run()");
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "New thread handling continue restore of a downloaded CV has been started.");
        }
        EventObject eventObject = null;
        try {
            eventObject = (EventObject)this.myQueue.dequeue();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "run ()", "Received event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
            if (eventObject instanceof ContinueRestoreRequestEvent) {
                this.handleContinueRestoreRequest((ContinueRestoreRequestEvent)eventObject);
            } else {
                Trace.warning(this.getClass(), "run ()", "Unexected event received (ignored)\n\tReceived event: " + eventObject.getClass().getName() + "\n\tEventData: " + eventObject);
            }
        }
        catch (RestoreException restoreException) {
            Trace.info(this.getClass(), "run()", "RestoreException caught while waiting for an event or executing an received event (this should not happen).\n\ttheRequestEvent: " + eventObject + "\n\tException data: " + restoreException.toString());
            try {
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
                this.requestRollback("The execution of continue restore failed i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "run()", "Exception caught while waiting for an event or executing an received event.theRequestEvent: " + eventObject, throwable);
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new IdleEvent(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new MainIdleEvent(this));
            CV_Controller.instance().continueRestoreResponse();
            try {
                CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
                this.requestRollback("The execution of continue restore failed i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "run ( )", "Thread handling the continue restore of a CV is now stopped.");
        }
        Trace.flushToTraceFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleContinueRestoreRequest(ContinueRestoreRequestEvent continueRestoreRequestEvent) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleContinueRestoreRequest(ContinueRestoreRequestEvent aContinueRestoreRequestEvent)", "aContinueRestoreRequestEvent: " + continueRestoreRequestEvent);
        }
        try {
            RestoreProperties restoreProperties = new RestoreProperties();
            String string = restoreProperties.cvCMA_FileDisk + restoreProperties.getCV_RestoreFilesPath();
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.MainActivity, new RestoringDownloadedBackupCV_Event(this));
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new InitiatingConfirmRestoreTimeSupervisionEvent(this));
            this.setRestoreSupervisionTimer(restoreProperties.restoreSupervisionTimerValue);
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.RestoreConfirmationDeadline, new RestoreConfirmationDeadlineEvent((Object)this, restoreProperties.restoreSupervisionTimerValue * 1000));
            this.restoreToBeAborted();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleContinueRestoreRequest(ContinueRestoreRequestEvent aContinueRestoreRequestEvent)", "Updates IP data.");
            }
            IP_handling iP_handling = new IP_handling();
            iP_handling.setIP_AddressData(string, false);
            this.restoreToBeAborted();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleContinueRestoreRequest(ContinueRestoreRequestEvent aContinueRestoreRequestEvent)", "Invokes any restore participator.");
            }
            RestoreParticipatorHandler restoreParticipatorHandler = new RestoreParticipatorHandler();
            restoreParticipatorHandler.nodeStartedIndication();
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleContinueRestoreRequest(ContinueRestoreRequestEvent aContinueRestoreRequestEvent)", "Updates auto-configuration data.");
            }
            this.setAutoConfigurationData(string);
            this.restoreToBeAborted();
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new AwaitingRestoreConfirmationEvent(this));
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "handleContinueRestoreRequest(ContinueRestoreRequestEvent aContinueRestoreRequestEvent)", "Waits for confirmation.");
            }
            CV_Controller.instance().continueRestoreResponse();
        }
        catch (RestoreCancelledException restoreCancelledException) {
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new RestoreCancelledEvent(this));
            CV_Controller.instance().continueRestoreResponse();
            this.myRestoreCanceller.cancelRestoreAllowed(true);
        }
        catch (RestoreParticipatorException restoreParticipatorException) {
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            CV_Controller.instance().continueRestoreResponse();
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
            this.requestRollback("The execution of continue restore failed due to failure reported from restore participator i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
        }
        catch (ConfigurationVersionException configurationVersionException) {
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            CV_Controller.instance().continueRestoreResponse();
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
            this.requestRollback("The execution of continue restore failed i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleContinueRestoreRequest(ContinueRestoreRequestEvent aContinueRestoreRequestEvent)", "Throwable caught.\n\taContinueRestoreRequestEvent: " + continueRestoreRequestEvent, throwable);
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new ExecutionFailedEvent(this));
            CV_Controller.instance().continueRestoreResponse();
            CV_ProgressInformationHandler.instance().firePropertyChange(NotifyingConfigurationVersionPropertyName.DetailedActivity, new NodeRestartRequestEvent(this));
            this.requestRollback("The execution of continue restore failed i.e. the node is restarted on the rollback CV.", new RestartReasonEnum(24, this.getClass()));
        }
        finally {
            Trace.log1(this.getClass(), "handleContinueRestoreRequest(ContinueRestoreRequestEvent aContinueRestoreRequestEvent)", "Cleaning up.");
            Trace.flushToTraceFile();
        }
    }

    private void restoreToBeAborted() throws RestoreCancelledException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "restoreToBeAborted()");
        }
        if (this.myIsRestoreToBeCancelled) {
            throw new RestoreCancelledException("The execution of continue restore is cancelled due to request from outside.");
        }
    }

    private void setAutoConfigurationData(String string) throws RestoreException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setAutoConfigurationData(String aRestoreCV_FilePath)", "aRestoreCV_FilePath: " + string);
        }
        try {
            String string2 = string + "/" + "autoconfig.xml";
            File file = new File(string2);
            if (file.exists()) {
                ManagedElementDataMO_HandlerInterface managedElementDataMO_HandlerInterface = ServiceFinder.getManagedElementDataMO_HandlerInterface();
                managedElementDataMO_HandlerInterface.setAutoconfigurationData(string);
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setAutoConfigurationData(String aRestoreCV_FilePath)", "Ignores setting of auto config due to the file dose not exist(has already been handled).\n\ttheAutoConfigPath: " + string2);
            }
        }
        catch (ManagedElementDataMO_HandlerException managedElementDataMO_HandlerException) {
            throw new RestoreException(managedElementDataMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setAutoConfigurationData(String aRestoreCV_FilePath)", "Throwable caught.\n\taRestoreCV_FilePath: " + string, throwable);
            throw new RestoreException("Class name: " + this.getClass().getName() + "\n\tsetAutoConfigurationData(String aRestoreCV_FilePath)" + "\n\tThrowable caught." + "\n\taRestoreCV_FilePath: " + string + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

