/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.handler;

import se.ericsson.cello.configurationversion.main.ConfigurationVersionMoExtension;
import se.ericsson.cello.configurationversion.util.handler.CV_DataHandlerException;
import se.ericsson.cello.configurationversion.util.handler.CV_DoesNotExistException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;

public class CV_DataHandler {
    public CV_DataHandler() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "CV_DataHandler()");
        }
    }

    public String getUpgradePackageID(String string) throws CV_DoesNotExistException, CV_DataHandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradePackageID(String aCV_Name)", "aCV_Name: " + string);
        }
        try {
            Struct[] structArray = ConfigurationVersionMoExtension.instance().getStoredConfigurationVersions(null);
            Struct struct = null;
            String string2 = null;
            for (int i = 0; i < structArray.length; ++i) {
                struct = structArray[i];
                string2 = (String)struct.getValue("name");
                if (string2 == null || !string2.equals(string)) continue;
                String string3 = (String)struct.getValue("upgradePackageId");
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getUpgradePackageID(String aCV_Name)", "The given CV name was found among the stored CVs.\n\tReturning the UpgradePackageID for this CV.\n\taCV_Name: " + string + "\n\tUpgradePackageID: " + string3);
                }
                return string3;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getUpgradePackageID(String aCV_Name)", "The given CV name does not exist on the node.\n\taCV_Name: " + string);
            }
            throw new CV_DoesNotExistException("The given CV name does not exist on the node.\n\taCV_Name: " + string);
        }
        catch (CV_DoesNotExistException cV_DoesNotExistException) {
            throw cV_DoesNotExistException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getUpgradePackageID(String aCV_Name)", "Exception caugth,\n\taCV_Name: " + string, throwable);
            throw new CV_DataHandlerException(this.getClass().getName() + "\n\tgetUpgradePackageID(String aCV_Name)" + "\n\tException caugth when trying to retreive the upgrade package ID for given CV name," + "\n\taCV_Name: " + string + "\n\tException data: " + throwable.toString());
        }
    }

    public String getTypeOfCV(String string) throws CV_DoesNotExistException, CV_DataHandlerException {
        try {
            Struct[] structArray = ConfigurationVersionMoExtension.instance().getStoredConfigurationVersions(null);
            Struct struct = null;
            String string2 = null;
            for (int i = 0; i < structArray.length; ++i) {
                struct = structArray[i];
                string2 = (String)struct.getValue("name");
                if (string2 == null || !string2.equals(string)) continue;
                String string3 = (String)struct.getValue("type");
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getTypeOfCV(String aCV_Name)", "The given CV name was found among the stored CVs.\n\tReturning the type for this CV.\n\taCV_Name: " + string + "\n\ttheTypeOfCV: " + string3);
                }
                return string3;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getTypeOfCV(String aCV_Name)", "The given CV name does not exist on the node.\n\taCV_Name: " + string + "\n\tStoredCVs: " + SuLib.toString(structArray));
            }
            throw new CV_DoesNotExistException("The given CV name does not exist on the node.\n\taCV_Name: " + string + "\n\tStoredCVs: " + SuLib.toString(structArray));
        }
        catch (CV_DoesNotExistException cV_DoesNotExistException) {
            throw cV_DoesNotExistException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getTypeOfCV(String aCV_Name)", "Exception caugth,\n\taCV_Name: " + string, throwable);
            throw new CV_DataHandlerException(this.getClass().getName() + "\n\tgetTypeOfCV(String aCV_Name)" + "\n\tException caugth when trying to retreive the type of CV for given CV name," + "\n\taCV_Name: " + string + "\n\tException data: " + throwable.toString());
        }
    }
}

