/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.util.mohandler.ip;

import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.util.mohandler.ethernetlink.EthernetLinkMO_handlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.ip.IpMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.ip.IpMO_HandlerInterface;
import se.ericsson.cello.configurationversion.util.mohandler.iphostlink.IpHostLinkMO_HandlerException;
import se.ericsson.cello.configurationversion.util.mohandler.iphostlink.IpHostLinkMO_HandlerInterface;
import se.ericsson.cello.ipoam.suaccess.IpMoSU_Access;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.mohandler.factory.MO_HandlerFactoryInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class IpMO_Handler
implements IpMO_HandlerInterface {
    public IpMO_Handler(MO_HandlerFactoryInterface mO_HandlerFactoryInterface) {
    }

    public String getIsOaM_CableConfiguredToString() throws IpMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIsOaM_CableConfiguredToString()");
        }
        String string = "no";
        if (this.getIsOaM_CableConfigured()) {
            string = "yes";
        }
        return string;
    }

    public boolean getIsOaM_CableConfigured() throws IpMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIsOaM_CableConfigured()");
        }
        try {
            IpMO_HandlerInterface ipMO_HandlerInterface = ServiceFinder.getIpMO_HandlerInterface();
            IpHostLinkMO_HandlerInterface ipHostLinkMO_HandlerInterface = ServiceFinder.getIpHostLinkMO_HandlerInterface();
            EthernetLinkMO_handlerInterface ethernetLinkMO_handlerInterface = ServiceFinder.getEthernetLinkMO_handlerInterface();
            boolean bl = false;
            if (ethernetLinkMO_handlerInterface.existsEthernetLinkMo() && ipHostLinkMO_HandlerInterface.existsIpHostLinkMo()) {
                String string = ipMO_HandlerInterface.getNodeInterfaceName();
                String string2 = ethernetLinkMO_handlerInterface.getInterfaceName();
                String string3 = ipHostLinkMO_HandlerInterface.getInterfaceName();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "getIsOaM_CableConfigured()", "theNodeInterfaceName: " + string + "\n\ttheEthernetLinkMO_InterfaceName: " + string2 + "\n\ttheIpHostLinkInterfaceName: " + string3);
                }
                if (string != null) {
                    if (string.equals(string2)) {
                        bl = true;
                    } else if (string.equals(string2)) {
                        bl = false;
                    } else if (Trace.valid(this.getClass(), 20)) {
                        Trace.debug(this.getClass(), 20, "getIsOaM_CableConfigured()", "Unexpected.. The configured NodeInterfaceName should match any of the two values configured in\n\tthe EthernetLinkMo or IpHostLinkMo.\n\tAssuming that OaM cable is used.");
                    }
                }
            } else if (ethernetLinkMO_handlerInterface.existsEthernetLinkMo() && !ipHostLinkMO_HandlerInterface.existsIpHostLinkMo()) {
                bl = true;
            } else if (!ethernetLinkMO_handlerInterface.existsEthernetLinkMo() && ipHostLinkMO_HandlerInterface.existsIpHostLinkMo()) {
                bl = false;
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getIsOaM_CableConfigured()", "RETURNS - " + bl);
            }
            return bl;
        }
        catch (ConfigurationVersionException configurationVersionException) {
            Trace.warning(this.getClass(), "getIsOaM_CableConfigured()", "ConfigurationVersionException caught.\n\tConfigurationVersionException info: " + (Object)((Object)configurationVersionException));
            throw new IpMO_HandlerException(configurationVersionException.toString());
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw ipMO_HandlerException;
        }
        catch (IpHostLinkMO_HandlerException ipHostLinkMO_HandlerException) {
            throw new IpMO_HandlerException(ipHostLinkMO_HandlerException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getIsOaM_CableConfigured()", "Throwable caught.", throwable);
            throw new IpMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetIsOaM_CableConfigured()" + "\n\tThrowable: " + throwable);
        }
    }

    public String getNodeInterfaceName() throws IpMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeInterfaceName()");
        }
        try {
            IpMoSU_Access ipMoSU_Access = this.getIpMo();
            if (ipMoSU_Access == null) {
                throw new IpMO_HandlerException("No Ip Mo instance was found");
            }
            String string = ipMoSU_Access.getNodeInterfaceName(null);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getNodeInterfaceName()", "RETURNS - " + string);
            }
            return string;
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw ipMO_HandlerException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeInterfaceName()", "Throwable caught.", throwable);
            throw new IpMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetNodeInterfaceName()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getNodeIpv6Address() throws IpMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeIpv6Address()");
        }
        try {
            IpMoSU_Access ipMoSU_Access = this.getIpMo();
            if (ipMoSU_Access == null) {
                throw new IpMO_HandlerException("No Ip Mo instance was found");
            }
            String string = ipMoSU_Access.getNodeIpv6Address(null);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getNodeIpv6Address()", "RETURNS - " + string);
            }
            return string;
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw ipMO_HandlerException;
        }
        catch (MoAccessException moAccessException) {
            throw new IpMO_HandlerException(moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeIpv6Address()", "Throwable caught.", throwable);
            throw new IpMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetNodeIpv6Address()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    public String getNodeIpv6InterfaceName() throws IpMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNodeIpv6InterfaceName()");
        }
        try {
            IpMoSU_Access ipMoSU_Access = this.getIpMo();
            if (ipMoSU_Access == null) {
                throw new IpMO_HandlerException("No Ip Mo instance was found");
            }
            String string = ipMoSU_Access.getNodeIpv6InterfaceName(null);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getNodeIpv6InterfaceName()", "RETURNS - " + string);
            }
            return string;
        }
        catch (IpMO_HandlerException ipMO_HandlerException) {
            throw ipMO_HandlerException;
        }
        catch (MoAccessException moAccessException) {
            throw new IpMO_HandlerException(moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNodeIpv6InterfaceName()", "Throwable caught.", throwable);
            throw new IpMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetNodeIpv6InterfaceName()" + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private IpMoSU_Access getIpMo() throws IpMO_HandlerException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getIpMo( )");
        }
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("Ip");
            if (moIterator != null) {
                return (IpMoSU_Access)moIterator.nextElement();
            }
            Trace.log1(this.getClass(), "getIpMo()", "No Ip MO instance was found in the node.");
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getIpMo( )", "Throwable caught when attempting to look up the IpMo.", throwable);
            throw new IpMO_HandlerException("Class name: " + this.getClass().getName() + "\n\tgetIpMo()" + "\n\tThrowable caught when attempting to look up the IpMo." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }
}

