/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configurationversion.verify.swintegrity;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.configurationversion.main.exception.ConfigurationVersionException;
import se.ericsson.cello.configurationversion.verify.swintegrity.ChecksumErrorLoadModuleInformation;
import se.ericsson.cello.moframework.FroNotAccessibleException;
import se.ericsson.cello.su.froproxy.cv.interfaces.ChecksumListResultInformation;
import se.ericsson.cello.su.froproxy.swinstall.interfaces.OsaSwInstallProxyAccess;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.verify.ChecksumFileWriter;

public class ChecksumController {
    public Collection checksumLoadModules(DocumentObjectProxyInterface documentObjectProxyInterface, Vector vector, ProductDataContainer productDataContainer, String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "checksumLoadModules(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Vector aProductNumberAndRevisionOfLoadModules, ProductDataContainer aProductDataOfUP, String aChecksumFilePathAndName)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevisionOfLoadModules: " + vector + "\n\taProductDataOfUP: " + productDataContainer + "\n\taChecksumFilePathAndName: " + string);
        }
        try {
            ChecksumFileWriter checksumFileWriter = new ChecksumFileWriter();
            String string2 = checksumFileWriter.writeToChecksumFile(documentObjectProxyInterface, vector, productDataContainer, string, false);
            this.sendSignalChecksumRequest(string2);
            return this.waitForResponseFromChecksumRequest(checksumFileWriter.getLoadModuleMappTable());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "checksumLoadModules(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Vector aProductNumberAndRevisionOfLoadModules, ProductDataContainer aProductDataOfUP)", "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevisionOfLoadModules: " + vector + "\n\taProductDataOfUP: " + productDataContainer + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tchecksumLoadModules(DocumentObjectProxyInterface aDocumentObjectProxyInterface, Vector aProductNumberAndRevisionOfLoadModules, ProductDataContainer aProductDataOfUP)" + "\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumberAndRevisionOfLoadModules: " + vector + "\n\taProductDataOfUP: " + productDataContainer + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private void sendSignalChecksumRequest(String string) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendSignalChecksumRequest(String aChecksumControlFilePath)", "aChecksumControlFilePath: " + string);
        }
        try {
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            osaSwInstallProxyAccess.sendAsynchOsaSwChecksumListReq(string);
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendSignalChecksumRequest(String aChecksumControlFilePath)", "\n\tSignal OsaSwChecksumListReq sent to the install proxy at Osa layer.");
            }
        }
        catch (FroNotAccessibleException froNotAccessibleException) {
            Trace.error(this.getClass(), "sendSignalChecksumRequest(String aChecksumControlFilePath)", "\n\taChecksumControlFilePath: " + string + "FroNotAccessibleException caught.", froNotAccessibleException);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tsendSignalChecksumRequest(String aChecksumControlFilePath)" + "\n\taChecksumControlFilePath: " + string + "\n\tFroNotAccessibleException caught." + "\n\tFroNotAccessibleException: " + (Object)((Object)froNotAccessibleException) + "\n\tFroNotAccessibleException data: " + froNotAccessibleException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "sendSignalChecksumRequest(String aChecksumControlFilePath)", "\n\taChecksumControlFilePath: " + string + "Throwable caught.", throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\tsendSignalChecksumRequest(String aChecksumControlFilePath)" + "\n\taChecksumControlFilePath: " + string + "\n\tThrowable caught." + "\n\tThrowable: " + throwable + "\n\tThrowable data: " + throwable.toString());
        }
    }

    private Collection waitForResponseFromChecksumRequest(HashMap hashMap) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "waitForResponseFromChecksumRequest(HashMap aLoadModuleMapTable)", "aLoadModuleMapTable: " + hashMap);
        }
        Collection collection = new LinkedList();
        try {
            ChecksumListResultInformation checksumListResultInformation = null;
            OsaSwInstallProxyAccess osaSwInstallProxyAccess = (OsaSwInstallProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaSwInstallProxyAccess.class);
            while (true) {
                checksumListResultInformation = osaSwInstallProxyAccess.receiveOsaSwChecksumListRsp();
                if (checksumListResultInformation.typeOfResponse == 0) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "waitForResponseFromChecksumRequest(HashMap aLoadModuleMapTable)", "Type of response: CELLO_SW_CHECKSUM_RESULT_ONE_FILE");
                    }
                    if (checksumListResultInformation.checksumOK) continue;
                    String string = checksumListResultInformation.loadModuleID;
                    ProductNumberAndRevision productNumberAndRevision = (ProductNumberAndRevision)hashMap.get(string);
                    if (productNumberAndRevision != null) {
                        collection = this.addChecksumErrorLoadModuleInformation(productNumberAndRevision, checksumListResultInformation, collection);
                        continue;
                    }
                    Trace.warning(this.getClass(), "waitForResponseFromChecksumRequest(HashMap aLoadModuleMapTable)", "A unknown load module identifier has been given by the resource layer (checksum for given Load module was not correct)- IGNORED\n\tGiven Load Module ID: " + string + "\n\tKnow load module IDs: " + hashMap);
                    continue;
                }
                if (checksumListResultInformation.typeOfResponse == 1) {
                    if (!Trace.valid(this.getClass(), 22)) break;
                    Trace.debug(this.getClass(), 22, "waitForResponseFromChecksumRequest(HashMap aLoadModuleMapTable)", "Type of response: CELLO_SW_CHECKSUM_EXECUTION_FINISHED");
                    break;
                }
                Trace.warning(this.getClass(), "waitForResponseFromChecksumRequest(HashMap aLoadModuleMapTable)", "Unexpected type in response signal 'OsaSwChecksumListRsp'.\n\tType: " + checksumListResultInformation.typeOfResponse);
            }
            return collection;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "waitForResponseFromChecksumRequest(HashMap aLoadModuleMapTable)", "Throwable caught: " + throwable.toString(), throwable);
            throw new ConfigurationVersionException("Class name: " + this.getClass().getName() + "\n\twaitForResponseFromChecksumRequest(HashMap aLoadModuleMapTable)" + "\n\tWhen waiting for response from the checksum request from the resource layer " + "\n\tan unexpected Throwable was caught." + "\n\tOrigin Throwable: " + throwable.toString());
        }
    }

    private Collection addChecksumErrorLoadModuleInformation(ProductNumberAndRevision productNumberAndRevision, ChecksumListResultInformation checksumListResultInformation, Collection collection) throws ConfigurationVersionException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addChecksumErrorLoadModuleInformation(ProductNumberAndRevision anLM_ProductNumberAndRevision, String anLM_OrSM_FilePath, Collection aChecksumErrorLoadModuleInformations)", "anLM_ProductNumberAndRevision: " + productNumberAndRevision + "\n\taChecksumListResultInformation: " + checksumListResultInformation + "\n\taChecksumErrorLoadModuleInformations: " + collection);
        }
        Iterator iterator = collection.iterator();
        ChecksumErrorLoadModuleInformation checksumErrorLoadModuleInformation = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            checksumErrorLoadModuleInformation = (ChecksumErrorLoadModuleInformation)iterator.next();
            if (!checksumErrorLoadModuleInformation.getLM_Id().equals(checksumListResultInformation.loadModuleID)) continue;
            checksumErrorLoadModuleInformation.setIsLM_OrIsSM_ChecksumErrorDetected(checksumListResultInformation.loadModulePath);
            bl = true;
            break;
        }
        if (!bl) {
            collection.add(new ChecksumErrorLoadModuleInformation(productNumberAndRevision, checksumListResultInformation.loadModuleID, checksumListResultInformation.loadModulePath));
        }
        return collection;
    }
}

