/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.repertoire;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import org.xml.sax.AttributeList;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.sudom.extif.eq.suaccess.sudom.ProductNumberAndRevisionInterface;
import se.ericsson.cello.sudom.extif.swm.suaccess.sudom.ExtendedLoadModuleInformationInterface;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.parser.ParseException;
import se.ericsson.cello.sudom.parser.UnexpectedAttributeException;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectInterface;
import se.ericsson.cello.sudom.parser.dom.ParsedData;
import se.ericsson.cello.sudom.parser.dom.loadmodule.MoDataLM_AttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefAttributeName;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefLoaderNameValue;
import se.ericsson.cello.sudom.parser.dom.repertoire.LoadModuleRefOptionalAttributes;
import se.ericsson.cello.sudom.parser.dom.repertoire.PiuTypeLoadListSubElementName;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstanceRecordException;
import se.ericsson.cello.sudom.parser.dom.repertoire.ProgramInstancesValue;
import se.ericsson.cello.sudom.parser.dom.repertoire.RepertoireSubElementName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class LoadModuleRef
extends ParsedData
implements DocumentObjectInterface,
ExtendedLoadModuleInformationInterface,
ProductNumberAndRevisionInterface {
    private String myProductNumber = null;
    private String myRevision = null;
    private String myTag = null;
    private LoadModuleRefOptionalAttributes myOptionalAttributes = null;

    public LoadModuleRef(Integer n, ProductNumberAndRevision productNumberAndRevision) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"Integer aTag, ProductNumberAndRevision aProductNumberAndRevision)", (String)("aTag: " + n + "\n\taProductNumberAndRevision: " + productNumberAndRevision));
        }
        this.myTag = n.toString();
        this.myProductNumber = StringHandler.optimize(productNumberAndRevision.productNumber);
        this.myRevision = StringHandler.optimize(productNumberAndRevision.revision);
    }

    public LoadModuleRef(AttributeList attributeList, Locator locator) throws UnexpectedAttributeException {
        super(locator);
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"LoadModuleRef(AttributeList anAttributeList, Locator aLocator)", (String)("anAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        if ((stringArray = LoadModuleRefAttributeName.verifyNames(attributeList)) == null || stringArray.length > 0) {
            super.handleUnexpectedAttribute("LoadModuleRef(AttributeList anAttributeList, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), stringArray, locator);
        }
        this.myTag = attributeList.getValue(LoadModuleRefAttributeName.Tag.getValue());
        this.myProductNumber = StringHandler.optimize(attributeList.getValue(LoadModuleRefAttributeName.ProductNumber.getValue()));
        this.myRevision = StringHandler.optimize(attributeList.getValue(LoadModuleRefAttributeName.Revision.getValue()));
        String string = attributeList.getValue(LoadModuleRefAttributeName.ProgramMemoryPoolSize.getValue());
        String string2 = attributeList.getValue(LoadModuleRefAttributeName.ProgramMemoryHeapSize.getValue());
        String string3 = attributeList.getValue(LoadModuleRefAttributeName.ProgramInstances.getValue());
        String string4 = attributeList.getValue(LoadModuleRefAttributeName.LoaderName.getValue());
        String string5 = attributeList.getValue(LoadModuleRefAttributeName.DeviceLoaderName.getValue());
        String string6 = attributeList.getValue(LoadModuleRefAttributeName.DeviceLoaderInformation.getValue());
        String string7 = attributeList.getValue(LoadModuleRefAttributeName.RestartCounterLimit.getValue());
        String string8 = attributeList.getValue(LoadModuleRefAttributeName.RestartTimer.getValue());
        if (string != null || string2 != null || string3 != null || string4 != null || string5 != null || string6 != null || string7 != null || string8 != null) {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(string, string2, string3, string4, string5, string6, string7, string8);
        }
    }

    public boolean isContainingAnyOptionalAttribute() {
        return this.myOptionalAttributes != null;
    }

    public DocumentObjectInterface create(String string, AttributeList attributeList, Locator locator) throws ParseException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", (String)("aDocumentObjectName: " + string + "\n\tanAttributeList: " + attributeList + "\n\taLocator: " + locator));
        }
        return super.handleUnexpectedElement("create(String aDocumentObjectName, AttributeList anAttributeList, Locator aLocator)", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), string, locator);
    }

    public String getProductNumber() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProductNumber( )");
        }
        return this.myProductNumber;
    }

    public String getRevision() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRevision( )");
        }
        return this.myRevision;
    }

    public void setProductNumber(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setProductNumber(String aProductNumber)", (String)("aProductNumber: " + string));
        }
        this.myProductNumber = StringHandler.optimize(string);
    }

    public void setRevision(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setRevision(String aRevision)", (String)("aRevision: " + string));
        }
        this.myRevision = StringHandler.optimize(string);
    }

    public Integer getTag() {
        if (this.myTag != null) {
            return new Integer(this.myTag);
        }
        return null;
    }

    public String getTagAsString() {
        return this.myTag;
    }

    public Integer getProgramMemoryPoolSize() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProgramMemoryPoolSize( )");
        }
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getProgramMemoryPoolSize() != null) {
            return new Integer(this.myOptionalAttributes.getProgramMemoryPoolSize());
        }
        return null;
    }

    public String getProgramMemoryPoolSizeForToString() {
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getProgramMemoryPoolSize() != null) {
            return this.myOptionalAttributes.getProgramMemoryPoolSize();
        }
        return "";
    }

    public String getHeapSize() {
        if (this.myOptionalAttributes != null) {
            return this.myOptionalAttributes.getProgramMemoryHeapSize();
        }
        return null;
    }

    public String getPoolSize() {
        if (this.myOptionalAttributes != null) {
            return this.myOptionalAttributes.getProgramMemoryPoolSize();
        }
        return null;
    }

    public Integer getProgramMemoryHeapSize() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getProgramMemoryHeapSize( )");
        }
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getProgramMemoryHeapSize() != null) {
            return new Integer(this.myOptionalAttributes.getProgramMemoryHeapSize());
        }
        return null;
    }

    public String getProgramMemoryHeapSizeForToString() {
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getProgramMemoryHeapSize() != null) {
            return this.myOptionalAttributes.getProgramMemoryHeapSize();
        }
        return "";
    }

    public String getProgramInstances() {
        String string = null;
        if (this.myOptionalAttributes != null) {
            string = this.myOptionalAttributes.getProgramInstances();
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getProgramInstances()", (String)("RETURNS - theProgramInstances: " + string));
        }
        return string;
    }

    public String getProgramInstancesForToString() {
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getProgramInstances() != null) {
            return this.myOptionalAttributes.getProgramInstances();
        }
        return "";
    }

    public String getExpandedProgramInstancesForString() {
        String string = "";
        String string2 = null;
        if (this.myOptionalAttributes != null) {
            string2 = this.myOptionalAttributes.getProgramInstances();
        }
        try {
            Collection collection = ProgramInstancesValue.getProgramInstancesExpandedFormat(string2);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next();
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
            return string;
        }
        catch (ProgramInstanceRecordException programInstanceRecordException) {
            UpgradeTrace.error(this.getClass(), (String)"getExpandedProgramInstancesForString()", (String)("Illegal value in short format of program instance value (should not be able to happen since a validation have been done prior this translation\n\ttheStoredProgramInstances: " + string2 + "\n\tIgnored in this case - assuming no program instances shall be used"), (Throwable)programInstanceRecordException);
            return string;
        }
    }

    public String getLoaderName() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getLoaderName( )");
        }
        if (this.myOptionalAttributes != null) {
            return this.myOptionalAttributes.getLoaderName();
        }
        return null;
    }

    public String getLoaderNameForToString() {
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getLoaderName() != null) {
            return this.myOptionalAttributes.getLoaderName();
        }
        return "";
    }

    public String getDeviceLoaderName() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDeviceLoaderName( )");
        }
        if (this.myOptionalAttributes != null) {
            return this.myOptionalAttributes.getDeviceLoaderName();
        }
        return null;
    }

    public String getDeviceLoaderNameForToString() {
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getDeviceLoaderName() != null) {
            return this.myOptionalAttributes.getDeviceLoaderName();
        }
        return "";
    }

    public String getDeviceLoaderInformation() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getDeviceLoaderInformation( )");
        }
        if (this.myOptionalAttributes != null) {
            return this.myOptionalAttributes.getDeviceLoaderInformation();
        }
        return null;
    }

    public String getDeviceLoaderInformationForToString() {
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getDeviceLoaderInformation() != null) {
            return this.myOptionalAttributes.getDeviceLoaderInformation();
        }
        return "";
    }

    public Integer getRestartCounterLimit() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRestartCounterLimit()");
        }
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getRestartCounterLimit() != null) {
            return new Integer(this.myOptionalAttributes.getRestartCounterLimit());
        }
        return null;
    }

    public String getRestartCounterLimitForToString() {
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getRestartCounterLimit() != null) {
            return this.myOptionalAttributes.getRestartCounterLimit();
        }
        return "";
    }

    public Integer getRestartTimer() {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRestartTimer()");
        }
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getRestartTimer() != null) {
            return new Integer(this.myOptionalAttributes.getRestartTimer());
        }
        return null;
    }

    public String getRestartTimerForToString() {
        if (this.myOptionalAttributes != null && this.myOptionalAttributes.getRestartTimer() != null) {
            return this.myOptionalAttributes.getRestartTimer();
        }
        return "";
    }

    public void print(PrintStream printStream, String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"print(PrintStream aPrintStream, String anIndentation)", (String)("aPrintStream: " + printStream + "\n\tanIndentation: " + string));
        }
        printStream.println(string + "<" + PiuTypeLoadListSubElementName.LoadModuleRef.getValue());
        if (this.myTag != null) {
            printStream.println(string + "  " + LoadModuleRefAttributeName.Tag.getValue() + " = \"" + this.myTag + "\"");
        }
        if (this.myProductNumber != null) {
            printStream.println(string + "  " + LoadModuleRefAttributeName.ProductNumber.getValue() + " = \"" + this.getProductNumber() + "\"");
        }
        if (this.myRevision != null) {
            printStream.println(string + "  " + LoadModuleRefAttributeName.Revision.getValue() + " = \"" + this.getRevision() + "\"");
        }
        if (this.myOptionalAttributes != null) {
            if (this.myOptionalAttributes.getProgramMemoryPoolSize() != null) {
                printStream.println(string + "  " + LoadModuleRefAttributeName.ProgramMemoryPoolSize.getValue() + " = \"" + this.myOptionalAttributes.getProgramMemoryPoolSize() + "\"");
            }
            if (this.myOptionalAttributes.getProgramMemoryHeapSize() != null) {
                printStream.println(string + "  " + LoadModuleRefAttributeName.ProgramMemoryHeapSize.getValue() + " = \"" + this.myOptionalAttributes.getProgramMemoryHeapSize() + "\"");
            }
            if (this.myOptionalAttributes.getProgramInstances() != null) {
                printStream.println(string + "  " + LoadModuleRefAttributeName.ProgramInstances.getValue() + " = \"" + this.myOptionalAttributes.getProgramInstances() + "\"");
            }
            if (this.myOptionalAttributes.getLoaderName() != null) {
                printStream.println(string + "  " + LoadModuleRefAttributeName.LoaderName.getValue() + " = \"" + this.myOptionalAttributes.getLoaderName() + "\"");
            }
            if (this.myOptionalAttributes.getDeviceLoaderName() != null) {
                printStream.println(string + "  " + LoadModuleRefAttributeName.DeviceLoaderName.getValue() + " = \"" + this.myOptionalAttributes.getDeviceLoaderName() + "\"");
            }
            if (this.myOptionalAttributes.getDeviceLoaderInformation() != null) {
                printStream.println(string + "  " + LoadModuleRefAttributeName.DeviceLoaderInformation.getValue() + " = \"" + this.myOptionalAttributes.getDeviceLoaderInformation() + "\"");
            }
            if (this.myOptionalAttributes.getRestartCounterLimit() != null) {
                printStream.println(string + "  " + LoadModuleRefAttributeName.RestartCounterLimit.getValue() + " = \"" + this.myOptionalAttributes.getRestartCounterLimit() + "\"");
            }
            if (this.myOptionalAttributes.getRestartTimer() != null) {
                printStream.println(string + "  " + LoadModuleRefAttributeName.RestartTimer.getValue() + " = \"" + this.myOptionalAttributes.getRestartTimer() + "\"");
            }
        }
        printStream.println(string + "/>");
    }

    public void setTag(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setTag(Integer aTag)", (String)("aTag: " + n));
        }
        this.myTag = n.toString();
    }

    public void setProgramMemoryPoolSize(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setProgramMemoryPoolSize(Integer aProgramMemoryPoolSize)", (String)("aProgramMemoryPoolSize: " + n));
        }
        if (this.myOptionalAttributes != null) {
            this.myOptionalAttributes.setProgramMemoryPoolSize(n.toString());
        } else {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(n.toString(), null, null, null, null, null, null, null);
        }
    }

    public void setProgramMemoryHeapSize(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setProgramMemoryHeapSize(Integer aProgramMemoryHeapSize)", (String)("aProgramMemoryHeapSize: " + n));
        }
        if (this.myOptionalAttributes != null) {
            this.myOptionalAttributes.setProgramMemoryHeapSize(n.toString());
        } else {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(null, n.toString(), null, null, null, null, null, null);
        }
    }

    public void setProgramInstances(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setProgramInstances(String aProgramInstances)", (String)("aProgramInstances: " + string));
        }
        if (this.myOptionalAttributes != null) {
            this.myOptionalAttributes.setProgramInstances(string);
        } else {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(null, null, string, null, null, null, null, null);
        }
    }

    public void setLoaderName(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setLoaderName(String aLoaderName)", (String)("aLoaderName: " + string));
        }
        if (this.myOptionalAttributes != null) {
            this.myOptionalAttributes.setLoaderName(string);
        } else {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(null, null, null, string, null, null, null, null);
        }
    }

    public void setDeviceLoaderName(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDeviceLoaderName(String aDeviceLoaderName)", (String)("aDeviceLoaderName: " + string));
        }
        if (this.myOptionalAttributes != null) {
            this.myOptionalAttributes.setDeviceLoaderName(string);
        } else {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(null, null, null, null, string, null, null, null);
        }
    }

    public void setDeviceLoaderInformation(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setDeviceLoaderInformation(String aDeviceLoaderInformation)", (String)("aDeviceLoaderInformation: " + string));
        }
        if (this.myOptionalAttributes != null) {
            this.myOptionalAttributes.setDeviceLoaderInformation(string);
        } else {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(null, null, null, null, null, string, null, null);
        }
    }

    public void setRestartCounterLimit(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setRestartCounterLimit(Integer aRestartCounterLimit)", (String)("aRestartCounterLimit: " + n));
        }
        if (this.myOptionalAttributes != null) {
            this.myOptionalAttributes.setRestartCounterLimit(n.toString());
        } else {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(null, null, null, null, null, null, n.toString(), null);
        }
    }

    public void setRestartTimer(Integer n) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"setRestartTimer(Integer aRestartTimer)", (String)("aRestartTimer: " + n));
        }
        if (this.myOptionalAttributes != null) {
            this.myOptionalAttributes.setRestartCounterLimit(n.toString());
        } else {
            this.myOptionalAttributes = new LoadModuleRefOptionalAttributes(null, null, null, null, null, null, null, n.toString());
        }
    }

    public void validate() throws ValidateException {
        String[] stringArray;
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"validate( )");
        }
        LoadModuleRefAttributeName.Tag.validate(this.myTag, super.getLocatorData(), false);
        LoadModuleRefAttributeName.ProductNumber.validate(this.getProductNumber(), super.getLocatorData(), false);
        LoadModuleRefAttributeName.Revision.validate(this.getRevision(), super.getLocatorData(), false);
        String string = null;
        if (this.myOptionalAttributes != null) {
            string = this.myOptionalAttributes.getProgramMemoryPoolSize();
        }
        LoadModuleRefAttributeName.ProgramMemoryPoolSize.validate(string, super.getLocatorData(), false);
        String string2 = null;
        if (this.myOptionalAttributes != null) {
            string2 = this.myOptionalAttributes.getProgramMemoryHeapSize();
        }
        LoadModuleRefAttributeName.ProgramMemoryHeapSize.validate(string2, super.getLocatorData(), false);
        String string3 = null;
        if (this.myOptionalAttributes != null) {
            string3 = this.myOptionalAttributes.getProgramInstances();
        }
        LoadModuleRefAttributeName.ProgramInstances.validate(string3, super.getLocatorData(), false);
        String string4 = null;
        if (this.myOptionalAttributes != null) {
            string4 = this.myOptionalAttributes.getLoaderName();
        }
        LoadModuleRefAttributeName.LoaderName.validate(string4, super.getLocatorData(), false);
        String string5 = null;
        if (this.myOptionalAttributes != null) {
            string5 = this.myOptionalAttributes.getDeviceLoaderName();
        }
        LoadModuleRefAttributeName.DeviceLoaderName.validate(string5, super.getLocatorData(), false);
        String string6 = null;
        if (this.myOptionalAttributes != null) {
            string6 = this.myOptionalAttributes.getDeviceLoaderInformation();
        }
        LoadModuleRefAttributeName.DeviceLoaderInformation.validate(string6, super.getLocatorData(), false);
        String string7 = null;
        if (this.myOptionalAttributes != null) {
            string7 = this.myOptionalAttributes.getRestartCounterLimit();
        }
        LoadModuleRefAttributeName.RestartCounterLimit.validate(string7, super.getLocatorData(), false);
        String string8 = null;
        if (this.myOptionalAttributes != null) {
            string8 = this.myOptionalAttributes.getRestartTimer();
        }
        LoadModuleRefAttributeName.RestartTimer.validate(string8, super.getLocatorData(), false);
        if (string4 != null && string4.equals(LoadModuleRefLoaderNameValue.DeviceLoader) && string5 == null) {
            super.errorAdditionalInfoAttributeMissing(this.getClass(), "validate( )", PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), LoadModuleRefAttributeName.DeviceLoaderName.getValue(), "\n\tThe attribute " + LoadModuleRefAttributeName.DeviceLoaderName.getValue() + " is mandatory when attribute " + LoadModuleRefAttributeName.LoaderName.getValue() + " has been assigned value " + LoadModuleRefLoaderNameValue.DeviceLoader + ".", super.getLocatorData());
        }
        if (!(string5 == null || string4 != null && string4.equals(LoadModuleRefLoaderNameValue.DeviceLoader))) {
            stringArray = new String[]{MoDataLM_AttributeName.DeviceLoaderName.getValue()};
            super.errorUnexpectedAttribute(this.getClass(), "validate( )", RepertoireSubElementName.PiuTypeLoadList.getValue(), PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), stringArray, "\n\tAttribute " + LoadModuleRefAttributeName.DeviceLoaderName.getValue() + " is only allowed if attribute " + LoadModuleRefAttributeName.LoaderName.getValue() + " has been assigned the value " + LoadModuleRefLoaderNameValue.DeviceLoader + ".", super.getLocatorData());
        }
        if (!(string6 == null || string4 != null && string4.equals(LoadModuleRefLoaderNameValue.DeviceLoader))) {
            stringArray = new String[]{LoadModuleRefAttributeName.DeviceLoaderInformation.getValue()};
            super.errorUnexpectedAttribute(this.getClass(), "validate( )", RepertoireSubElementName.PiuTypeLoadList.getValue(), PiuTypeLoadListSubElementName.LoadModuleRef.getValue(), stringArray, "\n\tAttribute " + LoadModuleRefAttributeName.DeviceLoaderInformation.getValue() + " is only allowed if attribute " + LoadModuleRefAttributeName.LoaderName.getValue() + " has been assigned the value " + LoadModuleRefLoaderNameValue.DeviceLoader + ".", super.getLocatorData());
        }
    }

    public String toString() {
        return super.toString() + "\n\t\tTag: " + this.myTag + "\n\t\tProgramMemoryPoolSize: " + this.getProgramMemoryPoolSizeForToString() + "\n\t\tProgramMemoryHeapSize: " + this.getProgramMemoryHeapSizeForToString() + "\n\t\tProgramInstances: " + this.getProgramInstancesForToString() + "\n\t\tLoaderName: " + this.getLoaderNameForToString() + "\n\t\tDeviceLoaderName: " + this.getDeviceLoaderNameForToString() + "\n\t\tDeviceLoaderInformation: " + this.getDeviceLoaderInformationForToString() + "\n\t\tRestartCounterLimit: " + this.getRestartCounterLimitForToString() + "\n\t\tRestartTimer: " + this.getRestartTimerForToString() + "\n\t";
    }
}

