/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.parser.dom.verifyupgradesequence;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.Locator;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.dom.installsequence.SoftJvmUpgrade;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.Trigger;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.TriggerAttributeName;
import se.ericsson.cello.sudom.parser.dom.upgradesequence.TriggerSubSpecValue;
import se.ericsson.cello.sudom.parser.dom.validators.Validator;
import se.ericsson.cello.sudom.parser.dom.verifysequence.VerifyStep;
import se.ericsson.cello.sudom.parser.dom.verifysequence.VerifyStepAttributeName;
import se.ericsson.cello.sudom.parser.dom.verifysequence.VerifyStepSubElementName;
import se.ericsson.cello.sudom.parser.dom.verifyupgradesequence.VerifyUpgradeSequence;
import se.ericsson.cello.sudom.parser.dom.verifyupgradesequence.VerifyUpgradeSequenceSubElementName;
import se.ericsson.cello.sudom.parser.exceptions.ValidateException;

public class VerifyUpgradeSequenceValidator
extends Validator {
    public static void validate(VerifyUpgradeSequence verifyUpgradeSequence, Locator locator) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpgradeSequenceValidator.class, (int)25, (String)"validate(VerifyUpgradeSequence aVerifyUpgradeSequence, Locator aLocator)", (String)("aVerifyUpgradeSequence: " + verifyUpgradeSequence + "\n\taLocator: " + locator));
        }
        Vector vector = verifyUpgradeSequence.getVerifySteps();
        Iterator iterator = vector.iterator();
        VerifyStep verifyStep = null;
        int n = 0;
        int n2 = 0;
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            verifyStep = (VerifyStep)iterator.next();
            VerifyUpgradeSequenceValidator.validateThatVerifyStepContainsA_KnownSubElement(verifyStep);
            VerifyUpgradeSequenceValidator.validateThatSoftJvmUpgradeInVerifyStepContainsA_KnownSubElement(verifyStep);
            n = VerifyUpgradeSequenceValidator.validateThatOneAndOnlyOneVerifyStepContainsA_VerifyUP(verifyStep, locator, n, iterator.hasNext());
            n2 = VerifyUpgradeSequenceValidator.validateThatNoneOrOnlyOneVerifyStepContainsA_PreUpgradeSu(verifyStep, n2);
            VerifyUpgradeSequenceValidator.validateThatLabelIsUniqueForAllVerifySteps(verifyStep, hashSet);
            VerifyUpgradeSequenceValidator.valdateThatTriggerInVerifyStepContainsAllowedSubSpecValue(verifyStep);
        }
    }

    private static void validateThatVerifyStepContainsA_KnownSubElement(VerifyStep verifyStep) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpgradeSequenceValidator.class, (int)25, (String)"validateThatVerifyStepContainsA_KnownSubElement(VerifyStep aVerifyStep)", (String)("aVerifyStep: " + verifyStep));
        }
        if (verifyStep.getPreUpgradeSu() == null && verifyStep.getVerifyUP() == null && verifyStep.getSoftJvmUpgrade() == null && verifyStep.getTrigger() == null) {
            String string = "\n\tA " + VerifyUpgradeSequenceSubElementName.VerifyStep.getValue() + " element must contain at least one sub element of known type.";
            VerifyUpgradeSequenceValidator.errorElementIsMissingNoSubElementWithLocatorString(VerifyUpgradeSequenceValidator.class, "validateThatVerifyStepContainsA_KnownSubElement(VerifyStep aVerifyStep)", "VerifyUpgradeSequence", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), string, verifyStep.getLocatorString());
        }
    }

    private static void validateThatLabelIsUniqueForAllVerifySteps(VerifyStep verifyStep, HashSet hashSet) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpgradeSequenceValidator.class, (int)25, (String)"validateThatLabelIsUniqueForAllVerifySteps(VerifyStep aVerifyStep, HashSet aLabels)", (String)("aVerifyStep: " + verifyStep + "\n\taLabels: " + hashSet));
        }
        if (!hashSet.add(verifyStep.getLabel().toUpperCase())) {
            String string = "\n\tThe value of this attribute must be unique among all " + VerifyUpgradeSequenceSubElementName.VerifyStep.getValue() + " elements in this " + "VerifyUpgradeSequence" + ".";
            VerifyUpgradeSequenceValidator.errorIllegalAttributeValueWithLocatorString(VerifyUpgradeSequenceValidator.class, "validateThatLabelIsUniqueForAllVerifySteps(VerifyStep aVerifyStep, HashSet aLabels)", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), VerifyStepAttributeName.Label.getValue(), verifyStep.getLabel(), string, verifyStep.getLocatorString());
        }
    }

    private static int validateThatNoneOrOnlyOneVerifyStepContainsA_PreUpgradeSu(VerifyStep verifyStep, int n) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpgradeSequenceValidator.class, (int)25, (String)"validateThatNoneOrOnlyOneVerifyStepContainsA_PreUpgradeSu(VerifyStep aVerifyStep, int aNumberOfVerifyStepsContainingA_PreUpgradeSu)", (String)("aVerifyStep: " + verifyStep + "\n\taNumberOfVerifyStepsContainingA_PreUpgradeSu: " + n));
        }
        if (verifyStep.getPreUpgradeSu() != null && ++n > 1) {
            String string = "\n\tA VerifyUpgradeSequence element is only allowed to contain one " + VerifyUpgradeSequenceSubElementName.VerifyStep.getValue() + " element that contains a " + VerifyStepSubElementName.PreUpgradeSu.getValue() + " element.";
            VerifyUpgradeSequenceValidator.errorUnexpectedElementWithLocatorString(VerifyUpgradeSequenceValidator.class, "validateThatNoneOrOnlyOneVerifyStepContainsA_PreUpgradeSu(VerifyStep aVerifyStep, int aNumberOfVerifyStepsContainingA_PreUpgradeSu)", "VerifyUpgradeSequence", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), VerifyStepSubElementName.PreUpgradeSu.getValue(), string, verifyStep.getPreUpgradeSu().getLocatorString());
        }
        return n;
    }

    private static int validateThatOneAndOnlyOneVerifyStepContainsA_VerifyUP(VerifyStep verifyStep, Locator locator, int n, boolean bl) throws ValidateException {
        if (UpgradeTrace.valid((Class)VerifyUpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpgradeSequenceValidator.class, (int)25, (String)"validateThatOneAndOnlyOneVerifyStepContainsA_VerifyUP(VerifyStep aVerifyStep, Locator aLocator, int aNumberOfVerifyStepsContainingA_VerifyUP, boolean anIsVerifyUpgradeSequenceContainingMoreVerifySteps)", (String)("aVerifyStep: " + verifyStep + "\n\taLocator: " + locator + "\n\taNumberOfVerifyStepsContainingA_VerifyUP: " + n + "\n\tanIsVerifyUpgradeSequenceContainingMoreVerifySteps: " + bl));
        }
        String string = null;
        if (verifyStep.getVerifyUP() != null) {
            if (++n > 1) {
                string = "\n\tA VerifyUpgradeSequence element is only allowed to contain one " + VerifyUpgradeSequenceSubElementName.VerifyStep.getValue() + " element that contains a " + VerifyStepSubElementName.VerifyUP.getValue() + " element.";
                VerifyUpgradeSequenceValidator.errorUnexpectedElementWithLocatorString(VerifyUpgradeSequenceValidator.class, "validateThatOneAndOnlyOneVerifyStepContainsA_VerifyUP(VerifyStep aVerifyStep, Locator aLocator, int aNumberOfVerifyStepsContainingA_VerifyUP, boolean anIsVerifyUpgradeSequenceContainingMoreVerifySteps)", "VerifyUpgradeSequence", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), VerifyStepSubElementName.VerifyUP.getValue(), string, verifyStep.getVerifyUP().getLocatorString());
            }
        } else if (!bl && n == 0) {
            string = "\n\tA VerifyUpgradeSequence element must contain one " + VerifyUpgradeSequenceSubElementName.VerifyStep.getValue() + " element that contains a " + VerifyStepSubElementName.VerifyUP.getValue() + " element.";
            VerifyUpgradeSequenceValidator.errorElementIsMissingOneElement(VerifyUpgradeSequenceValidator.class, "validateThatOneAndOnlyOneVerifyStepContainsA_VerifyUP(VerifyStep aVerifyStep, Locator aLocator, int aNumberOfVerifyStepsContainingA_VerifyUP, boolean anIsVerifyUpgradeSequenceContainingMoreVerifySteps)", "VerifyUpgradeSequence", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), VerifyStepSubElementName.VerifyUP.getValue(), string, locator);
        }
        return n;
    }

    private static void validateThatSoftJvmUpgradeInVerifyStepContainsA_KnownSubElement(VerifyStep verifyStep) throws ValidateException {
        SoftJvmUpgrade softJvmUpgrade;
        if (UpgradeTrace.valid((Class)VerifyUpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpgradeSequenceValidator.class, (int)25, (String)"validateThatSoftJvmUpgradeInVerifyStepContainsA_KnownSubElement(VerifyStep aVerifyStep, Locator aLocator)", (String)("aVerifyStep: " + verifyStep));
        }
        if ((softJvmUpgrade = verifyStep.getSoftJvmUpgrade()) != null && softJvmUpgrade.getLoadJavaLMs().isEmpty() && softJvmUpgrade.getUnloadJavaLMs().isEmpty()) {
            String string = "\n\tA " + VerifyStepSubElementName.SoftJvmUpgrade.getValue() + " element must contain at least one sub element of known type.";
            VerifyUpgradeSequenceValidator.errorElementIsMissingNoSubElementWithLocatorString(VerifyUpgradeSequenceValidator.class, "validateThatSoftJvmUpgradeInVerifyStepContainsA_KnownSubElement(VerifyStep aVerifyStep)", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), VerifyStepSubElementName.SoftJvmUpgrade.getValue(), string, softJvmUpgrade.getLocatorString());
        }
    }

    private static void valdateThatTriggerInVerifyStepContainsAllowedSubSpecValue(VerifyStep verifyStep) throws ValidateException {
        String string;
        Trigger trigger;
        if (UpgradeTrace.valid((Class)VerifyUpgradeSequenceValidator.class, (int)25)) {
            UpgradeTrace.debug((Class)VerifyUpgradeSequenceValidator.class, (int)25, (String)"valdateThatTriggerInVerifyStepContainsAllowedSubSpecValue(VerifyStep aVerifyStep)", (String)("aVerifyStep: " + verifyStep));
        }
        if ((trigger = verifyStep.getTrigger()) != null && !TriggerSubSpecValue.isValuePreDefinedForVerifyUpgradeSequence(string = trigger.getSubSpec())) {
            if (TriggerSubSpecValue.isValuePreDefinedForPreCheckSequence(string)) {
                String string2 = "\n\tThe requested value is the value that is predefined for an InstallSequence,";
                if (TriggerSubSpecValue.isValuePreDefinedForVerifySequence(string)) {
                    string2 = "\n\tThe requested value is the value that is predefined for a VerifySequence,";
                } else if (TriggerSubSpecValue.isValuePreDefinedForVerifyUpdateSequence(string)) {
                    string2 = "\n\tThe requested value is the value that is predefined for a VerifyUpdateSequence,";
                }
                String string3 = "\n\tthis value is not allowed in a VerifyUpgradeSequence.";
                VerifyUpgradeSequenceValidator.errorIllegalAttributeValueWithLocatorString(VerifyUpgradeSequenceValidator.class, "valdateThatTriggerInVerifyStepContainsAllowedSubSpecValue(VerifyStep aVerifyStep)", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), VerifyStepSubElementName.Trigger.getValue(), TriggerAttributeName.SubSpec.getValue(), string, string2 + string3, trigger.getLocatorString());
            } else if (TriggerSubSpecValue.isValuePreDefinedForUpgradeSequence(string)) {
                String string4 = "\n\tThe requested value is one of the values that is predefined for an UpgradeSequence,\n\tthis value is not allowed in a VerifyUpgradeSequence.";
                VerifyUpgradeSequenceValidator.errorIllegalAttributeValueWithLocatorString(VerifyUpgradeSequenceValidator.class, "valdateThatTriggerInVerifyStepContainsAllowedSubSpecValue(VerifyStep aVerifyStep)", VerifyUpgradeSequenceSubElementName.VerifyStep.getValue(), VerifyStepSubElementName.Trigger.getValue(), TriggerAttributeName.SubSpec.getValue(), string, string4, trigger.getLocatorString());
            }
        }
    }
}

