/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.sudom.proxy.explicitreplacement;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.mao.UpgradeTrace;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.NewRpu;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.OldRpu;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.OldRpu2;
import se.ericsson.cello.sudom.parser.dom.explicitreplacement.RpuAddition;
import se.ericsson.cello.sudom.proxy.exceptions.DocumentObjectProxyException;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_AdditionsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_BaseInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_CopyFromOneRPU_Information;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_CopyFromTwoRPUsInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_ModificationInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_NormalisationModeEnum;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_PropertyInformation;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_ReplicationModeEnum;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RPU_SwitchOverModeEnum;

public class RPU_AdditionsProxy
implements RPU_AdditionsProxyInterface {
    private Collection myRPU_Additions = null;

    public RPU_AdditionsProxy(Collection collection) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"RPU_AdditionsProxy(Collection aRpuAdditions)", (String)("aRpuAdditions: " + collection));
        }
        this.myRPU_Additions = collection;
    }

    public Collection getRPUsToBeModified() throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRPUsToBeModified()");
        }
        Iterator iterator = this.myRPU_Additions.iterator();
        RpuAddition rpuAddition = null;
        LinkedList<RPU_ModificationInformation> linkedList = new LinkedList<RPU_ModificationInformation>();
        OldRpu oldRpu = null;
        OldRpu2 oldRpu2 = null;
        Vector vector = null;
        NewRpu newRpu = null;
        while (iterator.hasNext()) {
            rpuAddition = (RpuAddition)iterator.next();
            if (!"yes".equals(rpuAddition.getModifyExisting())) continue;
            oldRpu = rpuAddition.getOldRpu();
            oldRpu2 = rpuAddition.getOldRpu2();
            vector = rpuAddition.getNewRpus();
            newRpu = (NewRpu)vector.elementAt(0);
            linkedList.add(this.getRPU_ModificationInformation(oldRpu, oldRpu2, newRpu));
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getRPUsToBeModified()", (String)("RETURNS - theRPUsToBeModified: " + linkedList));
        }
        return linkedList;
    }

    public Collection getRPUsToBeCopiedFromOneRPU() throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRPUsToBeCopiedFromOneRPU( )");
        }
        Iterator iterator = this.myRPU_Additions.iterator();
        RpuAddition rpuAddition = null;
        LinkedList<RPU_CopyFromOneRPU_Information> linkedList = new LinkedList<RPU_CopyFromOneRPU_Information>();
        OldRpu oldRpu = null;
        Vector vector = null;
        while (iterator.hasNext()) {
            rpuAddition = (RpuAddition)iterator.next();
            if ("yes".equals(rpuAddition.getModifyExisting()) || rpuAddition.getOldRpu2() != null) continue;
            oldRpu = rpuAddition.getOldRpu();
            vector = rpuAddition.getNewRpus();
            linkedList.add(this.getRPU_CopyFromOneRPU_Information(oldRpu, vector));
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getRPUsToBeCopiedFromOneRPU( )", (String)("RETURNS - theRPUsToBeCopiedFromOneRPU: " + linkedList));
        }
        return linkedList;
    }

    public Collection getRPUsToBeCopiedFromTwoRPUs() throws DocumentObjectProxyException {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRPUsToBeCopiedFromTwoRPUs( )");
        }
        Iterator iterator = this.myRPU_Additions.iterator();
        RpuAddition rpuAddition = null;
        LinkedList<RPU_CopyFromTwoRPUsInformation> linkedList = new LinkedList<RPU_CopyFromTwoRPUsInformation>();
        OldRpu oldRpu = null;
        OldRpu2 oldRpu2 = null;
        Vector vector = null;
        while (iterator.hasNext()) {
            rpuAddition = (RpuAddition)iterator.next();
            if ("yes".equals(rpuAddition.getModifyExisting()) || rpuAddition.getOldRpu2() == null) continue;
            oldRpu = rpuAddition.getOldRpu();
            oldRpu2 = rpuAddition.getOldRpu2();
            vector = rpuAddition.getNewRpus();
            linkedList.add(this.getRPU_CopyFromTwoRPUsInformation(oldRpu, oldRpu2, vector));
        }
        if (UpgradeTrace.valid(this.getClass(), (int)26)) {
            UpgradeTrace.debug(this.getClass(), (int)26, (String)"getRPUsToBeCopiedFromOneRPU( )", (String)("RETURNS - theRPUsToBeCopiedFromTwoRPUs: " + linkedList));
        }
        return linkedList;
    }

    private RPU_CopyFromOneRPU_Information getRPU_CopyFromOneRPU_Information(OldRpu oldRpu, Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRPU_CopyFromOneRPU_Information(OldRpu anOldRPU, Vector aNewRPUs)", (String)("anOldRPU: " + oldRpu + "\n\taNewRPUs: " + vector));
        }
        String string = oldRpu.getRpLabel();
        RPU_BaseInformation rPU_BaseInformation = new RPU_BaseInformation(string);
        Iterator iterator = vector.iterator();
        NewRpu newRpu = null;
        RPU_PropertyInformation rPU_PropertyInformation = null;
        LinkedList<RPU_PropertyInformation> linkedList = new LinkedList<RPU_PropertyInformation>();
        while (iterator.hasNext()) {
            newRpu = (NewRpu)iterator.next();
            rPU_PropertyInformation = this.getRPU_PropertyInformationForCopyRPU(newRpu);
            linkedList.add(rPU_PropertyInformation);
        }
        return new RPU_CopyFromOneRPU_Information(rPU_BaseInformation, linkedList);
    }

    private RPU_CopyFromTwoRPUsInformation getRPU_CopyFromTwoRPUsInformation(OldRpu oldRpu, OldRpu2 oldRpu2, Vector vector) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRPU_CopyFromTwoRPUsInformation(OldRpu anOldRPU, OldRpu2 anOldRPU_2, Vector aNewRPUs)", (String)("anOldRPU: " + oldRpu + "\n\tanOldRPU_2: " + oldRpu2 + "\n\taNewRPUs: " + vector));
        }
        String string = oldRpu.getRpLabel();
        RPU_BaseInformation rPU_BaseInformation = new RPU_BaseInformation(string);
        String string2 = oldRpu2.getRpLabel();
        RPU_BaseInformation rPU_BaseInformation2 = new RPU_BaseInformation(string2);
        Iterator iterator = vector.iterator();
        NewRpu newRpu = null;
        RPU_PropertyInformation rPU_PropertyInformation = null;
        LinkedList<RPU_PropertyInformation> linkedList = new LinkedList<RPU_PropertyInformation>();
        while (iterator.hasNext()) {
            newRpu = (NewRpu)iterator.next();
            rPU_PropertyInformation = this.getRPU_PropertyInformationForCopyRPU(newRpu);
            linkedList.add(rPU_PropertyInformation);
        }
        return new RPU_CopyFromTwoRPUsInformation(rPU_BaseInformation, rPU_BaseInformation2, linkedList);
    }

    private RPU_ModificationInformation getRPU_ModificationInformation(OldRpu oldRpu, OldRpu2 oldRpu2, NewRpu newRpu) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRPU_ModificationInformation ( OldRpu anOldRPU, OldRpu2 anOldRPU2, NewRPU aNewRPU )", (String)("anOldRPU: " + oldRpu + "\n\tanOldRpu2: " + oldRpu2 + "\n\taNewRPU: " + newRpu));
        }
        String string = oldRpu.getRpLabel();
        String string2 = null;
        if (oldRpu2 != null) {
            string2 = oldRpu2.getRpLabel();
        }
        RPU_NormalisationModeEnum rPU_NormalisationModeEnum = this.getNormalisationMode(newRpu.getNormalisation());
        RPU_ReplicationModeEnum rPU_ReplicationModeEnum = this.getReplicationMode(newRpu.getReplication());
        RPU_SwitchOverModeEnum rPU_SwitchOverModeEnum = this.getSwitchOverMode(newRpu.getSwitchOver());
        boolean bl = false;
        if ("yes".equals(newRpu.getOneLegged())) {
            bl = true;
        }
        Boolean bl2 = null;
        if (newRpu.getIsForDeviceProgram() == null) {
            bl2 = null;
        } else if ("yes".equals(newRpu.getIsForDeviceProgram())) {
            bl2 = true;
        }
        String string3 = newRpu.getRpLabel();
        return new RPU_ModificationInformation(new RPU_PropertyInformation(string, string2, rPU_NormalisationModeEnum, rPU_ReplicationModeEnum, rPU_SwitchOverModeEnum, bl, string3, bl2));
    }

    private RPU_PropertyInformation getRPU_PropertyInformationForCopyRPU(NewRpu newRpu) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getRPU_PropertyInformationForCopyRPU(NewRpu aNewRPU)", (String)("aNewRPU: " + newRpu));
        }
        String string = newRpu.getRpLabel();
        boolean bl = false;
        if ("yes".equals(newRpu.getReverseRelations())) {
            bl = true;
        }
        RPU_NormalisationModeEnum rPU_NormalisationModeEnum = this.getNormalisationMode(newRpu.getNormalisation());
        RPU_ReplicationModeEnum rPU_ReplicationModeEnum = this.getReplicationMode(newRpu.getReplication());
        RPU_SwitchOverModeEnum rPU_SwitchOverModeEnum = this.getSwitchOverMode(newRpu.getSwitchOver());
        boolean bl2 = true;
        if ("yes".equals(newRpu.getCreateOnlyIfNotExisting())) {
            bl2 = false;
        }
        boolean bl3 = false;
        if ("yes".equals(newRpu.getOneLegged())) {
            bl3 = true;
        }
        Boolean bl4 = null;
        if (newRpu.getIsForDeviceProgram() == null) {
            bl4 = null;
        } else if ("yes".equals(newRpu.getIsForDeviceProgram())) {
            bl4 = true;
        }
        return new RPU_PropertyInformation(string, bl, rPU_NormalisationModeEnum, rPU_ReplicationModeEnum, rPU_SwitchOverModeEnum, bl2, bl3, bl4);
    }

    private RPU_NormalisationModeEnum getNormalisationMode(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getNormalisationMode ( String aNewRPU_NormalisationMode )");
        }
        if (string == null) {
            return null;
        }
        if ("automatic".equals(string)) {
            return RPU_NormalisationModeEnum.Automatic;
        }
        if ("manual".equals(string)) {
            return RPU_NormalisationModeEnum.Manual;
        }
        UpgradeTrace.info(this.getClass(), (String)"getNormalisationMode ( String aNewRPU_NormalisationMode )", (String)("Unexpected value in aNewRPU_NormalisationMode (ignored).\n\taNewRPU_NormalisationMode: " + string));
        return null;
    }

    private RPU_ReplicationModeEnum getReplicationMode(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getReplicationMode ( String aNewRPU_ReplicationMode )");
        }
        if (string == null) {
            return null;
        }
        if ("always".equals(string)) {
            return RPU_ReplicationModeEnum.Always;
        }
        if ("applControlled".equals(string)) {
            return RPU_ReplicationModeEnum.ApplControlled;
        }
        if ("atShutDown".equals(string)) {
            return RPU_ReplicationModeEnum.AtShutdown;
        }
        if ("never".equals(string)) {
            return RPU_ReplicationModeEnum.Never;
        }
        UpgradeTrace.info(this.getClass(), (String)"getReplicationMode ( String aNewRPU_ReplicationMode )", (String)("Unexpected value in aNewRPU_ReplicationMode (ignored).\n\taNewRPU_ReplicationMode: " + string));
        return null;
    }

    private RPU_SwitchOverModeEnum getSwitchOverMode(String string) {
        if (UpgradeTrace.valid(this.getClass(), (int)25)) {
            UpgradeTrace.debug(this.getClass(), (int)25, (String)"getSwitchOverMode ( String aNewRPU_SwitchOverMode )");
        }
        if (string == null) {
            return null;
        }
        if ("atPiuFault".equals(string)) {
            return RPU_SwitchOverModeEnum.AtPIU_Fault;
        }
        if ("atPiuRestart".equals(string)) {
            return RPU_SwitchOverModeEnum.AtPIU_Restart;
        }
        UpgradeTrace.info(this.getClass(), (String)"getSwitchOverMode ( String aNewRPU_SwitchOverMode )", (String)("Unexpected value in aNewRPU_SwitchOverMode (ignored).\n\taNewRPU_SwitchOverMode: " + string));
        return null;
    }
}

