/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.delete;

import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.su.extsuif.upgradepackage.util.constants.SystemUpgradeConstantsInterface;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.FilepathHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.parser.MainElementHolder;
import se.ericsson.cello.sudom.parser.ParserKeyInformation;
import se.ericsson.cello.sudom.parser.UpgradeControlFileParserFactory;
import se.ericsson.cello.sudom.parser.dom.DocumentObjectUpgradePackage;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxy;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleInformation;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModuleProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.LoadModulesProxyInterface;
import se.ericsson.cello.sudom.proxy.loadmodule.UpLmDataRemove;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.upgradepackage.delete.DataOfLoadModulesToBeDeleted;
import se.ericsson.cello.upgradepackage.delete.LoadModuleMOsAndFilesToBeDeleted;
import se.ericsson.cello.upgradepackage.delete.LoadModulesToBeDeletedAnalyserException;
import se.ericsson.cello.upgradepackage.delete.UpgradePackageLoadModuleFileHolder;
import se.ericsson.cello.upgradepackage.main.exception.UpgradePackageDeleteException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;

public class LoadModulesToBeDeletedAnalyser {
    private SystemUpgradeConstantsInterface mySystemUpgradeConstantsInterface = (SystemUpgradeConstantsInterface)ServiceLocatorFacade.getRepository().getService(SystemUpgradeConstantsInterface.class);

    public LoadModulesToBeDeletedAnalyser() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "LoadModulesToBeDeletedAnalyser( )");
        }
    }

    public Collection collectLMsDataThatMayBeDeleted(DocumentObjectProxyInterface documentObjectProxyInterface, String string, String string2) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLMsDataThatMayBeDeleted(DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aProductNumber, String aProductRevision)", "aDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            LoadModulesProxyInterface loadModulesProxyInterface = documentObjectProxyInterface.getLoadModulesProxyInterface();
            DataOfLoadModulesToBeDeleted dataOfLoadModulesToBeDeleted = this.collectDataOfLoadModulesToBeDeleted(loadModulesProxyInterface, string, string2);
            Collection collection = this.getProductNumberAndRevisionsOfLMsToDelete(dataOfLoadModulesToBeDeleted.getLoadModulesToBeDeletedData());
            LoadModuleProxyInterface loadModuleProxyInterface = null;
            LoadModuleInformation loadModuleInformation = null;
            Iterator iterator = collection.iterator();
            ProductNumberAndRevision productNumberAndRevision = null;
            LinkedList<LoadModuleInformation> linkedList = new LinkedList<LoadModuleInformation>();
            while (iterator.hasNext()) {
                productNumberAndRevision = (ProductNumberAndRevision)iterator.next();
                loadModuleProxyInterface = loadModulesProxyInterface.getLoadModuleProxyInterface(productNumberAndRevision);
                loadModuleInformation = loadModuleProxyInterface.getLoadModuleInformation();
                linkedList.add(loadModuleInformation);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "collectLMsDataThatMayBeDeleted(DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aProductNumber, String aProductRevision)", "RETURNS - theNotrequiredLoadModuleInformations: " + linkedList);
            }
            return linkedList;
        }
        catch (LoadModulesToBeDeletedAnalyserException loadModulesToBeDeletedAnalyserException) {
            throw loadModulesToBeDeletedAnalyserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLMsDataThatMayBeDeleted(DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aProductNumber, String aProductRevision)", "Throwable caught.\n\taDocumentObjectProxyInterface: " + documentObjectProxyInterface + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectLMsDataThatMayBeDeleted(DocumentObjectProxyInterface aDocumentObjectProxyInterface, String aProductNumber, String aProductRevision)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    public LoadModuleMOsAndFilesToBeDeleted collectLoadModuleMOsAndFilesToBeDeleted(String string, File file, String string2, String string3) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLoadModuleMOsAndFilesToBeDeleted(String aControlFileName, File aControlFile, String aProductNumber, String aProductRevision)", "aControlFileName: " + string + "\n\taControlFile: " + file.getPath() + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3);
        }
        try {
            if (!file.exists()) {
                if (!(file = new File(file.getAbsoluteFile() + "Original")).exists()) {
                    Trace.info(this.getClass(), "collectDataOfLoadModulesToBeDeleted(String aControlFileName, File aControlFile)", "Not possible to delete the UP since no UCF file exists for it");
                    throw new UpgradePackageDeleteException("Not possible to delete the UP since no UCF file exists for it");
                }
                Trace.log1(this.getClass(), "collectDataOfLoadModulesToBeDeleted(String aControlFileName, File aControlFile)", "Using the UCF file " + file.getAbsoluteFile() + " since the .xml file is missing");
            }
            DataOfLoadModulesToBeDeleted dataOfLoadModulesToBeDeleted = this.collectDataOfLoadModulesToBeDeleted(file.getAbsolutePath(), string2, string3);
            UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder = this.collectLoadModuleFilesToBeDeleted(dataOfLoadModulesToBeDeleted, string);
            Vector vector = this.collectLoadModuleMOsToBeDeleted(dataOfLoadModulesToBeDeleted);
            return new LoadModuleMOsAndFilesToBeDeleted(vector, upgradePackageLoadModuleFileHolder);
        }
        catch (LoadModulesToBeDeletedAnalyserException loadModulesToBeDeletedAnalyserException) {
            throw loadModulesToBeDeletedAnalyserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectDataOfLoadModulesToBeDeleted(String aControlFileName, File aControlFile, String aProductNumber, String aProductRevision)", "Throwable caught.\n\taControlFileName: " + string + "\n\taControlFile: " + file.getPath() + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectDataOfLoadModulesToBeDeleted(String aControlFileName, File aControlFile, String aProductNumber, String aProductRevision)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private UpgradePackageLoadModuleFileHolder addLoadModuleFileIfItExists(UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addLoadModuleFileIfItExists( UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFileHolder, String aLoadModuleFilePath)", "anUpgradePackageLoadModuleFileHolder: " + upgradePackageLoadModuleFileHolder + "\n\taLoadModuleFilePath: " + string);
        }
        try {
            if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath())) {
                File file = new File(string);
                if (file.exists()) {
                    upgradePackageLoadModuleFileHolder.addMasterLoadModuleFilePath(file);
                }
                if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath())) {
                    String string2 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + string.substring(this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath().length());
                    upgradePackageLoadModuleFileHolder.addReplicatedLoadModuleFilePath(string2);
                } else if (string.startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) {
                    String string3 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath() + string.substring(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath().length());
                    upgradePackageLoadModuleFileHolder.addReplicatedLoadModuleFilePath(string3);
                } else if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_2", (Object)this.mySystemUpgradeConstantsInterface) && string.startsWith(this.mySystemUpgradeConstantsInterface.getCertCrlInstallLmRootPath())) {
                    String string4 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + string.substring(this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath().length());
                    upgradePackageLoadModuleFileHolder.addReplicatedLoadModuleFilePath(string4);
                }
            } else {
                Trace.error(this.getClass(), "addLoadModuleFileIfItExists( UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFileHolder, String aLoadModuleFilePath)", "The root path for load module " + string + " did not start with the path " + this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + ".");
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "addLoadModuleFileIfItExists( UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFileHolder, String aLoadModuleFilePath)", "The root path for load module " + string, throwable);
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "addLoadModuleFileIfItExists( UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFileHolder, String aLoadModuleFilePath)", "Returning - anUpgradePackageLoadModuleFileHolder: " + upgradePackageLoadModuleFileHolder);
        }
        return upgradePackageLoadModuleFileHolder;
    }

    private UpgradePackageLoadModuleFileHolder addSMFileIfItExists(UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "addSMFileIfItExists( UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFileHolder, String aSMFilePath)", "anUpgradePackageLoadModuleFileHolder: " + upgradePackageLoadModuleFileHolder + "\n\taSMFilePath: " + string);
        }
        if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath())) {
            File file = new File(string);
            if (file.exists()) {
                upgradePackageLoadModuleFileHolder.addMasterSMFilePath(file);
            }
            if (string.startsWith(this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath())) {
                String string2 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + string.substring(this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath().length());
                upgradePackageLoadModuleFileHolder.addReplicatedSMFilePath(string2);
            } else if (string.startsWith(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath())) {
                String string3 = this.mySystemUpgradeConstantsInterface.getNodeReplicatedRootPath() + this.mySystemUpgradeConstantsInterface.getXbReplicatedFilePath() + string.substring(this.mySystemUpgradeConstantsInterface.getXbInstallLmRootPath().length());
                upgradePackageLoadModuleFileHolder.addReplicatedSMFilePath(string3);
            }
        } else {
            Trace.error(this.getClass(), "addLoadModuleFileIfItExists( UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFileHolder, String aLoadModuleFilePath)", "The root path for load module " + string + " did not start with the path " + this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + ".");
        }
        return upgradePackageLoadModuleFileHolder;
    }

    private DataOfLoadModulesToBeDeleted collectDataOfLoadModulesToBeDeleted(String string, String string2, String string3) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectDataOfLoadModulesToBeDeleted(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision)", "anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3);
        }
        Hashtable hashtable = this.collectLM_InfoForUP_ToBeDeleted(string, string2, string3);
        return this.collectDataOfLoadModulesToBeDeleted(hashtable, string2, string3);
    }

    private DataOfLoadModulesToBeDeleted collectDataOfLoadModulesToBeDeleted(LoadModulesProxyInterface loadModulesProxyInterface, String string, String string2) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectDataOfLoadModulesToBeDeleted(LoadModulesProxyInterface aLoadModulesProxyInterface, String aProductNumber, String aProductRevision)", "aLoadModulesProxyInterface: " + loadModulesProxyInterface + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        Hashtable hashtable = this.collectLM_InfoForUP_ToBeDeleted(loadModulesProxyInterface);
        return this.collectDataOfLoadModulesToBeDeleted(hashtable, string, string2);
    }

    private DataOfLoadModulesToBeDeleted collectDataOfLoadModulesToBeDeleted(Hashtable hashtable, String string, String string2) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectDataOfLoadModulesToBeDeleted(Hashtable anLM_InfoForUP_ToBeDeleted, String aProductNumber, String aProductRevision)", "anLM_InfoForUP_ToBeDeleted: " + hashtable + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            Hashtable hashtable2 = this.collectLM_InfoForOtherUPs(string, string2);
            Enumeration enumeration = hashtable.keys();
            String string3 = null;
            UpLmDataRemove upLmDataRemove = null;
            UpLmDataRemove upLmDataRemove2 = null;
            String string4 = null;
            LinkedList<UpLmDataRemove> linkedList = new LinkedList<UpLmDataRemove>();
            LinkedList<UpLmDataRemove> linkedList2 = new LinkedList<UpLmDataRemove>();
            while (enumeration.hasMoreElements()) {
                string3 = (String)enumeration.nextElement();
                upLmDataRemove2 = (UpLmDataRemove)hashtable2.get(string3);
                if (upLmDataRemove2 != null) {
                    upLmDataRemove = (UpLmDataRemove)hashtable.remove(string3);
                    if (!upLmDataRemove.hasInstallSM || upLmDataRemove2.hasInstallSM) continue;
                    linkedList.add(upLmDataRemove);
                    continue;
                }
                upLmDataRemove = (UpLmDataRemove)hashtable.get(string3);
                if (this.hasMultiDestPath(upLmDataRemove)) continue;
                string4 = this.getDestionationPathForLoadModule(string3, upLmDataRemove);
                if (string4 == null) {
                    string4 = this.generateDestPath(upLmDataRemove);
                }
                if (!this.isLoadModuleDestinationPathUsedByOtherUPs(string4, hashtable2.values())) continue;
                hashtable.remove(string3);
                linkedList2.add(upLmDataRemove);
            }
            return new DataOfLoadModulesToBeDeleted(hashtable, linkedList2, linkedList);
        }
        catch (LoadModulesToBeDeletedAnalyserException loadModulesToBeDeletedAnalyserException) {
            throw loadModulesToBeDeletedAnalyserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectDataOfLoadModulesToBeDeleted(Hashtable anLM_InfoForUP_ToBeDeleted, String aProductNumber, String aProductRevision)", "Throwable caught.\n\tanLM_InfoForUP_ToBeDeleted: " + hashtable + "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectDataOfLoadModulesToBeDeleted(Hashtable anLM_InfoForUP_ToBeDeleted, String aProductNumber, String aProductRevision)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private Hashtable collectLM_InfoForUP_ToBeDeleted(String string, String string2, String string3) throws LoadModulesToBeDeletedAnalyserException {
        LoadModulesProxyInterface loadModulesProxyInterface;
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLM_InfoForUP_ToBeDeleted(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision)", "anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3);
        }
        if ((loadModulesProxyInterface = this.getLoadModulesProxyInterface(string, string2, string3)) != null) {
            return this.collectLM_InfoForUP_ToBeDeleted(loadModulesProxyInterface);
        }
        return new Hashtable();
    }

    private Hashtable collectLM_InfoForUP_ToBeDeleted(LoadModulesProxyInterface loadModulesProxyInterface) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLM_InfoForUP_ToBeDeleted(LoadModulesProxyInterface aLoadModulesProxyInterface)", "aLoadModulesProxyInterface: " + loadModulesProxyInterface);
        }
        try {
            Hashtable<String, UpLmDataRemove> hashtable = new Hashtable<String, UpLmDataRemove>();
            Iterator iterator = loadModulesProxyInterface.getAllUpLmDataRemoveData().iterator();
            UpLmDataRemove upLmDataRemove = null;
            while (iterator.hasNext()) {
                upLmDataRemove = (UpLmDataRemove)iterator.next();
                hashtable.put(upLmDataRemove.productNumber + upLmDataRemove.productRevision, upLmDataRemove);
            }
            return hashtable;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLM_InfoForUP_ToBeDeleted(LoadModulesProxyInterface aLoadModulesProxyInterface)", "Throwable caught.\n\taLoadModulesProxyInterface: " + loadModulesProxyInterface, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectLM_InfoForUP_ToBeDeleted(LoadModulesProxyInterface aLoadModulesProxyInterface)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private Hashtable collectLM_InfoForOtherUPs(String string, String string2) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLM_InfoForOtherUPs(String aProductNumber, String aProductRevision)", "\n\taProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            Hashtable<String, UpLmDataRemove> hashtable = new Hashtable<String, UpLmDataRemove>();
            Collection collection = this.getAllUP_MOsExludingIndicated(string, string2);
            Iterator iterator = collection.iterator();
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            Iterator iterator2 = null;
            UpLmDataRemove upLmDataRemove = null;
            String string3 = null;
            UpLmDataRemove upLmDataRemove2 = null;
            while (iterator.hasNext()) {
                upgradePackageMoExtended = (UpgradePackageMoExtended)iterator.next();
                iterator2 = this.collectLM_InfoForOtherUP(upgradePackageMoExtended).iterator();
                while (iterator2.hasNext()) {
                    upLmDataRemove = (UpLmDataRemove)iterator2.next();
                    string3 = upLmDataRemove.productNumber + upLmDataRemove.productRevision;
                    upLmDataRemove2 = (UpLmDataRemove)hashtable.get(string3);
                    if (upLmDataRemove2 != null && upLmDataRemove2.hasInstallSM) continue;
                    hashtable.put(string3, upLmDataRemove);
                }
            }
            return hashtable;
        }
        catch (LoadModulesToBeDeletedAnalyserException loadModulesToBeDeletedAnalyserException) {
            throw loadModulesToBeDeletedAnalyserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLM_InfoForOtherUPs(String aProductNumber, String aProductRevision)", "Throwable caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectLM_InfoForOtherUPs(String aProductNumber, String aProductRevision)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private Collection collectLM_InfoForOtherUP(UpgradePackageMoExtended upgradePackageMoExtended) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLM_InfoForOtherUP(UpgradePackageMoExtended anUpgradePackageMo)", "anUpgradePackageMo: " + upgradePackageMoExtended);
        }
        try {
            LoadModulesProxyInterface loadModulesProxyInterface;
            String string = upgradePackageMoExtended.getUpgradeControlFilePath(null);
            String string2 = upgradePackageMoExtended.getDocumentNumber(null);
            String string3 = upgradePackageMoExtended.getDocumentRevision(null);
            File file = new File(string);
            if (!file.exists()) {
                file = new File(string + "Original");
                if (!file.exists()) {
                    Trace.info(this.getClass(), "collectDataOfLoadModulesToBeDeleted(String aControlFileName, File aControlFile)", "Not possible to delete the UP since no UCF file exists for it");
                    throw new UpgradePackageDeleteException("Not possible to delete the UP since no UCF file exists for it");
                }
                Trace.log1(this.getClass(), "collectDataOfLoadModulesToBeDeleted(String aControlFileName, File aControlFile)", "Using the UCF file " + file.getAbsoluteFile() + " since the .xml file is missing");
            }
            if ((loadModulesProxyInterface = this.getLoadModulesProxyInterface(file.getAbsolutePath(), string2, string3)) != null) {
                return loadModulesProxyInterface.getAllUpLmDataRemoveData();
            }
            return new LinkedList();
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLM_InfoForOtherUP(UpgradePackageMoExtended anUpgradePackageMo)", "Throwable caught.\n\tanUpgradePackageMo: " + upgradePackageMoExtended, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectLM_InfoForOtherUP(UpgradePackageMoImpl anUpgradePackageMo)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private UpgradePackageLoadModuleFileHolder collectLoadModuleFilesToBeDeleted(DataOfLoadModulesToBeDeleted dataOfLoadModulesToBeDeleted, String string) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "collectLoadModuleFilesToBeDeleted(Hashtable aDataOfLoadModulesToBeDeleted, String aControlFileName)", "aDataOfLoadModulesToBeDeleted: " + dataOfLoadModulesToBeDeleted + "\n\taControlFileName: " + string);
        }
        try {
            Collection collection = dataOfLoadModulesToBeDeleted.getLoadModulesToBeDeletedData().values();
            boolean bl = false;
            if (string.equals("initUP.xml")) {
                bl = true;
            }
            UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder = this.collectLoadModuleFilesToBeDeleted(collection, bl, new UpgradePackageLoadModuleFileHolder(), false);
            upgradePackageLoadModuleFileHolder = this.collectLoadModuleFilesToBeDeleted(dataOfLoadModulesToBeDeleted.getSM_FilesOnlyToBeDeleted(), bl, upgradePackageLoadModuleFileHolder, true);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "collectLoadModuleFilesToBeDeleted(DataOfLoadModulesToBeDeleted aDataOfLoadModulesToBeDeleted, String aControlFileName)", "RETURNS - theUpgradePackageLoadModuleFilesToBeDeleted: " + upgradePackageLoadModuleFileHolder);
            }
            this.logNumberOfFilePathsToBeDeleted(upgradePackageLoadModuleFileHolder);
            return upgradePackageLoadModuleFileHolder;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLoadModuleFilesToBeDeleted(DataOfLoadModulesToBeDeleted aDataOfLoadModulesToBeDeleted, String aControlFileName)", "Throwable caught.\n\taDataOfLoadModulesToBeDeleted: " + dataOfLoadModulesToBeDeleted + "\n\taControlFileName: " + string, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectLoadModuleFilesToBeDeleted(DataOfLoadModulesToBeDeleted aDataOfLoadModulesToBeDeleted, String aControlFileName)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private UpgradePackageLoadModuleFileHolder collectLoadModuleFilesToBeDeleted(Collection collection, boolean bl, UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder, boolean bl2) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "collectLoadModuleFilesToBeDeleted(Collection aLoadModulesToBeDeletedData, boolean anIsInitUP, UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFilesToBeDeleted, boolean anIsOnlySM_FilesToBeAdded)", "aLoadModulesToBeDeletedData: " + collection + "\n\tanIsInitUP: " + bl + "\n\tanUpgradePackageLoadModuleFilesToBeDeleted: " + upgradePackageLoadModuleFileHolder + "\n\tanIsOnlySM_FilesToBeAdded: " + bl2);
        }
        try {
            Iterator iterator = collection.iterator();
            String string = "";
            String string2 = null;
            String string3 = null;
            Enumeration enumeration = null;
            Enumeration enumeration2 = null;
            File file = null;
            String string4 = null;
            while (iterator.hasNext()) {
                int n;
                String string5;
                UpLmDataRemove upLmDataRemove = (UpLmDataRemove)iterator.next();
                if (!this.isRequiredLoadModuleFileDataAvailable(bl, upLmDataRemove)) continue;
                if (upLmDataRemove.destinationPaths.isEmpty()) {
                    string = upLmDataRemove.rawProductNumber + "_" + upLmDataRemove.rawProductRevision;
                    string = string.replace('/', '%').replace('\\', '%');
                    string2 = this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath() + string;
                    if (upLmDataRemove.hasInstallSM && upLmDataRemove.destinationPathsRef.isEmpty()) {
                        string3 = this.mySystemUpgradeConstantsInterface.getNodeDefaultInstallLmRootPath() + string + "." + upLmDataRemove.SMExtension;
                        upgradePackageLoadModuleFileHolder = this.addSMFileIfItExists(upgradePackageLoadModuleFileHolder, string3);
                    } else {
                        enumeration = upLmDataRemove.destinationPathsRef.elements();
                        while (enumeration.hasMoreElements()) {
                            string3 = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + (String)enumeration.nextElement();
                            upgradePackageLoadModuleFileHolder = this.addSMFileIfItExists(upgradePackageLoadModuleFileHolder, string3);
                        }
                    }
                    if (bl2) continue;
                    upgradePackageLoadModuleFileHolder = this.addLoadModuleFileIfItExists(upgradePackageLoadModuleFileHolder, string2);
                    continue;
                }
                enumeration2 = upLmDataRemove.destinationPaths.elements();
                while (enumeration2.hasMoreElements()) {
                    string5 = (String)enumeration2.nextElement();
                    n = string5.indexOf("/c/");
                    if (n != -1) {
                        string5 = string5.substring(n + 3);
                    }
                    string2 = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + string5;
                    if (bl2) continue;
                    upgradePackageLoadModuleFileHolder = this.addLoadModuleFileIfItExists(upgradePackageLoadModuleFileHolder, string2);
                    if (upLmDataRemove.hasInstallSM && !upLmDataRemove.destinationPathsRef.isEmpty() && (file = new File(string2)).exists() && file.isDirectory()) {
                        this.addSMFileIfItExists(upgradePackageLoadModuleFileHolder, string2);
                    }
                    if (!string2.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath())) continue;
                    string4 = FilepathHandler.addInstallDirectoryToLoadModulePath(string2);
                    upgradePackageLoadModuleFileHolder = this.addLoadModuleFileIfItExists(upgradePackageLoadModuleFileHolder, string4);
                }
                if (upLmDataRemove.hasInstallSM && upLmDataRemove.destinationPathsRef.isEmpty()) {
                    string3 = string2 + "." + upLmDataRemove.SMExtension;
                    upgradePackageLoadModuleFileHolder = this.addSMFileIfItExists(upgradePackageLoadModuleFileHolder, string3);
                    if (!string3.startsWith(this.mySystemUpgradeConstantsInterface.getNodeJavaRootPath())) continue;
                    string4 = FilepathHandler.addInstallDirectoryToLoadModulePath(string3);
                    upgradePackageLoadModuleFileHolder = this.addSMFileIfItExists(upgradePackageLoadModuleFileHolder, string4);
                    continue;
                }
                if (!upLmDataRemove.hasInstallSM || upLmDataRemove.destinationPathsRef.isEmpty()) continue;
                enumeration = upLmDataRemove.destinationPathsRef.elements();
                while (enumeration.hasMoreElements()) {
                    string5 = (String)enumeration.nextElement();
                    n = string5.indexOf("/c/");
                    if (n != -1) {
                        string5 = string5.substring(n + 3);
                    }
                    string3 = this.mySystemUpgradeConstantsInterface.getNodeDefaultRootPath() + string5;
                    upgradePackageLoadModuleFileHolder = this.addSMFileIfItExists(upgradePackageLoadModuleFileHolder, string3);
                }
            }
            return upgradePackageLoadModuleFileHolder;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLoadModuleFilesToBeDeleted(Collection aLoadModulesToBeDeletedData, boolean anIsInitUP, UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFilesToBeDeleted, boolean anIsOnlySM_FilesToBeAdded)", "Throwable caught.\n\taLoadModulesToBeDeletedData: " + collection + "\n\tanIsInitUP: " + bl + "\n\tanUpgradePackageLoadModuleFilesToBeDeleted: " + upgradePackageLoadModuleFileHolder + "\n\tanIsOnlySM_FilesToBeAdded: " + bl2, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectLoadModuleFilesToBeDeleted(Collection aLoadModulesToBeDeletedData, boolean anIsInitUP, UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFilesToBeDeleted, boolean anIsOnlySM_FilesToBeAdded)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private Vector collectLoadModuleMOsToBeDeleted(DataOfLoadModulesToBeDeleted dataOfLoadModulesToBeDeleted) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectLoadModuleMOsToBeDeleted(DataOfLoadModulesToBeDeleted aDataOfLoadModulesToBeDeleted)", "aDataOfLoadModulesToBeDeleted: " + dataOfLoadModulesToBeDeleted);
        }
        Vector<LoadModuleMoSU_Access> vector = new Vector<LoadModuleMoSU_Access>();
        UpLmDataRemove upLmDataRemove = null;
        LoadModuleMoSU_Access loadModuleMoSU_Access = null;
        try {
            Enumeration enumeration = dataOfLoadModulesToBeDeleted.getLoadModulesToBeDeletedData().elements();
            while (enumeration.hasMoreElements()) {
                upLmDataRemove = (UpLmDataRemove)enumeration.nextElement();
                loadModuleMoSU_Access = null;
                loadModuleMoSU_Access = this.getLoadModuleMO(upLmDataRemove.productNumber, upLmDataRemove.productRevision);
                if (loadModuleMoSU_Access != null) {
                    vector.addElement(loadModuleMoSU_Access);
                    continue;
                }
                if (!Trace.valid(this.getClass(), 22)) continue;
                Trace.debug(this.getClass(), 22, "collectLoadModuleMOsToBeDeleted(DataOfLoadModulesToBeDeleted aLoadModulesToBeDeleted)", "No Load Module MO found for load module information.\n\ttheDataOfLoadmoduleToBeDeleted: " + upLmDataRemove);
            }
            if (!dataOfLoadModulesToBeDeleted.getLM_MOsOnlyToBeDeleted().isEmpty()) {
                Iterator iterator = dataOfLoadModulesToBeDeleted.getLM_MOsOnlyToBeDeleted().iterator();
                while (iterator.hasNext()) {
                    upLmDataRemove = (UpLmDataRemove)iterator.next();
                    loadModuleMoSU_Access = this.getLoadModuleMO(upLmDataRemove.productNumber, upLmDataRemove.productRevision);
                    if (loadModuleMoSU_Access == null) continue;
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "collectLoadModuleMOsToBeDeleted(DataOfLoadModulesToBeDeleted aDataOfLoadModulesToBeDeleted)", "Adding the load module for deletion of its LM MO (its file will not be deleted): \n\ttheLoadModuleMo: " + loadModuleMoSU_Access);
                    }
                    vector.addElement(loadModuleMoSU_Access);
                }
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "collectLoadModuleMOsToBeDeleted(DataOfLoadModulesToBeDeleted aDataOfLoadModulesToBeDeleted)", "RETURNS - theLoadModuleMOsToBeDeleted: " + vector);
            }
            this.logNumberOfLoadModuleMOsToBeDeleted(vector);
            return vector;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "collectLoadModuleMOsToBeDeleted(DataOfLoadModulesToBeDeleted aDataOfLoadModulesToBeDeleted)", "Throwable caught.\n\taDataOfLoadModulesToBeDeleted: " + dataOfLoadModulesToBeDeleted + "\n\ttheLoadModuleMOsToBeDeleted: " + vector + "\n\ttheDataOfLoadmoduleToBeDeleted: " + upLmDataRemove, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "collectLoadModuleMOsToBeDeleted(DataOfLoadModulesToBeDeleted aDataOfLoadModulesToBeDeleted)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private String generateDestPath(UpLmDataRemove upLmDataRemove) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "generateDestPath(UpLmDataRemove anUpLmDataRemove)", "anUpLmDataRemove: " + upLmDataRemove);
        }
        String string = upLmDataRemove.productNumber + "_" + upLmDataRemove.productRevision;
        string = string.replace('/', '%').replace('\\', '%');
        String string2 = "loadmodules/" + string;
        return string2;
    }

    private Collection getAllUP_MOsExludingIndicated(String string, String string2) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getAllUP_MOsExludingIndicated(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        LinkedList<UpgradePackageMoExtended> linkedList = new LinkedList<UpgradePackageMoExtended>();
        try {
            MoIterator moIterator = MoRepository.instance().lookupType("UpgradePackage");
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    upgradePackageMoExtended = (UpgradePackageMoExtended)moIterator.nextMo();
                    if (upgradePackageMoExtended == null || upgradePackageMoExtended.getDocumentNumber(null).equals(string) && upgradePackageMoExtended.getDocumentRevision(null).equals(string2)) continue;
                    linkedList.add(upgradePackageMoExtended);
                }
                return linkedList;
            }
            Trace.error(this.getClass(), "getAllUP_MOsExludingIndicated(String aProductNumber, String aProductRevision)", "No MO of type UpgradePackage found.aProductNumber: " + string + "\n\taProductRevision: " + string2);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "getAllUP_MOsExludingIndicated(String aProductNumber, String aProductRevision)" + "\n\tNo MO of type UpgradePackage found.");
        }
        catch (LoadModulesToBeDeletedAnalyserException loadModulesToBeDeletedAnalyserException) {
            throw loadModulesToBeDeletedAnalyserException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getAllUP_MOsExludingIndicated(String aProductNumber, String aProductRevision)", "Throwable caught.\n\taProductNumber: " + string + "\n\taProductRevision: " + string2, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "getAllUP_MOsExludingIndicated(String aProductNumber, String aProductRevision)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private LoadModuleMoSU_Access getLoadModuleMO(String string, String string2) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModuleMO(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2);
        }
        try {
            MoIterator moIterator = null;
            moIterator = MoRepository.instance().lookupType("LoadModule");
            if (moIterator != null) {
                LoadModuleMoSU_Access loadModuleMoSU_Access = null;
                String string3 = StringHandler.optimize(string);
                String string4 = StringHandler.optimize(string2);
                if (ServiceFinder.getLoadModuleMO_HandlerInterface().isSU_VersionSupported("SU_5")) {
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (!loadModuleMoSU_Access.getProductNumberOpt(null).equals(string3) || !loadModuleMoSU_Access.getProductRevisionOpt(null).equals(string4)) continue;
                        return loadModuleMoSU_Access;
                    }
                } else {
                    while (moIterator.hasMoreElements()) {
                        loadModuleMoSU_Access = (LoadModuleMoSU_Access)moIterator.nextMo();
                        if (!StringHandler.optimize(loadModuleMoSU_Access.getProductNumber(null)).equals(string3) || !StringHandler.optimize(loadModuleMoSU_Access.getProductRevision(null)).equals(string4)) continue;
                        return loadModuleMoSU_Access;
                    }
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModuleMO(String aProductNumber, String aProductRevision)", "aProductNumber: " + string + "\n\taProductRevision: " + string2 + "\n\tThrowable caught.", throwable);
            return null;
        }
    }

    private String getDestionationPathForLoadModule(String string, UpLmDataRemove upLmDataRemove) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getDestionationPathForLoadModule(String aLoadModuleKeyToBeRemoved, UpLmDataRemove aLoadModuleDataForLM_ToBeRemoved)", "aLoadModuleKeyToBeRemoved: " + string + "\n\taLoadModuleDataForLM_ToBeRemoved: " + upLmDataRemove);
        }
        try {
            if (upLmDataRemove.destinationPaths == null || upLmDataRemove.destinationPaths.size() != 1) {
                return null;
            }
            String string2 = (String)upLmDataRemove.destinationPaths.elementAt(0);
            if (string2 == null || string2.equals("")) {
                return null;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getDestionationPathForLoadModule(String aLoadModuleKeyToBeRemoved, UpLmDataRemove aLoadModuleDataForLM_ToBeRemoved)", "The load module file do have a destination path defined in the UCF.\n\tDestination path of the LM is: " + string2);
            }
            return string2;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getDestionationPathForLoadModule(String aLoadModuleKeyToBeRemoved, UpLmDataRemove aLoadModuleDataForLM_ToBeRemoved)", "aLoadModuleKeyToBeRemoved: " + string + "\n\taLoadModuleDataForLM_ToBeRemoved: " + upLmDataRemove + "\n\tThrowable caught.", throwable);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoadModulesProxyInterface getLoadModulesProxyInterface(String string, String string2, String string3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesProxyInterface(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision)", "anAbsolutePathToControlFile: " + string + "\n\taProductNumber: " + string2 + "\n\taProductRevision: " + string3);
        }
        ParserKeyInformation parserKeyInformation = null;
        try {
            LoadModulesProxyInterface loadModulesProxyInterface;
            UpgradeControlFileParserFactory upgradeControlFileParserFactory = UpgradeControlFileParserFactory.instance();
            MainElementHolder mainElementHolder = new MainElementHolder();
            mainElementHolder.add("LoadModule");
            parserKeyInformation = upgradeControlFileParserFactory.parseMainElements(new ParserKeyInformation(string2, string3), string, mainElementHolder, false);
            DocumentObjectUpgradePackage documentObjectUpgradePackage = upgradeControlFileParserFactory.getDocumentObjectForUpgradePackage(parserKeyInformation);
            DocumentObjectProxy documentObjectProxy = new DocumentObjectProxy(documentObjectUpgradePackage);
            LoadModulesProxyInterface loadModulesProxyInterface2 = loadModulesProxyInterface = documentObjectProxy.getLoadModulesProxyInterface();
            Object var12_13 = null;
            if (parserKeyInformation != null) {
                UpgradeControlFileParserFactory.instance().removeDocumentObjectForUpgradePackage(string2, string3);
            }
            return loadModulesProxyInterface2;
        }
        catch (Throwable throwable) {
            try {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getLoadModulesProxyInterface(String anAbsolutePathToControlFile, String aProductNumber, String aProductRevision)", "Throwable caught.\n\tIndicating parsing of UCF failed by returning 'null'.\n\tThrowable: " + throwable);
                }
                LoadModulesProxyInterface loadModulesProxyInterface = null;
                Object var12_14 = null;
                if (parserKeyInformation != null) {
                    UpgradeControlFileParserFactory.instance().removeDocumentObjectForUpgradePackage(string2, string3);
                }
                return loadModulesProxyInterface;
            }
            catch (Throwable throwable2) {
                block8: {
                    Object var12_15 = null;
                    if (parserKeyInformation == null) break block8;
                    UpgradeControlFileParserFactory.instance().removeDocumentObjectForUpgradePackage(string2, string3);
                }
                throw throwable2;
            }
        }
    }

    private Collection getProductNumberAndRevisionsOfLMsToDelete(Hashtable hashtable) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getProductNumberAndRevisionsOfLMsToDelete(Hashtable aDataOfLoadModulesToBeDeleted)", "aDataOfLoadModulesToBeDeleted: " + hashtable);
        }
        Enumeration enumeration = hashtable.elements();
        UpLmDataRemove upLmDataRemove = null;
        LinkedList<ProductNumberAndRevision> linkedList = new LinkedList<ProductNumberAndRevision>();
        while (enumeration.hasMoreElements()) {
            upLmDataRemove = (UpLmDataRemove)enumeration.nextElement();
            linkedList.add(new ProductNumberAndRevision(upLmDataRemove.productNumber, upLmDataRemove.productRevision));
        }
        if (Trace.valid(this.getClass(), 21)) {
            Trace.debug(this.getClass(), 21, "getProductNumberAndRevisionsOfLMsToDelete(Hashtable aDataOfLoadModulesToBeDeleted)", "RETURNS - theProdNoRev: " + linkedList);
        }
        return linkedList;
    }

    private boolean hasMultiDestPath(UpLmDataRemove upLmDataRemove) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "hasMultiDestPath(UpLmDataRemove anUpLmDataRemove)", "anUpLmDataRemove: " + upLmDataRemove);
        }
        return upLmDataRemove.destinationPaths != null && upLmDataRemove.destinationPaths.size() > 1;
    }

    private boolean isLoadModuleDestinationPathUsedByOtherUPs(String string, Collection collection) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isLoadModuleDestinationPathUsedByOtherUPs(Collection aLoadModulesDataForOtherUpgradePackages)", "aDestinationPathOfLM: " + string + "\n\taLoadModulesDataForOtherUpgradePackages: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            UpLmDataRemove upLmDataRemove = null;
            while (iterator.hasNext()) {
                String string2;
                upLmDataRemove = (UpLmDataRemove)iterator.next();
                if (this.hasMultiDestPath(upLmDataRemove)) continue;
                if (upLmDataRemove.destinationPaths != null && upLmDataRemove.destinationPaths.size() == 1) {
                    string2 = (String)upLmDataRemove.destinationPaths.elementAt(0);
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "isLoadModuleDestinationPathUsedByOtherUPs(Collection aLoadModulesDataForOtherUpgradepackages)", "theDestinationFileName: " + string2);
                    }
                } else {
                    string2 = this.generateDestPath(upLmDataRemove);
                }
                if (!string.equals(string2)) continue;
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "isLoadModuleDestinationPathUsedByOtherUPs(Collection aLoadModulesDataForOtherUpgradepackages)", "The load module file of UP to be removed is used by other Upgrade Packages.\n\taDestinationPathOfLM: " + string);
                }
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isLoadModuleDestinationPathUsedByOtherUPs(Collection aLoadModulesDataForOtherUpgradepackages)", "aLoadModulesDataForOtherUpgradePackages: " + collection + "\n\tThrowable caught: " + throwable.toString(), throwable);
            return false;
        }
    }

    private boolean isRequiredLoadModuleFileDataAvailable(boolean bl, UpLmDataRemove upLmDataRemove) throws LoadModulesToBeDeletedAnalyserException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "isRequiredLoadModuleFileDataAvailable(boolean anIsInitUP, UpLmDataRemove aDataOfLoadmoduleToBeRemoved)", "anIsInitUP: " + bl + "\n\taDataOfLoadmoduleToBeRemoved: " + upLmDataRemove);
        }
        try {
            LoadModuleMoSU_Access loadModuleMoSU_Access;
            if (bl && (loadModuleMoSU_Access = this.getLoadModuleMO(upLmDataRemove.productNumber, upLmDataRemove.productRevision)) != null && loadModuleMoSU_Access.getLoaderType(null) == 3) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "isRequiredLoadModuleFileDataAvailable(boolean anIsInitUP, UpLmDataRemove aDataOfLoadmoduleToBeRemoved)", "For initUP, WebServer MO's files can not be deleted\n since serveral layer directory and initUp.xml can not include enough information");
                }
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "isRequiredLoadModuleFileDataAvailable(boolean anIsInitUP, UpLmDataRemove aDataOfLoadmoduleToBeRemoved)", "Throwable caught.\n\tanIsInitUP: " + bl + "\n\taDataOfLoadmoduleToBeRemoved: " + upLmDataRemove, throwable);
            throw new LoadModulesToBeDeletedAnalyserException("Class name: " + this.getClass().getName() + "\n\tMethod: " + "isRequiredLoadModuleFileDataAvailable(boolean anIsInitUP, UpLmDataRemove aDataOfLoadmoduleToBeRemoved)" + "\n\tThrowable caught." + "\n\tOrigin Throwable: " + throwable);
        }
    }

    private void logNumberOfFilePathsToBeDeleted(UpgradePackageLoadModuleFileHolder upgradePackageLoadModuleFileHolder) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "logNumberOfFilePathsToBeDeleted(UpgradePackageLoadModuleFileHolder anUpgradePackageLoadModuleFilesToBeDeleted)", "Number of MasterLoadModuleFilePaths to be deleted: " + upgradePackageLoadModuleFileHolder.getMasterLoadModuleFilePaths().size() + "\n\tNumber of ReplicatedLoadModuleFilePaths to be deleted: " + upgradePackageLoadModuleFileHolder.getReplicatedLoadModuleFilePaths().size() + "\n\tNumber of MasterSMFilePaths to be deleted: " + upgradePackageLoadModuleFileHolder.getMasterSMFilePaths().size() + "\n\tNumber of ReplicatedSMFilePaths to be deleted: " + upgradePackageLoadModuleFileHolder.getReplicatedSMFilePaths().size());
        }
    }

    private void logNumberOfLoadModuleMOsToBeDeleted(Collection collection) {
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "logNumberOfLoadModuleMOsToBeDeleted(Collection aLoadModuleMOsToBeDeleted)", "Number of LoadModuleMOs to be deleted: " + collection.size());
        }
    }
}

