/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.install;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import se.ericsson.cello.su.extsuif.upgradepackage.main.exception.UpgradePackageException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.enumer.ActualTypeOfUP;
import se.ericsson.cello.su.extsuif.upgradepackage.util.helpers.StringHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;
import se.ericsson.cello.su.froproxy.swinstall.PiuTypeInstallSupervisionTimerInterface;
import se.ericsson.cello.su.upgradedbstorage.UpgradeDB_StorageUtil;
import se.ericsson.cello.sudom.extsuif.util.datacontainer.ProductNumberAndRevision;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RepertoireReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.util.datacontainer.ProductDataContainer;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.support.thread.ActionEvent;
import se.ericsson.cello.swmanagement.suaccess.LoadModuleMoSU_Access;
import se.ericsson.cello.swmanagement.suaccess.PiuTypeMoSU_Access;
import se.ericsson.cello.upgradepackage.control.UpgradeCoordinator;
import se.ericsson.cello.upgradepackage.install.CancelInstallRequestException;
import se.ericsson.cello.upgradepackage.install.InstallBaseHandler;
import se.ericsson.cello.upgradepackage.install.InstallCoordinator;
import se.ericsson.cello.upgradepackage.install.InstallException;
import se.ericsson.cello.upgradepackage.install.InstallOfLoadModulesRejectedException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedFTP_ServerNotAccessibleException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedGetLoadModuleFileException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedInsufficientDiskSpaceException;
import se.ericsson.cello.upgradepackage.install.InstallRejectedPiuTypeNotReferencedException;
import se.ericsson.cello.upgradepackage.install.LM_ExistenceInformation;
import se.ericsson.cello.upgradepackage.install.UP_LM_InstallInformation;
import se.ericsson.cello.upgradepackage.install.event.FTP_ServerInformation;
import se.ericsson.cello.upgradepackage.install.event.ForcedInstallLoadModulesForPiuTypeRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallConfirmedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallLoadModulesForPiuTypeAtUpgradeRequestEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallRejectedEvent;
import se.ericsson.cello.upgradepackage.install.event.InstallRejectedReasonEvent;
import se.ericsson.cello.upgradepackage.install.event.LMsForPiuTypeInstallStateInformationEvent;
import se.ericsson.cello.upgradepackage.install.event.PiuTypeInstallRequestEvent;
import se.ericsson.cello.upgradepackage.main.exception.ActionNotAllowedException;
import se.ericsson.cello.upgradepackage.main.exception.GetFileException;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradePackageMoExtended;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.datacontainer.CalculationOfLMsToBeInstalled;
import se.ericsson.cello.upgradepackage.util.datacontainer.UCF_ControlResultContainer;
import se.ericsson.cello.upgradepackage.util.enumer.LoadModuleInstalledState;
import se.ericsson.cello.upgradepackage.util.enumer.LoadModuleState;
import se.ericsson.cello.upgradepackage.util.hwsensitive.FromStateSupportInformation;
import se.ericsson.cello.upgradepackage.util.hwsensitive.HW_SensitiveAdapter;
import se.ericsson.cello.upgradepackage.util.mohandler.configurationversion.ConfigurationVersionMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.PiuTypeNotReferencedException;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.verify.ChecksumHandler;
import se.ericsson.cello.upgradepackage.verify.FailedUCFChecksumErrorInformation;

public class PiuTypeInstallLMs
extends InstallBaseHandler
implements TimerListener {
    private Timer mySupervisionOfInstallAtUpgrade = null;
    private PiuTypeMoSU_Access myPiuTypeMo = null;
    private boolean mySupervisionTimerExpired = false;

    public void handleInstallLMsForPiuTypeRequest(PiuTypeInstallRequestEvent piuTypeInstallRequestEvent, boolean bl) throws InstallException, ActionNotAllowedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "handleInstallLMsForPiuTypeRequest(PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "aPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\taForcedInstall: " + bl);
        }
        try {
            this.verifyAllowedToInvokeThisAction(piuTypeInstallRequestEvent);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new CalculationOfLMsToBeInstalled(this));
            Collection collection = this.getLoadModulesNeededToBeInstalled(piuTypeInstallRequestEvent, bl, false);
            if (piuTypeInstallRequestEvent.actualTypeOfUP.isDelta()) {
                this.installLMsForPiuTypeRequestWhenDeltaUP(collection, piuTypeInstallRequestEvent, true);
            } else {
                this.sendProgressTotal(piuTypeInstallRequestEvent.upgradePackageDocumentNumber, piuTypeInstallRequestEvent.upgradePackageDocumentRevision, new File(piuTypeInstallRequestEvent.upgradePackageUCF_Path), collection, new HashSet());
                ProductDataContainer productDataContainer = new ProductDataContainer(piuTypeInstallRequestEvent.upgradePackageDocumentNumber, piuTypeInstallRequestEvent.upgradePackageDocumentRevision, piuTypeInstallRequestEvent.upgradePackageProductName, piuTypeInstallRequestEvent.upgradePackageProductionDate, "NotKnown", "NotKnown");
                if (!collection.isEmpty()) {
                    this.installLoadModules(productDataContainer, new File(piuTypeInstallRequestEvent.upgradePackageUCF_Path), collection, piuTypeInstallRequestEvent.ftpServerInformation, 1, bl, true);
                }
            }
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.LMsForPiuTypeInstallState, new LMsForPiuTypeInstallStateInformationEvent(this, piuTypeInstallRequestEvent.piuTypeMoSU_Access, LoadModuleInstalledState.Installed));
            int n = 871;
            UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)this, n, "--"));
            UpgradeCoordinator.instance().installResponse(new InstallConfirmedEvent(this));
        }
        catch (InstallRejectedFTP_ServerNotAccessibleException installRejectedFTP_ServerNotAccessibleException) {
            this.installRequestRejected(installRejectedFTP_ServerNotAccessibleException);
        }
        catch (InstallRejectedGetLoadModuleFileException installRejectedGetLoadModuleFileException) {
            this.installRequestRejected(installRejectedGetLoadModuleFileException);
        }
        catch (InstallRejectedInsufficientDiskSpaceException installRejectedInsufficientDiskSpaceException) {
            this.installRequestRejected(installRejectedInsufficientDiskSpaceException);
        }
        catch (InstallRejectedPiuTypeNotReferencedException installRejectedPiuTypeNotReferencedException) {
            this.installRequestRejected(installRejectedPiuTypeNotReferencedException);
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            this.installRequestRejected((Throwable)((Object)installOfLoadModulesRejectedException));
        }
        catch (InstallException installException) {
            this.installRequestRejected((Throwable)((Object)installException));
        }
        catch (ActionNotAllowedException actionNotAllowedException) {
            this.installRequestRejected((Throwable)((Object)actionNotAllowedException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "handleInstallLMsForPiuTypeRequest(PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "Throwable caught.\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\taForcedInstall: " + bl + throwable);
            this.installRequestRejected(throwable);
        }
    }

    public void installLMsForPiuTypeAtUpgradeRequest(InstallLoadModulesForPiuTypeAtUpgradeRequestEvent installLoadModulesForPiuTypeAtUpgradeRequestEvent, boolean bl) throws InstallException, ActionNotAllowedException, UpgradePackageException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installLMsForPiuTypeAtUpgradeRequest(InstallLoadModulesForPiuTypeAtUpgradeRequestEvent anInstallLoadModulesForPiuTypeAtUpgradeRequestEvent, boolean aForcedInstall)", "aInstallLoadModulesForPiuTypeAtUpgradeRequestEvent: " + installLoadModulesForPiuTypeAtUpgradeRequestEvent + "\n\taForcedInstall: " + bl);
        }
        try {
            block17: {
                try {
                    Collection collection = this.getLoadModulesNeededToBeInstalled(installLoadModulesForPiuTypeAtUpgradeRequestEvent, bl, true);
                    if (Trace.valid(this.getClass(), 40)) {
                        Trace.debug(this.getClass(), 40, "installLMsForPiuTypeAtUpgradeRequest(InstallLoadModulesForPiuTypeAtUpgradeRequestEvent anInstallLoadModulesForPiuTypeAtUpgradeRequestEvent, boolean aForcedInstall)", "No of LMs that needs to be installed: " + collection.size());
                    }
                    if (!collection.isEmpty()) {
                        this.myPiuTypeMo = installLoadModulesForPiuTypeAtUpgradeRequestEvent.piuTypeMoSU_Access;
                        this.startTimer();
                    }
                    if (installLoadModulesForPiuTypeAtUpgradeRequestEvent.actualTypeOfUP.isDelta()) {
                        this.installLMsForPiuTypeRequestWhenDeltaUP(collection, installLoadModulesForPiuTypeAtUpgradeRequestEvent, false);
                    } else {
                        ProductDataContainer productDataContainer = new ProductDataContainer(installLoadModulesForPiuTypeAtUpgradeRequestEvent.upgradePackageDocumentNumber, installLoadModulesForPiuTypeAtUpgradeRequestEvent.upgradePackageDocumentRevision, installLoadModulesForPiuTypeAtUpgradeRequestEvent.upgradePackageProductName, installLoadModulesForPiuTypeAtUpgradeRequestEvent.upgradePackageProductionDate, "NotKnown", "NotKnown");
                        if (!collection.isEmpty()) {
                            this.installLoadModules(productDataContainer, new File(installLoadModulesForPiuTypeAtUpgradeRequestEvent.upgradePackageUCF_Path), collection, installLoadModulesForPiuTypeAtUpgradeRequestEvent.ftpServerInformation, 1, bl, false);
                        }
                    }
                    if (!this.mySupervisionTimerExpired) {
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.LMsForPiuTypeInstallState, new LMsForPiuTypeInstallStateInformationEvent(this, installLoadModulesForPiuTypeAtUpgradeRequestEvent.piuTypeMoSU_Access, LoadModuleInstalledState.Installed));
                        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.InstallResult, new InstallConfirmedEvent(this));
                        break block17;
                    }
                    if (!Trace.valid(this.getClass(), 40)) break block17;
                    Trace.debug(this.getClass(), 40, "installLMsForPiuTypeAtUpgradeRequest(InstallLoadModulesForPiuTypeAtUpgradeRequestEvent anInstallLoadModulesForPiuTypeAtUpgradeRequestEvent, boolean aForcedInstall)", "The installation of load module files has been successfully executed but after that timeout occured on the overall supervision timer i.e. no response is sent from here since a timeout reason already have been given.");
                }
                catch (InstallRejectedFTP_ServerNotAccessibleException installRejectedFTP_ServerNotAccessibleException) {
                    throw installRejectedFTP_ServerNotAccessibleException;
                }
                catch (InstallRejectedGetLoadModuleFileException installRejectedGetLoadModuleFileException) {
                    throw installRejectedGetLoadModuleFileException;
                }
                catch (InstallRejectedInsufficientDiskSpaceException installRejectedInsufficientDiskSpaceException) {
                    throw installRejectedInsufficientDiskSpaceException;
                }
                catch (InstallRejectedPiuTypeNotReferencedException installRejectedPiuTypeNotReferencedException) {
                    throw installRejectedPiuTypeNotReferencedException;
                }
                catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
                    throw installOfLoadModulesRejectedException;
                }
                catch (InstallException installException) {
                    throw installException;
                }
                catch (Throwable throwable) {
                    Trace.error(this.getClass(), "installLMsForPiuTypeAtUpgradeRequest(InstallLoadModulesForPiuTypeAtUpgradeRequestEvent anInstallLoadModulesForPiuTypeAtUpgradeRequestEvent, boolean aForcedInstall)", "Throwable caught.\n\taInstallLoadModulesForPiuTypeAtUpgradeRequestEvent: " + installLoadModulesForPiuTypeAtUpgradeRequestEvent + "\n\taForcedInstall: " + bl + throwable);
                    throw new InstallException(throwable.toString());
                }
            }
            Object var6_12 = null;
            this.stopTimer();
            this.myPiuTypeMo = null;
            this.mySupervisionTimerExpired = false;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            this.stopTimer();
            this.myPiuTypeMo = null;
            this.mySupervisionTimerExpired = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void timerAction(TimerEvent timerEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "timerAction(TimerEvent aTimerEvent)");
        }
        try {
            try {
                this.mySupervisionTimerExpired = true;
                InstallCoordinator installCoordinator = new InstallCoordinator();
                installCoordinator.cancelInstallOfLoadModules(false);
            }
            catch (CancelInstallRequestException cancelInstallRequestException) {
                Trace.log1(this.getClass(), "timerAction(TimerEvent aTimerEvent)", "At installation of load module files for a specific piu type the supervision timer expired.\n\tAn attempt was made to cancel the ongoing installation but that failed\n\tPiuType Mo: " + this.myPiuTypeMo + "Reason (exception info), Ignored: " + (Object)((Object)cancelInstallRequestException));
                Object var4_5 = null;
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "timerAction(TimerEvent aTimerEvent)", "Starting to send progress info about supervision timeout");
                }
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.LMsForPiuTypeInstallState, new LMsForPiuTypeInstallStateInformationEvent(this, this.myPiuTypeMo, LoadModuleInstalledState.Installed));
                PiuTypeInstallSupervisionTimerInterface piuTypeInstallSupervisionTimerInterface2 = (PiuTypeInstallSupervisionTimerInterface)ServiceLocatorFacade.getRepository().getService(PiuTypeInstallSupervisionTimerInterface.class);
                ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.InstallResult, new InstallRejectedReasonEvent(this, 851, "At installation of load module files for a specific piu type the overall supervision timer expired (" + piuTypeInstallSupervisionTimerInterface2.getSupervisionTimerValue() + " ms)." + "\n\tAn attempt was made to cancel the ongoing installation" + "\n\tPiuType Mo: " + this.myPiuTypeMo));
                if (!Trace.valid(this.getClass(), 40)) return;
                Trace.debug(this.getClass(), 40, "timerAction(TimerEvent aTimerEvent)", "Progress info about supervision timeout have been sent");
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "timerAction(TimerEvent aTimerEvent)", "Starting to send progress info about supervision timeout");
            }
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.LMsForPiuTypeInstallState, new LMsForPiuTypeInstallStateInformationEvent(this, this.myPiuTypeMo, LoadModuleInstalledState.Installed));
            PiuTypeInstallSupervisionTimerInterface piuTypeInstallSupervisionTimerInterface = (PiuTypeInstallSupervisionTimerInterface)ServiceLocatorFacade.getRepository().getService(PiuTypeInstallSupervisionTimerInterface.class);
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.InstallResult, new InstallRejectedReasonEvent(this, 851, "At installation of load module files for a specific piu type the overall supervision timer expired (" + piuTypeInstallSupervisionTimerInterface.getSupervisionTimerValue() + " ms)." + "\n\tAn attempt was made to cancel the ongoing installation" + "\n\tPiuType Mo: " + this.myPiuTypeMo));
            if (!Trace.valid(this.getClass(), 40)) throw throwable;
            Trace.debug(this.getClass(), 40, "timerAction(TimerEvent aTimerEvent)", "Progress info about supervision timeout have been sent");
            throw throwable;
        }
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "timerAction(TimerEvent aTimerEvent)", "Starting to send progress info about supervision timeout");
        }
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.LMsForPiuTypeInstallState, new LMsForPiuTypeInstallStateInformationEvent(this, this.myPiuTypeMo, LoadModuleInstalledState.Installed));
        PiuTypeInstallSupervisionTimerInterface piuTypeInstallSupervisionTimerInterface = (PiuTypeInstallSupervisionTimerInterface)ServiceLocatorFacade.getRepository().getService(PiuTypeInstallSupervisionTimerInterface.class);
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.InstallResult, new InstallRejectedReasonEvent(this, 851, "At installation of load module files for a specific piu type the overall supervision timer expired (" + piuTypeInstallSupervisionTimerInterface.getSupervisionTimerValue() + " ms)." + "\n\tAn attempt was made to cancel the ongoing installation" + "\n\tPiuType Mo: " + this.myPiuTypeMo));
        if (!Trace.valid(this.getClass(), 40)) return;
        Trace.debug(this.getClass(), 40, "timerAction(TimerEvent aTimerEvent)", "Progress info about supervision timeout have been sent");
    }

    private void startTimer() {
        PiuTypeInstallSupervisionTimerInterface piuTypeInstallSupervisionTimerInterface = (PiuTypeInstallSupervisionTimerInterface)ServiceLocatorFacade.getRepository().getService(PiuTypeInstallSupervisionTimerInterface.class);
        if (Trace.valid(this.getClass(), 40)) {
            Trace.debug(this.getClass(), 40, "startTimer()", "Starts a supervision timer at installation of a Piu Type.\n\tThe time out value is: " + piuTypeInstallSupervisionTimerInterface.getSupervisionTimerValue() + " ms." + "\n\tThe Piu Type to be installed is: " + this.myPiuTypeMo);
        }
        this.mySupervisionOfInstallAtUpgrade = new Timer(piuTypeInstallSupervisionTimerInterface.getSupervisionTimerValue());
        this.mySupervisionOfInstallAtUpgrade.addListener(this);
        this.mySupervisionOfInstallAtUpgrade.startTimer();
    }

    private void stopTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "stopTimer()()");
        }
        if (this.mySupervisionOfInstallAtUpgrade != null) {
            this.mySupervisionOfInstallAtUpgrade.removeListener(this);
            this.mySupervisionOfInstallAtUpgrade.stopTimer();
            this.mySupervisionOfInstallAtUpgrade = null;
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "stopTimer()()", "The supervision timer at installation of a Piu Type has been stoped i.e. " + this.myPiuTypeMo);
            }
        }
    }

    private void installLMsForPiuTypeRequestWhenDeltaUP(Collection collection, PiuTypeInstallRequestEvent piuTypeInstallRequestEvent, boolean bl) throws InstallException, InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)", "\n\taLoadModulesToBeInstalled: " + collection + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent);
        }
        try {
            Object object;
            Object object2;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "installLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)", "Collect information of all LMs to be installed from the Delta UP.");
            }
            String[] stringArray = new String[]{"LoadModule"};
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElementsNoSave(piuTypeInstallRequestEvent.upgradePackageOriginalUCF_Path, stringArray, false);
            LM_ExistenceInformation lM_ExistenceInformation = this.getLM_ExistenceInUP(documentObjectProxyInterface.getLoadModulesProxyInterface().getProductNumberAndRevisionOfLoadModules().getElements(), collection);
            LinkedList<UP_LM_InstallInformation> linkedList = new LinkedList<UP_LM_InstallInformation>();
            ProductDataContainer productDataContainer = new ProductDataContainer(piuTypeInstallRequestEvent.upgradePackageDocumentNumber, piuTypeInstallRequestEvent.upgradePackageDocumentRevision);
            linkedList.add(new UP_LM_InstallInformation(productDataContainer, piuTypeInstallRequestEvent.ftpServerInformation, (Collection)lM_ExistenceInformation.existingLMs.clone(), new File(piuTypeInstallRequestEvent.upgradePackageOriginalUCF_Path)));
            UCF_ParserFacade.removeDocumentObjectForUpgradePackage(documentObjectProxyInterface);
            if (!lM_ExistenceInformation.notExistingLMs.isEmpty()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "installLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)", "Collects information of all LMs to be installed from the Delta UP based on UP's.");
                }
                if ((object2 = (object = ServiceFinder.getUpgradePackageMO_HandlerInterface()).getUpgradePackageMo(piuTypeInstallRequestEvent.upgradePackageDocumentNumber, piuTypeInstallRequestEvent.upgradePackageDocumentRevision)) == null) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "installLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)", "The delta UP MO with product data below was not found (aborting the installation).\n\tProduct no: " + piuTypeInstallRequestEvent.upgradePackageDocumentNumber + "\n\tProduct rev: " + piuTypeInstallRequestEvent.upgradePackageDocumentRevision + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent);
                    }
                    throw new InstallException("Class name: " + this.getClass().getName() + "\n\tinstallLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)" + "\n\tThe delta UP MO with product data below was not found (aborting the installation)." + "\n\tProduct no: " + piuTypeInstallRequestEvent.upgradePackageDocumentNumber + "\n\tProduct rev: " + piuTypeInstallRequestEvent.upgradePackageDocumentRevision + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent);
                }
                Collection collection2 = this.collectUP_LMsInformation(object2.getBasedOnUpgradePackagesAsProductDatas(null), lM_ExistenceInformation.notExistingLMs);
                linkedList.addAll(collection2);
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "installLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)", "theUP_LMsInformations: " + collection2 + "\n\ttheUP_LM_InstallInformations: " + linkedList);
                }
            }
            if (bl) {
                this.sendProgressTotal(piuTypeInstallRequestEvent.upgradePackageDocumentNumber, piuTypeInstallRequestEvent.upgradePackageDocumentRevision, new File(piuTypeInstallRequestEvent.upgradePackageUCF_Path), collection);
            }
            object = linkedList.iterator();
            object2 = null;
            int n = 0;
            boolean bl2 = false;
            if (piuTypeInstallRequestEvent instanceof ForcedInstallLoadModulesForPiuTypeRequestEvent) {
                bl2 = true;
            }
            while (object.hasNext()) {
                object2 = (UP_LM_InstallInformation)object.next();
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "installLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)", "Installing load modules from the UP with product data:\n\tProduct number: " + ((UP_LM_InstallInformation)object2).upProductData.getNumber() + "\n\tProduct revision: " + ((UP_LM_InstallInformation)object2).upProductData.getRevision());
                }
                if (((UP_LM_InstallInformation)object2).lmsToBeInstalled.isEmpty()) continue;
                this.installLoadModules(((UP_LM_InstallInformation)object2).upProductData, ((UP_LM_InstallInformation)object2).ucfPath, ((UP_LM_InstallInformation)object2).lmsToBeInstalled, ((UP_LM_InstallInformation)object2).ftpServerInformation, ++n, bl2, bl);
            }
            Trace.log1(this.getClass(), "installLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)", "All required load modules have been installed.");
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            throw installOfLoadModulesRejectedException;
        }
        catch (InstallException installException) {
            throw installException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "installLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)", "Throwable caught.\n\taLoadModulesToBeInstalled: " + collection + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\tinstallLMsForPiuTypeRequestWhenDeltaUP (Collection aLoadModulesToBeInstalled, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean anIsProgressInfoToBeSent)" + "\n\tThrowable caught." + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private Collection getLoadModulesNeededToBeInstalled(PiuTypeInstallRequestEvent piuTypeInstallRequestEvent, boolean bl, boolean bl2) throws InstallException, InstallRejectedPiuTypeNotReferencedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesNeededToBeInstalled(PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall, boolean anIsUpgradeOngoing)", "aPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\taForcedInstall: " + bl + "\n\tanIsUpgradeOngoing:" + bl2);
        }
        try {
            UpgradePackageMoExtended upgradePackageMoExtended = null;
            if (bl2) {
                upgradePackageMoExtended = piuTypeInstallRequestEvent.getUpgradePackageMoExtended();
                if (UpgradeDB_StorageUtil.isNewActiveUP_Existing()) {
                    return this.getLoadModulesConnectedToPiuType(upgradePackageMoExtended, piuTypeInstallRequestEvent, bl);
                }
                return this.getLoadModulesConnectedToPiuTypeBeforeReplConfig(upgradePackageMoExtended, piuTypeInstallRequestEvent, bl);
            }
            upgradePackageMoExtended = ServiceFinder.getConfigurationVersionMO_HandlerInterface().getCurrentUpgradePackage(null);
            return this.getLoadModulesConnectedToPiuType(upgradePackageMoExtended, piuTypeInstallRequestEvent, bl);
        }
        catch (InstallException installException) {
            throw installException;
        }
        catch (InstallRejectedPiuTypeNotReferencedException installRejectedPiuTypeNotReferencedException) {
            throw installRejectedPiuTypeNotReferencedException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModulesNeededToBeInstalled(PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall, boolean anIsUpgradeOngoing)", "Throwable caught.\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\taForcedInstall: " + bl, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\tgetLoadModulesNeededToBeInstalled(PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall, boolean anIsUpgradeOngoing)" + "\n\tThrowable caught." + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\taForcedInstall: " + bl + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private Collection getLoadModulesConnectedToPiuType(UpgradePackageMoExtended upgradePackageMoExtended, PiuTypeInstallRequestEvent piuTypeInstallRequestEvent, boolean bl) throws InstallException, InstallRejectedPiuTypeNotReferencedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesConnectedToPiuType(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "anUP_ToBeUsed: " + upgradePackageMoExtended + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\taForcedInstall: " + bl);
        }
        try {
            ActualTypeOfUP actualTypeOfUP = ActualTypeOfUP.getInstance(upgradePackageMoExtended.getActualTypeOfUP(null));
            Collection collection = null;
            RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
            collection = actualTypeOfUP.isHW_Sensitive() ? ServiceFinder.getSwAllocationMO_HandlerInterface().getConnectedRepertoires(null) : repertoireMO_HandlerInterface.getRepertoireMOs();
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            Collection collection2 = repertoireMO_HandlerInterface.getReferencedLoadModules(actualTypeOfUP, collection, piuTypeInstallRequestEvent.piuTypeMoSU_Access);
            if (bl) {
                collection2 = loadModuleMO_HandlerInterface.getProductNumberAndRevisionsForLoadModules(collection2);
                if (Trace.valid(this.getClass(), 21)) {
                    Trace.debug(this.getClass(), 21, "getLoadModulesConnectedToPiuType(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "RETURNS - theLMsConnectedToPiuType (the LMs To Be Installed): " + collection2);
                }
                return collection2;
            }
            Collection collection3 = this.getNotInstalledLMs(collection2);
            collection3 = loadModuleMO_HandlerInterface.getProductNumberAndRevisionsForLoadModules(collection3);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModulesConnectedToPiuType(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "RETURNS - theLMsToBeInstalled: " + collection3);
            }
            return collection3;
        }
        catch (PiuTypeNotReferencedException piuTypeNotReferencedException) {
            throw new InstallRejectedPiuTypeNotReferencedException(piuTypeNotReferencedException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModulesConnectedToPiuType(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "Throwable caught.\n\tanUP_ToBeUsed: " + upgradePackageMoExtended, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\tgetLoadModulesConnectedToPiuType(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)" + "\n\tThrowable caught." + "\n\tanUP_ToBeUsed: " + upgradePackageMoExtended + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private Collection getLoadModulesConnectedToPiuTypeBeforeReplConfig(UpgradePackageMoExtended upgradePackageMoExtended, PiuTypeInstallRequestEvent piuTypeInstallRequestEvent, boolean bl) throws InstallException, InstallRejectedPiuTypeNotReferencedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getLoadModulesConnectedToPiuTypeBeforeReplConfig(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "anUP_ToBeUsed: " + upgradePackageMoExtended + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\taForcedInstall: " + bl);
        }
        try {
            Object object;
            if (Trace.valid(this.getClass(), 40)) {
                Trace.debug(this.getClass(), 40, "getLoadModulesConnectedToPiuTypeBeforeReplConfig(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "Using UCF to understand which LMs that eed to be installed since requested prior step ReplaceCOnfigSupportMOsOp");
            }
            ActualTypeOfUP actualTypeOfUP = ActualTypeOfUP.getInstance(upgradePackageMoExtended.getActualTypeOfUP(null));
            String[] stringArray = new String[]{"UpCompatibilityIndex", "UpgradeWindow", "MandatoryPiuTypeList", "CommonPiuTypeList", "NodeTypeSpecificPiuTypeList", "Repertoire", "PiuType", "ExplicitReplacement", "InstallSequence", "VerifySequence", "VerifyUpgradeSequence", "VerifyUpdateSequence", "UpgradeSequence", "LoadModule"};
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(piuTypeInstallRequestEvent.upgradePackageDocumentNumber, piuTypeInstallRequestEvent.upgradePackageDocumentRevision, piuTypeInstallRequestEvent.upgradePackageUCF_Path, stringArray);
            HW_SensitiveAdapter hW_SensitiveAdapter = new HW_SensitiveAdapter();
            FromStateSupportInformation fromStateSupportInformation = hW_SensitiveAdapter.getFromStateSupportInformation(actualTypeOfUP.isDelta(), documentObjectProxyInterface);
            RepertoireReplacementsProxyInterface repertoireReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface().getRepertoireReplacementsProxyInterface(fromStateSupportInformation.getFirstValidUpgradeCase());
            Collection collection = repertoireReplacementsProxyInterface.getRepertoireReplacementsData();
            RepertoiresProxyInterface repertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
            HashSet hashSet = new HashSet(repertoiresProxyInterface.getRepertoireNames());
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
            RepertoiresProxyInterface repertoiresProxyInterface2 = documentObjectProxyInterface.getRepertoiresProxyInterface();
            Collection collection2 = null;
            collection2 = actualTypeOfUP.isHW_Sensitive() ? swAllocationMO_HandlerInterface.getRepertoiresToBeConnected(collection, hashSet) : repertoiresProxyInterface2.getRepertoireNames();
            String string = null;
            String string2 = null;
            if (ServiceFinder.getPiuTypeMO_HandlerInterface().isSU_VersionSupported("SU_3")) {
                string = piuTypeInstallRequestEvent.piuTypeMoSU_Access.getProductNumberOpt(null);
                string2 = piuTypeInstallRequestEvent.piuTypeMoSU_Access.getProductRevisionOpt(null);
            } else {
                string = StringHandler.optimize(piuTypeInstallRequestEvent.piuTypeMoSU_Access.getProductNumber(null));
                string2 = StringHandler.optimize(piuTypeInstallRequestEvent.piuTypeMoSU_Access.getProductRevision(null));
            }
            Collection collection3 = repertoiresProxyInterface2.getLoadModulesConnectedToPiuType(string, string2, collection2);
            if (Trace.valid(this.getClass(), 40)) {
                object = this.prettyString(collection2);
                Trace.debug(this.getClass(), 40, "getLoadModulesConnectedToPiuTypeBeforeReplConfig(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "Used Upgrade Sequence in UCF (upgradeCase): " + fromStateSupportInformation.getFirstValidUpgradeCase() + "\n\tThe TO state connected repertoires: " + new HashSet(collection2) + "\n\tThe number of TO state connected repertoires: " + collection2.size() + "\n\tName of connected repertoires in TO state: " + (String)object);
            }
            if (bl) {
                if (Trace.valid(this.getClass(), 40)) {
                    Trace.debug(this.getClass(), 40, "getLoadModulesConnectedToPiuTypeBeforeReplConfig(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "RETURNS - theLMsConnectedToPiuType (the LMs To Be Installed (forced install)): " + collection3 + "\n\tThe number of LMs To Be Installed (forced install): " + collection3.size());
                }
                return collection3;
            }
            object = ServiceFinder.getLoadModuleMO_HandlerInterface();
            Collection collection4 = object.getLoadModuleMos(collection3);
            Collection collection5 = this.getNotInstalledLMs(collection4);
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getLoadModulesConnectedToPiuTypeBeforeReplConfig(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "RETURNS - theLMsToBeInstalled: " + collection5 + "\n\tThe number of LMs To Be Installed: " + collection5.size());
            }
            return object.getProductNumberAndRevisionsForLoadModules(collection5);
        }
        catch (PiuTypeNotReferencedException piuTypeNotReferencedException) {
            throw new InstallRejectedPiuTypeNotReferencedException(piuTypeNotReferencedException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getLoadModulesConnectedToPiuTypeBeforeReplConfig(UpgradePackageMoExtended anUP_ToBeUsed, PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent, boolean aForcedInstall)", "Throwable caught.\n\tanUP_ToBeUsed: " + upgradePackageMoExtended, throwable);
            throw new InstallException(throwable.toString());
        }
    }

    private String prettyString(Collection collection) {
        String string = "Connected Repertoire in TO state: ";
        String string2 = "\n\t";
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            string2 = string2 + string + iterator.next() + "\n\t";
        }
        return string2;
    }

    private Collection getNotInstalledLMs(Collection collection) throws InstallException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNotInstalledLMs ( Collection aLoadModules )", "aLoadModules: " + collection);
        }
        try {
            Iterator iterator = collection.iterator();
            LoadModuleMoSU_Access loadModuleMoSU_Access = null;
            HashSet<LoadModuleMoSU_Access> hashSet = new HashSet<LoadModuleMoSU_Access>();
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            LoadModuleState loadModuleState = null;
            while (iterator.hasNext()) {
                loadModuleMoSU_Access = (LoadModuleMoSU_Access)iterator.next();
                loadModuleState = loadModuleMO_HandlerInterface.getLoadModuleState(loadModuleMoSU_Access, null);
                if (!loadModuleState.equals(LoadModuleState.NotInstalled)) continue;
                hashSet.add(loadModuleMoSU_Access);
            }
            if (Trace.valid(this.getClass(), 21)) {
                Trace.debug(this.getClass(), 21, "getNotInstalledLMs ( Collection aLoadModules )", "RETURNS - theLM_MOsNotInstalled: " + hashSet);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNotInstalledLMs ( Collection aLoadModules )", "Throwable caught.\n\taLoadModules: " + collection, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\tgetNotInstalledLMs(Collection aLoadModules)" + "\n\tThrowable caught." + "\n\taLoadModules: " + collection + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private void verifyAllowedToInvokeThisAction(PiuTypeInstallRequestEvent piuTypeInstallRequestEvent) throws ActionNotAllowedException, InstallException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "verifyAllowedToInvokeThisAction ( PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent )", "aPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent);
        }
        try {
            ConfigurationVersionMO_HandlerInterface configurationVersionMO_HandlerInterface;
            UpgradePackageMoExtended upgradePackageMoExtended;
            ProductNumberAndRevision productNumberAndRevision;
            ProductNumberAndRevision productNumberAndRevision2;
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "verifyAllowedToInvokeThisAction ( PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent )", "Verify that it is allowed to request for install of load modules for given PiuType MO on this UP MO.");
            }
            if (!(productNumberAndRevision2 = new ProductNumberAndRevision(piuTypeInstallRequestEvent.upgradePackageDocumentNumber, piuTypeInstallRequestEvent.upgradePackageDocumentRevision)).equals(productNumberAndRevision = new ProductNumberAndRevision((upgradePackageMoExtended = (configurationVersionMO_HandlerInterface = ServiceFinder.getConfigurationVersionMO_HandlerInterface()).getCurrentUpgradePackage(null)).getDocumentNumber(null), upgradePackageMoExtended.getDocumentRevision(null)))) {
                Trace.log1(this.getClass(), "verifyAllowedToInvokeThisAction ( PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent )", "Not allowed to invoke action 'piuTypeInstall' on an Upgrade Package MO that is not the current active UP.\n\tCurrent Upgrade Package MO: " + productNumberAndRevision + "\n\tInstallin Upgrade package MO: " + productNumberAndRevision2);
                throw new ActionNotAllowedException("Not allowed to invoke action 'piuTypeInstall' on an Upgrade Package MO that is not the current active UP.\n\tCurrent Upgrade Package MO: " + productNumberAndRevision + "\n\tInstalling Upgrade package MO: " + productNumberAndRevision2);
            }
            ChecksumHandler checksumHandler = new ChecksumHandler();
            UCF_ControlResultContainer uCF_ControlResultContainer = checksumHandler.checksumUCF(upgradePackageMoExtended);
            FailedUCFChecksumErrorInformation failedUCFChecksumErrorInformation = uCF_ControlResultContainer.isCalculated_StoredChecksumMatched();
            FailedUCFChecksumErrorInformation failedUCFChecksumErrorInformation2 = uCF_ControlResultContainer.isCalculated_StoredOrigChecksumMatched();
            if (!failedUCFChecksumErrorInformation.isChecksumMatched()) {
                throw new ActionNotAllowedException("Not allowed to invoke action 'piuTypeInstall' on an Upgrade Package MO :" + failedUCFChecksumErrorInformation.toString());
            }
            if (!failedUCFChecksumErrorInformation2.isChecksumMatched()) {
                throw new ActionNotAllowedException("Not allowed to invoke action 'piuTypeInstall' on an Upgrade Package MO :" + failedUCFChecksumErrorInformation2.toString());
            }
        }
        catch (ActionNotAllowedException actionNotAllowedException) {
            throw actionNotAllowedException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "verifyAllowedToInvokeThisAction ( PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent )", "Throwable caught.aPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "\n\tverifyAllowedToInvokeThisAction ( PiuTypeInstallRequestEvent aPiuTypeInstallRequestEvent )" + "\n\tThrowable caught." + "\n\taPiuTypeInstallRequestEvent: " + piuTypeInstallRequestEvent + "\n\tOriginal Throwable: " + throwable);
        }
    }

    private void installLoadModules(ProductDataContainer productDataContainer, File file, Collection collection, FTP_ServerInformation fTP_ServerInformation, int n, boolean bl, boolean bl2) throws InstallException, InstallOfLoadModulesRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "installLoadModules (ProductDataContainer anUP_ProductData, File anUCF_Path, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation, boolean aForcedInstall, boolean anIsProgressInfoToBeSent", "\n\tanUP_ProductData: " + productDataContainer + "\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanUPWithLMsCouner: " + n + "\n\taForcedInstall: " + bl + "\n\tanIsProgressInfoToBeSent: " + bl2);
        }
        try {
            InstallCoordinator installCoordinator = new InstallCoordinator();
            installCoordinator.installLoadModules(productDataContainer, file, collection, fTP_ServerInformation, n, bl, bl2);
        }
        catch (InstallOfLoadModulesRejectedException installOfLoadModulesRejectedException) {
            throw installOfLoadModulesRejectedException;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "installLoadModules (ProductDataContainer anUP_ProductData, File anUCF_Path, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation, boolean aForcedInstall, boolean anIsProgressInfoToBeSent)", "Throwable caught.\n\tanUP_ProductData: " + productDataContainer + "\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tanIsProgressInfoToBeSent: " + bl2, throwable);
            throw new InstallException("Class name: " + this.getClass().getName() + "method: installLoadModules (ProductDataContainer anUP_ProductData, File anUCF_Path, Collection aLoadModulesToBeInstalled, FTP_ServerInformation aFTP_ServerInformation, boolean anIsProgressInfoToBeSent)" + "\n\tanUP_ProductData: " + productDataContainer + "\n\tanUCF_Path: " + file + "\n\taLoadModulesToBeInstalled: " + collection + "\n\taFTP_ServerInformation: " + fTP_ServerInformation + "\n\tOrigin Throwable data: " + throwable);
        }
    }

    private void installRequestRejected(InstallRejectedFTP_ServerNotAccessibleException installRejectedFTP_ServerNotAccessibleException) {
        UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException(installRejectedFTP_ServerNotAccessibleException.toString()), 896, "--"));
        UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
    }

    private void installRequestRejected(InstallRejectedGetLoadModuleFileException installRejectedGetLoadModuleFileException) {
        UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new GetFileException("Load module file not found on FTP server", installRejectedGetLoadModuleFileException.getFailedToInstallLoadModule()), 897, installRejectedGetLoadModuleFileException.toString()));
        UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
    }

    private void installRequestRejected(InstallRejectedInsufficientDiskSpaceException installRejectedInsufficientDiskSpaceException) {
        UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException(installRejectedInsufficientDiskSpaceException.toString()), 892, "--"));
        UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
    }

    private void installRequestRejected(InstallRejectedPiuTypeNotReferencedException installRejectedPiuTypeNotReferencedException) {
        UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException(installRejectedPiuTypeNotReferencedException.toString()), 866, "--"));
        UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
    }

    private void installRequestRejected(Throwable throwable) {
        UpgradeCoordinator.instance().installProgressInformation(new ActionEvent((Object)new InstallOfLoadModulesRejectedException(throwable.toString()), 993, "--"));
        UpgradeCoordinator.instance().installResponse(new InstallRejectedEvent(this));
    }
}

