/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.main.handler.attributehandler;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoRemovedException;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceAttribute;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.property.PropertyChangeListener;
import se.ericsson.cello.su.extsuif.upgradepackage.util.programhandler.ProgramInformationForConfiguredUpgradeablePIU;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.upgradepackage.main.handler.attributehandler.AttributePiusUpgradeInformationHandlerInterface;
import se.ericsson.cello.upgradepackage.main.handler.attributehandler.PiuUpgradeInformation;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.transaction.Transaction;

public class AttributePiusUpgradeInformationHandler
implements AttributePiusUpgradeInformationHandlerInterface,
PropertyChangeListener {
    private MoData data;
    private SequenceAttribute myPiusUpgradeInformation = null;
    private static final String PIUS_UPGRADE_INFORMATION = "piusUpgradeInformation";
    private static final String PIU_UPGRADE_INFORMATION = "piuUpgradeInformation";
    private static final String UPGRADEABLE_PIU = "upgradeablePIU";
    private static final String IS_RESTART_REQUIRED = "isRestartRequired";
    private static final String IS_RESTART_EXECUTED = "isRestartExecuted";
    private static final String IS_ANY_PROGRAM_PRESENT_IN_TO_VERSION = "isAnyProgramPresentInToVersion";
    private boolean myIsActive = false;

    public AttributePiusUpgradeInformationHandler(MoData moData, boolean bl) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "AttributePiusUpgradeInformationHandler(MoData anUpgradePackageMoData, boolean anIsRecoveredData)", "anIsRecoveredData: " + bl);
        }
        this.data = moData;
        if (!bl) {
            this.myPiusUpgradeInformation = new SequenceAttribute(PIUS_UPGRADE_INFORMATION, false);
            this.data.registerPersistentAttr((Attribute)this.myPiusUpgradeInformation);
        } else {
            this.myPiusUpgradeInformation = (SequenceAttribute)this.data.getAttribute(PIUS_UPGRADE_INFORMATION);
            if (this.myPiusUpgradeInformation == null) {
                this.myPiusUpgradeInformation = new SequenceAttribute(PIUS_UPGRADE_INFORMATION, false);
                this.data.registerPersistentAttr((Attribute)this.myPiusUpgradeInformation);
            }
        }
    }

    public void activate() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "activate( )");
        }
        if (!this.myIsActive) {
            ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.PiuUpgradeInformation, this);
            this.myIsActive = true;
        }
    }

    public void deactivate() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deactivate( )");
        }
        if (this.myIsActive) {
            ProgressInformationHandler.instance().removePropertyChangeListener(NotifyingSystemUpgradePropertyName.PiuUpgradeInformation, this);
            this.myIsActive = false;
            this.setPiusUpgradeInformation(new Vector(0));
        }
    }

    public PiuUpgradeInformation getPiuUpgradeInformation(GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiuUpgradeInformation(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "aGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit);
        }
        try {
            Iterator iterator = this.getPiusUpgradeInformation().iterator();
            StructAttribute structAttribute = null;
            ManagedObject managedObject = null;
            ManagedObject managedObject2 = (ManagedObject)genericUpgradeablePlugInUnit;
            while (iterator.hasNext()) {
                structAttribute = (StructAttribute)iterator.next();
                managedObject = ((ReferenceAttribute)structAttribute.getElement(UPGRADEABLE_PIU, null)).getValue(null);
                if (!managedObject.equals(managedObject2)) continue;
                return this.createPiuUpgradeInformation(structAttribute);
            }
            return null;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "getPiuUpgradeInformation(GenericUpgradeablePlugInUnit aGenericUpgradeablePlugInUnit)", "Throwable caught (and ignored i.e. null is returned) when trying to retrieve PiuUpgradeInformation,\n\taGenericUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tThrowable info: " + throwable);
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "aPropertyChangeEvent: " + propertyChangeEvent);
        }
        if (propertyChangeEvent.getNewValue() instanceof ProgramInformationForConfiguredUpgradeablePIU) {
            this.updatePiuUpgradeInformation((ProgramInformationForConfiguredUpgradeablePIU)propertyChangeEvent.getNewValue());
        } else {
            Trace.info(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Unknown type of property change value received (ignored).aPropertyChangeEvent: " + propertyChangeEvent);
        }
    }

    private void updatePiuUpgradeInformation(ProgramInformationForConfiguredUpgradeablePIU programInformationForConfiguredUpgradeablePIU) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updatePiuUpgradeInformation(ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU)", "aProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU);
        }
        try {
            ManagedObject managedObject = programInformationForConfiguredUpgradeablePIU.getUpgradeablePIU();
            StructAttribute structAttribute = this.createPiuUpgradeInformationStruct(managedObject, programInformationForConfiguredUpgradeablePIU.isRestartRequired(), programInformationForConfiguredUpgradeablePIU.isRestartExecuted(), programInformationForConfiguredUpgradeablePIU.isAnyProgramPresentInToVersion());
            Vector vector = this.getPiusUpgradeInformation();
            Iterator iterator = vector.iterator();
            StructAttribute structAttribute2 = null;
            ManagedObject managedObject2 = null;
            boolean bl = false;
            int n = 0;
            while (iterator.hasNext()) {
                structAttribute2 = (StructAttribute)iterator.next();
                managedObject2 = ((ReferenceAttribute)structAttribute2.getElement(UPGRADEABLE_PIU, null)).getValue(null);
                if (managedObject2.equals(managedObject)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                vector.setElementAt(structAttribute, n);
            } else {
                vector.addElement(structAttribute);
            }
            this.setPiusUpgradeInformation(vector);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "updatePiuUpgradeInformation(ProgramInformationForConfiguredUpgradeablePIU aProgramInformationForConfiguredUpgradeablePIU)", "Throwable caught (and ignored i.e. failure) when trying to update attribute 'piusUpgradeInformation',\n\taProgramInformationForConfiguredUpgradeablePIU: " + programInformationForConfiguredUpgradeablePIU + "\n\tThrowable info: " + throwable);
        }
    }

    private PiuUpgradeInformation createPiuUpgradeInformation(StructAttribute structAttribute) throws MoRemovedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createPiuUpgradeInformation(StructAttribute aPiuUpgradeInformationStruct)", "aPiuUpgradeInformationStruct: " + SuLib.toString(structAttribute.getValue(null)));
        }
        ManagedObject managedObject = ((ReferenceAttribute)structAttribute.getElement(UPGRADEABLE_PIU, null)).getValue(null);
        boolean bl = ((BooleanAttribute)structAttribute.getElement(IS_RESTART_REQUIRED, null)).getValue(null);
        boolean bl2 = ((BooleanAttribute)structAttribute.getElement(IS_RESTART_EXECUTED, null)).getValue(null);
        boolean bl3 = ((BooleanAttribute)structAttribute.getElement(IS_ANY_PROGRAM_PRESENT_IN_TO_VERSION, null)).getValue(null);
        return new PiuUpgradeInformation(managedObject, bl, bl2, bl3);
    }

    private StructAttribute createPiuUpgradeInformationStruct(ManagedObject managedObject, boolean bl, boolean bl2, boolean bl3) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createPiuUpgradeInformationStruct(ManagedObject aManagedObject, boolean anIsRestartRequired, boolean anIsRestartExecuted, boolean anIsAnyProgramPresentInToVersion)", "aManagedObject: " + managedObject + "\n\tanIsRestartRequired: " + bl + "\n\tanIsRestartExecuted: " + bl2 + "\n\tanIsAnyProgramPresentInToVersion: " + bl3);
        }
        StructAttribute structAttribute = new StructAttribute(PIU_UPGRADE_INFORMATION, false);
        ReferenceAttribute referenceAttribute = new ReferenceAttribute(UPGRADEABLE_PIU, false, managedObject);
        structAttribute.addElement((Attribute)referenceAttribute);
        BooleanAttribute booleanAttribute = new BooleanAttribute(IS_RESTART_REQUIRED, false, bl);
        structAttribute.addElement((Attribute)booleanAttribute);
        BooleanAttribute booleanAttribute2 = new BooleanAttribute(IS_RESTART_EXECUTED, false, bl2);
        structAttribute.addElement((Attribute)booleanAttribute2);
        BooleanAttribute booleanAttribute3 = new BooleanAttribute(IS_ANY_PROGRAM_PRESENT_IN_TO_VERSION, false, bl3);
        structAttribute.addElement((Attribute)booleanAttribute3);
        return structAttribute;
    }

    private Vector getPiusUpgradeInformation() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getPiusUpgradeInformation( )");
        }
        try {
            Enumeration enumeration = this.myPiusUpgradeInformation.elements();
            Vector<StructAttribute> vector = new Vector<StructAttribute>(this.myPiusUpgradeInformation.size());
            while (enumeration.hasMoreElements()) {
                vector.addElement((StructAttribute)enumeration.nextElement());
            }
            return vector;
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "getPiusUpgradeInformation( )", "Throwable caught (and ignored i.e empty Vector is returned) when trying to get attribute 'piusUpgradeInformation',\n\tThrowable info: " + throwable);
            return new Vector(0);
        }
    }

    private void setPiusUpgradeInformation(Vector vector) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setPiusUpgradeInformation(Vector aPiusUpgradeInformation)", "aPiusUpgradeInformation: " + vector);
        }
        Control control = null;
        Coordinator coordinator = null;
        try {
            control = Transaction.create();
            coordinator = Transaction.getCoordinator(control);
            this.data.handleTransaction(coordinator, MoData.WRITE_ACCESS);
            Object[] objectArray = new StructAttribute[vector.size()];
            vector.copyInto(objectArray);
            this.myPiusUpgradeInformation.setValue((Attribute[])objectArray);
            Transaction.commit(control);
        }
        catch (Throwable throwable) {
            Trace.warning(this.getClass(), "setPiusUpgradeInformation(Vector aPiusUpgradeInformation)", "Throwable caught (and ignored i.e. failure) when trying to set attribute 'piusUpgradeInformation',\n\tThrowable info: " + throwable);
            Transaction.rollback(control);
        }
    }
}

