/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.trace.writers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import se.ericsson.cello.property.PropertyChangeEvent;
import se.ericsson.cello.su.extsuif.configurationversion.service.ServiceStatusInformationEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.Timer;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerEvent;
import se.ericsson.cello.su.extsuif.upgradepackage.util.time.TimerListener;
import se.ericsson.cello.upgradepackage.trace.TraceConstants;
import se.ericsson.cello.upgradepackage.trace.datacontainer.LogContainer;
import se.ericsson.cello.upgradepackage.trace.datacontainer.TraceInfoDataContainer;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNameInUseException;
import se.ericsson.cello.upgradepackage.trace.exception.LogFileNotInUseException;
import se.ericsson.cello.upgradepackage.trace.exception.TraceWriterException;
import se.ericsson.cello.upgradepackage.trace.writers.TraceLogWriter;
import se.ericsson.cello.upgradepackage.trace.writers.TraceTE_LogWriter;
import se.ericsson.cello.upgradepackage.util.enumer.NotifyingTracePropertyName;

public class TraceFileWriter
extends TraceLogWriter
implements TimerListener {
    private static String myFileNameUsed = "";
    private int myFileSizeUsed = 1;
    private int myFlushIntervalUsed = 1;
    private boolean isOneClickUpgrade = false;
    List myBufferList = Collections.synchronizedList(new LinkedList());
    private PrintStream myPrintStream = null;
    private Timer myFlushTimer = null;
    private boolean myLastLogWriteFailed = false;
    private boolean myBulkActive = false;

    public TraceFileWriter(TraceInfoDataContainer traceInfoDataContainer) {
        myFileNameUsed = traceInfoDataContainer.getFileName(false);
        this.myFileSizeUsed = traceInfoDataContainer.getFileSize();
        this.myFlushIntervalUsed = traceInfoDataContainer.getFlushInterval();
        this.isOneClickUpgrade = traceInfoDataContainer.isOneClickUpgrade();
        try {
            this.createTraceFileDir();
            this.openOut();
            this.closeOut();
        }
        catch (TraceWriterException traceWriterException) {
            TraceTE_LogWriter.teLogError(this.getClass(), "TraceFileWriter(TraceInfoDataContainer aTraceInfoDataContainer)", "Failed to open trace file (ignored for now)", (Throwable)((Object)traceWriterException));
        }
        traceInfoDataContainer.addPropertyChangeListener(this);
    }

    public synchronized void clear(TraceInfoDataContainer traceInfoDataContainer) {
        this.flushOut();
        myFileNameUsed = "";
        this.myFileSizeUsed = 1;
        this.myFlushIntervalUsed = 1;
        traceInfoDataContainer.removePropertyChangeListener(this);
        this.myLastLogWriteFailed = false;
    }

    public static Collection getNotActiveLogFiles() {
        Vector<String> vector = new Vector<String>(1);
        File file = new File(TraceConstants.TRACE_FILE_PATH_NAME);
        if (file.exists()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(TraceConstants.TRACE_FILE_PATH_NAME + stringArray[i]);
                if (file2.isDirectory() || file2.getName().equals(myFileNameUsed)) continue;
                vector.add(file2.getName());
            }
        } else {
            TraceTE_LogWriter.teLogError(TraceFileWriter.class, "getNotActiveLogFiles ( )", "\n\tCould not find the directory: " + TraceConstants.TRACE_FILE_PATH_NAME);
        }
        return vector;
    }

    public synchronized void clearOut() throws LogFileNotInUseException {
        this.flushOut();
        this.deleteLogFile();
        try {
            this.createTraceFile();
        }
        catch (TraceWriterException traceWriterException) {
            TraceTE_LogWriter.teLogError(this.getClass(), "clearOut()", "Failed to re-create the trace file, exception caught.", (Throwable)((Object)traceWriterException));
        }
    }

    private void openOut() throws TraceWriterException {
        if (this.myPrintStream != null) {
            return;
        }
        try {
            this.createTraceFile();
            this.myPrintStream = new PrintStream(new FileOutputStream(TraceConstants.TRACE_FILE_PATH_NAME + myFileNameUsed, true));
        }
        catch (TraceWriterException traceWriterException) {
            throw traceWriterException;
        }
        catch (Throwable throwable) {
            throw new TraceWriterException("Failed to open printStream for trace file, throwable caught. Throwable: " + throwable);
        }
    }

    private void closeOut() {
        if (this.myPrintStream != null) {
            try {
                this.myPrintStream.flush();
                this.myPrintStream.close();
                this.myPrintStream = null;
                this.moveTraceContentIfNeeded();
            }
            catch (Throwable throwable) {
                TraceTE_LogWriter.teLogError(this.getClass(), "closeOut()", "Throwable caught when trying to close printStream for su trace file.", throwable);
            }
        }
    }

    private void moveTraceContentIfNeeded() {
        File file = new File(this.getTotalTraceFilePath());
        long l = file.length();
        if (l > (long)(this.myFileSizeUsed * 1024)) {
            TraceTE_LogWriter.teLogInfo(this.getClass(), "moveTraceContentIfNeeded()", "The file '" + myFileNameUsed + "' has exceeded the maximum size. (" + this.myFileSizeUsed + " kB)" + "\n\tThe contents is moved to file '" + myFileNameUsed + "_old." + "\n\tThe trace logging continues to the existing trace log file '" + myFileNameUsed + "'.");
            try {
                String string = myFileNameUsed + "_old";
                File file2 = new File(TraceConstants.TRACE_FILE_PATH_NAME + string);
                if (!file.renameTo(file2)) {
                    TraceTE_LogWriter.teLogError(this.getClass(), "moveTraceContentIfNeeded()", "Failed to rename the trace file to trace old");
                }
                file.delete();
            }
            catch (Throwable throwable) {
                TraceTE_LogWriter.teLogError(this.getClass(), "moveTraceContentIfNeeded()", "Creation of trace file " + myFileNameUsed + "_old" + " failed due to throwable caught.", throwable);
            }
            try {
                this.openOut();
                this.closeOut();
            }
            catch (TraceWriterException traceWriterException) {
                TraceTE_LogWriter.teLogInfo(this.getClass(), "moveTraceContentIfNeeded()", "Failed to create the trace file '" + myFileNameUsed + "', exception caught (ignored for now)." + "Exception: " + (Object)((Object)traceWriterException));
            }
        }
    }

    private void createTraceFile() throws TraceWriterException {
        File file = new File(this.getTotalTraceFilePath());
        if (file.exists()) {
            if (!file.isFile()) {
                throw new TraceWriterException("Creation of trace file failed. The trace file name " + myFileNameUsed + " does not refer to a file.");
            }
        } else {
            try {
                PrintStream printStream = new PrintStream(new FileOutputStream(TraceConstants.TRACE_FILE_PATH_NAME + myFileNameUsed));
                printStream.close();
            }
            catch (Throwable throwable) {
                throw new TraceWriterException("Creation of trace file failed. Creation of trace file " + myFileNameUsed + " failed, throwable caught." + "Throwable: " + throwable);
            }
        }
    }

    private String getTotalTraceFilePath() {
        return TraceConstants.TRACE_FILE_PATH_NAME + myFileNameUsed;
    }

    public static boolean deleteLogFile(String string) throws LogFileNameInUseException {
        if (string.equals(myFileNameUsed)) {
            throw new LogFileNameInUseException(string);
        }
        boolean bl = false;
        File file = new File(TraceConstants.TRACE_FILE_PATH_NAME + string);
        if (file.exists() && file.isFile()) {
            bl = file.delete();
        }
        return bl;
    }

    private void deleteLogFile() {
        if (this.myPrintStream != null) {
            TraceTE_LogWriter.teLogError(this.getClass(), "deleteLogFile()", "Attempt to delete the log file when it is in use.");
            return;
        }
        File file = new File(this.getTotalTraceFilePath());
        file.delete();
    }

    private void createTraceFileDir() throws TraceWriterException {
        try {
            File file = new File(TraceConstants.TRACE_FILE_PATH_NAME);
            if (!file.exists() && !file.mkdirs()) {
                throw new TraceWriterException("Failed to create the trace file directory. Directory: " + TraceConstants.TRACE_FILE_PATH_NAME);
            }
        }
        catch (Throwable throwable) {
            throw new TraceWriterException("Failed to create the trace file directory due to throwable caught. Directory: " + TraceConstants.TRACE_FILE_PATH_NAME + " Throwable: " + throwable);
        }
    }

    public synchronized void writeToOut(String string, String string2, String string3, Class clazz, String string4, String string5, String string6, Throwable throwable) {
        if (this.myBulkActive) {
            this.flushOut();
            this.myBulkActive = false;
        }
        LogContainer logContainer = new LogContainer(string, string2, string3, clazz, string4, string5, string6, throwable);
        int n = this.myFlushIntervalUsed;
        if (this.isOneClickUpgrade && n < 50) {
            n = 50;
        }
        if (n == 1) {
            boolean bl = this.writeToOut(logContainer);
            this.writeTraceToTE_Log(logContainer, bl);
        } else {
            this.myBufferList.add(logContainer);
            if (this.myBufferList.size() >= n || string.equals("I N F O") || string.equals("W A R N I N G") || string.equals("E R R O R")) {
                this.flushOut();
            }
        }
    }

    public synchronized void flushOut() {
        if (this.myBufferList.isEmpty()) {
            return;
        }
        boolean bl = this.writeToOut(this.myBufferList);
        Iterator iterator = this.myBufferList.iterator();
        while (iterator.hasNext()) {
            this.writeTraceToTE_Log((LogContainer)iterator.next(), bl);
        }
        this.myBufferList.clear();
    }

    public synchronized void writeTraceToBuffer(LogContainer logContainer) {
        this.myBulkActive = true;
        if (this.myBufferList.size() >= 50) {
            this.flushOut();
        }
        this.myBufferList.add(logContainer);
    }

    private void writeTraceToTE_Log(LogContainer logContainer, boolean bl) {
        if (bl) {
            logContainer.appendBeforeMessage("(SU Log redirected.) ");
        }
        TraceTE_LogWriter.writeToMessageLog(logContainer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToOut(LogContainer logContainer) {
        boolean bl = false;
        try {
            this.openOut();
            String string = this.getLogMessageString(logContainer);
            if (this.myLastLogWriteFailed) {
                string = "\n **** SU traces has been lost due to problem accessing the trace file. ****\n" + string;
            }
            this.myPrintStream.println(string);
            this.myLastLogWriteFailed = false;
        }
        catch (TraceWriterException traceWriterException) {
            bl = true;
            if (!this.myLastLogWriteFailed) {
                TraceTE_LogWriter.teLogError(this.getClass(), "writeToOut(LogContainer aLogContainer)", "Failed to write an upgrade trace to log file, exception caught.", (Throwable)((Object)traceWriterException));
                this.myLastLogWriteFailed = true;
            }
        }
        finally {
            this.closeOut();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToOut(Collection collection) {
        boolean bl = false;
        try {
            this.openOut();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = this.getLogMessageString((LogContainer)iterator.next());
                if (this.myLastLogWriteFailed) {
                    string = "\n **** SU traces has been lost due to problem accessing the trace file. ****\n" + string;
                }
                this.myPrintStream.println(string);
                this.myLastLogWriteFailed = false;
            }
        }
        catch (TraceWriterException traceWriterException) {
            bl = true;
            if (!this.myLastLogWriteFailed) {
                TraceTE_LogWriter.teLogError(this.getClass(), "writeToOut(LogContainer aLogContainer)", "Failed to write an upgrade trace to log file, exception caught.", (Throwable)((Object)traceWriterException));
                this.myLastLogWriteFailed = true;
            }
        }
        finally {
            this.closeOut();
        }
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.FileName.getValue())) {
            myFileNameUsed = (String)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.FileSize.getValue())) {
            this.myFileSizeUsed = (Integer)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.OneClickUpgrade.getValue())) {
            this.isOneClickUpgrade = (Boolean)propertyChangeEvent.getNewValue();
        } else {
            if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.FlushInterval.getValue())) {
                this.myFlushIntervalUsed = (Integer)propertyChangeEvent.getNewValue();
                if (this.myBufferList.size() >= this.myFlushIntervalUsed) {
                    this.flushOut();
                }
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals(NotifyingTracePropertyName.UpgradeTraceMoLoaded.getValue())) {
                ProgressInformationHandler.instance().addPropertyChangeListener(NotifyingSystemUpgradePropertyName.ServiceStatus, this);
                return;
            }
            if (propertyChangeEvent.getNewValue() instanceof ServiceStatusInformationEvent) {
                if (!((ServiceStatusInformationEvent)propertyChangeEvent.getNewValue()).isExecuting) {
                    this.startFlushTimer();
                }
                return;
            }
            return;
        }
        try {
            this.createTraceFileDir();
            this.openOut();
            this.closeOut();
        }
        catch (TraceWriterException traceWriterException) {
            TraceTE_LogWriter.teLogError(this.getClass(), "propertyChange(PropertyChangeEvent aPropertyChangeEvent)", "Failed to (re)open trace file (ignored for now)", (Throwable)((Object)traceWriterException));
        }
    }

    public void timerAction(TimerEvent timerEvent) {
        this.flushOut();
        this.myFlushTimer.removeListener(this);
        this.myFlushTimer = null;
    }

    private void startFlushTimer() {
        this.stopFlushTimer();
        this.myFlushTimer = new Timer(2000);
        this.myFlushTimer.addListener(this);
        this.myFlushTimer.startTimer();
    }

    private void stopFlushTimer() {
        if (this.myFlushTimer != null) {
            this.myFlushTimer.removeListener(this);
            this.myFlushTimer.stopTimer();
            this.myFlushTimer = null;
        }
    }
}

