/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.upgradepackage.upgrade;

import java.io.File;
import java.io.FileReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;
import se.ericsson.cello.equipment.GenericUpgradeablePlugInUnit;
import se.ericsson.cello.equipment.suaccess.PlugInUnitMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SlotMoSU_Access;
import se.ericsson.cello.equipment.suaccess.SubrackMoSU_Access;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.su.convert.UpgradeMoDataConverter;
import se.ericsson.cello.su.convert.base.ConverterState;
import se.ericsson.cello.su.convert.exception.SuConverterException;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.NotifyingSystemUpgradePropertyName;
import se.ericsson.cello.su.extsuif.upgradepackage.util.progresshandler.ProgressInformationHandler;
import se.ericsson.cello.su.froproxy.upi.interfaces.OsaUpiProxyAccess;
import se.ericsson.cello.su.util.versionhandler.SU_AccessVersionHandler;
import se.ericsson.cello.sudom.proxy.DocumentObjectProxyInterface;
import se.ericsson.cello.sudom.proxy.UCF_ParserFacade;
import se.ericsson.cello.sudom.proxy.exceptions.UpgradeControlFileParserException;
import se.ericsson.cello.sudom.proxy.explicitreplacement.ExplicitReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.explicitreplacement.RepertoireReplacementsProxyInterface;
import se.ericsson.cello.sudom.proxy.managedelement.ManagedElementProxyInterface;
import se.ericsson.cello.sudom.proxy.repertoire.RepertoiresProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequenceProxyInterface;
import se.ericsson.cello.sudom.proxy.upgradesequence.UpgradeSequencesProxyInterface;
import se.ericsson.cello.support.servloc.ServiceLocatorFacade;
import se.ericsson.cello.upgradepackage.main.interfaces.UpgradeMaster;
import se.ericsson.cello.upgradepackage.trace.Trace;
import se.ericsson.cello.upgradepackage.upgrade.ActiveOtherLMsHelper;
import se.ericsson.cello.upgradepackage.upgrade.UpgradeClientInterface;
import se.ericsson.cello.upgradepackage.upgrade.UpgradeSupervisionTimerHandler;
import se.ericsson.cello.upgradepackage.upgrade.WebserverLMsHelper;
import se.ericsson.cello.upgradepackage.upgrade.exception.UpgradeRejectedException;
import se.ericsson.cello.upgradepackage.upgrade.parser.configsupport.ConfigSupportMoSAXdh;
import se.ericsson.cello.upgradepackage.upgrade.step.rebootjvmupgrade.JvmUpdateHandler;
import se.ericsson.cello.upgradepackage.util.datacontainer.ConfirmationDeadlineTimerInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.EnteringNormalModeInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.EnteringUpgradeModeInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.LockPIUsInformation;
import se.ericsson.cello.upgradepackage.util.datacontainer.SlotDataAPN_SMN_Container;
import se.ericsson.cello.upgradepackage.util.library.SuLib;
import se.ericsson.cello.upgradepackage.util.mohandler.activeotherlms.ActiveOtherLMsMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.loadmodule.LoadModuleMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.managedelement.ManagedElementMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.piu.PIU_MO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.repertoire.RepertoireMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.slot.SlotMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.swallocation.SwAllocationMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerException;
import se.ericsson.cello.upgradepackage.util.mohandler.upgradeable.UpgradeablePIU_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.mohandler.webserver.WebServerMO_HandlerInterface;
import se.ericsson.cello.upgradepackage.util.servicefinder.ServiceFinder;
import se.ericsson.cello.upgradepackage.util.time.TimeHandler;

public class UpgradePackageUpgrader {
    private boolean myUPI_ProxyIsUpAndRunning = false;
    private File myUpgradeControlFile = null;
    private UpgradeSequenceProxyInterface myUpgradeSequenceProxyInterface = null;
    private UpgradeClientInterface myUpgradeClientInterface = null;
    private OsaUpiProxyAccess myOsaUPI_Proxy = (OsaUpiProxyAccess)ServiceLocatorFacade.getRepository().getService(OsaUpiProxyAccess.class);
    private RepertoireReplacementsProxyInterface myRepertoireReplacementsProxyInterface = null;
    private RepertoiresProxyInterface myRepertoiresProxyInterface = null;

    public UpgradePackageUpgrader(File file, String string, UpgradeClientInterface upgradeClientInterface) throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence, UpgradeClientInterface anUpgradeClientInterface)", "anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string + "\n\tanUpgradeClientInterface: " + upgradeClientInterface);
        }
        if (file == null) {
            Trace.error(this.getClass(), "UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence, UpgradeClientInterface anUpgradeClientInterface)", "The request to execute an upgrade is rejected due to the path to the Upgrade Control File is not known\n\tanUpgradeControlFile: null");
            throw new UpgradeRejectedException("UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence, UpgradeClientInterface anUpgradeClientInterface)\n\tThe request to execute an upgrade is rejected due to the path to the Upgrade Control File is not known\n\tanUpgradeControlFile: null");
        }
        if (upgradeClientInterface == null) {
            Trace.error(this.getClass(), "UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence, UpgradeClientInterface anUpgradeClientInterface)", "The request to execute an upgrade is rejected due to anUpgradeClientInterface is null");
            throw new UpgradeRejectedException("UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence, UpgradeClientInterface anUpgradeClientInterface)\n\tThe request to execute an upgrade is rejected due to anUpgradeClientInterface is null");
        }
        try {
            this.myUpgradeControlFile = file;
            this.myUpgradeClientInterface = upgradeClientInterface;
            String[] stringArray = new String[]{"UpgradeSequence", "ExplicitReplacement"};
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElements(this.myUpgradeClientInterface.getUpgradePackageProductNumber(), this.myUpgradeClientInterface.getUpgradePackageProductRevision(), this.myUpgradeControlFile.getAbsolutePath(), stringArray);
            UpgradeSequencesProxyInterface upgradeSequencesProxyInterface = documentObjectProxyInterface.getUpgradeSequencesProxyInterface();
            ExplicitReplacementsProxyInterface explicitReplacementsProxyInterface = documentObjectProxyInterface.getExplicitReplacementsProxyInterface();
            this.myUpgradeSequenceProxyInterface = upgradeSequencesProxyInterface.getUpgradeSequenceProxyInterface(string);
            this.myRepertoireReplacementsProxyInterface = explicitReplacementsProxyInterface.getRepertoireReplacementsProxyInterface(string);
            this.myRepertoiresProxyInterface = documentObjectProxyInterface.getRepertoiresProxyInterface();
            if (this.myUpgradeSequenceProxyInterface == null) {
                Trace.error(this.getClass(), "UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence)", "Not able to find an UpgradeSequenceProxyInterface for the given upgrade sequence label argument.anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string);
                throw new UpgradeRejectedException("Not able to find an UpgradeSequenceProxyInterface for the given upgrade sequence label argument.anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string);
            }
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence)", "An UpgradeControlFileParserException was caught while parsing the upgrade sequence of the UCF.anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string + "\n\tUpgradeControlFileParserException reason: " + upgradeControlFileParserException.toString());
            }
            throw new UpgradeRejectedException("UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence)An UpgradeControlFileParserException was caught while parsing the upgrade sequence of the UCF.anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string + "\n\tUpgradeControlFileParserException reason: " + upgradeControlFileParserException.toString());
        }
        catch (MoAccessException moAccessException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence)", "The MoAccessException was caught when requesting for parsing of the upgrade sequence.anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string + "\n\tMoAccessException reason: " + moAccessException.toString());
            }
            throw new UpgradeRejectedException("The parser factory detected a MoAccessException when requesting for parsing of the upgrade sequence.anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string + "\n\tMoAccessException reason: " + moAccessException.toString());
        }
        catch (Exception exception) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "UpgradePackageUpgrader(File anUpgradeControlFile, String anLabelOfUpgradeSequence)", "The Exception was caught when requesting for parsing of the upgrade sequence.anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string + "\n\tParserFactoryException reason: " + exception.toString());
            }
            throw new UpgradeRejectedException("The Exception was caught when requesting for parsing of the upgrade sequence.anUpgradeControlFile: " + SuLib.toString(file) + "\n\tanLabelOfUpgradeSequence: " + string + "\n\tException reason: " + exception.toString());
        }
    }

    public Vector collectFaultyAndNotSupportedSlotsToBeFaultTolerant(Vector vector, Vector vector2, Vector vector3, Vector vector4) throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "collectFaultyAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "aFaultyPIUsLockedBeforeUpgrade: " + vector + "\n\taNonSupportedPIUsLockedBeforeUpgrade: " + vector2 + "\n\taFaultyPIUsNotLocked: " + vector3 + "\n\taNonSupportedPIUsNotLocked: " + vector4);
        }
        try {
            Vector<ManagedObject> vector5 = new Vector<ManagedObject>();
            GenericUpgradeablePlugInUnit genericUpgradeablePlugInUnit = null;
            ManagedObject managedObject = null;
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator.next();
                managedObject = genericUpgradeablePlugInUnit.getParent();
                if (managedObject instanceof SlotMoSU_Access) {
                    vector5.addElement(managedObject);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collectFaultyAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "A Faulty PIUs (locked) slot has been added to be fault tolerant: " + managedObject);
                    continue;
                }
                Trace.warning(this.getClass(), "collectFaultyAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "A PIU (UpgradeablePlugInUnit) that is faulty and that was locked before the upgrade was requested\n\tis not related to a Slot MO and therefore it is ignored.\n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthe parent MO of the UpgradeablePlugInUnit: " + managedObject);
            }
            Iterator iterator2 = vector2.iterator();
            while (iterator2.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator2.next();
                managedObject = genericUpgradeablePlugInUnit.getParent();
                if (managedObject instanceof SlotMoSU_Access) {
                    vector5.addElement(managedObject);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "A Non Supported PIUs (locked) slot has been added to be fault tolerant: " + managedObject);
                    continue;
                }
                Trace.warning(this.getClass(), "collectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "A PIU (UpgradeablePlugInUnit) that is not supported and that was locked before the upgrade was requested\n\tis not related to a Slot MO and therefore it is ignored.\n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthe parent MO of the UpgradeablePlugInUnit: " + managedObject);
            }
            Iterator iterator3 = vector3.iterator();
            while (iterator3.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator3.next();
                managedObject = genericUpgradeablePlugInUnit.getParent();
                if (managedObject instanceof SlotMoSU_Access) {
                    vector5.addElement(managedObject);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "A faulty PIUs (not locked) slot has been added to be fault tolerant: " + managedObject);
                    continue;
                }
                Trace.log1(this.getClass(), "collectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "A faulty PIU (UpgradeablePlugInUnit) has been detected. This PIU is not a child Mo to a Slot Mo and can therefore NOT be marked as fault tolerant during the upgrade procedure. Note that this faulty PIU will not prevent the upgrade itself.\n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthe parent MO of the UpgradeablePlugInUnit: " + managedObject);
            }
            Iterator iterator4 = vector4.iterator();
            while (iterator4.hasNext()) {
                genericUpgradeablePlugInUnit = (GenericUpgradeablePlugInUnit)iterator4.next();
                managedObject = genericUpgradeablePlugInUnit.getParent();
                if (managedObject instanceof SlotMoSU_Access) {
                    vector5.addElement(managedObject);
                    if (!Trace.valid(this.getClass(), 22)) continue;
                    Trace.debug(this.getClass(), 22, "collectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "A non supported PIUs (not locked) slot has been added to be fault tolerant: " + managedObject);
                    continue;
                }
                Trace.warning(this.getClass(), "collectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "A PIU (UpgradeablePlugInUnit) that is not suported and that was not locked before the upgrade where requested\n\tis not related to a Slot MO and therefor it is ignored.\n\ttheUpgradeablePlugInUnit: " + genericUpgradeablePlugInUnit + "\n\tthe parent MO of the UpgradeablePlugInUnit: " + managedObject);
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "collectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "List of all faulty PIUs, non supported PIUs and locked PIUs that shall be fault tolerant during the execution of the upgrade. \n\ttheSlotsToBeFaultTolerant: " + vector5);
            }
            return vector5;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "collectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade, Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)", "The collection of faulty PIUs, non supported PIUs and locked PIUs (Slots) that shall be fault tolerant during an upgrade failed due to a caught exception.\n\taFaultyPIUsLockedBeforeUpgrade: " + vector + "\n\taNonSupportedPIUsLockedBeforeUpgrade: " + vector2 + "\n\taFaultyPIUsNotLocked: " + vector3 + "\n\taNonSupportedPIUsNotLocked: " + vector4 + "\n\tException reason: " + exception.toString());
            throw new UpgradeRejectedException(this.getClass() + "\n\tcollectNonSupportedAndNotSupportedSlotsToBeFaultTolerant (Vector aFaultyPIUsLockedBeforeUpgrade," + "Vector aNonSupportedPIUsLockedBeforeUpgrade, Vector aFaultyPIUsNotLocked, Vector aNonSupportedPIUsNotLocked)" + "The collection of faulty PIUs, non supported PIUs and locked PIUs (Slots) that shall be fault tolerant during an upgrade failed due to a caught exception." + "\n\taFaultyPIUsLockedBeforeUpgrade: " + vector + "\n\taNonSupportedPIUsLockedBeforeUpgrade: " + vector2 + "\n\taFaultyPIUsNotLocked: " + vector3 + "\n\taNonSupportedPIUsNotLocked: " + vector4 + "\n\tException reason: " + exception.toString());
        }
    }

    public Vector getFaultyPIUsLockedBeforeUpgrade() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFaultyPIUsLockedBeforeUpgrade()");
        }
        if (this.myUpgradeClientInterface != null) {
            Object[] objectArray = this.myUpgradeClientInterface.getFaultyPIUsLockedBeforeUpgrade(null);
            return SuLib.translateToVector(objectArray);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getFaultyPIUsLockedBeforeUpgrade()", "The attribute myUpgradeClientInterface == null");
        }
        return new Vector();
    }

    public Vector getFaultyPIUsLockedByUpgrade() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getFaultyPIUsLockedByUpgrade()");
        }
        if (this.myUpgradeClientInterface != null) {
            Object[] objectArray = this.myUpgradeClientInterface.getFaultyPIUsLockedByUpgrade(null);
            return SuLib.translateToVector(objectArray);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getFaultyPIUsLockedByUpgrade()", "The attribute myUpgradeClientInterface == null");
        }
        return new Vector();
    }

    public Vector getNonSupportedPIUsLockedBeforeUpgrade() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNonSupportedPIUsLockedByUpgrade()");
        }
        if (this.myUpgradeClientInterface != null) {
            Object[] objectArray = this.myUpgradeClientInterface.getNonSupportedPIUsLockedBeforeUpgrade(null);
            return SuLib.translateToVector(objectArray);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getNonSupportedPIUsLockedBeforeUpgrade()", "The attribute myUpgradeClientInterface == null");
        }
        return new Vector();
    }

    public Vector getNonSupportedPIUsLockedByUpgrade() throws MoAccessException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNonSupportedPIUsLockedByUpgrade()");
        }
        if (this.myUpgradeClientInterface != null) {
            Object[] objectArray = this.myUpgradeClientInterface.getNonSupportedPIUsLockedByUpgrade(null);
            return SuLib.translateToVector(objectArray);
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "getNonSupportedPIUsLockedByUpgrade()", "The attribute myUpgradeClientInterface == null");
        }
        return new Vector();
    }

    public RepertoiresProxyInterface getRepertoiresProxyInterface() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getRepertoiresProxyInterface( )");
        }
        return this.myRepertoiresProxyInterface;
    }

    public boolean getTolerateErrors() throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getTolerateErrors()");
        }
        try {
            boolean bl = this.myUpgradeSequenceProxyInterface.getTolerateErrors();
            if (bl) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getTolerateErrors()", "There are PIUs defined in the UCF that shall tolerate errors.");
                }
                return bl;
            }
            Vector vector = this.getFaultyPIUsLockedBeforeUpgrade();
            Vector vector2 = this.getNonSupportedPIUsLockedBeforeUpgrade();
            Vector vector3 = this.getFaultyPIUsLockedByUpgrade();
            Vector vector4 = this.getNonSupportedPIUsLockedByUpgrade();
            if (vector.size() > 0 || vector2.size() > 0 || vector3.size() > 0 || vector4.size() > 0) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "getTolerateErrors()", "There are no PIUs defined in the UCF that shall tolerate errors but there are other PIUs that shall tolerate errors.\n\ttheFaultyPIUsLockedBeforeUpgrade: " + vector + "\n\ttheNonSupportedPIUsLockedBeforeUpgrade: " + vector2 + "\n\ttheFaultyPIUsNotLocked: " + vector3 + "\n\ttheNonSupportedPIUsNotLocked: " + vector4);
                }
                return true;
            }
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "getTolerateErrors()", "There are no PIUs that shall be fault tolerant i.e. neither defined in the UCF nor not supported, faulty r operational but locked.\n\ttheFaultyPIUsLockedBeforeUpgrade: " + vector + "\n\ttheNonSupportedPIUsLockedBeforeUpgrade: " + vector2 + "\n\ttheFaultyPIUsNotLocked: " + vector3 + "\n\ttheNonSupportedPIUsNotLocked: " + vector4);
            }
            return false;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "getTolerateErrors()", "Failed to find out the tolerate error mode due to an exception was caught.\n\tException data: " + exception.toString());
            throw new UpgradeRejectedException("getTolerateErrors()\n\tFailed to find out the tolerate error mode due to an exception was caught.\n\tException data: " + exception.toString());
        }
    }

    public UpgradeSequenceProxyInterface getUpgradeSequenceProxyInterface() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getUpgradeSequenceProxyInterface()");
        }
        return this.myUpgradeSequenceProxyInterface;
    }

    public void normalExecutionMode(String string) throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "normalExecutionMode(String anExecutedStepLabel)\n\tanExecutedStepLabel: " + string);
        }
        Trace.suTestLog(this.getClass(), "normalExecutionMode(String anExecutedStepLabel)", "Entering normal execution mode");
        try {
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new EnteringNormalModeInformation(this));
            JvmUpdateHandler jvmUpdateHandler = new JvmUpdateHandler();
            jvmUpdateHandler.generateAndSetNewJvmClasspath("New", this.myUpgradeClientInterface);
            this.setNormalExecutionMode();
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "normalExecutionMode()", "The preparation of normal execution mode  failed for any reason.\n\tException reason: " + exception, exception);
            throw new UpgradeRejectedException("normalExecutionMode()\n\tUpgrade failed to go back to normal execution mode for any reason.\n\tException reason: " + exception.toString());
        }
    }

    public void requestNormalExecutionMode() {
        Trace.suTestLog(this.getClass(), "requestNormalExecutionMode( )", "Entering normal execution mode");
        ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new EnteringNormalModeInformation(this));
        this.setNormalExecutionMode();
    }

    private void setNormalExecutionMode() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setNormalExecutionMode( )");
        }
        this.myOsaUPI_Proxy.sendOsaUpiResetRollbackReq();
        if (!this.sendOsaUpiChangeErrorEscalation(0)) {
            Trace.error(this.getClass(), "normalExecutionMode()", "Failed to set back the error escalation mode to NORMAL.");
        }
        if (!this.myOsaUPI_Proxy.sendOsaUpiSetSuperTimerReq(0L)) {
            Trace.error(this.getClass(), "requestNormalExecutionMode()", "Failed to stop the upgrade supervision timer.");
        }
    }

    public boolean triggerIndication(UpgradeMaster upgradeMaster, String string) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "aMaster: " + upgradeMaster + "\n\taTriggerName: " + string);
        }
        try {
            if (string.equalsIgnoreCase("INITIATE")) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "Updating other loader name information.");
                }
                this.updateOtherLoaderNames();
            } else if (string.equalsIgnoreCase("CONVERT")) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "Creating SU convert table.");
                }
                this.createSuConvertTable(ConverterState.UPGRADE);
            } else if (string.equalsIgnoreCase("EXECUTE")) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "Updating web server paths.");
                }
                this.updateWebServerPaths();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "Updating product data in MO Managed Element.");
                }
                this.updateManagedElementMO();
            } else if (string.equalsIgnoreCase("FINISH")) {
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "Updating OtherLoaderNames.");
                }
                this.updateOtherLoaderNames(false);
                this.updateRepertoireMos();
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "Deleting temporary DB tables used by SystemUpgrade converter.");
                }
                this.deleteSuConvertTables();
            }
            return true;
        }
        catch (UpgradeRejectedException upgradeRejectedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "UpgradeRejectedException during execution of the received trigger type.\n\tException message: " + upgradeRejectedException.getMessage() + "\n\taMaster: " + upgradeMaster + "\n\taTriggerName: " + string + "\n\tException: " + upgradeRejectedException.toString());
            }
            return false;
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "triggerIndication(UpgradeMaster aMaster, String aTriggerName)", "Throwable during execution of the received trigger type.\n\tThrowable message: " + throwable.getMessage() + "\n\taMaster: " + upgradeMaster + "\n\taTriggerName: " + string + "\n\tException: " + throwable.toString(), throwable);
            return false;
        }
    }

    public void upgradeExecutionMode(String string, String string2, File file, String string3, String string4) throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "upgradeExecutionMode(String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, File anUpgradePackageControlFile, String aStepLabel)", "anUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3);
        }
        try {
            Trace.suTestLog(this.getClass(), "upgradeExecutionMode(String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, File anUpgradePackageControlFile, String aStepLabel)", "Entering upgrade execution mode");
            ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new EnteringUpgradeModeInformation(this));
            UpgradeSupervisionTimerHandler upgradeSupervisionTimerHandler = this.myUpgradeClientInterface.getUpgradeSupervisionTimerHandler();
            if (upgradeSupervisionTimerHandler != null) {
                if (upgradeSupervisionTimerHandler.getAttemptsToSetUpgradeSupervisionTimer()) {
                    upgradeSupervisionTimerHandler.stopAttempts();
                    this.setUpgradeSupervisionTimer();
                } else if (!upgradeSupervisionTimerHandler.isTimerSet()) {
                    this.setUpgradeSupervisionTimer();
                }
            } else {
                this.setUpgradeSupervisionTimer();
            }
            this.myUpgradeClientInterface.setUpgradeSupervisionTimerHandler(null);
            this.lockingOfPIUs(string, string2, file, string3);
            this.setErrorEscalation(string4);
        }
        catch (UpgradeRejectedException upgradeRejectedException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "upgradeExecutionMode(String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, File anUpgradePackageControlFile, String aStepLabel)", "The preparation of upgrade execution mode failed while collecting slots that are connected to repertoire names in UCF that shall tolerate errors during an upgrade.\n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3 + "\n\tUpgradeRejectedException reason: " + upgradeRejectedException.toString());
            }
            throw upgradeRejectedException;
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "upgradeExecutionMode(String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, File anUpgradePackageControlFile, String aStepLabel)", "The preparation of upgrade execution mode failed for any reason.\n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3 + "\n\tException reason: " + exception.toString());
            throw new UpgradeRejectedException("upgradeExecutionMode(String anUpgradePackageProductNumber, String anUpgradePackageProductRevision, File anUpgradePackageControlFile, String aStepLabel)\n\tThe preparation of upgrade failed for any reason.\n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3 + "\n\tException reason: " + exception.toString());
        }
    }

    private void updateRepertoireMos() throws UpgradeRejectedException {
        try {
            if (ServiceFinder.getRepertoireMO_HandlerInterface().isSU_VersionSupported("SU_2")) {
                return;
            }
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "updateRepertoireMos()", "Repertoire MOs are updated.");
            }
            RepertoireMO_HandlerInterface repertoireMO_HandlerInterface = ServiceFinder.getRepertoireMO_HandlerInterface();
            Parser parser = ParserFactory.makeParser("com.microstar.xml.SAXDriver");
            ConfigSupportMoSAXdh configSupportMoSAXdh = new ConfigSupportMoSAXdh("setPiuTypeLoadListsInRepertoires", new Vector(), repertoireMO_HandlerInterface);
            parser.setDocumentHandler(configSupportMoSAXdh);
            parser.parse(new InputSource(new FileReader(this.myUpgradeControlFile)));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateRepertoireMos()", "Throwable caught during execution of the received trigger type.\n\tThrowable: " + throwable, throwable);
            throw new UpgradeRejectedException("Throwable caught during execution of the update of the repertoire MOs.\n\tThrowable: " + throwable);
        }
    }

    public void updateOtherLoaderNames(boolean bl) throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateOtherLoaderNames(boolean anIsTableToBeUpdated)", "\n\tanIsTableToBeUpdated: " + bl);
        }
        try {
            ActiveOtherLMsHelper activeOtherLMsHelper = new ActiveOtherLMsHelper();
            Collection collection = activeOtherLMsHelper.getOtherLMs(this.myUpgradeClientInterface, this.myUpgradeControlFile);
            ActiveOtherLMsMO_HandlerInterface activeOtherLMsMO_HandlerInterface = ServiceFinder.getActiveOtherLMsMO_HandlerInterface();
            if (bl) {
                activeOtherLMsMO_HandlerInterface.setActiveOtherLoaderTypeLoadModules(collection);
                Collection collection2 = activeOtherLMsMO_HandlerInterface.getOtherLoaderNameMOs(collection);
                activeOtherLMsMO_HandlerInterface.setActiveOtherLoaderNameLoadModules(collection2, bl);
            } else {
                ManagedObject[] managedObjectArray;
                ManagedObject[] managedObjectArray2 = activeOtherLMsMO_HandlerInterface.getOtherLoaderTypeContents(null);
                if (managedObjectArray2 == null || managedObjectArray2.length == 0) {
                    activeOtherLMsMO_HandlerInterface.setActiveOtherLoaderTypeLoadModules(collection);
                }
                if ((managedObjectArray = activeOtherLMsMO_HandlerInterface.getOtherLoaderNameContents(null)) == null || managedObjectArray.length == 0) {
                    Collection collection3 = activeOtherLMsMO_HandlerInterface.getOtherLoaderNameMOs(collection);
                    activeOtherLMsMO_HandlerInterface.setActiveOtherLoaderNameLoadModules(collection3, bl);
                }
            }
        }
        catch (MoAccessException moAccessException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "updateOtherLoaderNames()", "MoAccessException caught during execution of the update of the other loader name information.\n\tMoAccessException: " + (Object)((Object)moAccessException));
            }
            throw new UpgradeRejectedException("MoAccessException caught during execution of the update of the other loader name information.\n\tMoAccessException: " + (Object)((Object)moAccessException));
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateOtherLoaderNames()", "Throwable caught during execution of the received trigger type.\n\tThrowable: " + throwable, throwable);
            throw new UpgradeRejectedException("Throwable caught during execution of the update of the other loader name information.\n\tThrowable: " + throwable);
        }
    }

    private void updateOtherLoaderNames() throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateOtherLoaderNames()");
        }
        this.updateOtherLoaderNames(true);
    }

    private Vector getNotConnectedPIUs() throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "getNotConnectedPIUs( )");
        }
        Vector<PlugInUnitMoSU_Access> vector = new Vector<PlugInUnitMoSU_Access>(1);
        try {
            PIU_MO_HandlerInterface pIU_MO_HandlerInterface = ServiceFinder.getPIU_MO_HandlerInterface();
            Collection collection = pIU_MO_HandlerInterface.getAllPIU_MOs();
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
            Collection collection2 = swAllocationMO_HandlerInterface.getContentsOfAllSlotLists();
            Iterator iterator = collection.iterator();
            PlugInUnitMoSU_Access plugInUnitMoSU_Access = null;
            while (iterator.hasNext()) {
                plugInUnitMoSU_Access = (PlugInUnitMoSU_Access)iterator.next();
                if (collection2.contains(pIU_MO_HandlerInterface.getSlotMO(plugInUnitMoSU_Access))) continue;
                vector.add(plugInUnitMoSU_Access);
            }
            return vector;
        }
        catch (MoAccessException moAccessException) {
            Trace.error(this.getClass(), "getNotConnectedPIUs( )", "MoAccessException caught: \n\tMoAccessException: " + moAccessException.toString(), moAccessException);
            throw new UpgradeRejectedException("getNotConnectedPIUs( )\n\tMoAccessException caught: \n\tMoAccessException: " + moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "getNotConnectedPIUs( )", "Throwable caught: \n\tThrowable: " + throwable.toString(), throwable);
            throw new UpgradeRejectedException("getNotConnectedPIUs( )\n\tThrowable caught: \n\tThrowable: " + throwable.toString());
        }
    }

    private void lockingOfPIUs(String string, String string2, File file, String string3) throws UpgradeRejectedException {
        block6: {
            if (Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "lockingOfPIUs(UpgradeRequestEvent anUpgradeRequestEvent)", "anUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3);
            }
            try {
                if (string3 != null && !string3.equals("")) break block6;
                UpgradeablePIU_HandlerInterface upgradeablePIU_HandlerInterface = ServiceFinder.getUpgradeablePIU_HandlerInterface();
                Vector vector = upgradeablePIU_HandlerInterface.collectNonSupportedPIUs(file.getAbsolutePath(), string, string2);
                Vector vector2 = upgradeablePIU_HandlerInterface.collectNonOperationalPIUs();
                Vector vector3 = upgradeablePIU_HandlerInterface.collectOperationalPIUs();
                Vector vector4 = this.getNotConnectedPIUs();
                LockPIUsInformation lockPIUsInformation = upgradeablePIU_HandlerInterface.getPIUsLockInformation(vector);
                LockPIUsInformation lockPIUsInformation2 = upgradeablePIU_HandlerInterface.getPIUsLockInformation(vector2);
                LockPIUsInformation lockPIUsInformation3 = upgradeablePIU_HandlerInterface.getPIUsLockInformation(vector3);
                if (this.myUpgradeClientInterface != null) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "lockingOfPIUs(UpgradeRequestEvent anUpgradeRequestEvent)", "Saving information about locked PIUs to be used when cleaning up when upgrade is finished.\n\ttheNonSupportedLockPIUsInformation: " + lockPIUsInformation + "\n\ttheOperationalLockPIUsInformation: " + lockPIUsInformation3 + "\n\ttheFaultyLockPIUsInformation: " + lockPIUsInformation2 + "\n\ttheNotConnectedPIUs: " + vector4);
                    }
                    Vector vector5 = new Vector();
                    vector5.addAll(lockPIUsInformation2.getPIUsLockedBeforeUpgrade());
                    vector5.addAll(lockPIUsInformation3.getPIUsLockedBeforeUpgrade());
                    Vector vector6 = new Vector();
                    vector6.addAll(lockPIUsInformation.getPIUsNotLocked());
                    vector6.addAll(vector4);
                    this.myUpgradeClientInterface.setFaultyPIUsLockedBeforeUpgrade(vector5);
                    this.myUpgradeClientInterface.setFaultyPIUsLockedByUpgrade(lockPIUsInformation2.getPIUsNotLocked());
                    this.myUpgradeClientInterface.setNonSupportedPIUsLockedBeforeUpgrade(lockPIUsInformation.getPIUsLockedBeforeUpgrade());
                    this.myUpgradeClientInterface.setNonSupportedPIUsLockedByUpgrade(vector6);
                    break block6;
                }
                Trace.error(this.getClass(), "lockingOfPIUs(UpgradeRequestEvent anUpgradeRequestEvent)", "Could not save the PIU's that was locked (or already was locked) by the upgrade logic due to the PIUs where either not supported or faulty.\n\tThe upgrade is aborted.\n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3);
                throw new UpgradeRejectedException("Could not save the PIU's that was locked (upgradeClientInterface== null) by the upgrade logic due to the PIUs where either not supported or faulty.\n\tThe upgrade is aborted.\n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3);
            }
            catch (UpgradeablePIU_HandlerException upgradeablePIU_HandlerException) {
                Trace.error(this.getClass(), "lockingOfPIUs(UpgradeRequestEvent anUpgradeRequestEvent)", "UpgradeablePIU_HandlerException exception caught: \n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3 + "\n\tException: " + upgradeablePIU_HandlerException.toString(), (Throwable)((Object)upgradeablePIU_HandlerException));
                throw new UpgradeRejectedException("lockingOfPIUs(UpgradeRequestEvent anUpgradeRequestEvent)\n\tUpgradeablePIU_HandlerException exception caught: \n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3 + "\n\tException: " + upgradeablePIU_HandlerException.toString());
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "lockingOfPIUs(UpgradeRequestEvent anUpgradeRequestEvent)", "Exception caught: \n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3 + "\n\tException: " + exception.toString(), exception);
                throw new UpgradeRejectedException("lockingOfPIUs(UpgradeRequestEvent anUpgradeRequestEvent)\n\tException exception caught: \n\tanUpgradePackageProductNumber: " + string + "\n\tanUpgradePackageProductRevision: " + string2 + "\n\tanUpgradePackageControlFile: " + SuLib.toString(file) + "\n\taStepLabel: " + string3 + "\n\tException: " + exception.toString());
            }
        }
    }

    private boolean sendOsaUpiChangeErrorEscalation(int n) {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "sendOsaUpiChangeErrorEscalation (int anErrorEscalationValue)", "\n\tanErrorEscalationValue: " + n);
        }
        if (this.myOsaUPI_Proxy.sendOsaUpiChangeErrorEscReq(n)) {
            return true;
        }
        Trace.log1(this.getClass(), "sendOsaUpiChangeErrorEscalation(int anErrorEscalationValue)", "Failed to set the upgrade error escalation.\n\tWill retry up to 300 times with 2 seconds intervall.\n\tanErrorEscalationValue: " + n);
        for (int i = 0; i < 300; ++i) {
            Trace.log1(this.getClass(), "sendOsaUpiChangeErrorEscalation(int anErrorEscalationValue)", "Waiting 2 seconds before re-trying (" + (i + 1) + ").");
            TimeHandler.sleepShort(2000L);
            if (!this.myOsaUPI_Proxy.sendOsaUpiChangeErrorEscReq(n)) continue;
            Trace.log1(this.getClass(), "sendOsaUpiChangeErrorEscalation(int anErrorEscalationValue)", "Successfully set of the upgrade error escalation.");
            return true;
        }
        Trace.error(this.getClass(), "sendOsaUpiChangeErrorEscalation(int anErrorEscalationValue)", "Failed to set the upgrade error escalation (will not try anymore...).");
        return false;
    }

    private void setErrorEscalation(String string) throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setErrorEscalation()");
        }
        try {
            Object object;
            Vector vector = this.myUpgradeSequenceProxyInterface.getRepertoireNamesForTolerateErrors(this.myRepertoireReplacementsProxyInterface, string);
            SwAllocationMO_HandlerInterface swAllocationMO_HandlerInterface = ServiceFinder.getSwAllocationMO_HandlerInterface();
            Vector vector2 = swAllocationMO_HandlerInterface.getConnectedSlots(vector, null);
            if (vector2.size() > 0 && Trace.valid(this.getClass(), 20)) {
                Trace.debug(this.getClass(), 20, "setErrorEscalation()", "Following slots shall tolerate errors during an upgrade (pointed out by repertoire names)theTolerateErrorsSlotsForRepertoireNames: " + vector2 + "\n\ttheRepertoireNamesForTolerateErrors: " + vector);
                object = vector2.iterator();
                while (object.hasNext()) {
                    Trace.debug(this.getClass(), 20, "setErrorEscalation(aStepLabel)", "Following slots shall tolerate errors during an upgrade (pointed out by repertoire names)theTolerateErrorsSlotsForRepertoireNames: " + object.next());
                }
            }
            object = this.myUpgradeSequenceProxyInterface.getUpgradeGroupTypeNamesForTolerateErrors();
            SlotMO_HandlerInterface slotMO_HandlerInterface = ServiceFinder.getSlotMO_HandlerInterface();
            Vector vector3 = slotMO_HandlerInterface.getSlotsWithUpgradeGroupTypeNames((Vector)object);
            Vector vector4 = this.collectFaultyAndNotSupportedSlotsToBeFaultTolerant(this.getFaultyPIUsLockedBeforeUpgrade(), this.getNonSupportedPIUsLockedBeforeUpgrade(), this.getFaultyPIUsLockedByUpgrade(), this.getNonSupportedPIUsLockedByUpgrade());
            this.setTolerateErrorModeForSlots(vector2, vector3, vector4);
            if (this.myUpgradeSequenceProxyInterface.getTolerateErrorsForNode()) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setErrorEscalation()", "Requested error escalation mode: TolerateErrors");
                }
                if (this.sendOsaUpiChangeErrorEscalation(0)) {
                    if (Trace.valid(this.getClass(), 22)) {
                        Trace.debug(this.getClass(), 22, "setErrorEscalation()", "Error escalation mode has been set to: TolerateErrors");
                    }
                } else {
                    Trace.error(this.getClass(), "setErrorEscalation()", "Failed to set the 'Error escalation mode' to value 'TolerateErrors'.\n\tThe upgrade proceeds its execution anyway.");
                }
            } else {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "setErrorEscalation()", "Error escalation mode: InstantRollback");
                }
                if (!this.sendOsaUpiChangeErrorEscalation(1)) {
                    Trace.error(this.getClass(), "setErrorEscalation()", "Failed to set the 'Error escalation mode' to value 'InstantRollback'.\n\tThe upgrade proceeds its execution anyway.");
                }
            }
        }
        catch (SwAllocationMO_HandlerException swAllocationMO_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setErrorEscalation()", "The preparation of upgrade failed while collecting slots that are connected to repertoire names in UCF that shall tolerate errors during an upgrade.\n\tSwAllocationMO_HandlerException reason: " + swAllocationMO_HandlerException.toString());
            }
            throw new UpgradeRejectedException("The preparation of upgrade failed while collecting slots that are connected to repertoire names in UCF that shall tolerate errors during an upgrade.\n\tSwAllocationMO_HandlerException reason: " + swAllocationMO_HandlerException.toString());
        }
        catch (SlotMO_HandlerException slotMO_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "setErrorEscalation()", "The preparation of upgrade failed while collecting slots that shall tolerate errors during an upgrade.\n\tSlotMO_HandlerException reason: " + slotMO_HandlerException.toString());
            }
            throw new UpgradeRejectedException("The preparation of upgrade failed while collecting slots that shall tolerate errors during an upgrade.\n\tSlotMO_HandlerException reason: " + slotMO_HandlerException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "setErrorEscalation()", "The preparation of upgrade failed while collecting slots that shall tolerate errors during an upgrade.\n\tException reason: " + exception.toString(), exception);
            throw new UpgradeRejectedException("The preparation of upgrade failed while collecting slots that shall tolerate errors during an upgrade.\n\tException reason: " + exception.toString());
        }
    }

    private void setTolerateErrorModeForSlots(Vector vector, Vector vector2, Vector vector3) throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setTolerateErrorModeForSlots(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots))", "aSlotsConnectedToRepertoireNames: " + vector + "\n\taSlotsWithUpgradeGroupTypeNames: " + vector2 + "\n\taFaultyAndNonSupportedSlots: " + vector3);
        }
        if (vector.isEmpty() && vector2.isEmpty() && vector3.isEmpty()) {
            return;
        }
        try {
            if (SU_AccessVersionHandler.getInstance().isCurrentlySupported("SU_2", (Object)this.myOsaUPI_Proxy)) {
                this.sendOsaUpi2PiuNoRollbackReq(vector, vector2, vector3, this.myOsaUPI_Proxy);
            } else {
                this.sendOsaUpiPiuNoRollbackReq(vector, vector2, vector3, this.myOsaUPI_Proxy);
            }
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "setTolerateErrorModeForSlots(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots)", "The preparation of upgrade failed while trying to indicate the PIUs that shall tolerate errors during an upgrade.\n\tException reason: " + throwable.toString(), throwable);
            throw new UpgradeRejectedException("The preparation of upgrade failed while trying to indicate the PIUs that shall tolerate errors during an upgrade.\n\tException reason: " + throwable.toString());
        }
    }

    private void sendOsaUpiPiuNoRollbackReq(Vector vector, Vector vector2, Vector vector3, OsaUpiProxyAccess osaUpiProxyAccess) throws MoAccessException {
        int n;
        int n2;
        Vector<SlotDataAPN_SMN_Container> vector4 = new Vector<SlotDataAPN_SMN_Container>(1);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Iterator iterator = vector.iterator();
        SlotMoSU_Access slotMoSU_Access = null;
        while (iterator.hasNext()) {
            slotMoSU_Access = (SlotMoSU_Access)iterator.next();
            int n3 = slotMoSU_Access.getAsciPortNumber(null);
            n2 = ((SubrackMoSU_Access)slotMoSU_Access.getParent()).getSwitchModuleNumber(null);
            if (hashtable.put(new Integer(n2).toString() + "_" + new Integer(n3).toString(), "") != null) continue;
            vector4.addElement(new SlotDataAPN_SMN_Container(n3, n2));
        }
        Iterator iterator2 = vector2.iterator();
        while (iterator2.hasNext()) {
            slotMoSU_Access = (SlotMoSU_Access)iterator2.next();
            n2 = slotMoSU_Access.getAsciPortNumber(null);
            n = ((SubrackMoSU_Access)slotMoSU_Access.getParent()).getSwitchModuleNumber(null);
            if (hashtable.put(new Integer(n).toString() + "_" + new Integer(n2).toString(), "") != null) continue;
            vector4.addElement(new SlotDataAPN_SMN_Container(n2, n));
        }
        Iterator iterator3 = vector3.iterator();
        while (iterator3.hasNext()) {
            slotMoSU_Access = (SlotMoSU_Access)iterator3.next();
            n = slotMoSU_Access.getAsciPortNumber(null);
            int n4 = ((SubrackMoSU_Access)slotMoSU_Access.getParent()).getSwitchModuleNumber(null);
            if (hashtable.put(new Integer(n4).toString() + "_" + new Integer(n).toString(), "") != null) continue;
            vector4.addElement(new SlotDataAPN_SMN_Container(n, n4));
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaUpiPiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "The following slots shall tolerate errors during an upgrade: " + vector4);
        }
        for (n = 0; n < 300; ++n) {
            this.myUPI_ProxyIsUpAndRunning = osaUpiProxyAccess.sendOsaUpiPiuNoRollbackReq(vector4);
            if (this.myUPI_ProxyIsUpAndRunning) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "sendOsaUpiPiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "Signal 'OsaUpiPiuNoRollbackReq' has been sent with result OK");
                }
                return;
            }
            TimeHandler.sleep(2000L);
        }
        Trace.error(this.getClass(), "sendOsaUpiPiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "Failed to inform the PIU's (slots) that shall tolerate errors during an upgrade i.e. the signal 'OsaUpiPiuNoRollbackReq' \n\tsent to the OsaUpiProxy returned failure\n\ttheSlotsAPN_SMN_Numbers: " + vector4 + "\n\ttheSlotsAPN_SMN_Keys: " + hashtable + "\n\tThe OsaUpiProxy may not have published itself yet." + "\n\tAfter waiting (300 * 2 seconds =) 10.");
        throw new UpgradeRejectedException("Failed to inform the PIU's (slots) that shall tolerate errors during an upgrade i.e. the signal 'OsaUpiPiuNoRollbackReq' \n\tsent to the OsaUpiProxy returned failure\n\ttheSlotsAPN_SMN_Numbers: " + vector4 + "\n\ttheSlotsAPN_SMN_Keys: " + hashtable);
    }

    private void sendOsaUpi2PiuNoRollbackReq(Vector vector, Vector vector2, Vector vector3, OsaUpiProxyAccess osaUpiProxyAccess) throws MoAccessException {
        ManagedObject managedObject;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Iterator iterator = vector.iterator();
        SlotMoSU_Access slotMoSU_Access = null;
        while (iterator.hasNext()) {
            managedObject = (ManagedObject)iterator.next();
            if (!(managedObject instanceof SlotMoSU_Access)) continue;
            slotMoSU_Access = (SlotMoSU_Access)managedObject;
            if (this.getGenericUpgradeablePiuFroIdentity((SlotMoSU_Access)managedObject) != null) {
                hashSet.add(this.getGenericUpgradeablePiuFroIdentity((SlotMoSU_Access)managedObject));
            } else if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "sendOsaUpi2PiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "No possible to add piu froid to list for slot connected to repertoire names, no PIU defined in slot: " + slotMoSU_Access.getLocalDistinguishedName());
            }
            if (!Trace.valid(this.getClass(), 22)) continue;
            Trace.debug(this.getClass(), 22, "sendOsaUpi2PiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "ManagedObject in SwAllocations slotList is not instance of SlotMoSU_Access, hence ignored.\n\tManagedObject LDN: " + slotMoSU_Access.getLocalDistinguishedName());
        }
        managedObject = vector2.iterator();
        while (managedObject.hasNext()) {
            slotMoSU_Access = (SlotMoSU_Access)managedObject.next();
            if (this.getGenericUpgradeablePiuFroIdentity(slotMoSU_Access) != null) {
                hashSet.add(this.getGenericUpgradeablePiuFroIdentity(slotMoSU_Access));
                continue;
            }
            if (!Trace.valid(this.getClass(), 22)) continue;
            Trace.debug(this.getClass(), 22, "sendOsaUpi2PiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "No possible to add piu froid to list tolerateErrorModeForSlots, no PIU defined in slot: " + slotMoSU_Access.getLocalDistinguishedName());
        }
        Iterator iterator2 = vector3.iterator();
        while (iterator2.hasNext()) {
            slotMoSU_Access = (SlotMoSU_Access)iterator2.next();
            if (this.getGenericUpgradeablePiuFroIdentity(slotMoSU_Access) == null) continue;
            hashSet.add(this.getGenericUpgradeablePiuFroIdentity(slotMoSU_Access));
        }
        if (Trace.valid(this.getClass(), 22)) {
            Trace.debug(this.getClass(), 22, "sendOsaUpi2PiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "The PIUs with the following FRO id's shall tolerate errors during an upgrade: " + hashSet.toString());
        }
        for (int i = 0; i < 300; ++i) {
            this.myUPI_ProxyIsUpAndRunning = osaUpiProxyAccess.sendOsaUpi2PiuNoRollbackReq(hashSet);
            if (this.myUPI_ProxyIsUpAndRunning) {
                if (Trace.valid(this.getClass(), 22)) {
                    Trace.debug(this.getClass(), 22, "sendOsaUpi2PiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "Signal 'OsaUpiPiu2NoRollbackReq' has been sent with result OK");
                }
                return;
            }
            TimeHandler.sleep(2000L);
        }
        Trace.error(this.getClass(), "sendOsaUpi2PiuNoRollbackReq(Vector aSlotsConnectedToRepertoireNames, Vector aSlotsWithUpgradeGroupTypeNames, Vector aFaultyAndNonSupportedSlots, OsaUpiProxyAccess aUpiProxy)", "Failed to inform the PIU's (slots) that shall tolerate errors during an upgrade i.e. the signal 'OsaUpi2PiuNoRollbackReq' \n\tsent to the OsaUpiProxy returned failure\n\ttthePiuFroIds: " + hashSet + "\n\tThe OsaUpiProxy may not have published itself yet." + "\n\tAfter waiting (300 * 2 seconds =) 10.");
        throw new UpgradeRejectedException("Failed to inform the PIU's (slots) that shall tolerate errors during an upgrade i.e. the signal 'OsaUpi2PiuNoRollbackReq' \n\tsent to the OsaUpiProxy returned failure\n\tthePiuFroIds: " + hashSet);
    }

    private Integer getGenericUpgradeablePiuFroIdentity(SlotMoSU_Access slotMoSU_Access) throws MoAccessException {
        MoIterator moIterator = slotMoSU_Access.getChildren();
        while (moIterator != null && moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            if (!(managedObject instanceof GenericUpgradeablePlugInUnit)) continue;
            return new Integer(((GenericUpgradeablePlugInUnit)managedObject).getResourceId(null));
        }
        return null;
    }

    private void setUpgradeSupervisionTimer() {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "setUpgradeSupervisionTimer()");
        }
        long l = this.myUpgradeSequenceProxyInterface.getUpgradeSupervisionTime();
        for (int i = 0; i < 300; ++i) {
            try {
                this.myUPI_ProxyIsUpAndRunning = l == 0L ? this.myOsaUPI_Proxy.sendOsaUpiSetSuperTimerReq(0L) : this.myOsaUPI_Proxy.sendOsaUpiSetSuperTimerReq(l);
                if (this.myUPI_ProxyIsUpAndRunning) {
                    ProgressInformationHandler.instance().firePropertyChange(NotifyingSystemUpgradePropertyName.ProgressInformation, new ConfirmationDeadlineTimerInformation((Object)this, l));
                    break;
                }
                if (Trace.valid(this.getClass(), 20)) {
                    Trace.debug(this.getClass(), 20, "run()", "Sleeps 2 seconds before trying to set the upgrade supervision timer again.");
                }
                TimeHandler.sleep(2000L);
                continue;
            }
            catch (Exception exception) {
                Trace.error(this.getClass(), "run()", "Exception caught when trying to set the Upgrade Supervision Timer (ignored).\n\tAttempts to set the upgrade supervision timer anyway,", exception);
            }
        }
        if (!this.myUPI_ProxyIsUpAndRunning) {
            Trace.error(this.getClass(), "setUpgradeSupervisionTimer()", "Failed to set the Upgrade Supervision Timer to " + l + " seconds." + "\n\tThe upgrade proceeds its execution anyway (default Osa supervision timer is used).");
        }
    }

    private void updateManagedElementMO() throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateManagedElementMO()");
        }
        try {
            DocumentObjectProxyInterface documentObjectProxyInterface = UCF_ParserFacade.parseMainElement(this.myUpgradeClientInterface.getUpgradePackageProductNumber(), this.myUpgradeClientInterface.getUpgradePackageProductRevision(), this.myUpgradeControlFile.getAbsolutePath(), "ManagedElement");
            ManagedElementProxyInterface managedElementProxyInterface = documentObjectProxyInterface.getManagedElementProxyInterface();
            ManagedElementMO_HandlerInterface managedElementMO_HandlerInterface = ServiceFinder.getManagedElementMO_HandlerInterface();
            managedElementMO_HandlerInterface.setProductData(managedElementProxyInterface.getManagedElement());
        }
        catch (UpgradeControlFileParserException upgradeControlFileParserException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "updateManagedElementMO()", "An UpgradeControlFileParserException was caught while parsing the upgrade sequence of the UCF.\n\tManagedElementMO_HandlerException message: " + upgradeControlFileParserException.getMessage() + "\n\tManagedElementMO_HandlerException: " + upgradeControlFileParserException.toString());
            }
            throw new UpgradeRejectedException("An UpgradeControlFileParserException was caught while parsing the upgrade sequence of the UCF.\n\tManagedElementMO_HandlerException message: " + upgradeControlFileParserException.getMessage() + "\n\tManagedElementMO_HandlerException: " + upgradeControlFileParserException.toString());
        }
        catch (ManagedElementMO_HandlerException managedElementMO_HandlerException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "updateManagedElementMO()", "ManagedElementMO_HandlerException during execution of the received trigger type.\n\tManagedElementMO_HandlerException message: " + managedElementMO_HandlerException.getMessage() + "\n\tManagedElementMO_HandlerException: " + managedElementMO_HandlerException.toString());
            }
            throw new UpgradeRejectedException("ManagedElementMO_HandlerException during execution of the received trigger type.\n\tManagedElementMO_HandlerException message: " + managedElementMO_HandlerException.getMessage() + "\n\tManagedElementMO_HandlerException: " + managedElementMO_HandlerException.toString());
        }
        catch (Exception exception) {
            Trace.error(this.getClass(), "updateManagedElementMO()", "Exception during execution of the received trigger type.\n\tException message: " + exception.getMessage() + "\n\tException: " + exception.toString(), exception);
            throw new UpgradeRejectedException("Exception during execution of the received trigger type.\n\tException message: " + exception.getMessage() + "\n\tException: " + exception.toString());
        }
    }

    private void updateWebServerPaths() throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "updateWebServerPaths( )");
        }
        try {
            WebserverLMsHelper webserverLMsHelper = new WebserverLMsHelper();
            Collection collection = webserverLMsHelper.getWebserverLMs(this.myUpgradeClientInterface);
            LoadModuleMO_HandlerInterface loadModuleMO_HandlerInterface = ServiceFinder.getLoadModuleMO_HandlerInterface();
            Collection collection2 = loadModuleMO_HandlerInterface.getFilePathsForLoadModules(collection);
            WebServerMO_HandlerInterface webServerMO_HandlerInterface = ServiceFinder.getWebServerMO_HandlerInterface();
            webServerMO_HandlerInterface.setWebServerPaths(collection2);
        }
        catch (MoAccessException moAccessException) {
            if (Trace.valid(this.getClass(), 22)) {
                Trace.debug(this.getClass(), 22, "updateWebServerPaths( )", "MoAccessException caught during execution of the received trigger type.\n\tMoAccessException message: " + moAccessException.getMessage() + "\n\tMoAccessException: " + moAccessException.toString());
            }
            throw new UpgradeRejectedException("MoAccessException caught during execution of the received trigger type.\n\tMoAccessException message: " + moAccessException.getMessage() + "\n\tMoAccessException: " + moAccessException.toString());
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "updateWebServerPaths( )", "Throwable caught during execution of the received trigger type.\n\tThrowable message: " + throwable.getMessage() + "\n\tThrowable: " + throwable.toString(), throwable);
            throw new UpgradeRejectedException("Throwable caught during execution of the received trigger type.\n\tThrowable message: " + throwable.getMessage() + "\n\tThrowable: " + throwable.toString());
        }
    }

    private void deleteSuConvertTables() throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "deleteSuConvertTables()");
        }
        try {
            UpgradeMoDataConverter.deleteSuConvertInfoInTables();
        }
        catch (SuConverterException suConverterException) {
            throw new UpgradeRejectedException("Exception caught during execution of the received trigger type.\n\tException: " + suConverterException);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createSuConvertTable(boolean aRecordConvertToFile, boolean aRemoveRecordedFiles)", "Throwable caught during execution of the received trigger type.", throwable);
            throw new UpgradeRejectedException("Throwable caught during execution of the received trigger type.\n\tThrowable: " + throwable);
        }
    }

    private void createSuConvertTable(ConverterState converterState) throws UpgradeRejectedException {
        if (Trace.valid(this.getClass(), 20)) {
            Trace.debug(this.getClass(), 20, "createSuConvertTable(ConverterState aConverterState)", "aConverterState: " + converterState);
        }
        try {
            UpgradeMoDataConverter.storeSuConvertInfoInTable(converterState, this.myUpgradeClientInterface.getUpgradePackageProductNumber(), this.myUpgradeClientInterface.getUpgradePackageProductRevision());
        }
        catch (SuConverterException suConverterException) {
            throw new UpgradeRejectedException("Exception caught during execution of the received trigger type.\n\tException: " + suConverterException);
        }
        catch (Throwable throwable) {
            Trace.error(this.getClass(), "createSuConvertTable(boolean aRecordConvertToFile, boolean aRemoveRecordedFiles)", "Throwable caught during execution of the received trigger type.", throwable);
            throw new UpgradeRejectedException("Throwable caught during execution of the received trigger type.\n\tThrowable: " + throwable);
        }
    }
}

